/*
 * Decompiled with CFR 0.152.
 */
package g2601_2700.s2642_design_graph_with_shortest_path_calculator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;

public class Graph {
    private final Map<Integer, ArrayList<Pair<Integer, Integer>>> adj = new HashMap<Integer, ArrayList<Pair<Integer, Integer>>>();

    public Graph(int n, int[][] edges) {
        for (int i = 0; i < n; ++i) {
            this.adj.put(i, new ArrayList());
        }
        for (int[] edge : edges) {
            int u = edge[0];
            int v = edge[1];
            int cost = edge[2];
            ArrayList<Pair<Integer, Integer>> uList = this.adj.get(u);
            uList.add(new Pair<Integer, Integer>(v, cost));
            this.adj.put(u, uList);
        }
    }

    public void addEdge(int[] edge) {
        int u = edge[0];
        int v = edge[1];
        int cost = edge[2];
        ArrayList<Pair<Integer, Integer>> uList = this.adj.getOrDefault(u, new ArrayList());
        uList.add(new Pair<Integer, Integer>(v, cost));
        this.adj.put(u, uList);
    }

    public int shortestPath(int node1, int node2) {
        PriorityQueue<Pair<Integer, Integer>> minHeap = new PriorityQueue<Pair<Integer, Integer>>((a, b) -> (Integer)a.getValue() - (Integer)b.getValue());
        int[] distance = new int[this.adj.size()];
        Arrays.fill(distance, Integer.MAX_VALUE);
        minHeap.add(new Pair<Integer, Integer>(node1, 0));
        distance[node1] = 0;
        while (!minHeap.isEmpty()) {
            ArrayList<Pair<Integer, Integer>> neighbors;
            Pair nodeCost = (Pair)minHeap.poll();
            int node = (Integer)nodeCost.getKey();
            int cost = (Integer)nodeCost.getValue();
            if (node == node2) {
                return cost;
            }
            if (cost > distance[node] || (neighbors = this.adj.get(node)) == null) continue;
            for (Pair<Integer, Integer> neighbor : neighbors) {
                int next = neighbor.getKey();
                int nextCost = neighbor.getValue();
                if (cost + nextCost >= distance[next]) continue;
                distance[next] = cost + nextCost;
                minHeap.add(new Pair<Integer, Integer>(next, cost + nextCost));
            }
        }
        return -1;
    }

    static class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

