/*
 * Decompiled with CFR 0.152.
 */
package g2901_3000.s2911_minimum_changes_to_make_k_semi_palindromes;

public class Solution {
    private static final int INF = 200;
    private final Divisor[] divisors = this.getDivisors();
    private char[] cs;
    private int[][] cost;
    private int[][] dp;

    public int minimumChanges(String s, int k) {
        this.cs = s.toCharArray();
        int n = this.cs.length;
        this.cost = new int[n - 1][n + 1];
        this.dp = new int[n + 1][k + 1];
        return this.calc(n, k) - k;
    }

    private int calc(int i, int k) {
        if (k == 1) {
            return this.change(0, i);
        }
        if (this.dp[i][k] > 0) {
            return this.dp[i][k];
        }
        int min = 200;
        for (int j = (k - 1) * 2; j < i - 1; ++j) {
            min = Math.min(min, this.calc(j, k - 1) + this.change(j, i));
        }
        this.dp[i][k] = min;
        return min;
    }

    private int change(int start, int end) {
        if (this.cost[start][end] > 0) {
            return this.cost[start][end];
        }
        int min = 200;
        Divisor divisor = this.divisors[end - start];
        while (divisor != null) {
            int d = divisor.value;
            int count = 0;
            for (int i = 0; i < d; ++i) {
                int left = start + i;
                for (int right = end - d + i; left + d <= right; right -= d) {
                    if (this.cs[left] != this.cs[right]) {
                        ++count;
                    }
                    left += d;
                }
            }
            if (count < min) {
                min = count;
            }
            divisor = divisor.next;
        }
        this.cost[start][end] = min + 1;
        return min + 1;
    }

    private Divisor[] getDivisors() {
        Divisor[] list = new Divisor[201];
        for (int d = 1; d < 200; ++d) {
            for (int len = d + d; len < 201; len += d) {
                list[len] = new Divisor(d, list[len]);
            }
        }
        return list;
    }

    private static class Divisor {
        int value;
        Divisor next;

        Divisor(int divisor, Divisor next) {
            this.value = divisor;
            this.next = next;
        }
    }
}

