/*
 * Decompiled with CFR 0.152.
 */
package g0901_1000.s0966_vowel_spellchecker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Solution {
    private Set<String> matched;
    private Map<String, String> capitalizations;
    private Map<String, String> vowelErrors;

    private boolean isVowel(char w) {
        return w == 'a' || w == 'e' || w == 'i' || w == 'o' || w == 'u';
    }

    private String removeVowels(String word) {
        StringBuilder s = new StringBuilder();
        for (char w : word.toCharArray()) {
            s.append(this.isVowel(w) ? (char)'*' : w);
        }
        return s.toString();
    }

    private String solveQuery(String query) {
        if (this.matched.contains(query)) {
            return query;
        }
        String word = query.toLowerCase();
        if (this.capitalizations.containsKey(word)) {
            return this.capitalizations.get(word);
        }
        if (this.vowelErrors.containsKey(word = this.removeVowels(word))) {
            return this.vowelErrors.get(word);
        }
        return "";
    }

    public String[] spellchecker(String[] wordlist, String[] queries) {
        String[] answer = new String[queries.length];
        this.matched = new HashSet<String>();
        this.capitalizations = new HashMap<String, String>();
        this.vowelErrors = new HashMap<String, String>();
        for (String word : wordlist) {
            this.matched.add(word);
            String s = word.toLowerCase();
            this.capitalizations.putIfAbsent(s, word);
            s = this.removeVowels(s);
            this.vowelErrors.putIfAbsent(s, word);
        }
        for (int i = 0; i < queries.length; ++i) {
            answer[i] = this.solveQuery(queries[i]);
        }
        return answer;
    }
}

