/*
 * Decompiled with CFR 0.152.
 */
package g1701_1800.s1728_cat_and_mouse_ii;

import java.util.ArrayList;
import java.util.List;

public class Solution {
    private static final int MOUSE_TURN = 0;
    private final List<Integer>[][] graphs = new List[2][];
    private int foodPos;
    private int[][][] memo;

    public boolean canMouseWin(String[] grid, int catJump, int mouseJump) {
        char c;
        int j;
        int i;
        int m = grid.length;
        int n = grid[0].length();
        int mousePos = 0;
        int catPos = 0;
        for (i = 0; i < m; ++i) {
            for (j = 0; j < n; ++j) {
                c = grid[i].charAt(j);
                if (c == 'F') {
                    this.foodPos = i * n + j;
                    continue;
                }
                if (c == 'C') {
                    catPos = i * n + j;
                    continue;
                }
                if (c != 'M') continue;
                mousePos = i * n + j;
            }
        }
        this.graphs[0] = this.buildGraph(mouseJump, grid);
        this.graphs[1] = this.buildGraph(catJump, grid);
        this.memo = new int[m * n][m * n][2];
        for (i = 0; i < m; ++i) {
            for (j = 0; j < n; ++j) {
                c = grid[i].charAt(j);
                if (c == '#' || c == 'F') continue;
                int catTurn = 1;
                this.dfs(i * n + j, this.foodPos, catTurn);
            }
        }
        return this.memo[mousePos][catPos][0] < 0;
    }

    private List<Integer>[] buildGraph(int jump, String[] grid) {
        int[][] dirs = new int[][]{{-1, 0}, {1, 0}, {0, 1}, {0, -1}};
        int m = grid.length;
        int n = grid[0].length();
        List[] graph = new List[m * n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                ArrayList<Integer> list;
                graph[i * n + j] = list = new ArrayList<Integer>();
                if (grid[i].charAt(j) == '#') continue;
                list.add(i * n + j);
                block2: for (int[] dir : dirs) {
                    for (int step = 1; step <= jump; ++step) {
                        int x = i + dir[0] * step;
                        int y = j + dir[1] * step;
                        if (x < 0 || x >= m || y < 0 || y >= n || grid[x].charAt(y) == '#') continue block2;
                        list.add(x * n + y);
                    }
                }
            }
        }
        return graph;
    }

    private void dfs(int p1, int p2, int turn) {
        if (p1 == p2) {
            return;
        }
        if ((turn == 0 ? p2 : p1) == this.foodPos) {
            return;
        }
        if (this.memo[p1][p2][turn] < 0) {
            return;
        }
        this.memo[p1][p2][turn] = -1;
        for (int w : this.graphs[turn ^= 1][p2]) {
            if (turn != 0) {
                int[] nArray = this.memo[w][p1];
                int n = turn;
                nArray[n] = nArray[n] + 1;
                if (nArray[n] != this.graphs[turn][w].size()) continue;
            }
            this.dfs(w, p1, turn);
        }
    }
}

