/*
 * Decompiled with CFR 0.152.
 */
package g1801_1900.s1825_finding_mk_average;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.TreeMap;

public class MKAverage {
    private final double m;
    private final double k;
    private final double c;
    private double avg;
    private final Bst middle;
    private final Bst min;
    private final Bst max;
    private final Deque<Integer> q;

    public MKAverage(int m, int k) {
        this.m = m;
        this.k = k;
        this.c = m - k * 2;
        this.avg = 0.0;
        this.middle = new Bst();
        this.min = new Bst();
        this.max = new Bst();
        this.q = new ArrayDeque<Integer>();
    }

    public void addElement(int num) {
        int val;
        if ((double)this.min.size < this.k) {
            this.min.add(num);
            this.q.offer(num);
            return;
        }
        if ((double)this.max.size < this.k) {
            this.min.add(num);
            this.max.add(this.min.removeMax());
            this.q.offer(num);
            return;
        }
        if (num >= this.min.lastKey() && num <= this.max.firstKey()) {
            this.middle.add(num);
            this.avg += (double)num / this.c;
        } else if (num < this.min.lastKey()) {
            this.min.add(num);
            val = this.min.removeMax();
            this.middle.add(val);
            this.avg += (double)val / this.c;
        } else if (num > this.max.firstKey()) {
            this.max.add(num);
            val = this.max.removeMin();
            this.middle.add(val);
            this.avg += (double)val / this.c;
        }
        this.q.offer(num);
        if ((double)this.q.size() > this.m) {
            num = this.q.poll();
            if (this.middle.containsKey(num)) {
                this.avg -= (double)num / this.c;
                this.middle.remove(num);
            } else if (this.min.containsKey(num)) {
                this.min.remove(num);
                val = this.middle.removeMin();
                this.avg -= (double)val / this.c;
                this.min.add(val);
            } else if (this.max.containsKey(num)) {
                this.max.remove(num);
                val = this.middle.removeMax();
                this.avg -= (double)val / this.c;
                this.max.add(val);
            }
        }
    }

    public int calculateMKAverage() {
        if ((double)this.q.size() < this.m) {
            return -1;
        }
        return (int)this.avg;
    }

    static class Bst {
        TreeMap<Integer, Integer> map = new TreeMap();
        int size = 0;

        void add(int num) {
            int count = this.map.getOrDefault(num, 0) + 1;
            this.map.put(num, count);
            ++this.size;
        }

        void remove(int num) {
            int count = this.map.getOrDefault(num, 1) - 1;
            if (count > 0) {
                this.map.put(num, count);
            } else {
                this.map.remove(num);
            }
            --this.size;
        }

        int removeMin() {
            int key = this.map.firstKey();
            this.remove(key);
            return key;
        }

        int removeMax() {
            int key = this.map.lastKey();
            this.remove(key);
            return key;
        }

        boolean containsKey(int key) {
            return this.map.containsKey(key);
        }

        int firstKey() {
            return this.map.firstKey();
        }

        int lastKey() {
            return this.map.lastKey();
        }
    }
}

