/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.console;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.hcjf.io.console.ConsoleCommandLayerInterface;
import org.hcjf.io.console.ConsoleSession;
import org.hcjf.io.console.ServerMetadata;
import org.hcjf.io.console.SessionMetadata;
import org.hcjf.io.console.messages.EvaluateQueryableMessage;
import org.hcjf.io.console.messages.ExecuteMessage;
import org.hcjf.io.console.messages.GetMetadataMessage;
import org.hcjf.io.console.messages.LoginMessage;
import org.hcjf.io.net.NetPackage;
import org.hcjf.io.net.NetService;
import org.hcjf.io.net.messages.Message;
import org.hcjf.io.net.messages.MessageBuffer;
import org.hcjf.io.net.messages.MessagesServer;
import org.hcjf.io.net.messages.ResponseMessage;
import org.hcjf.layers.Layers;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.Queryable;
import org.hcjf.service.ServiceSession;
import org.hcjf.utils.Cryptography;

public abstract class ConsoleServer
extends MessagesServer<ConsoleSession> {
    public ConsoleServer(Integer port) {
        this(port, (Cryptography)null);
    }

    public ConsoleServer(Integer port, Cryptography cryptography) {
        super(port, NetService.TransportLayerProtocol.TCP, false, true, cryptography);
    }

    @Override
    public final ConsoleSession createSession(NetPackage netPackage) {
        return new ConsoleSession(UUID.randomUUID(), this);
    }

    @Override
    public final ConsoleSession checkSession(ConsoleSession session, MessageBuffer payLoad, NetPackage netPackage) {
        session.setChecked(true);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void onRead(ConsoleSession session, Message message) {
        ResponseMessage responseMessage;
        block13: {
            responseMessage = new ResponseMessage(message);
            try {
                if (message instanceof GetMetadataMessage) {
                    responseMessage.setValue(this.getMetadata());
                    break block13;
                }
                if (message instanceof LoginMessage) {
                    ServiceSession serviceSession = this.login(((LoginMessage)message).getParameters());
                    SessionMetadata sessionMetadata = new SessionMetadata();
                    sessionMetadata.setId(serviceSession.getId());
                    sessionMetadata.setSessionName(serviceSession.getSessionName());
                    responseMessage.setValue(sessionMetadata);
                    break block13;
                }
                if (message instanceof EvaluateQueryableMessage) {
                    Object serviceSession = ServiceSession.findSession(message.getSessionId());
                    try {
                        ((ServiceSession)ServiceSession.getCurrentIdentity()).addIdentity((ServiceSession)serviceSession);
                        responseMessage.setValue(this.evaluate(((EvaluateQueryableMessage)message).getQueryable()));
                        break block13;
                    }
                    finally {
                        ((ServiceSession)ServiceSession.getCurrentIdentity()).removeIdentity();
                    }
                }
                if (!(message instanceof ExecuteMessage)) break block13;
                Object serviceSession = ServiceSession.findSession(message.getSessionId());
                try {
                    ((ServiceSession)ServiceSession.getCurrentIdentity()).addIdentity((ServiceSession)serviceSession);
                    ConsoleCommandLayerInterface consoleCommandLayerInterface = Layers.get(ConsoleCommandLayerInterface.class, ((ExecuteMessage)message).getCommandName());
                    responseMessage.setValue(consoleCommandLayerInterface.execute(((ExecuteMessage)message).getParameters()));
                }
                finally {
                    ((ServiceSession)ServiceSession.getCurrentIdentity()).removeIdentity();
                }
            }
            catch (Exception ex) {
                responseMessage.setThrowable(ex);
            }
        }
        try {
            this.send(session, responseMessage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract ServerMetadata getMetadata();

    protected abstract ServiceSession login(Map<String, Object> var1);

    protected abstract Collection<JoinableMap> evaluate(Queryable var1);
}

