/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.DefaultNetPackage;
import org.hcjf.io.net.NetClient;
import org.hcjf.io.net.NetPackage;
import org.hcjf.io.net.NetServer;
import org.hcjf.io.net.NetServiceConsumer;
import org.hcjf.io.net.NetSession;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceThread;
import org.hcjf.utils.LruMap;

public final class NetService
extends Service<NetServiceConsumer> {
    private static final NetService instance = new NetService(SystemProperties.get("hcjf.net.service.name"));
    private Map<NetServiceConsumer, ServerSocketChannel> serverSocketChannelMap;
    private Map<NetSession, SelectableChannel> channels;
    private Map<SelectableChannel, NetSession> sessionsByChannel;
    private DatagramChannel udpServer;
    private Map<NetSession, SocketAddress> addresses;
    private Map<SocketAddress, NetSession> sessionsByAddress;
    private Map<SelectableChannel, Long> lastWrite;
    private Map<SelectableChannel, Queue<NetPackage>> outputQueue;
    private Map<NetSession, SSLHelper> sslHelpers;
    private Map<NetServiceConsumer, SelectorRunnable> selectors;
    private Map<NetServiceConsumer, Future> tasks;
    private Timer timer;
    private boolean creationTimeoutAvailable;
    private long creationTimeout;
    private boolean shuttingDown;

    private NetService(String serviceName) {
        super(serviceName, 2);
    }

    public static final NetService getInstance() {
        return instance;
    }

    @Override
    protected void init() {
        this.timer = new Timer();
        this.selectors = new HashMap<NetServiceConsumer, SelectorRunnable>();
        this.tasks = new HashMap<NetServiceConsumer, Future>();
        this.creationTimeoutAvailable = SystemProperties.getBoolean("hcjf.net.connection.timeout.available");
        this.creationTimeout = SystemProperties.getLong("hcjf.net.connection.timeout");
        if (this.creationTimeoutAvailable && this.creationTimeout <= 0L) {
            throw new IllegalArgumentException("Illegal creation timeout value: " + this.creationTimeout);
        }
        this.lastWrite = Collections.synchronizedMap(new HashMap());
        this.outputQueue = Collections.synchronizedMap(new HashMap());
        this.serverSocketChannelMap = Collections.synchronizedMap(new HashMap());
        this.channels = Collections.synchronizedMap(new TreeMap());
        this.sessionsByChannel = Collections.synchronizedMap(new HashMap());
        this.sessionsByAddress = Collections.synchronizedMap(new LruMap(SystemProperties.getInteger("hcjf.net.io.udp.lru.sessions.size")));
        this.sslHelpers = Collections.synchronizedMap(new HashMap());
        this.addresses = Collections.synchronizedMap(new LruMap(SystemProperties.getInteger("hcjf.net.io.udp.lru.addresses.size")));
    }

    @Override
    protected void shutdown(Service.ShutdownStage stage) {
        this.shuttingDown = true;
        for (SelectorRunnable selectorRunnable : this.selectors.values()) {
            selectorRunnable.shutdown(stage);
        }
    }

    @Override
    public final void registerConsumer(NetServiceConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("Net consumer null");
        }
        boolean illegal = false;
        try {
            switch (consumer.getProtocol()) {
                case TCP: 
                case TCP_SSL: {
                    if (consumer instanceof NetServer) {
                        this.registerTCPNetServer((NetServer)consumer);
                        break;
                    }
                    if (consumer instanceof NetClient) {
                        this.registerTCPNetClient((NetClient)consumer);
                        break;
                    }
                    illegal = true;
                    break;
                }
                case UDP: {
                    if (consumer instanceof NetServer) {
                        this.registerUDPNetServer((NetServer)consumer);
                        break;
                    }
                    if (consumer instanceof NetClient) {
                        this.registerUDPNetClient((NetClient)consumer);
                        break;
                    }
                    illegal = true;
                }
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        if (illegal) {
            throw new IllegalArgumentException("Is not a legal consumer.");
        }
        consumer.setService(this);
    }

    @Override
    public void unregisterConsumer(NetServiceConsumer consumer) {
    }

    private void registerTCPNetServer(NetServer server) throws IOException {
        ServerSocketChannel tcpServer = ServerSocketChannel.open();
        tcpServer.configureBlocking(false);
        InetSocketAddress tcpAddress = new InetSocketAddress(server.getPort());
        tcpServer.socket().bind(tcpAddress);
        this.registerChannel(server, tcpServer, 16, server);
        this.serverSocketChannelMap.put(server, tcpServer);
    }

    private void registerTCPNetClient(NetClient client) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(false);
        channel.connect(new InetSocketAddress(client.getHost(), (int)client.getPort()));
        this.registerChannel(client, channel, 9, client);
    }

    private void registerUDPNetServer(NetServer server) throws IOException {
        this.udpServer = DatagramChannel.open();
        this.udpServer.configureBlocking(false);
        InetSocketAddress udpAddress = new InetSocketAddress(server.getPort());
        this.udpServer.socket().bind(udpAddress);
        this.registerChannel(server, this.udpServer, 1, server);
    }

    private void registerUDPNetClient(NetClient client) throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        InetSocketAddress address = new InetSocketAddress(client.getHost(), (int)client.getPort());
        channel.connect(address);
        this.addresses.put((NetSession)client.getSession(), address);
        this.sessionsByAddress.put(channel.getRemoteAddress(), (NetSession)client.getSession());
        this.registerChannel(client, channel, 1, client);
        this.selectors.get(client).addSession((NetSession)client.getSession());
    }

    private boolean isCreationTimeoutAvailable() {
        return this.creationTimeoutAvailable;
    }

    private long getCreationTimeout() {
        return this.creationTimeout;
    }

    private Timer getTimer() {
        return this.timer;
    }

    public final boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public final boolean checkSession(NetSession session) {
        boolean result = false;
        SelectableChannel channel = this.channels.get(session);
        if (channel != null) {
            result = channel.isOpen();
        }
        return result;
    }

    private void registerChannel(NetServiceConsumer consumer, SelectableChannel channel, int operation, Object attach) throws ClosedChannelException {
        this.selectors.put(consumer, new SelectorRunnable(consumer));
        this.tasks.put(consumer, this.fork(this.selectors.get(consumer)));
        this.selectors.get(consumer).registerChannel(channel, operation, attach);
    }

    private NetPackage createPackage(SelectableChannel channel, byte[] data, NetPackage.ActionEvent event) {
        int localPort;
        int remotePort;
        String remoteAddress;
        String remoteHost;
        if (channel instanceof SocketChannel) {
            remoteHost = "";
            if (SystemProperties.getBoolean("hcjf.net.remote.address.into.net.package").booleanValue()) {
                remoteHost = ((SocketChannel)channel).socket().getInetAddress().getHostName();
            }
            remoteAddress = ((SocketChannel)channel).socket().getInetAddress().getHostAddress();
            remotePort = ((SocketChannel)channel).socket().getPort();
            localPort = ((SocketChannel)channel).socket().getLocalPort();
        } else if (channel instanceof DatagramChannel) {
            remoteHost = "";
            remoteAddress = "";
            remotePort = -1;
            localPort = -1;
            try {
                Field field = channel.getClass().getDeclaredField("sender");
                field.setAccessible(true);
                InetSocketAddress socketAddress = (InetSocketAddress)field.get(channel);
                if (SystemProperties.getBoolean("hcjf.net.remote.address.into.net.package").booleanValue()) {
                    remoteHost = socketAddress.getAddress().getHostName();
                }
                remoteAddress = socketAddress.getAddress().getHostAddress();
                remotePort = socketAddress.getPort();
                localPort = ((DatagramChannel)channel).socket().getLocalPort();
            }
            catch (Exception ex) {
                Log.d(SystemProperties.get("hcjf.net.log.tag"), "createPackage method exception", ex, new Object[0]);
            }
        } else {
            throw new IllegalArgumentException("Unknown channel type");
        }
        DefaultNetPackage netPackage = new DefaultNetPackage(remoteHost, remoteAddress, remotePort, localPort, data, event);
        return netPackage;
    }

    private void writeWakeup(SelectableChannel channel, NetPackage netPackage) {
        SelectorRunnable selectorRunnable = this.selectors.get(netPackage.getSession().getConsumer());
        selectorRunnable.writeWakeup(channel, netPackage);
    }

    public final NetPackage writeData(NetSession session, byte[] data) throws IOException {
        SelectableChannel channel = this.channels.get(session);
        if (channel == null) {
            throw new IOException("Unknown session");
        }
        NetPackage netPackage = this.createPackage(channel, data, NetPackage.ActionEvent.WRITE);
        netPackage.setSession(session);
        this.writeWakeup(channel, netPackage);
        return netPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect(NetSession session, String message) {
        SelectableChannel channel = this.channels.get(session);
        if (channel != null) {
            SelectableChannel selectableChannel = channel;
            synchronized (selectableChannel) {
                if (this.channels.containsKey(session)) {
                    NetPackage netPackage = this.createPackage(channel, message.getBytes(), NetPackage.ActionEvent.DISCONNECT);
                    netPackage.setSession(session);
                    this.writeWakeup(channel, netPackage);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyChannel(SocketChannel channel) {
        SocketChannel socketChannel = channel;
        synchronized (socketChannel) {
            NetSession session = this.sessionsByChannel.remove(channel);
            this.lastWrite.remove(channel);
            this.outputQueue.remove(channel);
            if (this.sslHelpers.containsKey(session)) {
                this.sslHelpers.remove(session).close();
            }
            ArrayList<NetSession> removedSessions = new ArrayList<NetSession>();
            try {
                if (session != null) {
                    NetServer server;
                    this.channels.remove(session);
                    if (session.getConsumer() instanceof NetServer && (server = (NetServer)session.getConsumer()).isDisconnectAndRemove()) {
                        this.destroySession(session);
                    }
                    removedSessions.add(session);
                    if (session.getConsumer() != null) {
                        session.getConsumer().onDisconnect(session, null);
                    }
                }
                if (channel.isConnected()) {
                    channel.close();
                }
            }
            catch (Exception ex) {
                Log.d(SystemProperties.get("hcjf.net.log.tag"), "Destroy method exception", ex, new Object[0]);
            }
            if (session.getConsumer() instanceof NetClient) {
                SelectorRunnable selectorRunnable = this.selectors.remove(session.getConsumer());
                selectorRunnable.shutdown(Service.ShutdownStage.START);
                selectorRunnable.shutdown(Service.ShutdownStage.END);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChannel(SocketChannel oldChannel, SocketChannel newChannel) {
        NetSession session = this.sessionsByChannel.remove(oldChannel);
        try {
            if (oldChannel.isConnected()) {
                oldChannel.finishConnect();
                oldChannel.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.channels.put(session, newChannel);
        }
        this.sessionsByChannel.put(newChannel, session);
        this.outputQueue.put(newChannel, this.outputQueue.remove(oldChannel));
        this.lastWrite.put(newChannel, this.lastWrite.remove(oldChannel));
    }

    public final boolean isConnected(NetSession session) {
        return this.channels.containsKey(session);
    }

    private NetSession getSession(NetServiceConsumer consumer, NetPackage netPackage, SocketChannel socketChannel) {
        Object result;
        if (consumer instanceof NetServer) {
            result = ((NetServer)consumer).createSession(netPackage);
        } else if (consumer instanceof NetClient) {
            result = ((NetClient)consumer).getSession();
        } else {
            throw new IllegalArgumentException("The service consumer must be instance of org.hcjf.io.net.NetServer or org.hcjf.io.net.NetClient.");
        }
        if (SystemProperties.getBoolean("hcjf.net.remote.address.into.net.session").booleanValue()) {
            ((NetSession)result).setRemoteHost(socketChannel.socket().getInetAddress().getHostName());
            ((NetSession)result).setRemotePort(socketChannel.socket().getPort());
        } else {
            ((NetSession)result).setRemoteHost(socketChannel.socket().getInetAddress().getHostAddress());
            ((NetSession)result).setRemotePort(socketChannel.socket().getPort());
        }
        return result;
    }

    private void destroySession(NetSession session) {
        session.getConsumer().destroySession(session);
    }

    private void setSocketOptions(SocketChannel socketChannel, NetServiceConsumer consumer) throws IOException {
        Map<SocketOption, Object> socketOptions = consumer.getSocketOptions();
        if (socketOptions != null) {
            for (SocketOption socketOption : socketOptions.keySet()) {
                socketChannel.setOption(socketOption, socketOptions.get(socketOption));
            }
        }
    }

    private void connect(SelectableChannel keyChannel, NetClient client) {
        if (!this.isShuttingDown()) {
            try {
                SocketChannel channel = (SocketChannel)keyChannel;
                channel.configureBlocking(false);
                channel.socket().setKeepAlive(true);
                channel.socket().setSoTimeout(100);
                channel.finishConnect();
                this.setSocketOptions(channel, client);
                NetSession session = this.getSession(client, this.createPackage(channel, null, NetPackage.ActionEvent.CONNECT), (SocketChannel)keyChannel);
                if (session != null) {
                    this.selectors.get(client).addSession(session);
                    this.sessionsByChannel.put(channel, session);
                    this.channels.put(session, channel);
                    this.outputQueue.put(channel, new LinkedBlockingQueue());
                    this.lastWrite.put(channel, System.currentTimeMillis());
                    if (client.getProtocol().equals((Object)TransportLayerProtocol.TCP_SSL)) {
                        SSLHelper sslHelper = new SSLHelper(client.getSSLEngine(), channel, client, session);
                        this.sslHelpers.put(session, sslHelper);
                    } else {
                        NetPackage connectionPackage = this.createPackage(keyChannel, new byte[0], NetPackage.ActionEvent.CONNECT);
                        this.onAction(connectionPackage, client);
                    }
                } else {
                    Log.w(SystemProperties.get("hcjf.net.log.tag"), "Rejected connection, session null", new Object[0]);
                    channel.close();
                    client.onConnectFail();
                    SelectorRunnable selectorRunnable = this.selectors.remove(client);
                    selectorRunnable.shutdown(Service.ShutdownStage.START);
                    selectorRunnable.shutdown(Service.ShutdownStage.END);
                }
            }
            catch (Exception ex) {
                Log.w(SystemProperties.get("hcjf.net.log.tag"), "Error creating new client connection, %s:%d", ex, client.getHost(), client.getPort());
                client.onConnectFail();
                SelectorRunnable selectorRunnable = this.selectors.remove(client);
                selectorRunnable.shutdown(Service.ShutdownStage.START);
                selectorRunnable.shutdown(Service.ShutdownStage.END);
            }
        }
    }

    private void accept(SelectableChannel keyChannel, NetServer server) {
        if (!this.isShuttingDown()) {
            try {
                ServerSocketChannel serverSocketChannel = (ServerSocketChannel)keyChannel;
                SocketChannel socketChannel = serverSocketChannel.accept();
                socketChannel.configureBlocking(false);
                this.setSocketOptions(socketChannel, server);
                NetSession session = this.getSession(server, this.createPackage(socketChannel, null, NetPackage.ActionEvent.CONNECT), socketChannel);
                if (session != null) {
                    if (this.channels.containsKey(session)) {
                        this.updateChannel((SocketChannel)this.channels.remove(session), socketChannel);
                    } else {
                        this.sessionsByChannel.put(socketChannel, session);
                        this.outputQueue.put(socketChannel, new LinkedBlockingQueue());
                        this.lastWrite.put(socketChannel, System.currentTimeMillis());
                        this.channels.put(session, socketChannel);
                        this.selectors.get(server).addSession(session);
                    }
                    if (server.getProtocol().equals((Object)TransportLayerProtocol.TCP_SSL)) {
                        SSLHelper sslHelper = new SSLHelper(server.getSSLEngine(), socketChannel, server, session);
                        this.sslHelpers.put(session, sslHelper);
                    }
                    socketChannel.register(this.selectors.get(server).getSelector(), 1, server);
                    if (this.isCreationTimeoutAvailable() && server.isCreationTimeoutAvailable()) {
                        this.getTimer().schedule((TimerTask)new ConnectionTimeout(socketChannel), this.getCreationTimeout());
                    }
                } else {
                    Log.w(SystemProperties.get("hcjf.net.log.tag"), "Rejected connection, session null", new Object[0]);
                    socketChannel.close();
                }
            }
            catch (Exception ex) {
                Log.w(SystemProperties.get("hcjf.net.log.tag"), "Error accepting a new connection.", ex, new Object[0]);
            }
        }
    }

    private void read(SelectableChannel keyChannel, NetServiceConsumer consumer) {
        if (!this.isShuttingDown()) {
            if (keyChannel instanceof SocketChannel) {
                SocketChannel channel = (SocketChannel)keyChannel;
                NetIOThread ioThread = (NetIOThread)Thread.currentThread();
                try {
                    int totalSize = 0;
                    ByteBuffer inputBuffer = ioThread.getInputBuffer();
                    inputBuffer.clear();
                    inputBuffer.rewind();
                    try {
                        int readSize = channel.read(inputBuffer);
                        totalSize += readSize;
                        while (readSize > 0) {
                            readSize = channel.read(inputBuffer);
                            totalSize += readSize;
                        }
                    }
                    catch (IOException ex) {
                        this.destroyChannel(channel);
                    }
                    if (totalSize == -1) {
                        this.destroyChannel(channel);
                    } else if (totalSize > 0) {
                        Log.d(SystemProperties.get("hcjf.net.log.tag"), "Total size read: %d", totalSize);
                        byte[] data = new byte[inputBuffer.position()];
                        inputBuffer.rewind();
                        inputBuffer.get(data);
                        NetPackage netPackage = this.createPackage(channel, data, NetPackage.ActionEvent.READ);
                        NetSession session = this.sessionsByChannel.get(channel);
                        ((ServiceThread)Thread.currentThread()).setSession(session);
                        netPackage.setSession(session);
                        if (consumer.getProtocol().equals((Object)TransportLayerProtocol.TCP_SSL)) {
                            netPackage = this.sslHelpers.get(session).read(netPackage);
                        }
                        this.onAction(netPackage, consumer);
                    }
                }
                catch (Exception ex) {
                    Log.e(SystemProperties.get("hcjf.net.log.tag"), "Net service read exception, on TCP context", ex, new Object[0]);
                    this.destroyChannel(channel);
                }
            } else if (keyChannel instanceof DatagramChannel) {
                DatagramChannel channel = (DatagramChannel)keyChannel;
                NetIOThread ioThread = (NetIOThread)Thread.currentThread();
                try {
                    ByteArrayOutputStream readData = new ByteArrayOutputStream();
                    ioThread.getInputBuffer().clear();
                    ioThread.getInputBuffer().rewind();
                    InetSocketAddress address = (InetSocketAddress)channel.receive(ioThread.getInputBuffer());
                    readData.write(ioThread.getInputBuffer().array(), 0, ioThread.getInputBuffer().position());
                    if (address != null) {
                        NetPackage netPackage = this.createPackage(channel, readData.toByteArray(), NetPackage.ActionEvent.READ);
                        NetSession session = this.sessionsByAddress.get(address);
                        if (session == null && consumer instanceof NetServer) {
                            session = ((NetServer)consumer).createSession(netPackage);
                            this.sessionsByAddress.put(address, session);
                        }
                        if (!this.addresses.containsKey(session)) {
                            this.addresses.put(session, address);
                        }
                        if (!this.channels.containsKey(session)) {
                            this.channels.put(session, channel);
                        }
                        ((ServiceThread)Thread.currentThread()).setSession(session);
                        netPackage.setSession(session);
                        if (!this.outputQueue.containsKey(channel)) {
                            this.outputQueue.put(channel, new LinkedBlockingQueue());
                            this.lastWrite.put(channel, System.currentTimeMillis());
                        }
                        if (readData.size() > 0) {
                            this.onAction(netPackage, consumer);
                        }
                    }
                }
                catch (Exception ex) {
                    Log.e(SystemProperties.get("hcjf.net.log.tag"), "Net service read exception, on UDP context", ex, new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SelectableChannel channel, NetServiceConsumer consumer) {
        block32: {
            NetIOThread ioThread = (NetIOThread)Thread.currentThread();
            try {
                Queue<NetPackage> queue = this.outputQueue.get(channel);
                if (queue == null) break block32;
                this.lastWrite.put(channel, System.currentTimeMillis());
                boolean stop = false;
                int count = 0;
                while (!queue.isEmpty() && !stop) {
                    NetPackage netPackage = queue.poll();
                    if (netPackage == null) {
                        break;
                    }
                    NetSession session = netPackage.getSession();
                    switch (netPackage.getActionEvent()) {
                        case WRITE: {
                            try {
                                if (consumer.getProtocol().equals((Object)TransportLayerProtocol.TCP_SSL)) {
                                    netPackage = this.sslHelpers.get(session).write(netPackage);
                                } else {
                                    byte[] byteData = netPackage.getPayload();
                                    if (byteData != null) {
                                        int begin;
                                        int length;
                                        if (byteData.length == 0) {
                                            Log.d(SystemProperties.get("hcjf.net.log.tag"), "Empty write data", new Object[0]);
                                        }
                                        int n = length = byteData.length - (begin = 0) > ioThread.getOutputBufferSize() ? ioThread.getOutputBufferSize() : byteData.length - begin;
                                        while (begin < byteData.length) {
                                            SocketAddress address;
                                            ioThread.getOutputBuffer().limit(length);
                                            ioThread.getOutputBuffer().put(byteData, begin, length);
                                            ioThread.getOutputBuffer().rewind();
                                            if (channel instanceof SocketChannel) {
                                                for (int writtenData = 0; writtenData < length; writtenData += ((SocketChannel)channel).write(ioThread.getOutputBuffer())) {
                                                }
                                            } else if (channel instanceof DatagramChannel && this.sessionsByAddress.get(address = this.addresses.get(netPackage.getSession())).equals(netPackage.getSession())) {
                                                ((DatagramChannel)channel).send(ioThread.getOutputBuffer(), address);
                                            }
                                            ioThread.getOutputBuffer().rewind();
                                            length = byteData.length - (begin += length) > ioThread.getOutputBufferSize() ? ioThread.getOutputBufferSize() : byteData.length - begin;
                                        }
                                    }
                                }
                                if (netPackage != null) {
                                    netPackage.setPackageStatus(NetPackage.PackageStatus.OK);
                                }
                            }
                            catch (Exception ex) {
                                netPackage.setPackageStatus(NetPackage.PackageStatus.IO_ERROR);
                                throw ex;
                            }
                            finally {
                                this.onAction(netPackage, consumer);
                            }
                            try {
                                channel.keyFor(this.selectors.get(consumer).getSelector()).interestOps(1);
                            }
                            catch (Exception ex) {
                                Log.e(SystemProperties.get("hcjf.net.log.tag"), "Write error", ex, new Object[0]);
                            }
                            break;
                        }
                        case DISCONNECT: {
                            if (channel instanceof SocketChannel) {
                                this.destroyChannel((SocketChannel)channel);
                            } else if (channel instanceof DatagramChannel && !channel.equals(this.udpServer)) {
                                NetServer server;
                                this.outputQueue.remove(channel);
                                this.lastWrite.remove(channel);
                                this.channels.remove(netPackage.getSession());
                                if (netPackage.getSession().getConsumer() instanceof NetServer && (server = (NetServer)netPackage.getSession().getConsumer()).isDisconnectAndRemove()) {
                                    this.destroySession(session);
                                }
                            }
                            this.onAction(netPackage, consumer);
                            stop = true;
                        }
                    }
                    ++count;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Log.d(SystemProperties.get("hcjf.net.log.tag"), "Write global thread exception", ex, new Object[0]);
            }
            finally {
                ioThread.getOutputBuffer().clear();
                ioThread.getOutputBuffer().rewind();
            }
        }
    }

    private void onAction(NetPackage netPackage, NetServiceConsumer consumer) {
        if (netPackage != null) {
            try {
                switch (netPackage.getActionEvent()) {
                    case CONNECT: {
                        consumer.onConnect(netPackage);
                        break;
                    }
                    case DISCONNECT: {
                        consumer.onDisconnect(netPackage);
                        break;
                    }
                    case READ: {
                        if (netPackage.getSession() != null && netPackage.getPayload() != null) {
                            netPackage.getSession().addIngressPackage(netPackage.getPayload().length);
                        }
                        consumer.onRead(netPackage);
                        break;
                    }
                    case WRITE: {
                        if (netPackage.getSession() != null && netPackage.getPayload() != null) {
                            netPackage.getSession().addEgressPackage(netPackage.getPayload().length);
                        }
                        consumer.onWrite(netPackage);
                    }
                }
            }
            catch (Exception ex) {
                Log.e(SystemProperties.get("hcjf.net.log.tag"), "Action consumer exception", ex, new Object[0]);
            }
        }
    }

    private static class SSLHelper
    implements Runnable {
        private static final String IO_NAME_TEMPLATE = "SSL IO (%s)";
        private static final String ENGINE_NAME_TEMPLATE = "SSL ENGINE (%s)";
        private final String ioName;
        private final String engineName;
        private SSLEngine sslEngine;
        private final SelectableChannel selectableChannel;
        private final NetServiceConsumer consumer;
        private final NetSession session;
        private final ThreadPoolExecutor ioExecutor;
        private final ThreadPoolExecutor engineTaskExecutor;
        private final ByteBuffer srcWrap;
        private final ByteBuffer destWrap;
        private final ByteBuffer srcUnwrap;
        private final ByteBuffer destUnwrap;
        private SSLHelperStatus status;
        private final Object writeSemaphore;
        private final Object readSemaphore;
        private ByteBuffer decryptedPlace;
        private boolean read;
        private boolean written;

        public SSLHelper(SSLEngine sslEngine, SelectableChannel selectableChannel, NetServiceConsumer consumer, NetSession session) {
            this.sslEngine = sslEngine;
            this.selectableChannel = selectableChannel;
            this.consumer = consumer;
            this.session = session;
            this.ioExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
            this.ioExecutor.setThreadFactory(R -> new ServiceThread(R, SystemProperties.get("hcjf.net.ssl.io.thread.name")));
            this.engineTaskExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(SystemProperties.getInteger("hcjf.net.ssl.max.io.thread.pool.size"));
            this.engineTaskExecutor.setThreadFactory(R -> new ServiceThread(R, SystemProperties.get("hcjf.net.ssl.engine.thread.name")));
            this.srcWrap = ByteBuffer.allocate(SystemProperties.getInteger("hcjf.net.output.buffer.size"));
            this.destWrap = ByteBuffer.allocate(SystemProperties.getInteger("hcjf.net.output.buffer.size"));
            this.srcUnwrap = ByteBuffer.allocate(SystemProperties.getInteger("hcjf.net.input.buffer.size"));
            this.destUnwrap = ByteBuffer.allocate(SystemProperties.getInteger("hcjf.net.input.buffer.size"));
            this.srcUnwrap.limit(0);
            this.status = SSLHelperStatus.WAITING;
            this.readSemaphore = new Object();
            this.writeSemaphore = new Object();
            this.ioName = String.format(IO_NAME_TEMPLATE, consumer.getName());
            this.engineName = String.format(ENGINE_NAME_TEMPLATE, consumer.getName());
            instance.fork(this, this.ioName, this.ioExecutor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onRead(ByteBuffer decrypted) {
            byte[] decryptedArray = new byte[decrypted.limit()];
            decrypted.get(decryptedArray);
            if (this.status.equals((Object)SSLHelperStatus.READY)) {
                Object object = this.readSemaphore;
                synchronized (object) {
                    this.read = true;
                    this.decryptedPlace = ByteBuffer.wrap(decryptedArray);
                    this.readSemaphore.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onWrite(ByteBuffer encrypted) {
            try {
                long size = encrypted.limit();
                for (long total = 0L; total < size; total += (long)((SocketChannel)this.selectableChannel).write(encrypted)) {
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("", ex);
            }
            if (this.status.equals((Object)SSLHelperStatus.READY)) {
                Object object = this.writeSemaphore;
                synchronized (object) {
                    this.written = true;
                    this.writeSemaphore.notifyAll();
                }
            }
        }

        private void onFailure(Exception ex) {
            this.status = SSLHelperStatus.FAIL;
        }

        private void onSuccess() {
            Log.d(SystemProperties.get("hcjf.net.log.tag"), "SSL handshaking success", new Object[0]);
            this.status = SSLHelperStatus.READY;
            DefaultNetPackage defaultNetPackage = new DefaultNetPackage("", "", 0, this.consumer.getPort(), new byte[0], NetPackage.ActionEvent.CONNECT);
            defaultNetPackage.setSession(this.session);
            if (this.consumer instanceof NetClient) {
                this.consumer.onConnect(defaultNetPackage);
            }
        }

        private void onClosed() {
            DefaultNetPackage defaultNetPackage = new DefaultNetPackage("", "", 0, this.consumer.getPort(), new byte[0], NetPackage.ActionEvent.DISCONNECT);
            this.consumer.onDisconnect(this.session, defaultNetPackage);
        }

        @Override
        public void run() {
            while (this.isHandShaking()) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized NetPackage write(NetPackage netPackage) {
            instance.fork(() -> {
                this.srcWrap.put(netPackage.getPayload());
                this.run();
            }, this.ioName, this.ioExecutor);
            DefaultNetPackage defaultNetPackage = null;
            if (this.status.equals((Object)SSLHelperStatus.READY)) {
                Object object = this.writeSemaphore;
                synchronized (object) {
                    try {
                        if (!this.written) {
                            this.readSemaphore.wait();
                            defaultNetPackage = new DefaultNetPackage("", "", 0, this.consumer.getPort(), netPackage.getPayload(), NetPackage.ActionEvent.READ);
                            defaultNetPackage.setSession(netPackage.getSession());
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.written = false;
                    }
                }
            }
            return defaultNetPackage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized NetPackage read(NetPackage netPackage) {
            instance.fork(() -> {
                this.srcUnwrap.put(netPackage.getPayload());
                this.run();
            }, this.ioName, this.ioExecutor);
            DefaultNetPackage defaultNetPackage = null;
            if (this.status.equals((Object)SSLHelperStatus.READY)) {
                Object object = this.readSemaphore;
                synchronized (object) {
                    try {
                        if (!this.read) {
                            this.readSemaphore.wait();
                        }
                        defaultNetPackage = new DefaultNetPackage("", "", 0, this.consumer.getPort(), this.decryptedPlace.array(), NetPackage.ActionEvent.READ);
                        defaultNetPackage.setSession(netPackage.getSession());
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.read = false;
                    }
                }
            }
            return defaultNetPackage;
        }

        public void close() {
            try {
                this.sslEngine.closeInbound();
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
            this.sslEngine.closeOutbound();
        }

        private boolean isHandShaking() {
            switch (this.sslEngine.getHandshakeStatus()) {
                case NOT_HANDSHAKING: {
                    boolean occupied = false;
                    if (this.srcWrap.position() > 0) {
                        occupied |= this.wrap();
                    }
                    if (this.srcUnwrap.position() > 0) {
                        occupied |= this.unwrap();
                    }
                    return occupied;
                }
                case NEED_WRAP: {
                    if (this.wrap()) break;
                    return false;
                }
                case NEED_UNWRAP: {
                    if (this.unwrap()) break;
                    return false;
                }
                case NEED_TASK: {
                    Runnable sslTask = this.sslEngine.getDelegatedTask();
                    instance.fork(() -> {
                        sslTask.run();
                        instance.fork(this, this.ioName, this.ioExecutor);
                    }, this.engineName, this.engineTaskExecutor);
                    return false;
                }
                case FINISHED: {
                    throw new IllegalStateException("SSL handshaking fail");
                }
            }
            return true;
        }

        private boolean wrap() {
            SSLEngineResult wrapResult;
            try {
                this.srcWrap.flip();
                wrapResult = this.sslEngine.wrap(this.srcWrap, this.destWrap);
                this.srcWrap.compact();
            }
            catch (SSLException exc) {
                this.onFailure(exc);
                return false;
            }
            switch (wrapResult.getStatus()) {
                case OK: {
                    if (this.destWrap.position() <= 0) break;
                    this.destWrap.flip();
                    this.onWrite(this.destWrap);
                    this.destWrap.compact();
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    break;
                }
                case BUFFER_OVERFLOW: {
                    throw new IllegalStateException("SSL failed to wrap");
                }
                case CLOSED: {
                    this.onClosed();
                    return false;
                }
            }
            if (this.consumer instanceof NetServer && wrapResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.onSuccess();
                return false;
            }
            return true;
        }

        private boolean unwrap() {
            SSLEngineResult unwrapResult;
            try {
                this.srcUnwrap.flip();
                unwrapResult = this.sslEngine.unwrap(this.srcUnwrap, this.destUnwrap);
                this.srcUnwrap.compact();
            }
            catch (SSLException ex) {
                this.onFailure(ex);
                return false;
            }
            switch (unwrapResult.getStatus()) {
                case OK: {
                    if (this.destUnwrap.position() <= 0) break;
                    this.destUnwrap.flip();
                    this.onRead(this.destUnwrap);
                    this.destUnwrap.compact();
                    break;
                }
                case CLOSED: {
                    this.onClosed();
                    return false;
                }
                case BUFFER_OVERFLOW: {
                    throw new IllegalStateException("SSL failed to unwrap");
                }
                case BUFFER_UNDERFLOW: {
                    return false;
                }
            }
            if (this.consumer instanceof NetClient && unwrapResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.onSuccess();
                return false;
            }
            return true;
        }

        public static enum SSLHelperStatus {
            WAITING,
            READY,
            FAIL;

        }
    }

    public static enum TransportLayerProtocol {
        TCP,
        TCP_SSL,
        UDP;

    }

    private class ConnectionTimeout
    extends TimerTask {
        private final SocketChannel channel;

        public ConnectionTimeout(SocketChannel channel) {
            this.channel = channel;
        }

        @Override
        public void run() {
            NetService.this.fork(() -> {
                if (!NetService.this.sessionsByChannel.containsKey(this.channel)) {
                    try {
                        NetService.this.destroyChannel(this.channel);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public class NetIOThread
    extends ServiceThread {
        private final ByteBuffer inputBuffer;
        private final ByteBuffer outputBuffer;
        private int inputBufferSize;
        private int outputBufferSize;

        public NetIOThread(Runnable target) {
            super(target, "Net IO");
            this.inputBufferSize = SystemProperties.getInteger("hcjf.net.default.input.buffer.size");
            this.outputBufferSize = SystemProperties.getInteger("hcjf.net.default.output.buffer.size");
            if (SystemProperties.getBoolean("hcjf.net.io.thread.direct.allocate.memory").booleanValue()) {
                this.inputBuffer = ByteBuffer.allocateDirect(this.getInputBufferSize());
                this.outputBuffer = ByteBuffer.allocateDirect(this.getOutputBufferSize());
            } else {
                this.inputBuffer = ByteBuffer.allocate(this.getInputBufferSize());
                this.outputBuffer = ByteBuffer.allocate(this.getOutputBufferSize());
            }
        }

        public final ByteBuffer getInputBuffer() {
            return this.inputBuffer;
        }

        public final ByteBuffer getOutputBuffer() {
            return this.outputBuffer;
        }

        public int getInputBufferSize() {
            return this.inputBufferSize;
        }

        public int getOutputBufferSize() {
            return this.outputBufferSize;
        }
    }

    private class NetIOThreadFactory
    implements ThreadFactory {
        private NetIOThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new NetIOThread(runnable);
        }
    }

    private class SelectorRunnable
    implements Runnable {
        private final NetServiceConsumer consumer;
        private Selector selector;
        private final Object monitor;
        private Boolean blocking;
        private Set<NetSession> sessions;
        private final Queue<SelectionKey> readableKeys;
        private final Queue<SelectionKey> writableKeys;
        private final ThreadPoolExecutor readIoExecutor;
        private final ThreadPoolExecutor writeIoExecutor;

        private SelectorRunnable(NetServiceConsumer consumer) {
            this.consumer = consumer;
            this.monitor = new Object();
            this.blocking = false;
            this.sessions = new TreeSet<NetSession>();
            try {
                this.createSelector();
            }
            catch (IOException ex) {
                throw new HCJFRuntimeException("Unable to create selector", (Throwable)ex, new Object[0]);
            }
            this.readableKeys = new ArrayBlockingQueue<SelectionKey>(SystemProperties.getInteger("hcjf.net.io.queue.size"));
            this.writableKeys = new ArrayBlockingQueue<SelectionKey>(SystemProperties.getInteger("hcjf.net.io.queue.size"));
            this.readIoExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool(new NetIOThreadFactory());
            this.readIoExecutor.setKeepAliveTime(SystemProperties.getInteger("hcjf.net.io.thread.pool.keep.alive.time").intValue(), TimeUnit.SECONDS);
            this.writeIoExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool(new NetIOThreadFactory());
            this.writeIoExecutor.setKeepAliveTime(SystemProperties.getInteger("hcjf.net.io.thread.pool.keep.alive.time").intValue(), TimeUnit.SECONDS);
            NetService.this.fork(new Reader(), SystemProperties.get("hcjf.net.io.thread.pool.name"), this.readIoExecutor);
            NetService.this.fork(new Writer(), SystemProperties.get("hcjf.net.io.thread.pool.name"), this.writeIoExecutor);
        }

        private Set<NetSession> getSessions() {
            return Collections.unmodifiableSet(this.sessions);
        }

        public void addSession(NetSession session) {
            this.sessions.add(session);
        }

        private Selector getSelector() {
            return this.selector;
        }

        private void setSelector(Selector selector) {
            this.selector = selector;
        }

        public Object getMonitor() {
            return this.monitor;
        }

        public Boolean getBlocking() {
            return this.blocking;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerChannel(SelectableChannel channel, int operation, Object attach) throws ClosedChannelException {
            Object object = this.monitor;
            synchronized (object) {
                channel.register(this.getSelector(), operation, attach);
                this.wakeup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeWakeup(SelectableChannel channel, NetPackage netPackage) {
            NetService.this.outputQueue.get(channel).add(netPackage);
            SelectionKey key = channel.keyFor(this.getSelector());
            Queue<SelectionKey> queue = this.writableKeys;
            synchronized (queue) {
                if (key.isValid() && !this.writableKeys.contains(key) && !this.writableKeys.offer(key)) {
                    Log.d(SystemProperties.get("hcjf.net.log.tag"), "Unable to add writable key!!!!", new Object[0]);
                }
                this.writableKeys.notifyAll();
            }
        }

        private void shutdown(Service.ShutdownStage stage) {
            switch (stage) {
                case START: {
                    for (NetSession session : this.getSessions()) {
                        try {
                            NetService.this.writeData(session, session.getConsumer().getShutdownFrame(session));
                        }
                        catch (IOException iOException) {}
                    }
                    this.wakeup();
                    break;
                }
                case END: {
                    for (NetSession session : this.getSessions()) {
                        NetService.this.disconnect(session, "");
                    }
                    NetService.this.tasks.remove(this.consumer).cancel(true);
                    this.wakeup();
                }
            }
        }

        private void createSelector() throws IOException {
            Selector newSelector = Selector.open();
            Selector selector = this.getSelector();
            if (selector != null) {
                for (SelectionKey key : selector.keys()) {
                    try {
                        SelectableChannel ch = key.channel();
                        int ops = key.interestOps();
                        Object att = key.attachment();
                        key.cancel();
                        ch.register(newSelector, ops, att);
                    }
                    catch (Exception exception) {}
                }
                try {
                    selector.close();
                    Log.d(SystemProperties.get("hcjf.net.log.tag"), "Previous selector closed", new Object[0]);
                }
                catch (Throwable ex) {
                    Log.w(SystemProperties.get("hcjf.net.log.tag"), "Fail to close the old selector", ex, new Object[0]);
                }
            }
            this.setSelector(newSelector);
            Log.d(SystemProperties.get("hcjf.net.log.tag"), "New selector created", new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int select() throws IOException {
            Object object = this.monitor;
            synchronized (object) {
                this.blocking = true;
            }
            int result = this.getSelector().select();
            object = this.monitor;
            synchronized (object) {
                this.blocking = false;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wakeup() {
            Object object = this.monitor;
            synchronized (object) {
                if (this.blocking.booleanValue()) {
                    this.getSelector().wakeup();
                    this.blocking = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    Thread.currentThread().setName(SystemProperties.get("hcjf.net.log.tag"));
                    Thread.currentThread().setPriority(10);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                long selectorMinWaitTime = SystemProperties.getLong("hcjf.net.nio.selector.min.wait.time");
                int selectorCounterLimit = SystemProperties.getInteger("hcjf.net.nio.selector.min.wait.counter.limit");
                int selectorCounter = 0;
                while (!Thread.currentThread().isInterrupted()) {
                    long selectionStartPeriod = System.currentTimeMillis();
                    int selectionSize = this.select();
                    if (selectionSize == 0) {
                        long selectionPeriod = System.currentTimeMillis() - selectionStartPeriod;
                        if (selectionPeriod >= selectorMinWaitTime || ++selectorCounter <= selectorCounterLimit) continue;
                        selectorCounter = 0;
                        Log.d(SystemProperties.get("hcjf.net.log.tag"), "Fixing selector loop", new Object[0]);
                        continue;
                    }
                    selectorCounter = 0;
                    Iterator<SelectionKey> selectedKeys = this.getSelector().selectedKeys().iterator();
                    while (selectedKeys.hasNext()) {
                        SelectionKey key = selectedKeys.next();
                        selectedKeys.remove();
                        if (!key.isValid()) continue;
                        try {
                            SelectableChannel keyChannel = key.channel();
                            if (keyChannel != null && key.channel().isOpen() && key.isValid()) {
                                Queue<SelectionKey> queue;
                                NetServiceConsumer consumer = (NetServiceConsumer)key.attachment();
                                if (key.isAcceptable()) {
                                    NetService.this.accept(key.channel(), (NetServer)consumer);
                                    continue;
                                }
                                if (key.isConnectable()) {
                                    NetService.this.connect(key.channel(), (NetClient)consumer);
                                    continue;
                                }
                                if (key.isReadable()) {
                                    queue = this.readableKeys;
                                    synchronized (queue) {
                                        if (key.isValid() && !this.readableKeys.contains(key) && !this.readableKeys.offer(key)) {
                                            Log.d(SystemProperties.get("hcjf.net.log.tag"), "Unable to add readable key!!!!", new Object[0]);
                                        }
                                        this.readableKeys.notifyAll();
                                        continue;
                                    }
                                }
                                if (!key.isWritable()) continue;
                                queue = this.writableKeys;
                                synchronized (queue) {
                                    if (key.isValid() && !this.writableKeys.contains(key) && !this.writableKeys.offer(key)) {
                                        Log.d(SystemProperties.get("hcjf.net.log.tag"), "Unable to add writable key!!!!", new Object[0]);
                                    }
                                    this.writableKeys.notifyAll();
                                    continue;
                                }
                            }
                            key.cancel();
                        }
                        catch (CancelledKeyException ex) {
                            Log.d(SystemProperties.get("hcjf.net.log.tag"), "Cancelled key", new Object[0]);
                        }
                        catch (Exception ex) {
                            Log.e(SystemProperties.get("hcjf.net.log.tag"), "Net service main thread exception", ex, new Object[0]);
                        }
                    }
                }
                try {
                    this.getSelector().close();
                }
                catch (IOException ex) {
                    Log.d(SystemProperties.get("hcjf.net.log.tag"), "Closing selector...", ex, new Object[0]);
                }
                if (NetServer.class.isAssignableFrom(this.consumer.getClass())) {
                    ServerSocketChannel channel = NetService.this.serverSocketChannelMap.get(this.consumer);
                    try {
                        channel.close();
                    }
                    catch (IOException ex) {
                        Log.d(SystemProperties.get("hcjf.net.log.tag"), "Closing channel...", ex, new Object[0]);
                    }
                }
                NetService.this.selectors.remove(this.consumer);
            }
            catch (Exception ex) {
                Log.e(SystemProperties.get("hcjf.net.log.tag"), "Unexpected error", ex, new Object[0]);
            }
            this.readIoExecutor.shutdownNow();
            this.writeIoExecutor.shutdownNow();
            Log.d(SystemProperties.get("hcjf.net.log.tag"), "Selector stopped", new Object[0]);
        }

        private class Writer
        implements Runnable {
            private Writer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    SelectionKey key;
                    Queue<SelectionKey> queue = SelectorRunnable.this.writableKeys;
                    synchronized (queue) {
                        key = SelectorRunnable.this.writableKeys.poll();
                    }
                    if (key != null) {
                        try {
                            NetServiceConsumer consumer = (NetServiceConsumer)key.attachment();
                            SelectableChannel keyChannel = key.channel();
                            if (keyChannel == null || !key.channel().isOpen()) continue;
                            SelectableChannel selectableChannel = keyChannel;
                            synchronized (selectableChannel) {
                                try {
                                    if (key.isValid()) {
                                        NetService.this.write(keyChannel, consumer);
                                    }
                                }
                                catch (Exception ex) {
                                    Log.d(SystemProperties.get("hcjf.net.log.tag"), "Internal write exception", ex, new Object[0]);
                                }
                                finally {
                                    ((ServiceThread)Thread.currentThread()).setSession(null);
                                }
                                continue;
                            }
                        }
                        catch (Exception ex) {
                            Log.d(SystemProperties.get("hcjf.net.log.tag"), "Internal IO thread exception, before to write process", ex, new Object[0]);
                            continue;
                        }
                    }
                    try {
                        if (!SelectorRunnable.this.writableKeys.isEmpty()) continue;
                        Queue<SelectionKey> ex = SelectorRunnable.this.writableKeys;
                        synchronized (ex) {
                            SelectorRunnable.this.writableKeys.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                Log.d(SystemProperties.get("hcjf.net.log.tag"), "Writer finished", new Object[0]);
            }
        }

        private class Reader
        implements Runnable {
            private Reader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    SelectionKey key;
                    Queue<SelectionKey> queue = SelectorRunnable.this.readableKeys;
                    synchronized (queue) {
                        key = SelectorRunnable.this.readableKeys.poll();
                    }
                    if (key != null) {
                        try {
                            NetServiceConsumer consumer = (NetServiceConsumer)key.attachment();
                            SelectableChannel keyChannel = key.channel();
                            if (keyChannel == null || !key.channel().isOpen()) continue;
                            SelectableChannel selectableChannel = keyChannel;
                            synchronized (selectableChannel) {
                                try {
                                    if (key.isValid()) {
                                        NetService.this.read(keyChannel, consumer);
                                    }
                                }
                                catch (Exception ex) {
                                    Log.d(SystemProperties.get("hcjf.net.log.tag"), "Internal read exception", ex, new Object[0]);
                                }
                                finally {
                                    ((ServiceThread)Thread.currentThread()).setSession(null);
                                }
                                continue;
                            }
                        }
                        catch (Exception ex) {
                            Log.d(SystemProperties.get("hcjf.net.log.tag"), "Internal IO thread exception, before to read process", ex, new Object[0]);
                            continue;
                        }
                    }
                    try {
                        if (!SelectorRunnable.this.readableKeys.isEmpty()) continue;
                        Queue<SelectionKey> ex = SelectorRunnable.this.readableKeys;
                        synchronized (ex) {
                            SelectorRunnable.this.readableKeys.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                Log.d(SystemProperties.get("hcjf.net.log.tag"), "Reader finished", new Object[0]);
            }
        }
    }
}

