/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net;

import java.io.IOException;
import java.net.SocketOption;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import javax.net.ssl.SSLEngine;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.NetPackage;
import org.hcjf.io.net.NetService;
import org.hcjf.io.net.NetSession;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceConsumer;
import org.hcjf.service.ServiceSession;

public abstract class NetServiceConsumer<S extends NetSession, D>
implements ServiceConsumer {
    private static final String NAME_TEMPLATE = "%s %s %d";
    private final String name;
    private final Integer port;
    private final NetService.TransportLayerProtocol protocol;
    private NetService service;
    private long writeWaitForTimeout;
    private Boolean decoupledIoAction;
    private Queue<DecoupledAction> actionsQueue;

    public NetServiceConsumer(Integer port, NetService.TransportLayerProtocol protocol) {
        this.port = port;
        this.protocol = protocol;
        this.writeWaitForTimeout = SystemProperties.getLong("hcjf.net.write.timeout");
        this.name = String.format(NAME_TEMPLATE, this.getClass().getName(), protocol.toString(), port);
        this.decoupledIoAction = false;
    }

    public final Boolean isDecoupledIoAction() {
        return this.decoupledIoAction;
    }

    public final void decoupleIoAction(Integer actionQueueSize, Integer workersNumber) {
        if (actionQueueSize <= 10) {
            throw new HCJFRuntimeException("The actions queue size can't be smaller than 11 places", new Object[0]);
        }
        if (workersNumber <= 0) {
            throw new HCJFRuntimeException("The decoupled function must have at least one worker", new Object[0]);
        }
        this.decoupledIoAction = true;
        this.actionsQueue = new ArrayBlockingQueue<DecoupledAction>(actionQueueSize);
        for (int i = 0; i < workersNumber; ++i) {
            Service.run(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    DecoupledAction decoupledAction;
                    Queue<DecoupledAction> queue = this.actionsQueue;
                    synchronized (queue) {
                        decoupledAction = this.actionsQueue.poll();
                    }
                    if (decoupledAction != null) {
                        try {
                            ((ServiceSession)ServiceSession.getCurrentSession()).addIdentity(decoupledAction.getServiceSession());
                            decoupledAction.onAction();
                            ((ServiceSession)ServiceSession.getCurrentSession()).removeIdentity();
                        }
                        catch (Throwable throwable) {
                            Log.w(SystemProperties.get("hcjf.net.log.tag"), "Decoupled action error", throwable, new Object[0]);
                        }
                        continue;
                    }
                    try {
                        Queue<DecoupledAction> throwable = this.actionsQueue;
                        synchronized (throwable) {
                            this.actionsQueue.wait();
                        }
                    }
                    catch (Exception ex) {
                        break;
                    }
                }
            }, ServiceSession.getSystemSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addDecoupledAction(DecoupledAction decoupledAction) {
        if (this.isDecoupledIoAction().booleanValue()) {
            Queue<DecoupledAction> queue = this.actionsQueue;
            synchronized (queue) {
                this.actionsQueue.add(decoupledAction);
                this.actionsQueue.notifyAll();
            }
        } else {
            decoupledAction.onAction();
        }
    }

    public String getName() {
        return this.name;
    }

    public long getWriteWaitForTimeout() {
        return this.writeWaitForTimeout;
    }

    public void setWriteWaitForTimeout(long writeWaitForTimeout) {
        this.writeWaitForTimeout = writeWaitForTimeout;
    }

    public final void setService(NetService service) {
        StackTraceElement element = Thread.currentThread().getStackTrace()[2];
        if (!element.getClassName().equals(NetService.class.getName()) || !element.getMethodName().equals("registerConsumer")) {
            throw new SecurityException("The method 'NetServiceConsumer.setService() only can be called from the net service that will be associated.'");
        }
        this.service = service;
    }

    protected final NetService getService() {
        return this.service;
    }

    public final Integer getPort() {
        return this.port;
    }

    protected SSLEngine getSSLEngine() {
        throw new UnsupportedOperationException("Unsupported ssl engine");
    }

    public final NetService.TransportLayerProtocol getProtocol() {
        return this.protocol;
    }

    protected final void disconnect(S session, String message) {
        this.service.disconnect((NetSession)session, message);
    }

    public final byte[] getShutdownFrame(S session) {
        byte[] result = null;
        try {
            D shutdownPackage = this.getShutdownPackage(session);
            if (shutdownPackage != null) {
                result = this.encode(shutdownPackage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected D getShutdownPackage(S session) {
        return null;
    }

    protected final void write(S session, D payLoad) throws IOException {
        this.write(session, payLoad, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void write(S session, D payLoad, boolean waitFor) throws IOException {
        if (waitFor) {
            NetPackage netPackage;
            NetPackage netPackage2 = netPackage = this.service.writeData((NetSession)session, this.encode(payLoad));
            synchronized (netPackage2) {
                try {
                    netPackage.wait(this.getWriteWaitForTimeout());
                }
                catch (InterruptedException e) {
                    Log.w(SystemProperties.get("hcjf.net.log.tag"), "Write wait for interrupted", e, new Object[0]);
                }
            }
            switch (netPackage.getPackageStatus()) {
                case CONNECTION_CLOSE: {
                    throw new IOException("Connection Close");
                }
                case IO_ERROR: {
                    throw new IOException("IO Error");
                }
                case REJECTED_SESSION_LOCK: {
                    throw new IOException("Session locked");
                }
                case UNKNOWN_SESSION: {
                    throw new IOException("Unknown session");
                }
            }
        } else {
            NetPackage netPackage = this.service.writeData((NetSession)session, this.encode(payLoad));
        }
    }

    public final void onConnect(NetPackage netPackage) {
        this.onConnect(netPackage.getSession(), this.decode(netPackage), netPackage);
    }

    protected void onConnect(S session, D payLoad, NetPackage netPackage) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onDisconnect(NetPackage netPackage) {
        NetPackage netPackage2 = netPackage;
        synchronized (netPackage2) {
            netPackage.notify();
        }
        this.onDisconnect(netPackage.getSession(), netPackage);
    }

    protected void onDisconnect(S session, NetPackage netPackage) {
    }

    public final void onRead(NetPackage netPackage) {
        NetSession session = netPackage.getSession();
        D decodedPackage = this.decode(netPackage);
        try {
            session = this.checkSession(session, decodedPackage, netPackage);
            session.setChecked(true);
            try {
                this.onRead(session, decodedPackage, netPackage);
            }
            catch (Exception ex) {
                Log.w(SystemProperties.get("hcjf.net.log.tag"), "On read method fail", ex, new Object[0]);
            }
        }
        catch (Exception ex) {
            Log.w(SystemProperties.get("hcjf.net.log.tag"), "Check session fail", ex, new Object[0]);
            session.setChecked(false);
            this.onCheckSessionError(session, decodedPackage, netPackage, ex);
        }
    }

    protected void onRead(S session, D payLoad, NetPackage netPackage) {
    }

    protected void onCheckSessionError(S session, D payLoad, NetPackage netPackage, Throwable cause) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onWrite(NetPackage netPackage) {
        NetPackage netPackage2 = netPackage;
        synchronized (netPackage2) {
            netPackage.notify();
        }
        this.onWrite(netPackage.getSession(), netPackage);
    }

    protected void onWrite(S session, NetPackage netPackage) {
    }

    protected abstract byte[] encode(D var1);

    protected abstract D decode(NetPackage var1);

    public abstract void destroySession(NetSession var1);

    public abstract S checkSession(S var1, D var2, NetPackage var3);

    public Map<SocketOption, Object> getSocketOptions() {
        return null;
    }

    public static abstract class DecoupledAction {
        public final ServiceSession serviceSession;

        public DecoupledAction(ServiceSession serviceSession) {
            this.serviceSession = serviceSession;
        }

        public ServiceSession getServiceSession() {
            return this.serviceSession;
        }

        public abstract void onAction();
    }
}

