/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.hcjf.errors.Errors;
import org.hcjf.io.net.NetClient;
import org.hcjf.io.net.NetPackage;
import org.hcjf.io.net.NetService;
import org.hcjf.io.net.NetSession;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.HttpMethod;
import org.hcjf.io.net.http.HttpPackage;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.HttpResponse;
import org.hcjf.io.net.http.HttpResponseCode;
import org.hcjf.io.net.http.HttpSession;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;

public class HttpClient
extends NetClient<HttpSession, HttpPackage> {
    public static final String HTTP_CLIENT_LOG_TAG = "HTTP_CLIENT";
    private static final String CONNECTION_TIMEOUT_MESSAGE = "Connection timeout";
    private static final String READ_TIMEOUT_MESSAGE = "Read timeout";
    private static final String DISCONNECTION_MESSAGE = "Http client request end";
    private static final String SESSION_NAME = "Http client session";
    private final URL url;
    private Status status;
    private HttpResponse response;
    private HttpRequest request;
    private Long connectTimeout;
    private Long writeTimeout;
    private Long readTimeout;
    private HttpSession session;
    private HttpPackage.HttpProtocol httpProtocol;
    private Boolean httpsInsecureConnection;

    public HttpClient(URL url) {
        super(url.getHost(), url.getPort() != -1 ? url.getPort() : (url.getProtocol().equalsIgnoreCase(HttpPackage.HttpProtocol.HTTPS.toString()) ? SystemProperties.getInteger("hcjf.net.https.default.server.port") : SystemProperties.getInteger("hcjf.net.http.default.client.port")).intValue(), url.getProtocol().equalsIgnoreCase(HttpPackage.HttpProtocol.HTTPS.toString()) ? NetService.TransportLayerProtocol.TCP_SSL : NetService.TransportLayerProtocol.TCP);
        this.url = url;
        this.connectTimeout = SystemProperties.getLong("hcjf.net.http.default.client.connect.timeout");
        this.writeTimeout = SystemProperties.getLong("hcjf.net.http.default.client.write.timeout");
        this.readTimeout = SystemProperties.getLong("hcjf.net.http.default.client.read.timeout");
        this.httpProtocol = url.getProtocol().equalsIgnoreCase(HttpPackage.HttpProtocol.HTTPS.toString()) ? HttpPackage.HttpProtocol.HTTPS : HttpPackage.HttpProtocol.HTTP;
        this.httpsInsecureConnection = false;
        this.init();
    }

    private void init() {
        this.response = null;
        this.status = Status.INACTIVE;
        this.request = new HttpRequest();
        this.request.setProtocol(this.httpProtocol);
        this.request.setHttpVersion("HTTP/1.1");
        this.request.setContext(this.url.getFile());
        this.request.setMethod(HttpMethod.GET);
        this.request.setBody(new byte[0]);
        this.request.addHeader(new HttpHeader("Host", this.url.getHost()));
        this.request.addHeader(new HttpHeader("User-Agent", "HCJF"));
    }

    public final Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public final void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public final Long getWriteTimeout() {
        return this.writeTimeout;
    }

    public final void setWriteTimeout(Long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public final Long getReadTimeout() {
        return this.readTimeout;
    }

    public final void setReadTimeout(Long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void addPath(String ... paths) {
        StringBuilder newPath = new StringBuilder();
        newPath.append(this.request.getContext());
        String separator = this.request.getContext().endsWith("/") ? "" : "/";
        for (String path : paths) {
            newPath.append(separator).append(path);
            separator = "/";
        }
        this.request.setContext(newPath.toString());
    }

    public final void reset() {
        this.init();
    }

    public void setBody(byte[] body) {
        this.request.setBody(body);
    }

    public final void setHttpMethod(HttpMethod method) {
        this.request.setMethod(method);
    }

    public final void addHttpHeader(String header) {
        this.request.addHeader(new HttpHeader(header));
    }

    public final void addHttpHeader(HttpHeader header) {
        this.request.addHeader(header);
    }

    public Boolean isHttpsInsecureConnection() {
        return this.httpsInsecureConnection;
    }

    public void setHttpsInsecureConnection(Boolean httpsInsecureConnection) {
        this.httpsInsecureConnection = httpsInsecureConnection;
    }

    @Override
    protected SSLEngine getSSLEngine() {
        try {
            SSLEngine engine;
            if (this.isHttpsInsecureConnection().booleanValue()) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                engine = sslContext.createSSLEngine();
            } else {
                engine = SSLContext.getDefault().createSSLEngine();
            }
            engine.setUseClientMode(true);
            engine.beginHandshake();
            return engine;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(Errors.getMessage("org.hcjf.io.net.http@6", new Object[0]), ex);
        }
    }

    @Override
    public HttpSession getSession() {
        return this.session;
    }

    @Override
    public HttpSession checkSession(HttpSession session, HttpPackage payLoad, NetPackage netPackage) {
        return session;
    }

    @Override
    protected byte[] encode(HttpPackage payLoad) {
        byte[] result = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            out.write(payLoad.getProtocolHeader());
            if (payLoad.getBody() != null) {
                out.write(payLoad.getBody());
            }
            out.flush();
            result = out.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected HttpPackage decode(NetPackage netPackage) {
        if (this.response == null) {
            this.response = new HttpResponse();
            this.response.setProtocol(this.httpProtocol);
        }
        this.response.addData(netPackage.getPayload());
        return this.response;
    }

    @Override
    public void destroySession(NetSession session) {
        session = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onConnect(HttpSession session, HttpPackage payLoad, NetPackage netPackage) {
        HttpClient httpClient = this;
        synchronized (httpClient) {
            this.status = Status.CONNECTED;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void onRead(HttpSession session, HttpPackage payLoad, NetPackage netPackage) {
        if (this.response.isComplete()) {
            HttpClient httpClient = this;
            synchronized (httpClient) {
                this.status = Status.DONE;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpResponse request() {
        HttpResponse response;
        long time = System.currentTimeMillis();
        this.session = new HttpSession(UUID.randomUUID(), this);
        this.session.setRequest(this.request);
        this.session.setSessionName(SESSION_NAME);
        Integer errorCode = null;
        this.status = Status.CONNECTING;
        HttpClient httpClient = this;
        synchronized (httpClient) {
            this.connect();
            if (this.status == Status.CONNECTING) {
                try {
                    this.wait(this.getConnectTimeout());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.status == Status.CONNECTING) {
                this.status = Status.ERROR;
                errorCode = HttpResponseCode.REQUEST_TIMEOUT;
            }
        }
        if (this.status != Status.ERROR) {
            this.status = Status.WRITING;
            httpClient = this;
            synchronized (httpClient) {
                Log.out(HTTP_CLIENT_LOG_TAG, "Request\r\n%s", this.request.toString());
                try {
                    this.write(this.getSession(), this.request, false);
                }
                catch (Exception ex) {
                    this.status = Status.ERROR;
                    errorCode = HttpResponseCode.BAD_REQUEST;
                }
                if (this.status == Status.WRITING) {
                    try {
                        this.wait(this.getReadTimeout());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.status == Status.WRITING) {
                    this.status = Status.ERROR;
                    errorCode = HttpResponseCode.REQUEST_TIMEOUT;
                }
            }
        }
        if (this.status == Status.ERROR) {
            response = new HttpResponse();
            response.setHttpVersion("HTTP/1.1");
            response.setResponseCode(errorCode);
        } else {
            response = this.response;
        }
        this.disconnect(this.getSession(), DISCONNECTION_MESSAGE);
        Log.in(HTTP_CLIENT_LOG_TAG, "Response -> [Time: %d ms]\r\n%s", System.currentTimeMillis() - time, response.toString());
        return response;
    }

    private static enum Status {
        INACTIVE,
        CONNECTING,
        CONNECTED,
        WRITING,
        DONE,
        ERROR;

    }
}

