/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.hcjf.encoding.MimeType;
import org.hcjf.io.net.http.Cookie;
import org.hcjf.io.net.http.FormUrlEncodedDecoder;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.HttpMethod;
import org.hcjf.io.net.http.HttpPackage;
import org.hcjf.io.net.http.MultipartFormDataDecoder;
import org.hcjf.io.net.http.RequestBodyDecoderLayer;
import org.hcjf.layers.Layers;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Strings;

public class HttpRequest
extends HttpPackage {
    private static final int METHOD_INDEX = 0;
    private static final int REQUEST_PATH_INDEX = 1;
    private static final int VERSION_INDEX = 2;
    private String path;
    private String context;
    private HttpMethod method;
    private final Map<String, Object> parameters;
    private final List<String> pathParts;
    private Matcher matcher;

    public HttpRequest(String requestPath, HttpMethod method) {
        this.path = requestPath;
        this.method = method;
        this.parameters = new HashMap<String, Object>();
        this.pathParts = new ArrayList<String>();
    }

    protected HttpRequest(HttpRequest httpRequest) {
        super(httpRequest);
        this.context = httpRequest.context;
        this.path = httpRequest.path;
        this.method = httpRequest.method;
        this.parameters = httpRequest.parameters;
        this.pathParts = httpRequest.pathParts;
    }

    public HttpRequest() {
        this(null, null);
    }

    public final String getPath() {
        return this.path;
    }

    public final void setPath(String path) {
        this.path = path;
    }

    public final String getContext() {
        return this.context;
    }

    public final void setContext(String context) {
        this.context = context;
        this.path = context;
    }

    public final HttpMethod getMethod() {
        return this.method;
    }

    public final void setMethod(HttpMethod method) {
        this.method = method;
    }

    public final boolean hasParameter(String name) {
        return this.parameters.containsKey(name);
    }

    public final Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public final <O> O getParameter(String parameterName) {
        return (O)this.parameters.get(parameterName);
    }

    public final String getReplaceableValue(String placeName) {
        return this.matcher == null ? null : this.matcher.group(placeName);
    }

    public final void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public final void addHttpParameter(String parameterName, String parameterValue) {
        this.parameters.put(parameterName, parameterValue);
    }

    public final List<String> getPathParts() {
        return this.pathParts;
    }

    @Override
    protected void processBody() {
        HttpHeader contentType = this.getHeader("Content-Type");
        if (contentType != null) {
            try {
                RequestBodyDecoderLayer bodyDecoderLayer = Layers.get(RequestBodyDecoderLayer.class, L -> contentType.getHeaderValue().startsWith(L.getImplName()));
                Map<String, Object> parameters = bodyDecoderLayer.decode(this);
                if (parameters != null) {
                    this.parameters.putAll(parameters);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void processFirstLine(String firstLine) {
        String[] parts = firstLine.split(" ");
        this.method = HttpMethod.valueOf(parts[0]);
        this.path = parts[1];
        this.setHttpVersion(parts[2]);
        if (this.path.indexOf("?") >= 0) {
            this.context = this.path.substring(0, this.path.indexOf("?"));
            this.parseHttpParameters(this.path.substring(this.path.indexOf("?") + 1));
        } else {
            this.context = this.path;
        }
        for (String pathPart : this.context.split("/")) {
            if (pathPart.isEmpty()) continue;
            this.pathParts.add(pathPart);
        }
    }

    private void parseHttpParameters(String parametersBody) {
        String[] params = parametersBody.split("&");
        String charset = null;
        HttpHeader contentType = this.getHeader("Content-Type");
        if (contentType != null) {
            charset = contentType.getParameter(contentType.getGroups().iterator().next(), "charset");
        }
        if (charset == null) {
            charset = SystemProperties.getDefaultCharset();
        }
        for (String param : params) {
            String value;
            String key;
            if (param.indexOf("=") < 0) {
                key = param;
                value = null;
            } else {
                key = param.substring(0, param.indexOf("="));
                value = param.substring(param.indexOf("=") + 1);
                if (value.length() == 0) {
                    value = null;
                }
            }
            if (key.contains("[") && key.contains("]")) {
                ArrayList listParameter;
                int insertIndex = -1;
                if (key.indexOf("[") + 1 != key.indexOf("]")) {
                    insertIndex = Integer.parseInt(key.substring(key.indexOf("[") + 1, key.indexOf("]")));
                }
                key = key.substring(0, key.indexOf("["));
                if (this.parameters.containsKey(key)) {
                    listParameter = (ArrayList)this.getParameter(key);
                } else {
                    listParameter = new ArrayList();
                    this.parameters.put(key, listParameter);
                }
                if (insertIndex >= 0) {
                    listParameter.add(insertIndex, value);
                    continue;
                }
                listParameter.add(value);
                continue;
            }
            try {
                this.parameters.put(URLDecoder.decode(key, charset), value == null ? null : URLDecoder.decode(value, charset));
            }
            catch (UnsupportedEncodingException e) {
                Log.w(SystemProperties.get("hcjf.net.http.server.log.tag"), "Unable to decode http parameter, %s:%s", key, value);
                this.parameters.put(key, value);
            }
        }
    }

    private String toStringProtocolHeader() {
        Strings.Builder builder = new Strings.Builder();
        builder.append(this.getMethod().toString()).append(" ").append(this.getPath()).append(" ").append(this.getHttpVersion()).append("\r\n");
        for (HttpHeader header : this.getHeaders()) {
            builder.append(header).append("\r\n");
        }
        Collection<Cookie> cookies = this.getCookies();
        if (cookies.size() > 0) {
            builder.append("Cookie".toString()).append(": ");
            for (Cookie cookie : cookies) {
                builder.append(cookie, "; ");
            }
        }
        builder.cleanBuffer();
        builder.append("\r\n");
        return builder.toString();
    }

    @Override
    public final byte[] getProtocolHeader() {
        return this.toStringProtocolHeader().getBytes();
    }

    public String toString() {
        int maxLength;
        StringBuilder builder = new StringBuilder();
        builder.append(this.toStringProtocolHeader());
        if (this.getBody() != null && (maxLength = SystemProperties.getInteger("hcjf.net.http.input.log.body.max.length").intValue()) > 0) {
            if (this.getBody().length > maxLength) {
                builder.append(new String(this.getBody(), 0, maxLength));
                builder.append(" ... [").append(this.getBody().length - maxLength).append(" more]");
            } else {
                builder.append(new String(this.getBody()));
            }
        }
        return builder.toString();
    }

    static {
        Layers.publishLayer(FormUrlEncodedDecoder.class);
        Layers.publishLayer(MultipartFormDataDecoder.class);
    }

    public static class AttachFile {
        private final String name;
        private final String fileName;
        private final MimeType mimeType;
        private final byte[] file;

        public AttachFile(String name, String fileName, MimeType mimeType, byte[] file) {
            this.name = name;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public MimeType getMimeType() {
            return this.mimeType;
        }

        public byte[] getFile() {
            return this.file;
        }
    }
}

