/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.io.FileInputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.hcjf.errors.Errors;
import org.hcjf.io.net.http.HttpServer;
import org.hcjf.properties.SystemProperties;

public class HttpsServer
extends HttpServer {
    private String keystorePassword = SystemProperties.get("hcjf.net.ssl.default.keystore.password");
    private String keyPassword = SystemProperties.get("hcjf.net.ssl.default.key.password");
    private Path keystoreFilePath = SystemProperties.getPath("hcjf.net.ssl.default.keystore.file.path");
    private Path trustedCertsFilePath = SystemProperties.getPath("hcjf.net.ssl.default.trusted.certs.file.path");
    private String keyType = SystemProperties.get("hcjf.net.ssl.default.key.type");
    private Provider provider;
    private String sslProtocol = SystemProperties.get("hcjf.net.ssl.default.protocol");

    public HttpsServer() {
        this(SystemProperties.getInteger("hcjf.net.https.default.server.port"));
    }

    public HttpsServer(Integer port) {
        super(port, true);
    }

    @Override
    protected SSLEngine getSSLEngine() {
        try {
            SSLContext context = SSLContext.getInstance(this.getSslProtocol());
            context.init(this.createKeyManagers(), this.createTrustManagers(), new SecureRandom());
            SSLSession dummySession = context.createSSLEngine().getSession();
            dummySession.invalidate();
            SSLEngine engine = context.createSSLEngine();
            engine.setUseClientMode(false);
            engine.beginHandshake();
            return engine;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(Errors.getMessage("org.hcjf.io.net.http@6", new Object[0]), ex);
        }
    }

    public final String getKeystorePassword() {
        return this.keystorePassword;
    }

    public final void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public final String getKeyPassword() {
        return this.keyPassword;
    }

    public final void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public final Path getKeystoreFilePath() {
        return this.keystoreFilePath;
    }

    public final void setKeystoreFilePath(Path keystoreFilePath) {
        this.keystoreFilePath = keystoreFilePath;
    }

    public final Path getTrustedCertsFilePath() {
        return this.trustedCertsFilePath;
    }

    public final void setTrustedCertsFilePath(Path trustedCertsFilePath) {
        this.trustedCertsFilePath = trustedCertsFilePath;
    }

    public final String getKeyType() {
        return this.keyType;
    }

    public final void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public final String getSslProtocol() {
        return this.sslProtocol;
    }

    public final void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void setProvider(Provider provider) {
        this.provider = provider;
    }

    protected KeyManager[] createKeyManagers() throws Exception {
        KeyStore keyStore = this.getProvider() == null ? KeyStore.getInstance(this.getKeyType()) : KeyStore.getInstance(this.getKeyType(), this.getProvider());
        try (FileInputStream keyStoreIS = new FileInputStream(this.getKeystoreFilePath().toFile());){
            keyStore.load(keyStoreIS, this.getKeystorePassword().toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, this.getKeyPassword().toCharArray());
        return kmf.getKeyManagers();
    }

    protected TrustManager[] createTrustManagers() throws Exception {
        KeyStore trustStore = this.getProvider() == null ? KeyStore.getInstance(this.getKeyType()) : KeyStore.getInstance(this.getKeyType(), this.getProvider());
        try (FileInputStream trustStoreIS = new FileInputStream(this.getTrustedCertsFilePath().toFile());){
            trustStore.load(trustStoreIS, this.getKeystorePassword().toCharArray());
        }
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(trustStore);
        return trustFactory.getTrustManagers();
    }
}

