/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.hcjf.bson.BsonCollection;
import org.hcjf.bson.BsonDecoder;
import org.hcjf.bson.BsonEncoder;
import org.hcjf.io.net.messages.Message;
import org.hcjf.utils.bson.BsonParcelable;

public final class MessageBuffer {
    private List<Message> messages = new ArrayList<Message>();
    private ByteBuffer buffer;
    private MessageBuffer leftover;

    public synchronized void append(Message message) {
        this.messages.add(message);
        this.buffer = ByteBuffer.wrap(BsonEncoder.encode((BsonCollection)message.toBson()));
    }

    public synchronized void append(byte[] data) {
        if (this.messages.isEmpty()) {
            if (this.buffer == null) {
                this.buffer = ByteBuffer.wrap(data);
                this.buffer.rewind();
            } else {
                ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() + data.length);
                this.buffer.rewind();
                newBuffer.put(this.buffer);
                newBuffer.put(data);
                this.buffer = newBuffer;
                this.buffer.rewind();
            }
            if (this.buffer.capacity() > 4) {
                int bsonObjectSize = this.buffer.getInt();
                if (bsonObjectSize == this.buffer.capacity()) {
                    this.buffer.rewind();
                    this.messages.add((Message)BsonParcelable.Builder.create(BsonDecoder.decode((byte[])this.buffer.array())));
                } else if (bsonObjectSize < this.buffer.capacity()) {
                    byte[] bsonObjectBody = new byte[bsonObjectSize];
                    byte[] leftOverBody = new byte[this.buffer.capacity() - bsonObjectSize];
                    this.buffer.rewind();
                    this.buffer.get(bsonObjectBody);
                    this.messages.add((Message)BsonParcelable.Builder.create(BsonDecoder.decode((byte[])this.buffer.array())));
                    this.buffer.get(leftOverBody);
                    MessageBuffer leftover = new MessageBuffer();
                    leftover.append(leftOverBody);
                    if (leftover.isComplete()) {
                        this.messages.addAll(leftover.getMessages());
                        this.leftover = leftover.getLeftover();
                    } else {
                        this.leftover = leftover;
                    }
                }
            }
        } else {
            if (this.leftover == null) {
                this.leftover = new MessageBuffer();
            }
            this.leftover.append(data);
        }
    }

    public synchronized boolean isComplete() {
        return !this.messages.isEmpty();
    }

    public List<Message> getMessages() {
        ArrayList<Message> result = new ArrayList<Message>();
        result.addAll(this.messages);
        this.messages.clear();
        return result;
    }

    public MessageBuffer getLeftover() {
        return this.leftover;
    }

    public synchronized byte[] getBytes() {
        this.buffer.rewind();
        return this.buffer.array();
    }
}

