/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hcjf.bson.BsonDocument;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.Layers;
import org.hcjf.layers.crud.IdentifiableLayerInterface;
import org.hcjf.layers.query.Enlarged;
import org.hcjf.layers.query.Groupable;
import org.hcjf.layers.query.Join;
import org.hcjf.layers.query.Joinable;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.ParameterizedQuery;
import org.hcjf.layers.query.Queryable;
import org.hcjf.layers.query.ResultSet;
import org.hcjf.layers.query.evaluators.And;
import org.hcjf.layers.query.evaluators.BaseEvaluator;
import org.hcjf.layers.query.evaluators.BooleanEvaluator;
import org.hcjf.layers.query.evaluators.Distinct;
import org.hcjf.layers.query.evaluators.Equals;
import org.hcjf.layers.query.evaluators.Evaluator;
import org.hcjf.layers.query.evaluators.EvaluatorCollection;
import org.hcjf.layers.query.evaluators.FieldEvaluator;
import org.hcjf.layers.query.evaluators.GreaterThan;
import org.hcjf.layers.query.evaluators.GreaterThanOrEqual;
import org.hcjf.layers.query.evaluators.In;
import org.hcjf.layers.query.evaluators.Like;
import org.hcjf.layers.query.evaluators.NotIn;
import org.hcjf.layers.query.evaluators.Or;
import org.hcjf.layers.query.evaluators.SmallerThan;
import org.hcjf.layers.query.evaluators.SmallerThanOrEqual;
import org.hcjf.layers.query.evaluators.TrueEvaluator;
import org.hcjf.layers.query.functions.BsonQueryFunctionLayer;
import org.hcjf.layers.query.functions.CollectionQueryFunction;
import org.hcjf.layers.query.functions.ContextAggregateFunction;
import org.hcjf.layers.query.functions.CountQueryAggregateFunctionLayer;
import org.hcjf.layers.query.functions.DateQueryFunctionLayer;
import org.hcjf.layers.query.functions.DistinctQueryAggregateFunction;
import org.hcjf.layers.query.functions.EvalExpressionAggregateFunctionLayer;
import org.hcjf.layers.query.functions.GeoDistanceAggregateFunctionLayer;
import org.hcjf.layers.query.functions.GeoQueryFunctionLayer;
import org.hcjf.layers.query.functions.GeoUnionAggregateFunctionLayer;
import org.hcjf.layers.query.functions.MathQueryFunctionLayer;
import org.hcjf.layers.query.functions.MaxAggregateFunctionLayer;
import org.hcjf.layers.query.functions.MeanAggregateFunctionLayer;
import org.hcjf.layers.query.functions.MinAggregateFunctionLayer;
import org.hcjf.layers.query.functions.ObjectQueryFunction;
import org.hcjf.layers.query.functions.ProductAggregateFunctionLayer;
import org.hcjf.layers.query.functions.ReferenceFunctionLayer;
import org.hcjf.layers.query.functions.StringQueryFunctionLayer;
import org.hcjf.layers.query.functions.SumAggregateFunctionLayer;
import org.hcjf.layers.query.model.QueryBsonBuilderLayer;
import org.hcjf.layers.query.model.QueryDynamicResource;
import org.hcjf.layers.query.model.QueryField;
import org.hcjf.layers.query.model.QueryFunction;
import org.hcjf.layers.query.model.QueryId;
import org.hcjf.layers.query.model.QueryOrderField;
import org.hcjf.layers.query.model.QueryOrderFunction;
import org.hcjf.layers.query.model.QueryOrderParameter;
import org.hcjf.layers.query.model.QueryParameter;
import org.hcjf.layers.query.model.QueryResource;
import org.hcjf.layers.query.model.QueryReturnField;
import org.hcjf.layers.query.model.QueryReturnFunction;
import org.hcjf.layers.query.model.QueryReturnParameter;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;
import org.hcjf.service.ServiceThread;
import org.hcjf.utils.Introspection;
import org.hcjf.utils.LruMap;
import org.hcjf.utils.NamedUuid;
import org.hcjf.utils.Strings;
import org.hcjf.utils.bson.BsonParcelable;

public class Query
extends EvaluatorCollection
implements Queryable {
    public static final String QUERY_BSON_FIELD_NAME = "__query__";
    private static final LruMap<String, Query> cache = new LruMap(SystemProperties.getInteger("hcjf.query.compiler.cache.size"));
    private final QueryId id;
    private final QueryResource resource;
    private final List<QueryResource> resources;
    private Integer limit;
    private Integer underlyingLimit;
    private Integer start;
    private Integer underlyingStart;
    private final List<QueryReturnParameter> groupParameters;
    private final List<QueryOrderParameter> orderParameters;
    private final List<QueryReturnParameter> returnParameters;
    private final List<Join> joins;
    private boolean returnAll;

    public Query(QueryResource resource, QueryId id) {
        this.id = id;
        this.groupParameters = new ArrayList<QueryReturnParameter>();
        this.orderParameters = new ArrayList<QueryOrderParameter>();
        this.returnParameters = new ArrayList<QueryReturnParameter>();
        this.joins = new ArrayList<Join>();
        this.resource = resource;
        this.resources = new ArrayList<QueryResource>();
        this.resources.add(this.resource);
    }

    public Query(String resource) {
        this(new QueryResource(resource));
    }

    public Query(QueryResource resource) {
        this(resource, new QueryId());
    }

    private Query(Query source) {
        super(source);
        this.id = new QueryId();
        this.resource = source.resource;
        this.resources = new ArrayList<QueryResource>();
        this.resources.add(this.resource);
        this.limit = source.limit;
        this.start = source.start;
        this.returnAll = source.returnAll;
        this.orderParameters = new ArrayList<QueryOrderParameter>();
        this.orderParameters.addAll(source.orderParameters);
        this.returnParameters = new ArrayList<QueryReturnParameter>();
        this.returnParameters.addAll(source.returnParameters);
        this.groupParameters = new ArrayList<QueryReturnParameter>();
        this.groupParameters.addAll(source.groupParameters);
        this.joins = new ArrayList<Join>();
        this.joins.addAll(source.joins);
    }

    private QueryParameter checkQueryParameter(QueryParameter queryParameter) {
        if (queryParameter instanceof QueryField) {
            QueryField queryField = (QueryField)queryParameter;
            QueryResource queryResource = queryField.getResource();
        } else if (queryParameter instanceof QueryFunction) {
            QueryFunction function = (QueryFunction)queryParameter;
            for (Object functionParameter : function.getParameters()) {
                if (!(functionParameter instanceof QueryParameter)) continue;
                this.checkQueryParameter((QueryParameter)functionParameter);
            }
        }
        return queryParameter;
    }

    @Override
    protected Evaluator checkEvaluator(Evaluator evaluator) {
        if (evaluator instanceof FieldEvaluator) {
            FieldEvaluator fieldEvaluator = (FieldEvaluator)evaluator;
            if (fieldEvaluator.getLeftValue() instanceof QueryParameter) {
                this.checkQueryParameter((QueryParameter)fieldEvaluator.getLeftValue());
            }
            if (fieldEvaluator.getRightValue() instanceof QueryParameter) {
                this.checkQueryParameter((QueryParameter)fieldEvaluator.getRightValue());
            }
        }
        return evaluator;
    }

    public final boolean returnAll() {
        return this.returnAll || this.returnParameters.isEmpty();
    }

    public final ParameterizedQuery getParameterizedQuery() {
        return new ParameterizedQuery(this);
    }

    public final QueryId getId() {
        return this.id;
    }

    public List<Join> getJoins() {
        return Collections.unmodifiableList(this.joins);
    }

    public QueryResource getResource() {
        return this.resource;
    }

    @Override
    public final String getResourceName() {
        return this.resource.getResourceName();
    }

    public List<QueryResource> getResources() {
        return this.resources;
    }

    public final Integer getLimit() {
        return this.limit;
    }

    public final void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getUnderlyingLimit() {
        return this.underlyingLimit;
    }

    public void setUnderlyingLimit(Integer underlyingLimit) {
        this.underlyingLimit = underlyingLimit;
    }

    public final Integer getStart() {
        return this.start != null ? this.start : 0;
    }

    public final void setStart(Integer start) {
        this.start = start;
    }

    public Integer getUnderlyingStart() {
        return this.underlyingStart;
    }

    public void setUnderlyingStart(Integer underlyingStart) {
        this.underlyingStart = underlyingStart;
    }

    public List<QueryReturnParameter> getGroupParameters() {
        return Collections.unmodifiableList(this.groupParameters);
    }

    public final Query addGroupField(String groupField) {
        return this.addGroupField(new QueryReturnField(this, groupField));
    }

    public final Query addGroupField(QueryReturnParameter groupField) {
        this.groupParameters.add((QueryReturnParameter)((Object)this.checkQueryParameter((QueryParameter)((Object)groupField))));
        return this;
    }

    public final List<QueryOrderParameter> getOrderParameters() {
        return Collections.unmodifiableList(this.orderParameters);
    }

    public final Query addOrderField(String orderField) {
        return this.addOrderField(orderField, SystemProperties.getBoolean("hcjf.query.default.desc.order"));
    }

    public final Query addOrderField(String orderField, boolean desc) {
        return this.addOrderParameter(new QueryOrderField(this, orderField, desc));
    }

    public final Query addOrderParameter(QueryOrderParameter orderParameter) {
        this.orderParameters.add((QueryOrderParameter)((Object)this.checkQueryParameter((QueryParameter)((Object)orderParameter))));
        return this;
    }

    public final List<QueryReturnParameter> getReturnParameters() {
        return Collections.unmodifiableList(this.returnParameters);
    }

    public final Query addReturnField(String returnField) {
        if (returnField.equals(SystemProperties.get("hcjf.query.return.all.reserved.word"))) {
            this.returnAll = true;
        } else {
            this.addReturnField(new QueryReturnField(this, returnField));
        }
        return this;
    }

    public final Query addReturnField(QueryReturnParameter returnParameter) {
        if (returnParameter instanceof QueryReturnField && ((QueryReturnField)returnParameter).getFieldPath().equals(SystemProperties.get("hcjf.query.return.all.reserved.word"))) {
            this.returnAll = true;
        } else {
            this.returnParameters.add((QueryReturnParameter)((Object)this.checkQueryParameter((QueryParameter)((Object)returnParameter))));
        }
        return this;
    }

    public final void addJoin(Join join) {
        if (join != null && !this.joins.contains(join)) {
            this.joins.add(join);
        } else if (join == null) {
            throw new NullPointerException("Null join instance");
        }
    }

    @Override
    public final <O> Collection<O> evaluate(Collection<O> dataSource) {
        return this.evaluate((Queryable query) -> dataSource, new Queryable.IntrospectionConsumer());
    }

    @Override
    public final <O> Collection<O> evaluate(Collection<O> dataSource, Queryable.Consumer<O> consumer) {
        return this.evaluate((Queryable query) -> dataSource, consumer);
    }

    @Override
    public final <O> Collection<O> evaluate(Queryable.DataSource<O> dataSource) {
        return this.evaluate(dataSource, new Queryable.IntrospectionConsumer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public final <O> Collection<O> evaluate(Queryable.DataSource<O> dataSource, Queryable.Consumer<O> consumer) {
        Collection<void> result;
        HashMap<String, Groupable> groupables = null;
        ArrayList<QueryReturnFunction> aggregateFunctions = new ArrayList<QueryReturnFunction>();
        if (!(Thread.currentThread() instanceof ServiceThread)) {
            result = Service.call(() -> this.evaluate(dataSource, consumer), ServiceSession.getGuestSession());
        } else {
            Long totalTime = System.currentTimeMillis();
            this.initializeEvaluatorsCache();
            result = this.orderParameters.size() > 0 ? new TreeSet((o1, o2) -> {
                int compareResult = 0;
                for (QueryOrderParameter orderField : this.orderParameters) {
                    Comparable comparable2;
                    Comparable comparable1;
                    try {
                        if (orderField instanceof QueryOrderFunction) {
                            comparable1 = (Comparable)consumer.resolveFunction((QueryOrderFunction)orderField, o1, dataSource);
                            comparable2 = (Comparable)consumer.resolveFunction((QueryOrderFunction)orderField, o2, dataSource);
                        } else {
                            comparable1 = (Comparable)consumer.get((Joinable)o1, (QueryParameter)((Object)orderField), dataSource);
                            comparable2 = (Comparable)consumer.get((Joinable)o2, (QueryParameter)((Object)orderField), dataSource);
                        }
                    }
                    catch (ClassCastException ex) {
                        throw new HCJFRuntimeException("Order field must be comparable", new Object[0]);
                    }
                    if ((compareResult = comparable1 == null ^ comparable2 == null ? (comparable1 == null ? -1 : 1) : (comparable1 == null && comparable2 == null ? 0 : comparable1.compareTo(comparable2) * (orderField.isDesc() ? -1 : 1))) == 0) continue;
                    break;
                }
                if (compareResult == 0) {
                    compareResult = o1.hashCode() - o2.hashCode();
                }
                return compareResult;
            }) : new ArrayList();
            Long timeCollectingData = System.currentTimeMillis();
            Integer evaluatingCount = 0;
            Integer formattingCount = 0;
            Long timeEvaluatingConditions = 0L;
            Long timeFormattingData = 0L;
            TreeSet<String> presentFields = new TreeSet<String>();
            try {
                Collection<? extends Joinable> data;
                if (this.joins.size() > 0) {
                    data = this.join(dataSource, consumer);
                } else if (this.getResource() instanceof QueryDynamicResource) {
                    data = this.resolveDynamicResource((QueryDynamicResource)this.getResource());
                } else {
                    Query resolveQuery = new Query(this.getResource());
                    resolveQuery.returnAll = true;
                    resolveQuery.setLimit(this.getLimit());
                    resolveQuery.setUnderlyingLimit(this.getUnderlyingLimit());
                    resolveQuery.setStart(this.getStart());
                    resolveQuery.setUnderlyingStart(this.getUnderlyingStart());
                    for (QueryOrderParameter queryOrderParameter : this.getOrderParameters()) {
                        resolveQuery.addOrderParameter(queryOrderParameter);
                    }
                    this.copyEvaluators(resolveQuery, this);
                    data = dataSource.getResourceData(this.verifyInstance(resolveQuery, consumer));
                }
                timeCollectingData = System.currentTimeMillis() - timeCollectingData;
                ArrayList<String> returnParametersAsArray = new ArrayList<String>();
                for (QueryReturnParameter returnParameter : this.getReturnParameters()) {
                    if (returnParameter instanceof QueryReturnFunction && ((QueryReturnFunction)returnParameter).isAggregate()) {
                        aggregateFunctions.add((QueryReturnFunction)returnParameter);
                    }
                    returnParametersAsArray.add(returnParameter.getAlias());
                }
                if (!this.groupParameters.isEmpty()) {
                    groupables = new HashMap<String, Groupable>();
                }
                for (Joinable joinable : data) {
                    void var19_25;
                    Long timeEvaluating = System.currentTimeMillis();
                    boolean add = this.verifyCondition(joinable, dataSource, consumer);
                    timeEvaluating = System.currentTimeMillis() - timeEvaluating;
                    timeEvaluatingConditions = timeEvaluatingConditions + timeEvaluating;
                    Integer n = evaluatingCount;
                    evaluatingCount = evaluatingCount + 1;
                    if (!add) continue;
                    Long timeFormatting = System.currentTimeMillis();
                    if (joinable instanceof Enlarged) {
                        Enlarged enlargedObject;
                        if (this.returnAll) {
                            enlargedObject = ((Enlarged)((Object)joinable)).clone(new String[0]);
                            presentFields.addAll(enlargedObject.keySet());
                        } else {
                            enlargedObject = ((Enlarged)((Object)joinable)).clone(returnParametersAsArray.toArray(new String[0]));
                        }
                        Enlarged enlarged = enlargedObject;
                        for (QueryReturnParameter returnParameter : this.getReturnParameters()) {
                            String name = null;
                            Object value = null;
                            if (returnParameter instanceof QueryReturnField) {
                                QueryReturnField returnField = (QueryReturnField)returnParameter;
                                name = returnField.getAlias();
                                value = consumer.get((Joinable)((Object)enlargedObject), returnField, dataSource);
                            } else if (returnParameter instanceof QueryReturnFunction && !((QueryReturnFunction)returnParameter).isAggregate()) {
                                QueryReturnFunction function = (QueryReturnFunction)returnParameter;
                                name = function.getAlias();
                                value = consumer.resolveFunction(function, enlargedObject, dataSource);
                            }
                            if (name == null || value == null) continue;
                            presentFields.add(name);
                            enlargedObject.put(name, value);
                        }
                    }
                    if (!this.groupParameters.isEmpty() && var19_25 instanceof Groupable) {
                        Groupable groupable = (Groupable)var19_25;
                        StringBuilder stringBuilder = new StringBuilder();
                        for (QueryReturnParameter returnParameter : this.groupParameters) {
                            Object groupValue = returnParameter instanceof QueryReturnField ? consumer.get((Joinable)var19_25, (QueryReturnField)returnParameter, dataSource) : consumer.resolveFunction((QueryReturnFunction)returnParameter, var19_25, dataSource);
                            if (groupValue == null) {
                                stringBuilder.append(SystemProperties.get("hcjf.query.null.reserved.word").hashCode());
                                continue;
                            }
                            stringBuilder.append(groupValue.hashCode());
                        }
                        if (groupables.containsKey(stringBuilder.toString())) {
                            ((Groupable)groupables.get(stringBuilder.toString())).group(groupable);
                        } else {
                            groupables.put(stringBuilder.toString(), groupable);
                        }
                    } else {
                        result.add(var19_25);
                    }
                    timeFormatting = System.currentTimeMillis() - timeFormatting;
                    Integer n2 = formattingCount;
                    formattingCount = formattingCount + 1;
                    timeFormattingData = timeFormattingData + timeFormatting;
                }
                if (groupables != null) {
                    result.addAll(groupables.values());
                }
            }
            finally {
                this.clearEvaluatorsCache();
            }
            Long timeAggregatingData = System.currentTimeMillis();
            if (aggregateFunctions.size() > 0) {
                for (QueryReturnFunction queryReturnFunction : aggregateFunctions) {
                    result = (Collection)consumer.resolveFunction(queryReturnFunction, result, dataSource);
                }
            }
            if (result.size() > 0 && result.iterator().next() instanceof Enlarged && !this.returnAll) {
                result.forEach(O -> ((Enlarged)O).purge());
            }
            if (this.getStart() != 0 || this.getLimit() != null) {
                result = this.getLimit() != null ? (Collection)result.stream().skip(this.getStart().intValue()).limit(this.getLimit().intValue()).collect(Collectors.toList()) : (Collection)result.stream().skip(this.getStart().intValue()).collect(Collectors.toList());
            }
            timeAggregatingData = System.currentTimeMillis() - timeAggregatingData;
            totalTime = System.currentTimeMillis() - totalTime;
            ResultSet resultSet = new ResultSet(totalTime, timeCollectingData, timeEvaluatingConditions, evaluatingCount == 0 ? 0L : timeEvaluatingConditions / (long)evaluatingCount.intValue(), timeFormattingData, formattingCount == 0 ? 0L : timeFormattingData / (long)formattingCount.intValue(), timeAggregatingData, presentFields, result);
            result = resultSet;
        }
        return result;
    }

    private Collection<JoinableMap> resolveDynamicResource(QueryDynamicResource resource) {
        QueryDynamicResource queryDynamicResource = (QueryDynamicResource)this.getResource();
        Collection<JoinableMap> data = Query.evaluate(queryDynamicResource.getQuery());
        if (queryDynamicResource.getPath() != null && !queryDynamicResource.getPath().isBlank()) {
            Collection resultPath = this.resolveResourcePath(data, queryDynamicResource.getPath());
            data = new ArrayList<JoinableMap>();
            for (Object dataObject : resultPath) {
                data.add(new JoinableMap(Introspection.toMap(dataObject), new String[0]));
            }
        }
        return data;
    }

    private Collection resolveResourcePath(Collection resultSet, String path) {
        ArrayList result = new ArrayList();
        for (Object row : resultSet) {
            Object pathValue = Introspection.resolve(row, path);
            if (pathValue == null) continue;
            if (pathValue instanceof Collection) {
                result.addAll((Collection)pathValue);
                continue;
            }
            result.add(pathValue);
        }
        return result;
    }

    private Queryable verifyInstance(Query query, Queryable.Consumer consumer) {
        Queryable result = query;
        if (consumer instanceof ParameterizedQuery.ParameterizedConsumer && ((ParameterizedQuery.ParameterizedConsumer)consumer).getParameters().size() > 0) {
            ParameterizedQuery parameterizedQuery = query.getParameterizedQuery();
            for (Object parameter : ((ParameterizedQuery.ParameterizedConsumer)consumer).getParameters()) {
                parameterizedQuery.add(parameter);
            }
            result = parameterizedQuery;
        }
        return result;
    }

    public final boolean verifyCondition(Object object) {
        Queryable.IntrospectionConsumer consumer = new Queryable.IntrospectionConsumer();
        List<Object> collection = List.of(object);
        return this.verifyCondition(object, Q -> collection, consumer);
    }

    private boolean verifyCondition(Object object, Queryable.DataSource dataSource, Queryable.Consumer consumer) {
        Boolean result = true;
        for (Evaluator evaluator : this.getEvaluators()) {
            if (!(evaluator instanceof BooleanEvaluator && ((BooleanEvaluator)evaluator).getValue() instanceof QueryParameter && ((QueryParameter)((BooleanEvaluator)evaluator).getValue()).isUnderlying() || this.isEvaluatorDone(evaluator) || (result = Boolean.valueOf(result & evaluator.evaluate(object, dataSource, consumer))).booleanValue())) break;
        }
        return result;
    }

    private boolean isEvaluatorDone(Evaluator evaluator) {
        List evaluatorsCache;
        boolean result = false;
        Object session = ServiceSession.getCurrentSession();
        if (session != null && (evaluatorsCache = (List)((ServiceSession)session).getProperties().get(SystemProperties.get("hcjf.query.evaluators.cache"))) != null) {
            result = evaluatorsCache.contains(evaluator);
        }
        return result;
    }

    private void initializeEvaluatorsCache() {
        Object session = ServiceSession.getCurrentIdentity();
        if (session != null) {
            ((ServiceSession)session).put(SystemProperties.get("hcjf.query.evaluators.cache"), new ArrayList());
            ((ServiceSession)session).put(SystemProperties.get("hcjf.query.evaluator.left.values.cache"), new HashMap());
            ((ServiceSession)session).put(SystemProperties.get("hcjf.query.evaluator.right.values.cache"), new HashMap());
        }
    }

    private void clearEvaluatorsCache() {
        Object session = ServiceSession.getCurrentIdentity();
        if (session != null) {
            ((ServiceSession)session).remove(SystemProperties.get("hcjf.query.evaluators.cache"));
            ((ServiceSession)session).remove(SystemProperties.get("hcjf.query.evaluator.left.values.cache"));
            ((ServiceSession)session).remove(SystemProperties.get("hcjf.query.evaluator.right.values.cache"));
        }
    }

    public static void skipEvaluator(Evaluator evaluator) {
        List evaluatorsCache;
        Object session = ServiceSession.getCurrentSession();
        if (session != null && (evaluatorsCache = (List)((ServiceSession)session).getProperties().get(SystemProperties.get("hcjf.query.evaluators.cache"))) != null) {
            evaluatorsCache.add(evaluator);
        }
    }

    private void copyEvaluators(EvaluatorCollection dest, EvaluatorCollection src) {
        for (Evaluator evaluator : src.getEvaluators()) {
            if (evaluator instanceof FieldEvaluator) {
                dest.addEvaluator(((FieldEvaluator)evaluator).copy());
                continue;
            }
            if (evaluator instanceof BooleanEvaluator) {
                QueryFunction queryFunction;
                BooleanEvaluator booleanEvaluator = (BooleanEvaluator)evaluator;
                if (!(booleanEvaluator.getValue() instanceof QueryFunction) || !(queryFunction = (QueryFunction)booleanEvaluator.getValue()).isUnderlying()) continue;
                dest.addEvaluator(evaluator);
                continue;
            }
            if (evaluator instanceof And) {
                this.copyEvaluators(dest.and(), (EvaluatorCollection)((Object)evaluator));
                continue;
            }
            if (!(evaluator instanceof Or)) continue;
            this.copyEvaluators(dest.or(), (EvaluatorCollection)((Object)evaluator));
        }
    }

    private Collection<? extends Joinable> setResource(Collection<? extends Joinable> resultSet, String resourceName) {
        for (Joinable joinable : resultSet) {
            if (!(joinable instanceof JoinableMap)) continue;
            ((JoinableMap)joinable).setResource(resourceName);
        }
        return resultSet;
    }

    private Collection<? extends Joinable> join(Queryable.DataSource<Joinable> dataSource, Queryable.Consumer<Joinable> consumer) {
        Query query = new Query(this.getResource());
        query.addReturnField(SystemProperties.get("hcjf.query.return.all.reserved.word"));
        for (Evaluator evaluator : this.getEvaluatorsFromResource(this, query, query.getResource())) {
            query.addEvaluator(evaluator);
        }
        Collection<? extends Joinable> leftData = this.getJoinData(query, dataSource, consumer);
        for (Join join : this.getJoins()) {
            query = new Query(join.getResource());
            query.addReturnField(SystemProperties.get("hcjf.query.return.all.reserved.word"));
            for (Evaluator evaluator : this.optimizeJoin(leftData, join)) {
                query.addEvaluator(evaluator);
            }
            for (Evaluator evaluator : this.getEvaluatorsFromResource(this, query, join.getResource())) {
                query.addEvaluator(evaluator);
            }
            Collection<? extends Joinable> rightData = this.getJoinData(query, dataSource, consumer);
            leftData = this.product(leftData, rightData, join, dataSource, consumer);
        }
        return leftData;
    }

    private Collection<? extends Joinable> getJoinData(Query query, Queryable.DataSource<Joinable> dataSource, Queryable.Consumer<Joinable> consumer) {
        Collection<Joinable> result = query.getResource() instanceof QueryDynamicResource ? this.resolveDynamicResource((QueryDynamicResource)query.getResource()) : dataSource.getResourceData(this.verifyInstance(query, consumer));
        return this.setResource(result, query.getResourceName());
    }

    private Collection<Evaluator> optimizeJoin(Collection<? extends Joinable> leftData, Join join) {
        Equals equals;
        ArrayList<Evaluator> result = new ArrayList<Evaluator>();
        if ((join.getType().equals((Object)Join.JoinType.JOIN) || join.getType().equals((Object)Join.JoinType.INNER) || join.getType().equals((Object)Join.JoinType.LEFT)) && join.getEvaluators().size() == 1 && join.getEvaluators().stream().findFirst().get() instanceof Equals && (equals = (Equals)join.getEvaluators().stream().findFirst().get()).getLeftValue() instanceof QueryField && equals.getRightValue() instanceof QueryField) {
            QueryField foreignKey = null;
            QueryField key = null;
            if (!((QueryField)equals.getLeftValue()).getResource().equals(join.getResource()) && ((QueryField)equals.getRightValue()).getResource().equals(join.getResource())) {
                foreignKey = (QueryField)equals.getLeftValue();
                key = (QueryField)equals.getRightValue();
            } else if (!((QueryField)equals.getRightValue()).getResource().equals(join.getResource()) && ((QueryField)equals.getLeftValue()).getResource().equals(join.getResource())) {
                foreignKey = (QueryField)equals.getRightValue();
                key = (QueryField)equals.getLeftValue();
            }
            if (foreignKey != null) {
                HashSet reducerList = new HashSet();
                for (Joinable joinable : leftData) {
                    Object foreignKeyValue = Introspection.resolve((Object)joinable, foreignKey.getFieldPath());
                    if (foreignKeyValue == null) continue;
                    reducerList.add(foreignKeyValue);
                }
                In inEvaluator = new In(key, reducerList);
                result.add(inEvaluator);
            }
        }
        return result;
    }

    private Collection<Joinable> product(Collection<? extends Joinable> left, Collection<? extends Joinable> right, Join join, Queryable.DataSource<? extends Joinable> dataSource, Queryable.Consumer<? extends Joinable> consumer) {
        ArrayList<Joinable> leftCopy = null;
        ArrayList<Joinable> rightCopy = null;
        switch (join.getType()) {
            case LEFT: {
                leftCopy = new ArrayList<Joinable>();
                leftCopy.addAll(left);
                break;
            }
            case RIGHT: {
                rightCopy = new ArrayList<Joinable>();
                rightCopy.addAll(right);
                break;
            }
            case FULL: {
                leftCopy = new ArrayList();
                leftCopy.addAll(left);
                rightCopy = new ArrayList();
                rightCopy.addAll(right);
            }
        }
        ArrayList<Joinable> result = new ArrayList<Joinable>();
        for (Joinable joinable : left) {
            for (Joinable joinable2 : right) {
                Evaluator evaluator;
                Joinable row = joinable.join(this.getResourceName(), join.getResourceName(), joinable2);
                Boolean rowEvaluation = false;
                Iterator<Evaluator> iterator = join.getEvaluators().iterator();
                while (iterator.hasNext() && (rowEvaluation = Boolean.valueOf((evaluator = iterator.next()).evaluate(row, dataSource, consumer))).booleanValue()) {
                }
                if (join.getOuter().booleanValue()) {
                    rowEvaluation = rowEvaluation == false;
                }
                if (!rowEvaluation.booleanValue()) continue;
                result.add(row);
                switch (join.getType()) {
                    case LEFT: {
                        leftCopy.remove(joinable);
                        break;
                    }
                    case RIGHT: {
                        rightCopy.remove(joinable2);
                        break;
                    }
                    case FULL: {
                        leftCopy.remove(joinable);
                        rightCopy.remove(joinable2);
                    }
                }
            }
        }
        switch (join.getType()) {
            case LEFT: {
                result.addAll(leftCopy);
                break;
            }
            case RIGHT: {
                result.addAll(rightCopy);
                break;
            }
            case FULL: {
                result.addAll(leftCopy);
                result.addAll(rightCopy);
            }
        }
        return result;
    }

    private List<Evaluator> getEvaluatorsFromResource(EvaluatorCollection collection, EvaluatorCollection parent, QueryResource resource) {
        ArrayList<Evaluator> result = new ArrayList<Evaluator>();
        for (Evaluator evaluator : collection.getEvaluators()) {
            QueryParameter queryParameter;
            if (evaluator instanceof FieldEvaluator) {
                FieldEvaluator fieldEvaluator = (FieldEvaluator)evaluator;
                boolean evaluatorAdded = false;
                if (fieldEvaluator.getLeftValue() instanceof QueryParameter && (queryParameter = (QueryParameter)fieldEvaluator.getLeftValue()).verifyResource(resource)) {
                    result.add(evaluator);
                    evaluatorAdded = true;
                }
                if (evaluatorAdded || !(fieldEvaluator.getRightValue() instanceof QueryParameter) || !(queryParameter = (QueryParameter)fieldEvaluator.getRightValue()).verifyResource(resource)) continue;
                result.add(evaluator);
                continue;
            }
            if (evaluator instanceof BooleanEvaluator) {
                if (!(((BooleanEvaluator)evaluator).getValue() instanceof QueryParameter) || !(queryParameter = (QueryParameter)((BooleanEvaluator)evaluator).getValue()).verifyResource(resource)) continue;
                result.add(evaluator);
                continue;
            }
            if (!(evaluator instanceof EvaluatorCollection)) continue;
            EvaluatorCollection subCollection = null;
            if (evaluator instanceof And) {
                subCollection = new And(parent);
            } else if (evaluator instanceof Or) {
                subCollection = new Or(parent);
            }
            for (Evaluator subEvaluator : this.getEvaluatorsFromResource((EvaluatorCollection)((Object)evaluator), subCollection, resource)) {
                subCollection.addEvaluator(subEvaluator);
            }
        }
        return result;
    }

    public final Query reduce(Collection<Evaluator> evaluatorsToRemove) {
        Query copy = new Query(this);
        copy.evaluators.addAll(this.evaluators);
        if (evaluatorsToRemove != null && !evaluatorsToRemove.isEmpty()) {
            this.reduceCollection(copy, evaluatorsToRemove);
        }
        return copy;
    }

    public final Query reduceFieldEvaluator(String fieldName, Class<? extends FieldEvaluator> ... evaluatorType) {
        return this.reduce(this.getFieldEvaluators(fieldName, evaluatorType));
    }

    private final void reduceCollection(EvaluatorCollection collection, Collection<Evaluator> evaluatorsToRemove) {
        for (Evaluator evaluatorToRemove : evaluatorsToRemove) {
            collection.removeEvaluator(evaluatorToRemove);
            collection.addEvaluator(new TrueEvaluator());
        }
        for (Evaluator evaluator : collection.getEvaluators()) {
            if (!(evaluator instanceof Or) && !(evaluator instanceof And)) continue;
            this.reduceCollection((EvaluatorCollection)((Object)evaluator), evaluatorsToRemove);
        }
    }

    public synchronized String toString() {
        Strings.Builder resultBuilder = new Strings.Builder();
        resultBuilder.append(SystemProperties.get("hcjf.query.select.reserved.word"));
        resultBuilder.append(" ");
        if (this.returnAll) {
            resultBuilder.append(SystemProperties.get("hcjf.query.return.all.reserved.word"));
            SystemProperties.get("hcjf.query.argument.separator");
            resultBuilder.append(" ");
        }
        for (QueryReturnParameter field : this.getReturnParameters()) {
            resultBuilder.append(field);
            if (field.getAlias() != null) {
                resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.as.reserved.word"));
                resultBuilder.append(" ").append(field.getAlias());
            }
            resultBuilder.append("", SystemProperties.get("hcjf.query.argument.separator"));
        }
        resultBuilder.cleanBuffer();
        resultBuilder.append(" ");
        resultBuilder.append(SystemProperties.get("hcjf.query.from.reserved.word"));
        resultBuilder.append(" ");
        resultBuilder.append(this.getResource().toString());
        resultBuilder.append(" ");
        for (Join join : this.joins) {
            if (join.getType() != Join.JoinType.JOIN) {
                resultBuilder.append((Object)join.getType());
                resultBuilder.append(" ");
            }
            resultBuilder.append(SystemProperties.get("hcjf.query.join.reserved.word")).append(" ");
            resultBuilder.append(join.getResource().toString()).append(" ");
            resultBuilder.append(SystemProperties.get("hcjf.query.on.reserved.word")).append(" ");
            if (join.getEvaluators().size() <= 0) continue;
            this.toStringEvaluatorCollection(resultBuilder, join);
        }
        if (this.evaluators.size() > 0) {
            resultBuilder.append(SystemProperties.get("hcjf.query.where.reserved.word")).append(" ");
            this.toStringEvaluatorCollection(resultBuilder, this);
        }
        if (this.groupParameters.size() > 0) {
            resultBuilder.append(SystemProperties.get("hcjf.query.group.by.reserved.word")).append(" ");
            for (QueryReturnParameter groupParameter : this.groupParameters) {
                resultBuilder.append(groupParameter, "hcjf.query.argument.separator");
            }
            resultBuilder.append(" ");
            resultBuilder.cleanBuffer();
        }
        if (this.orderParameters.size() > 0) {
            resultBuilder.append(SystemProperties.get("hcjf.query.order.by.reserved.word")).append(" ");
            for (QueryOrderParameter orderField : this.orderParameters) {
                resultBuilder.append(orderField);
                if (orderField.isDesc()) {
                    resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.desc.reserved.word"));
                }
                resultBuilder.append("", SystemProperties.get("hcjf.query.argument.separator"));
            }
            resultBuilder.cleanBuffer();
        }
        if (this.getStart() != null) {
            resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.start.reserved.word"));
            resultBuilder.append(" ").append(this.getStart());
        }
        if (this.getUnderlyingStart() != null) {
            if (this.getStart() == null) {
                resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.start.reserved.word")).append(" ");
            }
            resultBuilder.append(",").append(this.getUnderlyingStart());
        }
        if (this.getLimit() != null) {
            resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.limit.reserved.word"));
            resultBuilder.append(" ").append(this.getLimit());
        }
        if (this.getUnderlyingLimit() != null) {
            if (this.getLimit() == null) {
                resultBuilder.append(" ").append(SystemProperties.get("hcjf.query.limit.reserved.word")).append(" ");
            }
            resultBuilder.append(",").append(this.getUnderlyingLimit());
        }
        return resultBuilder.toString();
    }

    private void toStringEvaluatorCollection(Strings.Builder result, EvaluatorCollection collection) {
        Object separator = "";
        String separatorValue = collection instanceof Or ? SystemProperties.get("hcjf.query.or.reserved.word") : SystemProperties.get("hcjf.query.and.reserved.word");
        for (Evaluator evaluator : collection.getEvaluators()) {
            if (evaluator instanceof Or) {
                if (!((String)separator).isEmpty()) {
                    result.append(SystemProperties.get("hcjf.query.or.reserved.word"));
                }
                result.append(" ");
                if (((Or)evaluator).getEvaluators().size() == 1) {
                    this.toStringEvaluatorCollection(result, (Or)evaluator);
                } else {
                    result.append("(");
                    this.toStringEvaluatorCollection(result, (Or)evaluator);
                    result.append(")");
                }
                result.append(" ");
            } else if (evaluator instanceof And) {
                if (!((String)separator).isEmpty()) {
                    result.append(SystemProperties.get("hcjf.query.and.reserved.word"));
                }
                result.append(" ");
                if (collection instanceof Query) {
                    this.toStringEvaluatorCollection(result, (And)evaluator);
                } else if (((And)evaluator).getEvaluators().size() == 1) {
                    this.toStringEvaluatorCollection(result, (And)evaluator);
                } else {
                    result.append("(");
                    this.toStringEvaluatorCollection(result, (And)evaluator);
                    result.append(")");
                }
                result.append(" ");
            } else if (evaluator instanceof BooleanEvaluator) {
                result.append((String)separator);
                BooleanEvaluator booleanEvaluator = (BooleanEvaluator)evaluator;
                if (booleanEvaluator.isTrueForced()) {
                    result.append(Boolean.TRUE.toString());
                } else {
                    result = Query.toStringFieldEvaluatorValue(booleanEvaluator.getValue(), booleanEvaluator.getClass(), result);
                }
                result.append(" ");
            } else if (evaluator instanceof FieldEvaluator) {
                result.append((String)separator);
                FieldEvaluator fieldEvaluator = (FieldEvaluator)evaluator;
                if (fieldEvaluator.isTrueForced()) {
                    result.append(Boolean.TRUE.toString());
                } else {
                    if (fieldEvaluator.getLeftValue() == null) {
                        result.append(SystemProperties.get("hcjf.query.null.reserved.word"));
                    } else {
                        result = Query.toStringFieldEvaluatorValue(fieldEvaluator.getLeftValue(), fieldEvaluator.getLeftValue().getClass(), result);
                    }
                    result.append(" ");
                    if (fieldEvaluator instanceof Distinct) {
                        result.append(SystemProperties.get("hcjf.query.distinct.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof Equals) {
                        result.append(SystemProperties.get("hcjf.query.equals.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof GreaterThanOrEqual) {
                        result.append(SystemProperties.get("hcjf.query.greater.than.or.equals.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof GreaterThan) {
                        result.append(SystemProperties.get("hcjf.query.greater.than.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof NotIn) {
                        result.append(SystemProperties.get("hcjf.query.not.in.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof In) {
                        result.append(SystemProperties.get("hcjf.query.in.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof Like) {
                        result.append(SystemProperties.get("hcjf.query.like.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof SmallerThanOrEqual) {
                        result.append(SystemProperties.get("hcjf.query.smaller.than.or.equals.reserved.word")).append(" ");
                    } else if (fieldEvaluator instanceof SmallerThan) {
                        result.append(SystemProperties.get("hcjf.query.smaller.than.reserved.word")).append(" ");
                    }
                    if (fieldEvaluator.getRightValue() == null) {
                        result.append(SystemProperties.get("hcjf.query.null.reserved.word"));
                    } else {
                        result = Query.toStringFieldEvaluatorValue(fieldEvaluator.getRightValue(), fieldEvaluator.getRightValue().getClass(), result);
                    }
                }
                result.append(" ");
            }
            separator = separatorValue + " ";
        }
    }

    private static Strings.Builder toStringFieldEvaluatorValue(Object value, Class type, Strings.Builder result) {
        if (BaseEvaluator.ReplaceableValue.class.isAssignableFrom(type)) {
            result.append(SystemProperties.get("hcjf.query.replaceable.value.reserved.word"));
        } else if (BaseEvaluator.QueryValue.class.isAssignableFrom(type)) {
            result.append("(");
            result.append(((BaseEvaluator.QueryValue)value).getQuery().toString());
            result.append(")");
        } else if (String.class.isAssignableFrom(type)) {
            result.append(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"));
            result.append(value);
            result.append(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"));
        } else if (Date.class.isAssignableFrom(type)) {
            result.append(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"));
            result.append(SystemProperties.getDateFormat("hcjf.query.date.format").format((Date)value));
            result.append(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"));
        } else if (Collection.class.isAssignableFrom(type)) {
            result.append("(");
            String separator = "";
            for (Object object : (Collection)value) {
                if (object == null) continue;
                result.append(separator);
                result = Query.toStringFieldEvaluatorValue(object, object.getClass(), result);
                separator = SystemProperties.get("hcjf.query.argument.separator");
            }
            result.append(")");
        } else {
            result.append(value.toString());
        }
        return result;
    }

    @Override
    public BsonDocument toBson() {
        BsonDocument document = new BsonDocument();
        document.put("__pcn__", (Object)this.getClass().getName());
        document.put(QUERY_BSON_FIELD_NAME, (Object)this.toString());
        return document;
    }

    @Override
    public <P extends BsonParcelable> P populate(BsonDocument document) {
        return (P)this;
    }

    public static Collection<JoinableMap> evaluate(String query) {
        return Query.evaluate(Query.compile(query));
    }

    public static Collection<JoinableMap> evaluate(Queryable queryable) {
        if (queryable instanceof Query) {
            Query query = (Query)queryable;
        } else {
            Query query = ((ParameterizedQuery)queryable).getQuery();
        }
        return queryable.evaluate(new Queryable.ReadableDataSource());
    }

    public static <O> O evaluate(UUID uuid) {
        String resourceName = NamedUuid.getName(uuid);
        IdentifiableLayerInterface identifiableLayerInterface = Layers.get(IdentifiableLayerInterface.class, resourceName);
        return identifiableLayerInterface.read(uuid);
    }

    public static Query compileSingleQuery(String resourceName) {
        return Query.compile(String.format(SystemProperties.get("hcjf.query.single.pattern"), resourceName));
    }

    public static Query compile(String sql) {
        return Query.compile(sql, true);
    }

    public static Query compile(String sql, boolean ignoreCache) {
        Query result = null;
        if (!ignoreCache) {
            result = cache.get(sql);
        }
        if (result == null) {
            List<String> richTexts = Strings.groupRichText(sql);
            List<String> groups = Strings.replaceableGroup(Strings.removeLines(richTexts.get(richTexts.size() - 1)));
            result = Query.compile(groups, richTexts, groups.size() - 1);
            if (!ignoreCache) {
                cache.put(sql, result);
            }
        }
        return result;
    }

    private static Query compile(List<String> groups, List<String> richTexts, Integer startGroup) {
        Query query;
        Pattern pattern = SystemProperties.getPattern("hcjf.query.select.regular.expression");
        Matcher matcher = pattern.matcher(groups.get(startGroup));
        if (matcher.matches()) {
            String selectBody = matcher.group(SystemProperties.get("hcjf.query.select.group.index"));
            selectBody = selectBody.replaceFirst("(?i)" + SystemProperties.get("hcjf.query.select.reserved.word"), "");
            String fromBody = matcher.group(SystemProperties.get("hcjf.query.from.group.index"));
            fromBody = fromBody.replaceFirst("(?i)" + SystemProperties.get("hcjf.query.from.reserved.word"), "");
            String conditionalBody = matcher.group(SystemProperties.get("hcjf.query.conditional.group.index"));
            if (conditionalBody != null && conditionalBody.endsWith(SystemProperties.get("hcjf.query.statement.end.reserved.word"))) {
                conditionalBody = conditionalBody.substring(0, conditionalBody.indexOf(SystemProperties.get("hcjf.query.statement.end.reserved.word")) - 1);
            }
            String resourceValue = matcher.group(SystemProperties.get("hcjf.query.resource.value.index"));
            String dynamicResource = matcher.group(SystemProperties.get("hcjf.query.dynamic.resource.group.index"));
            String dynamicResourceAlias = matcher.group(SystemProperties.get("hcjf.query.dynamic.resource.alias.group.index"));
            query = new Query(Query.createResource(resourceValue, dynamicResource, dynamicResourceAlias, groups, richTexts));
            if (conditionalBody != null) {
                Pattern conditionalPatter = SystemProperties.getPattern("hcjf.query.conditional.regular.expression", 2);
                List conditionalElements = List.of(conditionalPatter.split(conditionalBody)).stream().filter(S -> !S.isBlank()).collect(Collectors.toList());
                for (int i = 0; i < conditionalElements.size(); ++i) {
                    String element = ((String)conditionalElements.get(i++)).trim();
                    String elementValue = ((String)conditionalElements.get(i)).trim();
                    if (element.equalsIgnoreCase(SystemProperties.get("hcjf.query.join.reserved.word")) || element.equalsIgnoreCase(SystemProperties.get("hcjf.query.full.reserved.word")) || element.equalsIgnoreCase(SystemProperties.get("hcjf.query.inner.join.reserved.word")) || element.equalsIgnoreCase(SystemProperties.get("hcjf.query.left.join.reserved.word")) || element.equalsIgnoreCase(SystemProperties.get("hcjf.query.right.join.reserved.word"))) {
                        Pattern joinPattern;
                        Matcher joinMatcher;
                        String[] type = Join.JoinType.valueOf(element.toUpperCase());
                        if (type != Join.JoinType.JOIN) {
                            elementValue = ((String)conditionalElements.get(++i)).trim();
                        }
                        if (!(joinMatcher = (joinPattern = SystemProperties.getPattern("hcjf.query.join.regular.expression")).matcher(elementValue)).matches()) {
                            throw new HCJFRuntimeException("Join syntax wrong, near '%s'", elementValue);
                        }
                        String joinDynamicResource = joinMatcher.group(SystemProperties.get("hcjf.query.join.dynamic.resource.index"));
                        String joinResourceValue = joinMatcher.group(SystemProperties.get("hcjf.query.join.resource.value"));
                        String joinDynamicResourceAlias = joinMatcher.group(SystemProperties.get("hcjf.query.join.dynamic.resource.alias.index"));
                        QueryResource joinResource = Query.createResource(joinResourceValue, joinDynamicResource, joinDynamicResourceAlias, groups, richTexts);
                        String joinConditionalBody = joinMatcher.group(SystemProperties.get("hcjf.query.join.conditional.body.index"));
                        joinConditionalBody = Strings.reverseGrouping(joinConditionalBody, groups);
                        joinConditionalBody = Strings.reverseRichTextGrouping(joinConditionalBody, richTexts);
                        Join join = new Join(query, joinResource, (Join.JoinType)type);
                        query.getResources().add(join.getResource());
                        Query.completeEvaluatorCollection(query, joinConditionalBody, groups, richTexts, join, 0, new AtomicInteger(0));
                        query.addJoin(join);
                        continue;
                    }
                    if (element.equalsIgnoreCase(SystemProperties.get("hcjf.query.where.reserved.word"))) {
                        Query.completeEvaluatorCollection(query, elementValue, groups, richTexts, query, 0, new AtomicInteger(0));
                        continue;
                    }
                    if (element.equalsIgnoreCase(SystemProperties.get("hcjf.query.order.by.reserved.word"))) {
                        for (String orderField : elementValue.split(SystemProperties.get("hcjf.query.argument.separator"))) {
                            query.addOrderParameter((QueryOrderParameter)Query.processStringValue(query, groups, richTexts, orderField, null, QueryOrderParameter.class, new ArrayList<QueryField>()));
                        }
                        continue;
                    }
                    if (element.equalsIgnoreCase(SystemProperties.get("hcjf.query.group.by.reserved.word"))) {
                        for (String orderField : elementValue.split(SystemProperties.get("hcjf.query.argument.separator"))) {
                            query.addGroupField((QueryReturnParameter)Query.processStringValue(query, groups, richTexts, orderField, null, QueryReturnParameter.class, new ArrayList<QueryField>()));
                        }
                        continue;
                    }
                    if (element.equalsIgnoreCase(SystemProperties.get("hcjf.query.limit.reserved.word"))) {
                        if (elementValue == null || elementValue.isBlank()) {
                            throw new HCJFRuntimeException("Undeclared limit value", new Object[0]);
                        }
                        String[] limitValues = elementValue.split(",");
                        if (limitValues.length > 0 && !limitValues[0].isBlank()) {
                            try {
                                query.setLimit(Integer.parseInt(limitValues[0].trim()));
                            }
                            catch (NumberFormatException ex) {
                                throw new HCJFRuntimeException("The limit value must be an integer", (Throwable)ex, new Object[0]);
                            }
                        }
                        if (limitValues.length <= 1 || limitValues[1].isBlank()) continue;
                        try {
                            query.setUnderlyingLimit(Integer.parseInt(limitValues[1].trim()));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new HCJFRuntimeException("The underlying limit value must be an integer", (Throwable)ex, new Object[0]);
                        }
                    }
                    if (!element.equalsIgnoreCase(SystemProperties.get("hcjf.query.start.reserved.word"))) continue;
                    if (elementValue == null || elementValue.isBlank()) {
                        throw new HCJFRuntimeException("Undeclared start value", new Object[0]);
                    }
                    String[] startValues = elementValue.split(",");
                    if (startValues.length > 0 && !startValues[0].isBlank()) {
                        try {
                            query.setStart(Integer.parseInt(startValues[0].trim()));
                        }
                        catch (NumberFormatException ex) {
                            throw new HCJFRuntimeException("The start value must be an integer", (Throwable)ex, new Object[0]);
                        }
                    }
                    if (startValues.length <= 1 || startValues[1].isBlank()) continue;
                    try {
                        query.setUnderlyingStart(Integer.parseInt(startValues[1].trim()));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new HCJFRuntimeException("The underlying start value must be an integer", (Throwable)ex, new Object[0]);
                    }
                }
            }
            for (String returnField : selectBody.split(SystemProperties.get("hcjf.query.argument.separator"))) {
                query.addReturnField((QueryReturnParameter)Query.processStringValue(query, groups, richTexts, returnField, null, QueryReturnParameter.class, new ArrayList<QueryField>()));
            }
        } else {
            String value = groups.get(startGroup);
            int place = Strings.getNoMatchPlace(matcher, groups.get(startGroup));
            String nearFrom = Strings.getNearFrom(value, place, 5);
            throw new HCJFRuntimeException("Query match fail near from ( '...%s...' ), query body: '%s'", new Object[]{nearFrom, value});
        }
        return query;
    }

    private static QueryResource createResource(String resourceValue, String dynamicResource, String dynamicResourceAlias, List<String> groups, List<String> richTexts) {
        QueryResource result;
        if (dynamicResource.isBlank()) {
            result = new QueryResource(resourceValue.trim());
        } else {
            String path = null;
            if (resourceValue.indexOf(".") > 0) {
                path = resourceValue.substring(resourceValue.indexOf(".") + 1).trim();
                resourceValue = resourceValue.substring(0, resourceValue.indexOf("."));
            }
            resourceValue = Strings.reverseGrouping(resourceValue, groups);
            resourceValue = Strings.reverseRichTextGrouping(resourceValue, richTexts);
            Query subQuery = (resourceValue = resourceValue.substring(1, resourceValue.length() - 1)).toUpperCase().startsWith(SystemProperties.get("hcjf.query.select.reserved.word")) ? Query.compile(resourceValue) : Query.compileSingleQuery(resourceValue);
            result = new QueryDynamicResource(dynamicResourceAlias.trim(), subQuery, path);
        }
        return result;
    }

    private static final void completeEvaluatorCollection(Query query, String startElement, List<String> groups, List<String> richTexts, EvaluatorCollection parentCollection, Integer definitionIndex, AtomicInteger placesIndex) {
        Pattern wherePatter = SystemProperties.getPattern("hcjf.query.evaluator.collection.regular.expression", 2);
        String[] evaluatorDefinitions = startElement != null ? wherePatter.split(startElement) : wherePatter.split(groups.get(definitionIndex));
        EvaluatorCollection collection = null;
        ArrayList<String> pendingDefinitions = new ArrayList<String>();
        for (String definition : evaluatorDefinitions) {
            if ((definition = definition.trim()).equalsIgnoreCase(SystemProperties.get("hcjf.query.and.reserved.word"))) {
                if (collection == null) {
                    if (parentCollection instanceof Query || parentCollection instanceof Join || parentCollection instanceof And) {
                        collection = parentCollection;
                        continue;
                    }
                    collection = parentCollection.and();
                    continue;
                }
                if (!(collection instanceof Or)) continue;
                if (parentCollection instanceof Query || parentCollection instanceof Join || parentCollection instanceof And) {
                    collection = parentCollection;
                    continue;
                }
                collection = parentCollection.and();
                continue;
            }
            if (definition.equalsIgnoreCase(SystemProperties.get("hcjf.query.or.reserved.word"))) {
                if (collection == null) {
                    if (parentCollection instanceof Or) {
                        collection = parentCollection;
                        continue;
                    }
                    collection = parentCollection.or();
                    continue;
                }
                if (!(collection instanceof Query) && !(collection instanceof Join) && !(collection instanceof And)) continue;
                if (parentCollection instanceof Or) {
                    collection = parentCollection;
                    continue;
                }
                collection = parentCollection.or();
                continue;
            }
            pendingDefinitions.add(definition);
            if (collection != null) {
                for (String pendingDefinition : pendingDefinitions) {
                    Query.processDefinition(query, pendingDefinition, collection, groups, richTexts, placesIndex);
                }
                pendingDefinitions.clear();
                continue;
            }
            if (pendingDefinitions.size() <= 1) continue;
            throw new IllegalArgumentException("");
        }
        for (String pendingDefinition : pendingDefinitions) {
            if (collection != null) {
                Query.processDefinition(query, pendingDefinition, collection, groups, richTexts, placesIndex);
                continue;
            }
            Query.processDefinition(query, pendingDefinition, parentCollection, groups, richTexts, placesIndex);
        }
    }

    private static void processDefinition(Query query, String definition, EvaluatorCollection collection, List<String> groups, List<String> richTexts, AtomicInteger placesIndex) {
        String[] evaluatorValues = definition.split(SystemProperties.get("hcjf.query.operation.regular.expression"));
        if (evaluatorValues.length == 1 && definition.startsWith("\u00bf")) {
            Integer index = Integer.parseInt(definition.replace("\u00bf", ""));
            Query.completeEvaluatorCollection(query, null, groups, richTexts, collection, index, placesIndex);
        } else {
            BaseEvaluator evaluator;
            boolean operatorDone = false;
            Object firstArgument = "";
            Object secondArgument = "";
            Object operator = "";
            for (String evaluatorValue : evaluatorValues) {
                if ((evaluatorValue = evaluatorValue.trim()).equalsIgnoreCase(SystemProperties.get("hcjf.query.not.reserved.word"))) {
                    operator = (String)operator + evaluatorValue + " ";
                    continue;
                }
                if (evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.not.2.reserved.word"))) {
                    operator = (String)operator + evaluatorValue;
                    continue;
                }
                if (evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.distinct.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.distinct.2.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.equals.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.greater.than.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.greater.than.or.equals.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.in.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.like.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.smaller.than.reserved.word")) || evaluatorValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.smaller.than.or.equals.reserved.word"))) {
                    operator = (String)operator + evaluatorValue;
                    operatorDone = true;
                    continue;
                }
                if (operatorDone) {
                    secondArgument = (String)secondArgument + evaluatorValue + " ";
                    continue;
                }
                firstArgument = (String)firstArgument + evaluatorValue + " ";
            }
            ArrayList<QueryField> presentFields = new ArrayList<QueryField>();
            if (operator == null || ((String)operator).trim().isEmpty()) {
                Object leftValue = Query.processStringValue(query, groups, richTexts, ((String)firstArgument).trim(), placesIndex, QueryParameter.class, presentFields);
                evaluator = new BooleanEvaluator(leftValue);
            } else {
                Object rightValue;
                Object leftValue = Query.processStringValue(query, groups, richTexts, ((String)firstArgument).trim(), placesIndex, QueryParameter.class, presentFields);
                if (leftValue instanceof String) {
                    leftValue = Strings.reverseGrouping((String)leftValue, groups);
                }
                if ((rightValue = Query.processStringValue(query, groups, richTexts, ((String)secondArgument).trim(), placesIndex, QueryParameter.class, presentFields)) instanceof String) {
                    rightValue = Strings.reverseGrouping((String)rightValue, groups);
                }
                if (((String)(operator = ((String)operator).trim())).equalsIgnoreCase(SystemProperties.get("hcjf.query.distinct.reserved.word")) || ((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.distinct.2.reserved.word"))) {
                    evaluator = new Distinct(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.equals.reserved.word"))) {
                    evaluator = new Equals(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.greater.than.reserved.word"))) {
                    evaluator = new GreaterThan(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.greater.than.or.equals.reserved.word"))) {
                    evaluator = new GreaterThanOrEqual(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.in.reserved.word"))) {
                    evaluator = new In(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.like.reserved.word"))) {
                    evaluator = new Like(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.not.in.reserved.word"))) {
                    evaluator = new NotIn(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.smaller.than.reserved.word"))) {
                    evaluator = new SmallerThan(leftValue, rightValue);
                } else if (((String)operator).equalsIgnoreCase(SystemProperties.get("hcjf.query.smaller.than.or.equals.reserved.word"))) {
                    evaluator = new SmallerThanOrEqual(leftValue, rightValue);
                } else {
                    throw new HCJFRuntimeException("Unsupported operator '%s', near '%s'", operator, definition);
                }
            }
            if (evaluator instanceof BaseEvaluator) {
                ((BaseEvaluator)evaluator).setEvaluatorFields(presentFields);
            }
            collection.addEvaluator(evaluator);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object processStringValue(Query query, List<String> groups, List<String> richTexts, String stringValue, AtomicInteger placesIndex, Class parameterClass, List<QueryField> presentFields) {
        Object result = null;
        String trimmedStringValue = stringValue.trim();
        if (trimmedStringValue.equals(SystemProperties.get("hcjf.query.replaceable.value.reserved.word"))) {
            result = new BaseEvaluator.ReplaceableValue(placesIndex.getAndAdd(1));
        } else if (trimmedStringValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.null.reserved.word"))) {
            result = null;
        } else if (trimmedStringValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.true.reserved.word"))) {
            result = true;
        } else if (trimmedStringValue.equalsIgnoreCase(SystemProperties.get("hcjf.query.false.reserved.word"))) {
            result = false;
        } else if (trimmedStringValue.startsWith(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"))) {
            if (!trimmedStringValue.endsWith(SystemProperties.get("hcjf.query.string.delimiter.reserved.word"))) throw new HCJFRuntimeException("Expecting string en delimiter, near %s", trimmedStringValue);
            trimmedStringValue = trimmedStringValue.substring(1, trimmedStringValue.length() - 1);
            trimmedStringValue = richTexts.get(Integer.parseInt(trimmedStringValue.replace("\u00a1", "")));
            trimmedStringValue = trimmedStringValue.replace("\\'", "'");
            try {
                result = SystemProperties.getDateFormat("hcjf.query.date.format").parse(trimmedStringValue);
            }
            catch (Exception ex) {
                while (trimmedStringValue.contains("\u00bf")) {
                    trimmedStringValue = Strings.reverseGrouping(trimmedStringValue, groups);
                }
                result = trimmedStringValue;
            }
        } else if (trimmedStringValue.startsWith("\u00bf")) {
            Integer index = Integer.parseInt(trimmedStringValue.replace("\u00bf", ""));
            String group = groups.get(index);
            if (group.toUpperCase().startsWith(SystemProperties.get("hcjf.query.select.reserved.word"))) {
                result = new BaseEvaluator.QueryValue(Query.compile(groups, richTexts, index));
            } else {
                ArrayList<Object> collection = new ArrayList<Object>();
                for (String subStringValue : group.split(SystemProperties.get("hcjf.query.argument.separator"))) {
                    collection.add(Query.processStringValue(query, groups, richTexts, subStringValue.trim(), placesIndex, parameterClass, presentFields));
                }
                result = collection;
            }
        } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.uuid.regex"))) {
            result = UUID.fromString(trimmedStringValue);
        } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.integer.number.regex"))) {
            result = Long.parseLong(trimmedStringValue);
        } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.decimal.number.regex"))) {
            try {
                result = SystemProperties.getDecimalFormat("hcjf.query.decimal.format").parse(trimmedStringValue);
            }
            catch (ParseException e) {
                throw new HCJFRuntimeException("Unable to parse decimal number", new Object[0]);
            }
        } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.scientific.number.regex"))) {
            try {
                result = SystemProperties.getDecimalFormat("hcjf.query.scientific.notation.format").parse(trimmedStringValue);
            }
            catch (ParseException e) {
                throw new HCJFRuntimeException("Unable to parse scientific number", new Object[0]);
            }
        } else if (trimmedStringValue.matches(SystemProperties.get("hcjf.math.connector.regular.expression")) && trimmedStringValue.matches(SystemProperties.get("hcjf.math.regular.expression"))) {
            String alias = null;
            String[] asParts = trimmedStringValue.split(SystemProperties.get("hcjf.query.as.regular.expression"));
            if (asParts.length == 3) {
                trimmedStringValue = asParts[0].trim();
                alias = asParts[2].trim();
            }
            String[] mathExpressionParts = trimmedStringValue.split(SystemProperties.get("hcjf.math.splitter.regular.expression"));
            ArrayList<Object> parameters = new ArrayList<Object>();
            boolean desc = false;
            for (int i = 0; i < mathExpressionParts.length; ++i) {
                String currentValue = mathExpressionParts[i];
                if (i == mathExpressionParts.length - 1) {
                    String[] parts;
                    if (parameterClass.equals(QueryReturnParameter.class)) {
                        parts = currentValue.split(SystemProperties.get("hcjf.query.as.regular.expression"));
                        if (parts.length == 2) {
                            currentValue = parts[0].trim();
                            alias = parts[1].trim();
                        }
                    } else if (parameterClass.equals(QueryOrderParameter.class) && (parts = currentValue.split(SystemProperties.get("hcjf.query.desc.regular.expression"))).length == 3) {
                        currentValue = parts[0].trim();
                        if (parts[2].trim().equalsIgnoreCase(SystemProperties.get("hcjf.query.desc.reserved.word"))) {
                            desc = true;
                        }
                    }
                }
                if (currentValue.matches(SystemProperties.get("hcjf.math.connector.regular.expression"))) {
                    parameters.add(currentValue.trim());
                    continue;
                }
                parameters.add(Query.processStringValue(query, groups, richTexts, currentValue, placesIndex, QueryParameter.class, presentFields));
            }
            if (parameterClass.equals(QueryParameter.class)) {
                result = new QueryFunction(query, Strings.reverseGrouping(trimmedStringValue, groups), SystemProperties.get("hcjf.query.function.math.eval.expression.name"), parameters);
            } else if (parameterClass.equals(QueryReturnParameter.class)) {
                result = new QueryReturnFunction(query, Strings.reverseGrouping(trimmedStringValue, groups), SystemProperties.get("hcjf.query.function.math.eval.expression.name"), parameters, alias);
            } else if (parameterClass.equals(QueryOrderParameter.class)) {
                result = new QueryOrderFunction(query, Strings.reverseGrouping(trimmedStringValue, groups), SystemProperties.get("hcjf.query.function.math.eval.expression.name"), parameters, desc);
            }
        } else {
            String functionName = null;
            String originalValue = null;
            String replaceValue = null;
            String group = null;
            ArrayList<Object> functionParameters = null;
            Boolean function = false;
            if (trimmedStringValue.contains("\u00bf")) {
                replaceValue = Strings.getGroupIndex(trimmedStringValue, "\u00bf");
                group = groups.get(Integer.parseInt(replaceValue.replace("\u00bf", "")));
                functionName = trimmedStringValue.substring(0, trimmedStringValue.indexOf("\u00bf"));
                originalValue = trimmedStringValue.replace(replaceValue, "(" + group + ")");
                functionParameters = new ArrayList<Object>();
                for (String param : group.split(SystemProperties.get("hcjf.query.argument.separator"))) {
                    functionParameters.add(Query.processStringValue(query, groups, richTexts, param, placesIndex, parameterClass, presentFields));
                }
                originalValue = Strings.reverseRichTextGrouping(originalValue, richTexts);
                function = true;
            } else {
                originalValue = trimmedStringValue;
            }
            if (parameterClass.equals(QueryParameter.class)) {
                result = function.booleanValue() ? new QueryFunction(query, originalValue, functionName, functionParameters) : new QueryField(query, trimmedStringValue);
            } else if (parameterClass.equals(QueryReturnParameter.class)) {
                String alias = null;
                String[] parts = originalValue.split(SystemProperties.get("hcjf.query.as.regular.expression"));
                if (parts.length == 3) {
                    originalValue = parts[0].trim();
                    alias = parts[2].trim();
                }
                result = function.booleanValue() ? new QueryReturnFunction(query, originalValue, functionName, functionParameters, alias) : new QueryReturnField(query, originalValue, alias);
            } else if (parameterClass.equals(QueryOrderParameter.class)) {
                boolean desc = false;
                String[] parts = originalValue.split(SystemProperties.get("hcjf.query.desc.regular.expression"));
                if (parts.length == 2) {
                    originalValue = parts[0].trim();
                    if (parts[1].trim().equalsIgnoreCase(SystemProperties.get("hcjf.query.desc.reserved.word"))) {
                        desc = true;
                    }
                }
                result = function != false ? new QueryOrderFunction(query, originalValue, functionName, functionParameters, desc) : new QueryOrderField(query, originalValue, desc);
            }
        }
        if (!(result instanceof QueryField)) return result;
        presentFields.add((QueryField)result);
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof Query && obj.toString().equals(this.toString());
    }

    static {
        Layers.publishLayer(MathQueryFunctionLayer.class);
        Layers.publishLayer(StringQueryFunctionLayer.class);
        Layers.publishLayer(DateQueryFunctionLayer.class);
        Layers.publishLayer(ReferenceFunctionLayer.class);
        Layers.publishLayer(BsonQueryFunctionLayer.class);
        Layers.publishLayer(CollectionQueryFunction.class);
        Layers.publishLayer(ObjectQueryFunction.class);
        Layers.publishLayer(QueryBsonBuilderLayer.class);
        Layers.publishLayer(GeoQueryFunctionLayer.class);
        Layers.publishLayer(CountQueryAggregateFunctionLayer.class);
        Layers.publishLayer(SumAggregateFunctionLayer.class);
        Layers.publishLayer(ProductAggregateFunctionLayer.class);
        Layers.publishLayer(MeanAggregateFunctionLayer.class);
        Layers.publishLayer(MaxAggregateFunctionLayer.class);
        Layers.publishLayer(MinAggregateFunctionLayer.class);
        Layers.publishLayer(DistinctQueryAggregateFunction.class);
        Layers.publishLayer(GeoUnionAggregateFunctionLayer.class);
        Layers.publishLayer(GeoDistanceAggregateFunctionLayer.class);
        Layers.publishLayer(EvalExpressionAggregateFunctionLayer.class);
        Layers.publishLayer(ContextAggregateFunction.class);
    }
}

