/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.functions.BaseQueryFunctionLayer;
import org.hcjf.properties.SystemProperties;

public class CollectionQueryFunction
extends BaseQueryFunctionLayer {
    private static final String SIZE = "size";
    private static final String GET = "get";
    private static final String CONTAINS = "contains";
    private static final String CONTAINS_ALL = "containsAll";
    private static final String CONTAINS_KEY = "containsKey";
    private static final String CONTAINS_ALL_KEYS = "containsAllKeys";
    private static final String KEYS = "keys";

    public CollectionQueryFunction() {
        super(SystemProperties.get("hcjf.query.function.collection.name"));
        this.addFunctionName(SIZE);
        this.addFunctionName(GET);
        this.addFunctionName(CONTAINS);
        this.addFunctionName(CONTAINS_ALL);
        this.addFunctionName(CONTAINS_KEY);
        this.addFunctionName(CONTAINS_ALL_KEYS);
        this.addFunctionName(KEYS);
    }

    @Override
    public Object evaluate(String functionName, Object ... parameters) {
        Object result = null;
        switch (functionName) {
            case "size": {
                if (this.getParameter(0, parameters) instanceof Collection) {
                    result = ((Collection)parameters[0]).size();
                    break;
                }
                if (this.getParameter(0, parameters) instanceof Map) {
                    result = ((Map)parameters[0]).size();
                    break;
                }
                if (this.getParameter(0, parameters).getClass().isArray()) {
                    result = Array.getLength(parameters[0]);
                    break;
                }
                result = 1;
                break;
            }
            case "get": {
                if (this.getParameter(0, parameters) instanceof Collection && parameters[1] instanceof Integer) {
                    result = Array.get(((Collection)parameters[0]).toArray(), (Integer)parameters[1]);
                    break;
                }
                if (this.getParameter(0, parameters).getClass().isArray() && parameters[1] instanceof Integer) {
                    result = Array.get(parameters[0], (Integer)parameters[1]);
                    break;
                }
                if (!(this.getParameter(0, parameters) instanceof Map)) break;
                result = ((Map)parameters[0]).get(parameters[1]);
                break;
            }
            case "contains": {
                if (this.getParameter(0, parameters) instanceof Collection) {
                    result = ((Collection)this.getParameter(0, parameters)).contains(this.getParameter(1, parameters));
                    break;
                }
                if (this.getParameter(0, parameters).getClass().isArray()) {
                    result = Arrays.asList((Object[])this.getParameter(0, parameters)).contains(this.getParameter(1, parameters));
                    break;
                }
                throw new HCJFRuntimeException("Contains functions is only for collections and arrays", new Object[0]);
            }
            case "containsAll": {
                List<Object> secondCollection;
                List<Object> firstCollection;
                if (this.getParameter(0, parameters) instanceof Collection) {
                    firstCollection = (List<Object>)this.getParameter(0, parameters);
                } else if (this.getParameter(0, parameters).getClass().isArray()) {
                    firstCollection = Arrays.asList((Object[])this.getParameter(0, parameters));
                } else {
                    throw new HCJFRuntimeException("The first parameter for contains all function can only be a collection or an array", new Object[0]);
                }
                if (this.getParameter(1, parameters) instanceof Collection) {
                    secondCollection = (List<Object>)this.getParameter(1, parameters);
                } else if (this.getParameter(1, parameters).getClass().isArray()) {
                    secondCollection = Arrays.asList((Object[])this.getParameter(1, parameters));
                } else {
                    throw new HCJFRuntimeException("The second parameter for contains all function can only be a collection or an array", new Object[0]);
                }
                result = firstCollection.containsAll(secondCollection);
                break;
            }
            case "containsKey": {
                if (this.getParameter(0, parameters) instanceof Map) {
                    result = ((Map)this.getParameter(0, parameters)).containsKey(this.getParameter(1, parameters));
                    break;
                }
                throw new HCJFRuntimeException("Contains key function is only for maps", new Object[0]);
            }
            case "containsAllKeys": {
                List<Object> collection;
                if (!(this.getParameter(0, parameters) instanceof Map)) {
                    throw new HCJFRuntimeException("The first parameter for contains all keys function can only be a map", new Object[0]);
                }
                Map map = (Map)this.getParameter(0, parameters);
                if (this.getParameter(1, parameters) instanceof Collection) {
                    collection = (List<Object>)this.getParameter(1, parameters);
                } else if (parameters[1].getClass().isArray()) {
                    collection = Arrays.asList((Object[])this.getParameter(1, parameters));
                } else {
                    throw new HCJFRuntimeException("The second parameter for contains all keys function can only be a collection or an array", new Object[0]);
                }
                result = map.keySet().containsAll(collection);
                break;
            }
            case "keys": {
                if (!(this.getParameter(0, parameters) instanceof Map)) {
                    throw new HCJFRuntimeException("The first parameter for 'keys' function can only be a map", new Object[0]);
                }
                Map map = (Map)this.getParameter(0, parameters);
                result = map.keySet();
                break;
            }
        }
        return result;
    }
}

