/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.service;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.hcjf.layers.Layer;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.ServiceThread;
import org.hcjf.service.security.Grants;

public class ServiceSession
implements Comparable {
    private static final SystemSession SYSTEM_SESSION;
    private static final ServiceSession GUEST_SESSION;
    private static final List<ServiceSessionSource> sources;
    private final UUID id;
    private String sessionName;
    private final Map<Long, List<LayerStackElement>> layerStack;
    private final Map<Long, Map<String, Object>> properties;
    private final Map<Long, Long> systemTimeByThread;
    private final ThreadMXBean threadMXBean;
    private final List<ServiceSession> identities;
    private final Set<Grants.Grant> grants;
    private Locale locale;

    public ServiceSession(UUID id) {
        this.id = id;
        this.properties = new HashMap<Long, Map<String, Object>>();
        this.layerStack = Collections.synchronizedMap(new HashMap());
        this.systemTimeByThread = new HashMap<Long, Long>();
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.locale = SystemProperties.getLocale();
        this.identities = new ArrayList<ServiceSession>();
        this.grants = new HashSet<Grants.Grant>();
    }

    public final void addIdentity(ServiceSession serviceSession) {
        if (serviceSession != null) {
            this.identities.add(0, serviceSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeIdentity() {
        List<ServiceSession> list = this.identities;
        synchronized (list) {
            if (!this.identities.isEmpty()) {
                this.identities.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <S extends ServiceSession> S currentIdentity() {
        ServiceSession result = this;
        List<ServiceSession> list = this.identities;
        synchronized (list) {
            if (!this.identities.isEmpty()) {
                result = this.identities.get(0);
            }
        }
        return (S)result;
    }

    public final UUID getId() {
        return this.id;
    }

    public final void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public final String getSessionName() {
        return this.sessionName;
    }

    public final synchronized void startThread() {
        this.systemTimeByThread.put(Thread.currentThread().getId(), this.threadMXBean.getCurrentThreadCpuTime());
        this.layerStack.put(Thread.currentThread().getId(), new ArrayList());
        this.properties.put(Thread.currentThread().getId(), new HashMap());
        this.onStartThread();
    }

    protected void onStartThread() {
    }

    public final synchronized void endThread() {
        this.layerStack.remove(Thread.currentThread().getId());
        this.properties.remove(Thread.currentThread().getId());
        this.onEndThread();
        this.addThreadTime(this.threadMXBean.getCurrentThreadCpuTime() - this.systemTimeByThread.remove(Thread.currentThread().getId()));
    }

    protected void onEndThread() {
    }

    public final Map<String, Object> getProperties() {
        Map<String, Object> result = null;
        if (((ServiceSession)ServiceSession.getCurrentSession()).equals(this)) {
            if (this.properties.containsKey(Thread.currentThread().getId())) {
                result = Collections.unmodifiableMap(this.properties.get(Thread.currentThread().getId()));
            }
        } else {
            result = ((ServiceSession)ServiceSession.getCurrentSession()).getProperties();
        }
        return result;
    }

    public final void putAll(Map<String, Object> properties) {
        if (((ServiceSession)ServiceSession.getCurrentSession()).equals(this)) {
            this.properties.get(Thread.currentThread().getId()).putAll(properties);
        } else {
            ((ServiceSession)ServiceSession.getCurrentSession()).putAll(properties);
        }
    }

    public final void put(String propertyName, Object propertyValue) {
        if (((ServiceSession)ServiceSession.getCurrentSession()).equals(this)) {
            this.properties.get(Thread.currentThread().getId()).put(propertyName, propertyValue);
        } else {
            ((ServiceSession)ServiceSession.getCurrentSession()).put(propertyName, propertyValue);
        }
    }

    public final <O> O get(String propertyName) {
        Object result = ((ServiceSession)ServiceSession.getCurrentSession()).equals(this) ? this.properties.get(Thread.currentThread().getId()).get(propertyName) : ((ServiceSession)ServiceSession.getCurrentSession()).get(propertyName);
        return result;
    }

    public final <O> O remove(String propertyName) {
        if (((ServiceSession)ServiceSession.getCurrentSession()).equals(this)) {
            return (O)this.properties.get(Thread.currentThread().getId()).remove(propertyName);
        }
        O result = ((ServiceSession)ServiceSession.getCurrentSession()).remove(propertyName);
        return result;
    }

    public final void putLayer(LayerStackElement element) {
        if (((ServiceSession)ServiceSession.getCurrentSession()).equals(this)) {
            this.layerStack.get(Thread.currentThread().getId()).add(0, element);
        } else {
            ((ServiceSession)ServiceSession.getCurrentSession()).putLayer(element);
        }
    }

    public final void removeLayer() {
        if (((ServiceSession)ServiceSession.getCurrentSession()).equals(this)) {
            this.layerStack.get(Thread.currentThread().getId()).remove(0);
        } else {
            ((ServiceSession)ServiceSession.getCurrentSession()).removeLayer();
        }
    }

    public final Collection<LayerStackElement> getLayerStack() {
        Collection<LayerStackElement> result = ((ServiceSession)ServiceSession.getCurrentSession()).equals(this) ? Collections.unmodifiableCollection((Collection)this.layerStack.get(Thread.currentThread().getId())) : ((ServiceSession)ServiceSession.getCurrentSession()).getLayerStack();
        return result;
    }

    public final LayerStackElement getCurrentLayer() {
        LayerStackElement result = null;
        if (((ServiceSession)ServiceSession.getCurrentSession()).equals(this)) {
            if (this.layerStack.containsKey(Thread.currentThread().getId()) && this.layerStack.get(Thread.currentThread().getId()).size() > 0) {
                result = this.layerStack.get(Thread.currentThread().getId()).get(0);
            }
        } else {
            result = ((ServiceSession)ServiceSession.getCurrentSession()).getCurrentLayer();
        }
        return result;
    }

    public final LayerStackElement getInvokerLayer() {
        LayerStackElement result = null;
        if (((ServiceSession)ServiceSession.getCurrentSession()).equals(this)) {
            if (this.layerStack.get(Thread.currentThread().getId()).size() > 1) {
                result = this.layerStack.get(Thread.currentThread().getId()).get(1);
            }
        } else {
            result = ((ServiceSession)ServiceSession.getCurrentSession()).getInvokerLayer();
        }
        return result;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected void addThreadTime(long time) {
    }

    public void addIngressPackage(long size) {
    }

    public void addEgressPackage(long size) {
    }

    public final void addGrant(Grants.Grant grant) {
        this.grants.add(grant);
    }

    public final void removeGrant(Grants.Grant grant) {
        this.grants.remove(grant);
    }

    public final Set<Grants.Grant> getGrants() {
        return Collections.unmodifiableSet(this.grants);
    }

    public final boolean containsGrant(String grantId) {
        Grants.Grant grant;
        boolean result = false;
        Iterator<Grants.Grant> iterator = this.grants.iterator();
        while (iterator.hasNext() && !(result = (grant = iterator.next()).getPermissionId().equals(grantId))) {
        }
        return result;
    }

    public final boolean isSystemSession() {
        return this.equals(ServiceSession.getSystemSession());
    }

    public final boolean isGuestSession() {
        return this.equals(ServiceSession.getGuestSession());
    }

    public final int compareTo(Object object) {
        int result = this.hashCode() - object.hashCode();
        if (this.getClass().equals(object.getClass())) {
            ServiceSession otherSession = (ServiceSession)object;
            if (this.getId().equals(otherSession.getId())) {
                result = 0;
            }
        }
        return result;
    }

    public final boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ServiceSession) {
            result = ((ServiceSession)obj).getId().equals(this.getId());
        }
        return result;
    }

    public static void addServiceSessionSource(ServiceSessionSource source) {
        Objects.requireNonNull(source, "Unable to add null source");
        sources.add(source);
    }

    public static <S extends ServiceSession> S findSession(UUID sessionId) {
        ServiceSession result = null;
        if (sessionId.equals(ServiceSession.getSystemSession().getId())) {
            result = ServiceSession.getSystemSession();
        } else if (sessionId.equals(ServiceSession.getGuestSession().getId())) {
            result = ServiceSession.getGuestSession();
        } else {
            ServiceSessionSource source;
            Iterator<ServiceSessionSource> iterator = sources.iterator();
            while (iterator.hasNext() && (result = (source = iterator.next()).findSession(sessionId)) == null) {
            }
        }
        return (S)result;
    }

    public static <S extends ServiceSession> S findSession(Map<String, Object> sessionBean) {
        ServiceSessionSource source;
        S result = null;
        Iterator<ServiceSessionSource> iterator = sources.iterator();
        while (iterator.hasNext() && (result = (S)(source = iterator.next()).findSession(sessionBean)) == null) {
        }
        return result;
    }

    public static final ServiceSession getSystemSession() {
        return SYSTEM_SESSION;
    }

    public static final ServiceSession getGuestSession() {
        return GUEST_SESSION;
    }

    public static final <S extends ServiceSession> S getCurrentSession() {
        Thread currentThread = Thread.currentThread();
        if (ServiceThread.class.isAssignableFrom(currentThread.getClass())) {
            return (S)((ServiceThread)currentThread).getSession();
        }
        throw new IllegalStateException("The current thread is not a service thread.");
    }

    public static final <S extends ServiceSession> S getCurrentIdentity() {
        Thread currentThread = Thread.currentThread();
        if (ServiceThread.class.isAssignableFrom(currentThread.getClass())) {
            return ((ServiceThread)currentThread).getSession() == null ? null : (S)((ServiceThread)currentThread).getSession().currentIdentity();
        }
        throw new IllegalStateException("The current thread is not a service thread.");
    }

    public Map<String, Object> getBody() {
        return Map.of();
    }

    static {
        GUEST_SESSION = new GuestSession();
        SYSTEM_SESSION = new SystemSession();
        sources = new ArrayList<ServiceSessionSource>();
    }

    public static interface ServiceSessionSource {
        public <S extends ServiceSession> S findSession(UUID var1);

        public <S extends ServiceSession> S findSession(Map<String, Object> var1);
    }

    public static final class LayerStackElement {
        private final Class<? extends Layer> layerClass;
        private final String implName;
        private final boolean plugin;
        private final boolean stateful;

        public LayerStackElement(Class<? extends Layer> layerClass, String implName, boolean plugin, boolean stateful) {
            this.layerClass = layerClass;
            this.implName = implName;
            this.plugin = plugin;
            this.stateful = stateful;
        }

        public Class<? extends Layer> getLayerClass() {
            return this.layerClass;
        }

        public String getImplName() {
            return this.implName;
        }

        public boolean isPlugin() {
            return this.plugin;
        }

        public boolean isStateful() {
            return this.stateful;
        }
    }

    private static class GuestSession
    extends ServiceSession {
        public GuestSession() {
            super(new UUID(0L, 1L));
            this.setSessionName(SystemProperties.get("hcjf.service.guest.session.name"));
        }
    }

    private static class SystemSession
    extends ServiceSession {
        public SystemSession() {
            super(new UUID(0L, 0L));
            this.setSessionName(SystemProperties.get("hcjf.service.system.session.name"));
        }
    }
}

