/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.names.Naming;
import org.hcjf.service.security.LazyPermission;
import org.hcjf.service.security.Permission;
import org.hcjf.service.security.SecurityPermissions;

public final class Introspection {
    private static final Pattern GETTER_METHODS_PATTERN = Pattern.compile("^(get|is)([1,A-Z]|[1,0-9])(.*)");
    private static final Pattern SETTER_METHODS_PATTERN = Pattern.compile("^(set)([1,A-Z]|[1,0-9])(.*)");
    private static final String PATH_SEPARATOR = "\\.";
    private static final int SETTER_GETTER_FIRST_CHAR_FIELD_NAME_GROUP = 2;
    private static final int SETTER_GETTER_FIELD_NAME_GROUP = 3;
    private static final Map<String, Map<String, ? extends Invoker>> invokerCache = new HashMap<String, Map<String, ? extends Invoker>>();
    private static final Map<Class, Map<String, Accessors>> accessorsCache = new HashMap<Class, Map<String, Accessors>>();

    public static <O> O resolve(Object instance, String path) {
        String[] pathElements = path.split(PATH_SEPARATOR);
        return Introspection.resolve(instance, pathElements);
    }

    public static <O> O resolve(Object instance, String ... path) {
        Object result = instance;
        for (String element : path) {
            Integer index;
            if (result == null) break;
            if (result instanceof Map) {
                result = ((Map)result).get(element);
                continue;
            }
            if (result instanceof List) {
                try {
                    index = Integer.parseInt(element);
                    result = ((List)result).get(index);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to access to list value [" + element + "]");
                }
            }
            if (result instanceof Collection) {
                try {
                    index = Integer.parseInt(element);
                    result = ((Collection)result).stream().skip(index - 1).findFirst().get();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to access to collection value [" + element + "]");
                }
            }
            if (result.getClass().isArray()) {
                try {
                    index = Integer.parseInt(element);
                    result = Array.get(result, index);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to access to array value [" + element + "]");
                }
            }
            try {
                result = Introspection.get(result, element);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to access to field '" + element + "'");
            }
        }
        return (O)result;
    }

    public static <O> O get(Object instance, String getterName) {
        return Introspection.getGetters(instance.getClass()).get(getterName).get(instance);
    }

    public static List get(Object instance, String ... getters) {
        ArrayList result = new ArrayList();
        for (String getter : getters) {
            result.add(Introspection.get(instance, getter));
        }
        return result;
    }

    public static Map<String, Object> toMap(Object instance) {
        return Introspection.toMap(instance, O -> O);
    }

    public static Map<String, String> toStringsMap(Object instance) {
        return Introspection.toMap(instance, O -> O.toString());
    }

    public static <O> Map<String, O> toMap(Object instance, Consumer consumer) {
        Map<String, Object> result = new HashMap();
        if (instance instanceof Map) {
            result = (Map)instance;
        } else {
            Map<String, Getter> getters = Introspection.getGetters(instance.getClass());
            for (String name : getters.keySet()) {
                try {
                    Object value = getters.get(name).get(instance);
                    if (value == null) continue;
                    result.put(name, consumer.consume(value));
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public static <O> O toInstance(Map<String, Object> map, Class<O> clazz) throws IllegalAccessException, InstantiationException {
        O result = null;
        try {
            result = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create instance", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Default constructor not found", e);
        }
        Map<String, Setter> setters = Introspection.getSetters(clazz);
        for (String name : setters.keySet()) {
            if (!map.containsKey(name)) continue;
            try {
                Setter currentSetter = setters.get(name);
                Object currentValue = map.get(name);
                if (currentValue instanceof Number) {
                    if (Byte.class.isAssignableFrom(currentSetter.getParameterType())) {
                        currentSetter.set(result, ((Number)map.get(name)).byteValue());
                        continue;
                    }
                    if (Short.class.isAssignableFrom(currentSetter.getParameterType())) {
                        currentSetter.set(result, ((Number)map.get(name)).shortValue());
                        continue;
                    }
                    if (Integer.class.isAssignableFrom(currentSetter.getParameterType())) {
                        currentSetter.set(result, ((Number)map.get(name)).intValue());
                        continue;
                    }
                    if (!Long.class.isAssignableFrom(currentSetter.getParameterType())) continue;
                    currentSetter.set(result, ((Number)map.get(name)).longValue());
                    continue;
                }
                if (Map.class.isAssignableFrom(currentValue.getClass()) && !Map.class.isAssignableFrom(currentSetter.getParameterType())) {
                    currentSetter.set(result, Introspection.toInstance((Map)currentValue, currentSetter.getParameterType()));
                    continue;
                }
                currentSetter.set(result, map.get(name));
            }
            catch (Exception exception) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends Invoker> Map<String, I> getInvokers(Class clazz, InvokerFilter<I> filter) {
        Map<Object, Object> result = new HashMap();
        String invokerKey = Introspection.getInvokerKey(clazz, filter);
        if (!clazz.equals(Object.class)) {
            Map<String, Map<String, ? extends Invoker>> map = invokerCache;
            synchronized (map) {
                if (!invokerCache.containsKey(invokerKey)) {
                    invokerCache.put(invokerKey, result);
                    if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Objects.class)) {
                        result.putAll(Introspection.getInvokers(clazz.getSuperclass(), filter));
                    }
                    for (Method method : clazz.getDeclaredMethods()) {
                        InvokerEntry<I> entry = filter.filter(method);
                        if (entry == null) continue;
                        result.put(entry.getKey(), entry.getInvoker());
                        for (String alias : entry.getAliases()) {
                            result.put(alias, entry.getInvoker());
                        }
                    }
                } else {
                    result = invokerCache.get(invokerKey);
                }
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private static String getInvokerKey(Class clazz, InvokerFilter filter) {
        return clazz.getName() + filter.getName();
    }

    public static synchronized Map<String, Accessors> getAccessors(Class clazz) {
        Map<String, Accessors> result = accessorsCache.get(clazz);
        if (result == null) {
            result = new HashMap<String, Accessors>();
            Map<String, Setter> setterMap = Introspection.getSetters(clazz);
            Map<String, Getter> getterMap = Introspection.getGetters(clazz);
            HashSet<String> keySet = new HashSet<String>();
            keySet.addAll(setterMap.keySet());
            keySet.addAll(getterMap.keySet());
            for (String key : keySet) {
                result.put(key, new Accessors(key, getterMap.get(key), setterMap.get(key)));
            }
            accessorsCache.put(clazz, result);
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, Getter> getGetters(Class clazz, String namingImpl) {
        Map<String, Getter> getters = Introspection.getGetters(clazz);
        HashMap<String, Getter> result = new HashMap<String, Getter>();
        for (String name : getters.keySet()) {
            result.put(Naming.normalize(namingImpl, name), getters.get(name));
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, Getter> getGetters(Class clazz) {
        Map result = Introspection.getInvokers(clazz, method -> {
            Matcher matcher;
            InvokerEntry<Getter> result1 = null;
            if (Modifier.isPublic(method.getModifiers()) && (matcher = GETTER_METHODS_PATTERN.matcher(method.getName())).matches() && !method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 0) {
                String fieldName = matcher.group(2).toLowerCase() + matcher.group(3);
                result1 = new InvokerEntry<Getter>(fieldName, new Getter(method.getDeclaringClass(), fieldName, method), new String[0]);
            }
            return result1;
        });
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, Setter> getSetters(Class clazz, String namingImpl) {
        Map<String, Setter> setters = Introspection.getSetters(clazz);
        HashMap<String, Setter> result = new HashMap<String, Setter>();
        for (String name : setters.keySet()) {
            result.put(Naming.normalize(namingImpl, name), setters.get(name));
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, Setter> getSetters(Class clazz) {
        Map result = Introspection.getInvokers(clazz, method -> {
            Matcher matcher;
            InvokerEntry<Setter> result1 = null;
            if (Modifier.isPublic(method.getModifiers()) && (matcher = SETTER_METHODS_PATTERN.matcher(method.getName())).matches() && method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 1) {
                String fieldName = matcher.group(2).toLowerCase() + matcher.group(3);
                result1 = new InvokerEntry<Setter>(fieldName, new Setter(method.getDeclaringClass(), fieldName, method), new String[0]);
            }
            return result1;
        });
        return Collections.unmodifiableMap(result);
    }

    public static interface Consumer {
        public Object consume(Object var1);
    }

    public static class InvokerEntry<I extends Invoker> {
        private final String key;
        private final I invoker;
        private final String[] aliases;

        public InvokerEntry(String key, I invoker, String ... aliases) {
            this.key = key;
            this.invoker = invoker;
            this.aliases = aliases;
        }

        public String getKey() {
            return this.key;
        }

        public I getInvoker() {
            return this.invoker;
        }

        public String[] getAliases() {
            return this.aliases;
        }
    }

    public static interface InvokerFilter<I extends Invoker> {
        public InvokerEntry<I> filter(Method var1);

        default public String getName() {
            return this.getClass().getName();
        }
    }

    public static class Setter
    extends Accessor {
        private final Class parameterType;
        private ParameterizedType parameterParameterizedType;
        private final Class parameterKeyType;
        private final Class parameterCollectionType;

        public Setter(Class implementationClass, String resourceName, Method method) {
            super(implementationClass, resourceName, method);
            this.parameterType = method.getParameterTypes()[0];
            this.parameterParameterizedType = null;
            if (method.getGenericParameterTypes()[0] instanceof ParameterizedType) {
                this.parameterParameterizedType = (ParameterizedType)method.getGenericParameterTypes()[0];
                if (Collection.class.isAssignableFrom(this.parameterType)) {
                    this.parameterKeyType = null;
                    this.parameterCollectionType = this.parameterParameterizedType.getActualTypeArguments()[0] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[0] : (this.parameterParameterizedType.getActualTypeArguments()[0] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[0]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[0]).getRawType());
                } else if (Map.class.isAssignableFrom(this.parameterType)) {
                    this.parameterKeyType = this.parameterParameterizedType.getActualTypeArguments()[0] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[0] : (this.parameterParameterizedType.getActualTypeArguments()[0] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[0]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[0]).getRawType());
                    this.parameterCollectionType = this.parameterParameterizedType.getActualTypeArguments()[1] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[1] : (this.parameterParameterizedType.getActualTypeArguments()[1] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[1]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[1]).getRawType());
                } else {
                    this.parameterKeyType = null;
                    this.parameterCollectionType = null;
                }
            } else {
                this.parameterKeyType = null;
                this.parameterCollectionType = null;
            }
        }

        public void set(Object instance, Object value) {
            this.invoke(instance, value);
        }

        public final Class getParameterType() {
            return this.parameterType;
        }

        public final ParameterizedType getParameterParameterizedType() {
            return this.parameterParameterizedType;
        }

        public final Class getParameterKeyType() {
            return this.parameterKeyType;
        }

        public final Class getParameterCollectionType() {
            return this.parameterCollectionType;
        }
    }

    public static class Getter
    extends Accessor {
        private final Class returnType;
        private ParameterizedType parameterParameterizedType;
        private final Class returnKeyType;
        private final Class returnCollectionType;

        public Getter(Class implementationClass, String resourceName, Method method) {
            super(implementationClass, resourceName, method);
            this.returnType = method.getReturnType();
            this.parameterParameterizedType = null;
            if (method.getGenericReturnType() instanceof ParameterizedType) {
                this.parameterParameterizedType = (ParameterizedType)method.getGenericReturnType();
                if (Collection.class.isAssignableFrom(this.returnType)) {
                    this.returnKeyType = null;
                    this.returnCollectionType = this.parameterParameterizedType.getActualTypeArguments()[0] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[0] : (this.parameterParameterizedType.getActualTypeArguments()[0] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[0]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[0]).getRawType());
                } else if (Map.class.isAssignableFrom(this.returnType)) {
                    this.returnKeyType = this.parameterParameterizedType.getActualTypeArguments()[0] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[0] : (this.parameterParameterizedType.getActualTypeArguments()[0] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[0]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[0]).getRawType());
                    this.returnCollectionType = this.parameterParameterizedType.getActualTypeArguments()[1] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[1] : (this.parameterParameterizedType.getActualTypeArguments()[1] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[1]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[1]).getRawType());
                } else {
                    this.returnKeyType = null;
                    this.returnCollectionType = null;
                }
            } else {
                this.returnKeyType = null;
                this.returnCollectionType = null;
            }
        }

        public <O> O get(Object instance) {
            return (O)this.invoke(instance, new Object[0]);
        }

        public final Class getReturnType() {
            return this.returnType;
        }

        public final ParameterizedType getParameterParameterizedType() {
            return this.parameterParameterizedType;
        }

        public final Class getReturnKeyType() {
            return this.returnKeyType;
        }

        public final Class getReturnCollectionType() {
            return this.returnCollectionType;
        }
    }

    public static abstract class Accessor
    extends Invoker {
        private final String resourceName;

        protected Accessor(Class implementationClass, String resourceName, Method method) {
            super(implementationClass, method);
            this.resourceName = resourceName;
        }

        public final String getResourceName() {
            return this.resourceName;
        }
    }

    public static final class Accessors {
        private final String resourceName;
        private final Getter getter;
        private final Setter setter;

        public Accessors(String resourceName, Getter getter, Setter setter) {
            this.resourceName = resourceName;
            this.getter = getter;
            this.setter = setter;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public Getter getGetter() {
            return this.getter;
        }

        public Setter getSetter() {
            return this.setter;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            boolean result = false;
            if (this.getter != null) {
                result |= this.getter.isAnnotationPresent(annotationClass);
            }
            if (this.setter != null) {
                result |= this.setter.isAnnotationPresent(annotationClass);
            }
            return result;
        }

        public final <A extends Annotation> A getAnnotation(Class<? extends A> annotationClass) {
            A result = null;
            if (this.getter != null) {
                result = this.getter.getAnnotation(annotationClass);
            }
            if (result == null && this.setter != null) {
                result = this.setter.getAnnotation(annotationClass);
            }
            return result;
        }

        public final <A extends Annotation> List<A> getAnnotations(Class<? extends A> annotationClass) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (this.getter != null) {
                result.addAll(this.getter.getAnnotations(annotationClass));
            }
            if (this.setter != null) {
                result.addAll(this.setter.getAnnotations(annotationClass));
            }
            return result;
        }

        public final Map<Class<? extends Annotation>, List<Annotation>> getAnnotationsMap() {
            HashMap<Class<? extends Annotation>, List<Annotation>> result = new HashMap<Class<? extends Annotation>, List<Annotation>>();
            if (this.getter != null) {
                result.putAll(this.getter.getAnnotationsMap());
            }
            if (this.setter != null) {
                result.putAll(this.setter.getAnnotationsMap());
            }
            return result;
        }
    }

    public static abstract class Invoker {
        private final Class implementationClass;
        private final Method method;
        private final Map<Class<? extends Annotation>, List<Annotation>> annotationsMap;
        private boolean containsPermission;

        public Invoker(Class implementationClass, Method method) {
            this.implementationClass = implementationClass;
            this.method = method;
            this.annotationsMap = new HashMap<Class<? extends Annotation>, List<Annotation>>();
            for (Annotation annotation : method.getAnnotations()) {
                Class<?> annotationClass = null;
                for (Class<?> interfaceClass : annotation.getClass().getInterfaces()) {
                    if (!Annotation.class.isAssignableFrom(interfaceClass)) continue;
                    annotationClass = interfaceClass;
                }
                List<Annotation> annotationList = this.annotationsMap.get(annotationClass);
                if (annotationList == null) {
                    annotationList = new ArrayList<Annotation>();
                    this.annotationsMap.put(annotationClass, annotationList);
                }
                annotationList.add(annotation);
                if (annotationClass.equals(Permission.class)) {
                    SecurityPermissions.publishPermission(implementationClass, ((Permission)annotation).value(), ((Permission)annotation).description(), List.of(((Permission)annotation).tags()));
                    this.containsPermission = true;
                    continue;
                }
                if (!annotationClass.equals(LazyPermission.class)) continue;
                SecurityPermissions.publishPermission(implementationClass, ((LazyPermission)annotation).value(), ((Permission)annotation).description(), List.of(((LazyPermission)annotation).tags()));
            }
        }

        public final Class getImplementationClass() {
            return this.implementationClass;
        }

        public final Method getMethod() {
            return this.method;
        }

        public final boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.annotationsMap.containsKey(annotationClass);
        }

        public final <A extends Annotation> A getAnnotation(Class<? extends A> annotationClass) {
            Annotation result = null;
            if (this.annotationsMap.containsKey(annotationClass)) {
                result = this.annotationsMap.get(annotationClass).get(0);
            }
            return (A)result;
        }

        public final <A extends Annotation> List<A> getAnnotations(Class<? extends A> annotationClass) {
            List<Object> result = new ArrayList();
            if (this.annotationsMap.containsKey(annotationClass)) {
                result = Collections.unmodifiableList(this.annotationsMap.get(annotationClass));
            }
            return result;
        }

        public final Map<Class<? extends Annotation>, List<Annotation>> getAnnotationsMap() {
            return Collections.unmodifiableMap(this.annotationsMap);
        }

        public Object invoke(Object instance, Object ... params) {
            if (this.containsPermission) {
                for (Permission permission : this.getAnnotations(Permission.class)) {
                    SecurityPermissions.checkPermission(instance.getClass(), permission.value());
                }
            }
            try {
                Object result = instance instanceof InvocationHandler ? ((InvocationHandler)instance).invoke(instance, this.method, params) : this.getMethod().invoke(instance, params);
                return result;
            }
            catch (Throwable throwable) {
                throw new HCJFRuntimeException("Layer invoker", throwable, new Object[0]);
            }
        }
    }
}

