/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils.bson;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hcjf.bson.BsonArray;
import org.hcjf.bson.BsonBinarySubType;
import org.hcjf.bson.BsonDocument;
import org.hcjf.bson.BsonElement;
import org.hcjf.bson.BsonPrimitive;
import org.hcjf.bson.BsonType;
import org.hcjf.layers.Layers;
import org.hcjf.utils.Introspection;
import org.hcjf.utils.bson.BsonCustomBuilderLayer;
import org.hcjf.utils.bson.BsonParcelableMap;

public interface BsonParcelable {
    public static final String MAP_KEYS_FIELD_NAME = "__K__";
    public static final String MAP_VALUES_FIELD_NAME = "__V__";
    public static final String PARCELABLE_CLASS_NAME = "__pcn__";

    default public BsonDocument toBson() {
        BsonDocument document = new BsonDocument();
        document.put(PARCELABLE_CLASS_NAME, (Object)this.getClass().getName());
        Map<String, Introspection.Accessors> accessorsMap = Introspection.getAccessors(this.getClass());
        for (Introspection.Accessors accessors : accessorsMap.values()) {
            try {
                Object value;
                Introspection.Getter getter = accessors.getGetter();
                if (getter == null || (value = getter.get(this)) == null) continue;
                document.put(this.toBson(accessors.getResourceName(), value));
            }
            catch (Exception exception) {}
        }
        return document;
    }

    default public BsonDocument toBson(String name, Map map) {
        BsonDocument document = new BsonDocument(name);
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) continue;
            keys.add(key);
            values.add(value);
        }
        document.put((BsonElement)this.toBson(MAP_KEYS_FIELD_NAME, keys));
        document.put((BsonElement)this.toBson(MAP_VALUES_FIELD_NAME, values));
        return document;
    }

    default public BsonArray toBson(String name, Collection collection) {
        BsonArray array = new BsonArray(name);
        for (Object value : collection) {
            array.add(this.toBson(null, value));
        }
        return array;
    }

    default public BsonElement toBson(String name, Object value) {
        BsonDocument result;
        block30: {
            if (BsonParcelable.class.isAssignableFrom(value.getClass())) {
                BsonDocument document = ((BsonParcelable)value).toBson();
                document.setName(name);
                result = document;
            } else if (Collection.class.isAssignableFrom(value.getClass())) {
                result = this.toBson(name, (Collection)value);
            } else if (Map.class.isAssignableFrom(value.getClass())) {
                result = this.toBson(name, (Map)value);
            } else if (byte[].class.equals(value.getClass())) {
                result = new BsonPrimitive(name, value);
            } else if (value.getClass().isArray()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    arrayList.add(Array.get(value, i));
                }
                result = this.toBson(name, arrayList);
            } else if (value.getClass().isEnum()) {
                result = new BsonPrimitive(name, (Object)value.toString());
            } else if (Class.class.equals(value.getClass())) {
                result = new BsonPrimitive(name, (Object)((Class)value).getName());
            } else if (BsonType.fromValue((Object)value) != null) {
                result = new BsonPrimitive(name, value);
            } else {
                if (Serializable.class.isAssignableFrom(value.getClass())) {
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                         ObjectOutputStream oos = new ObjectOutputStream(baos);){
                        oos.writeObject(value);
                        oos.flush();
                        result = new BsonPrimitive(name, (Object)baos.toByteArray());
                        break block30;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    default public <P extends BsonParcelable> P populate(BsonDocument document) {
        Map<String, Introspection.Accessors> accessorsMap = Introspection.getAccessors(this.getClass());
        for (Introspection.Accessors accessors : accessorsMap.values()) {
            try {
                BsonElement element;
                Introspection.Setter setter = accessors.getSetter();
                if (setter == null || (element = document.get(accessors.getResourceName())) == null) continue;
                setter.set(this, this.fromBson(setter.getParameterType(), setter.getParameterKeyType(), setter.getParameterCollectionType(), element));
            }
            catch (Exception exception) {}
        }
        return (P)this;
    }

    default public Map fromBson(Class expectedKeyType, Class expectedValueType, BsonDocument document) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (document.hasElement(MAP_KEYS_FIELD_NAME)) {
            BsonArray keys = document.get(MAP_KEYS_FIELD_NAME).getAsArray();
            BsonArray values = document.get(MAP_VALUES_FIELD_NAME).getAsArray();
            for (int i = 0; i < keys.size(); ++i) {
                Object key = this.fromBson(expectedKeyType, null, null, keys.get(Integer.valueOf(i)));
                Object value = this.fromBson(expectedValueType, null, null, values.get(Integer.valueOf(i)));
                result.put(key, value);
            }
        } else {
            for (String key : document) {
                result.put(key, this.fromBson(null, null, null, document.get(key)));
            }
        }
        return result;
    }

    default public Collection fromBson(Class expectedCollectionType, BsonArray array) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            result.add(this.fromBson(expectedCollectionType, null, null, array.get(Integer.valueOf(i))));
        }
        return result;
    }

    default public Object fromBson(Class expectedDataType, Class keyType, Class collectionDataType, BsonElement element) {
        Object result;
        if (BsonParcelable.class.isAssignableFrom(expectedDataType = this.typeFromBson(expectedDataType, element)) && element instanceof BsonDocument) {
            result = Builder.create((BsonDocument)element);
        } else if (Collection.class.isAssignableFrom(expectedDataType) && element instanceof BsonArray) {
            result = this.fromBson(collectionDataType, (BsonArray)element);
        } else if (expectedDataType.isArray() && element instanceof BsonArray) {
            Collection collection = this.fromBson(expectedDataType.getComponentType(), (BsonArray)element);
            result = collection.toArray((Object[])Array.newInstance(expectedDataType.getComponentType(), collection.size()));
        } else if (Map.class.isAssignableFrom(expectedDataType) && element instanceof BsonDocument) {
            result = this.fromBson(keyType, collectionDataType, (BsonDocument)element);
        } else if (expectedDataType.isEnum() && element instanceof BsonPrimitive) {
            result = Enum.valueOf(expectedDataType, element.getAsString());
        } else {
            if (expectedDataType.equals(Class.class) && element instanceof BsonPrimitive) {
                try {
                    result = Class.forName(element.getAsString());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException();
                }
            }
            if (byte[].class.equals((Object)expectedDataType)) {
                result = byte[].class.equals(element.getValue().getClass()) ? element.getValue() : (ByteBuffer.class.isAssignableFrom(element.getValue().getClass()) ? (Object)((ByteBuffer)element.getValue()).array() : element.getValue());
            } else if (Serializable.class.isAssignableFrom(expectedDataType) && !UUID.class.isAssignableFrom(expectedDataType) && element instanceof BsonPrimitive && ((BsonPrimitive)element).getType().equals((Object)BsonType.BINARY)) {
                try (ByteArrayInputStream bais = new ByteArrayInputStream(element.getAsBytes());
                     ObjectInputStream ois = new ObjectInputStream(bais);){
                    result = ois.readObject();
                }
                catch (Exception ex) {
                    result = element.getValue();
                }
            } else {
                result = element.getValue();
            }
        }
        return result;
    }

    default public Class typeFromBson(Class expectedType, BsonElement element) {
        Class result = expectedType;
        if (result == null || result.equals(Object.class)) {
            if (element instanceof BsonArray) {
                result = Collection.class;
            } else if (element instanceof BsonDocument) {
                if (((BsonDocument)element).hasElement(PARCELABLE_CLASS_NAME)) {
                    try {
                        result = Class.forName(((BsonDocument)element).get(PARCELABLE_CLASS_NAME).getAsString());
                    }
                    catch (Exception ex) {
                        result = Map.class;
                    }
                } else {
                    result = Map.class;
                }
            } else {
                BsonType type = ((BsonPrimitive)element).getType();
                if (type.equals((Object)BsonType.DATE)) {
                    result = Date.class;
                } else if (type.equals((Object)BsonType.BOOLEAN)) {
                    result = Boolean.class;
                } else if (type.equals((Object)BsonType.DOUBLE)) {
                    result = Double.class;
                } else if (type.equals((Object)BsonType.INTEGER)) {
                    result = Integer.class;
                } else if (type.equals((Object)BsonType.LONG)) {
                    result = Long.class;
                } else if (type.equals((Object)BsonType.STRING)) {
                    result = String.class;
                } else if (type.equals((Object)BsonType.BINARY)) {
                    BsonBinarySubType subType = ((BsonPrimitive)element).getBinarySubType();
                    if (subType.equals((Object)BsonBinarySubType.UUID)) {
                        result = UUID.class;
                    } else if (subType.equals((Object)BsonBinarySubType.GENERIC)) {
                        result = byte[].class;
                    }
                }
            }
        }
        return result;
    }

    public static final class Builder {
        public static <P extends BsonParcelable> P create(BsonDocument document) {
            BsonParcelable result;
            String className = document.get(BsonParcelable.PARCELABLE_CLASS_NAME).getAsString();
            try {
                try {
                    result = (BsonParcelable)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    try {
                        BsonCustomBuilderLayer bsonCustomBuilderLayer = Layers.get(BsonCustomBuilderLayer.class, className);
                        result = bsonCustomBuilderLayer.create(document);
                    }
                    catch (Exception ex) {
                        result = new BsonParcelableMap();
                    }
                }
                result.populate(document);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to create parcelable instance: " + className, ex);
            }
            return (P)result;
        }
    }
}

