/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.hcjf.cloud.CloudServiceImpl;
import org.hcjf.cloud.cache.CloudCache;
import org.hcjf.cloud.cache.CloudCacheStrategy;
import org.hcjf.cloud.counter.Counter;
import org.hcjf.cloud.impl.LockImpl;
import org.hcjf.cloud.impl.MapImpl;
import org.hcjf.cloud.impl.QueueImpl;
import org.hcjf.cloud.impl.network.CloudOrchestrator;
import org.hcjf.events.DistributedEvent;
import org.hcjf.layers.Layer;
import org.hcjf.layers.LayerInterface;

public class DefaultCloudServiceImpl
implements CloudServiceImpl {
    private final Map<String, Map> mapInstances = new HashMap<String, Map>();
    private final Map<String, Queue> queueInstances = new HashMap<String, Queue>();
    private final Map<String, Lock> lockInstances = new HashMap<String, Lock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> Map<K, V> getMap(String mapName) {
        MapImpl result;
        Map<String, Map> map = this.mapInstances;
        synchronized (map) {
            result = this.mapInstances.get(mapName);
            if (result == null) {
                result = new MapImpl(mapName);
                this.mapInstances.put(mapName, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> Queue<V> getQueue(String queueName) {
        QueueImpl result;
        Map<String, Queue> map = this.queueInstances;
        synchronized (map) {
            result = this.queueInstances.get(queueName);
            if (result == null) {
                result = new QueueImpl(queueName);
                this.queueInstances.put(queueName, result);
            }
        }
        return result;
    }

    @Override
    public <V> Set<V> getSet(String setName) {
        return null;
    }

    @Override
    public Counter getCounter(String counterName) {
        return null;
    }

    @Override
    public void lock(String resourceName) throws InterruptedException {
        this.getLock(resourceName).lock();
    }

    @Override
    public void unlock(String resourceName) throws InterruptedException {
        this.getLock(resourceName).unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getLock(String lockName) {
        Lock result;
        Map<String, Lock> map = this.lockInstances;
        synchronized (map) {
            result = this.lockInstances.get(lockName);
            if (result == null) {
                result = new LockImpl(lockName);
                this.lockInstances.put(lockName, result);
            }
        }
        return result;
    }

    @Override
    public Condition getCondition(String conditionName, Lock lock) {
        return ((LockImpl)lock).newCondition(conditionName);
    }

    @Override
    public void createCache(String cacheName, Set<CloudCacheStrategy> strategies) {
    }

    @Override
    public CloudCache getCache(String cacheName) {
        return null;
    }

    @Override
    public void dispatchEvent(DistributedEvent event) {
        CloudOrchestrator.getInstance().dispatchEvent(event);
    }

    @Override
    public void publishDistributedLayer(Class<? extends LayerInterface> layerClass, String implName, String regex) {
        CloudOrchestrator.getInstance().publishDistributedLayer(regex, Layer.class.getName(), layerClass.getName(), implName);
    }

    @Override
    public boolean isLayerPublished(Class<? extends LayerInterface> layerClass, String implName) {
        return CloudOrchestrator.getInstance().isDistributedLayerPublished(Layer.class.getName(), layerClass.getName(), implName);
    }

    @Override
    public String getRegexFromDistributedLayer(Class<? extends LayerInterface> layerClass, String implName) {
        return CloudOrchestrator.getInstance().getRegexFromDistributedLayer(Layer.class.getName(), layerClass.getName(), implName);
    }

    @Override
    public void publishPlugin(byte[] jarFile) {
        CloudOrchestrator.getInstance().publishPlugin(jarFile);
    }

    @Override
    public <O> O layerInvoke(Class<? extends LayerInterface> layerClass, String implName, Method method, Object ... parameters) {
        return CloudOrchestrator.getInstance().layerInvoke(parameters, method, Layer.class.getName(), layerClass.getName(), implName);
    }

    @Override
    public void publishMe() {
        CloudOrchestrator.getInstance().publishMe();
    }

    @Override
    public void forkWorker(Map<String, Object> workerConfig) {
    }

    @Override
    public void shutdown() {
    }
}

