/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.impl.network;

import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.models.V1Service;
import io.kubernetes.client.models.V1ServicePort;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.hcjf.cloud.Cloud;
import org.hcjf.cloud.impl.LockImpl;
import org.hcjf.cloud.impl.messages.AckMessage;
import org.hcjf.cloud.impl.messages.BusyNodeMessage;
import org.hcjf.cloud.impl.messages.EventMessage;
import org.hcjf.cloud.impl.messages.HidePathMessage;
import org.hcjf.cloud.impl.messages.InvokeMessage;
import org.hcjf.cloud.impl.messages.LayerInvokeMessage;
import org.hcjf.cloud.impl.messages.LockMessage;
import org.hcjf.cloud.impl.messages.NodeIdentificationMessage;
import org.hcjf.cloud.impl.messages.PublishLayerMessage;
import org.hcjf.cloud.impl.messages.PublishObjectMessage;
import org.hcjf.cloud.impl.messages.PublishPathMessage;
import org.hcjf.cloud.impl.messages.PublishPluginMessage;
import org.hcjf.cloud.impl.messages.ServiceDefinitionMessage;
import org.hcjf.cloud.impl.messages.ServiceDefinitionResponseMessage;
import org.hcjf.cloud.impl.messages.SignalAllMessage;
import org.hcjf.cloud.impl.messages.SignalMessage;
import org.hcjf.cloud.impl.messages.TestNodeMessage;
import org.hcjf.cloud.impl.messages.UnlockMessage;
import org.hcjf.cloud.impl.network.CloudBroadcastConsumer;
import org.hcjf.cloud.impl.network.CloudClient;
import org.hcjf.cloud.impl.network.CloudServer;
import org.hcjf.cloud.impl.network.CloudSession;
import org.hcjf.cloud.impl.network.NetworkComponent;
import org.hcjf.cloud.impl.network.Node;
import org.hcjf.cloud.impl.network.ServiceEndPoint;
import org.hcjf.cloud.impl.objects.DistributedLayer;
import org.hcjf.cloud.impl.objects.DistributedLock;
import org.hcjf.cloud.impl.objects.DistributedTree;
import org.hcjf.cloud.impl.objects.LocalLeaf;
import org.hcjf.cloud.impl.objects.RemoteLeaf;
import org.hcjf.errors.HCJFRemoteException;
import org.hcjf.errors.HCJFRemoteInvocationTimeoutException;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.events.DistributedEvent;
import org.hcjf.events.Events;
import org.hcjf.events.RemoteEvent;
import org.hcjf.events.StoreStrategyLayerInterface;
import org.hcjf.io.net.NetService;
import org.hcjf.io.net.NetServiceConsumer;
import org.hcjf.io.net.broadcast.BroadcastService;
import org.hcjf.io.net.kubernetes.KubernetesSpy;
import org.hcjf.io.net.kubernetes.KubernetesSpyConsumer;
import org.hcjf.io.net.messages.Message;
import org.hcjf.io.net.messages.MessageCollection;
import org.hcjf.io.net.messages.NetUtils;
import org.hcjf.io.net.messages.ResponseMessage;
import org.hcjf.layers.Layer;
import org.hcjf.layers.Layers;
import org.hcjf.layers.crud.ReadRowsLayerInterface;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.Queryable;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;
import org.hcjf.utils.Introspection;
import org.hcjf.utils.JsonUtils;

public final class CloudOrchestrator
extends Service<NetworkComponent> {
    public static final CloudOrchestrator instance = new CloudOrchestrator();
    private Node thisNode;
    private Map<String, Object> thisNodeMap;
    private Map<UUID, Node> nodes;
    private Map<String, Node> nodesByLanId;
    private Map<String, Node> nodesByWanId;
    private Set<Node> sortedNodes;
    private Map<UUID, Node> waitingAck;
    private Map<UUID, ResponseListener> responseListeners;
    private ServiceEndPoint thisServiceEndPoint;
    private Map<String, Object> thisServiceEndPointMap;
    private Map<UUID, ServiceEndPoint> endPoints;
    private Map<String, ServiceEndPoint> endPointsByGatewayId;
    private Object publishMeMonitor;
    private Object wagonMonitor;
    private Long lastVisit;
    private Long lastServicePublication;
    private Map<String, List<Message>> wagonLoad;
    private CloudServer server;
    private DistributedTree sharedStore;
    private Random random;

    private CloudOrchestrator() {
        super(SystemProperties.get("hcjf.cloud.orchestrator.name"), SystemProperties.getInteger("hcjf.cloud.orchestrator.service.priority"));
    }

    public static CloudOrchestrator getInstance() {
        return instance;
    }

    @Override
    protected void init() {
        this.nodes = new HashMap<UUID, Node>();
        this.nodesByLanId = new HashMap<String, Node>();
        this.nodesByWanId = new HashMap<String, Node>();
        this.sortedNodes = new TreeSet<Node>();
        this.waitingAck = new HashMap<UUID, Node>();
        this.responseListeners = new HashMap<UUID, ResponseListener>();
        this.thisNode = new Node();
        UUID thisNodeId = SystemProperties.getUUID("hcjf.cloud.orchestrator.this.node.id");
        if (thisNodeId == null) {
            thisNodeId = UUID.randomUUID();
        }
        this.thisNode.setId(thisNodeId);
        this.thisNode.setDataCenterName(SystemProperties.get("hcjf.cloud.orchestrator.this.node.data.center.name"));
        this.thisNode.setClusterName(SystemProperties.get("hcjf.cloud.orchestrator.this.node.cluster.name"));
        this.thisNode.setName(SystemProperties.get("hcjf.cloud.orchestrator.this.node.name"));
        this.thisNode.setVersion(SystemProperties.get("hcjf.cloud.orchestrator.this.node.version"));
        this.thisNode.setLanAddress(SystemProperties.get("hcjf.cloud.orchestrator.this.node.lan.address"));
        this.thisNode.setLanPort(SystemProperties.getInteger("hcjf.cloud.orchestrator.this.node.lan.port"));
        if (SystemProperties.get("hcjf.cloud.orchestrator.this.node.wan.address") != null) {
            this.thisNode.setWanAddress(SystemProperties.get("hcjf.cloud.orchestrator.this.node.wan.address"));
            this.thisNode.setWanPort(SystemProperties.getInteger("hcjf.cloud.orchestrator.this.node.wan.port"));
        }
        this.thisNode.setStartupDate(new Date());
        this.thisNode.setStatus(Node.Status.CONNECTED);
        this.thisNode.setLocalNode(true);
        this.sortedNodes.add(this.thisNode);
        this.thisServiceEndPoint = new ServiceEndPoint();
        UUID thisServiceEndPointId = SystemProperties.getUUID("hcjf.cloud.orchestrator.this.service.end.point.id");
        if (thisServiceEndPointId == null) {
            thisServiceEndPointId = UUID.randomUUID();
        }
        this.thisServiceEndPoint.setId(thisServiceEndPointId);
        this.thisServiceEndPoint.setName(SystemProperties.get("hcjf.cloud.orchestrator.this.service.end.point.name"));
        this.thisServiceEndPoint.setGatewayAddress(SystemProperties.get("hcjf.cloud.orchestrator.this.service.end.point.gateway.address"));
        this.thisServiceEndPoint.setGatewayPort(SystemProperties.getInteger("hcjf.cloud.orchestrator.this.service.end.point.gateway.port"));
        this.thisServiceEndPoint.setDistributedEventListener(SystemProperties.getBoolean("hcjf.cloud.orchestrator.this.service.end.point.distributed.event.listener"));
        this.endPoints = new HashMap<UUID, ServiceEndPoint>();
        this.endPointsByGatewayId = new HashMap<String, ServiceEndPoint>();
        this.publishMeMonitor = new Object();
        this.wagonMonitor = new Object();
        this.lastVisit = System.currentTimeMillis();
        this.lastServicePublication = System.currentTimeMillis() - SystemProperties.getLong("hcjf.cloud.orchestrator.this.service.end.point.publication.timeout");
        this.wagonLoad = new HashMap<String, List<Message>>();
        this.random = new Random();
        this.sharedStore = new DistributedTree("");
        this.server = new CloudServer();
        this.server.start();
        try {
            for (Node node : SystemProperties.getObjects("hcjf.cloud.orchestrator.nodes", Node.class)) {
                this.registerConsumer(node);
            }
        }
        catch (Exception ex) {
            Log.w(System.getProperty("hcjf.cloud.log.tag"), "Load nodes from properties fail", ex, new Object[0]);
        }
        try {
            for (ServiceEndPoint serviceEndPoint : SystemProperties.getObjects("hcjf.cloud.orchestrator.service.end.points", ServiceEndPoint.class)) {
                this.registerConsumer(serviceEndPoint);
            }
        }
        catch (Exception ex) {
            Log.w(System.getProperty("hcjf.cloud.log.tag"), "Load service end points from properties fail", ex, new Object[0]);
        }
        if (SystemProperties.getBoolean("hcjf.cloud.orchestrator.broadcast.enabled").booleanValue()) {
            CloudBroadcastConsumer broadcastConsumer = new CloudBroadcastConsumer();
            BroadcastService.getInstance().registerConsumer(broadcastConsumer);
        }
        if (SystemProperties.getBoolean("hcjf.cloud.orchestrator.kubernetes.enabled").booleanValue()) {
            this.thisNode.setId(new UUID((NetUtils.getLocalIp() + Node.class.getName()).hashCode(), KubernetesSpy.getHostName().hashCode()));
            this.thisServiceEndPoint.setId(new UUID(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.namespace").hashCode(), SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.service.name").hashCode()));
            this.thisServiceEndPoint.setName(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.service.name"));
            Log.d(System.getProperty("hcjf.cloud.log.tag"), "Kubernetes service id %s", this.thisServiceEndPoint.getId());
            Log.d(System.getProperty("hcjf.cloud.log.tag"), "Kubernetes node id %s", this.thisNode.getId());
            Log.d(System.getProperty("hcjf.cloud.log.tag"), "Local IP %s", NetUtils.getLocalIp());
            this.thisNode.setLanAddress(NetUtils.getLocalIp());
            this.thisServiceEndPoint.setGatewayAddress(NetUtils.getLocalIp());
            Log.d(System.getProperty("hcjf.cloud.log.tag"), "Kubernetes consumer starting", new Object[0]);
            Log.d(System.getProperty("hcjf.cloud.log.tag"), "Kubernetes pod labels: %s", SystemProperties.getMap("hcjf.cloud.orchestrator.kubernetes.pod.labels").toString());
            Log.d(System.getProperty("hcjf.cloud.log.tag"), "Kubernetes service labels: %s", SystemProperties.getMap("hcjf.cloud.orchestrator.kubernetes.service.labels").toString());
            KubernetesSpy.getInstance().registerConsumer(new KubernetesSpyConsumer(pod -> {
                Map<String, String> expectedLabels = SystemProperties.getMap("hcjf.cloud.orchestrator.kubernetes.pod.labels");
                Map labels = pod.getMetadata().getLabels();
                return SystemProperties.getList("hcjf.cloud.orchestrator.kubernetes.allow.phases").contains(pod.getStatus().getPhase()) && this.verifyLabels(expectedLabels, labels);
            }, service -> {
                Map<String, String> expectedLabels = SystemProperties.getMap("hcjf.cloud.orchestrator.kubernetes.service.labels");
                Map labels = service.getMetadata().getLabels();
                return this.verifyLabels(expectedLabels, labels);
            }){
                private final Map<String, Node> nodesByPodId;
                {
                    this.nodesByPodId = new HashMap<String, Node>();
                }

                @Override
                protected void onPodDiscovery(V1Pod pod) {
                    Log.d(System.getProperty("hcjf.cloud.log.tag"), "Kubernetes pod discovery: %s", pod.getMetadata().getUid());
                    Node node = new Node();
                    node.setLanAddress(pod.getStatus().getPodIP());
                    node.setLanPort(SystemProperties.getInteger("hcjf.cloud.orchestrator.this.node.lan.port"));
                    CloudOrchestrator.this.registerConsumer(node);
                    this.nodesByPodId.put(pod.getMetadata().getUid(), node);
                }

                @Override
                protected void onPodLost(V1Pod pod) {
                    Log.d(System.getProperty("hcjf.cloud.log.tag"), "Kubernetes pod lost: %s", pod.getMetadata().getUid());
                    CloudOrchestrator.this.unregisterConsumer(this.nodesByPodId.remove(pod.getMetadata().getUid()));
                }

                @Override
                protected void onServiceDiscovery(V1Service service) {
                    Log.d(System.getProperty("hcjf.cloud.log.tag"), "Kubernetes service discovery: %s", service.getMetadata().getUid());
                    ServiceEndPoint serviceEndPoint = new ServiceEndPoint();
                    serviceEndPoint.setId(new UUID(service.getMetadata().getNamespace().hashCode(), service.getMetadata().getName().hashCode()));
                    serviceEndPoint.setGatewayAddress(service.getMetadata().getName());
                    for (V1ServicePort port : service.getSpec().getPorts()) {
                        if (!port.getName().equals(SystemProperties.get("hcjf.cloud.orchestrator.kubernetes.service.port.name"))) continue;
                        serviceEndPoint.setGatewayPort(port.getPort());
                        break;
                    }
                    CloudOrchestrator.this.registerConsumer(serviceEndPoint);
                }

                @Override
                protected void onServiceLost(V1Service service) {
                    ServiceEndPoint serviceEndPoint = new ServiceEndPoint();
                    serviceEndPoint.setId(new UUID(service.getMetadata().getNamespace().hashCode(), service.getMetadata().getName().hashCode()));
                    CloudOrchestrator.this.unregisterConsumer(serviceEndPoint);
                }
            });
        }
    }

    private synchronized Map<String, Object> getThisNodeMap() {
        if (this.thisNodeMap == null) {
            this.thisNodeMap = Introspection.toMap(this.thisNode);
        }
        return this.thisNodeMap;
    }

    private synchronized Map<String, Object> getThisServiceEndPointMap() {
        if (this.thisServiceEndPointMap == null) {
            this.thisServiceEndPointMap = Introspection.toMap(this.thisServiceEndPoint);
        }
        return this.thisServiceEndPointMap;
    }

    private synchronized Map<String, Object> getOriginData() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("node", this.getThisNodeMap());
        result.put("service", this.getThisServiceEndPointMap());
        return result;
    }

    public boolean verifyLabels(Map<String, String> expectedLabels, Map<String, String> labels) {
        boolean result = true;
        for (String labelKey : expectedLabels.keySet()) {
            if (labels.containsKey(labelKey) && labels.get(labelKey).equals(expectedLabels.get(labelKey))) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public void registerConsumer(NetworkComponent networkComponent) {
        ServiceEndPoint endPoint;
        Objects.requireNonNull(networkComponent, "Unable to register a null component");
        if (networkComponent instanceof Node) {
            Node node = (Node)networkComponent;
            String lanId = node.getLanId();
            String wanId = node.getWanId();
            if (lanId != null || wanId != null) {
                boolean add = true;
                if (lanId != null && (this.thisNode.getLanId().equalsIgnoreCase(lanId) || this.nodesByLanId.containsKey(lanId))) {
                    add = false;
                }
                if (wanId != null && (this.thisNode.getWanId().equalsIgnoreCase(wanId) || this.nodesByWanId.containsKey(wanId))) {
                    add = false;
                }
                if (add) {
                    node.setStatus(Node.Status.DISCONNECTED);
                    if (lanId != null) {
                        this.nodesByLanId.put(lanId, node);
                        node.setId(new UUID(0L, lanId.hashCode()));
                    }
                    if (wanId != null) {
                        this.nodesByWanId.put(wanId, node);
                    }
                    this.nodes.put(node.getId(), node);
                    this.sortedNodes.add(node);
                    Log.d(System.getProperty("hcjf.cloud.log.tag"), "New node registered: %s", node);
                }
            }
        } else if (networkComponent instanceof ServiceEndPoint && (endPoint = (ServiceEndPoint)networkComponent).getGatewayAddress() != null && !this.thisServiceEndPoint.getGatewayId().equals(endPoint.getGatewayId()) && !this.endPointsByGatewayId.containsKey(endPoint.getGatewayId())) {
            this.endPoints.put(endPoint.getId(), endPoint);
            this.endPointsByGatewayId.put(endPoint.getGatewayId(), endPoint);
            Log.d(System.getProperty("hcjf.cloud.log.tag"), "New service end point registered: %s", endPoint);
            this.fork(() -> this.initServicePublication(endPoint));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServicePublication(ServiceEndPoint serviceEndPoint) {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                block14: {
                    Collection<Message> messages = this.createServicePublicationCollection();
                    ServiceDefinitionMessage serviceDefinitionMessage = new ServiceDefinitionMessage();
                    serviceDefinitionMessage.setId(UUID.randomUUID());
                    serviceDefinitionMessage.setMessages(messages);
                    serviceDefinitionMessage.setServiceId(this.thisServiceEndPoint.getId());
                    serviceDefinitionMessage.setServiceName(this.thisServiceEndPoint.getName());
                    serviceDefinitionMessage.setEventListener(this.thisServiceEndPoint.isDistributedEventListener());
                    serviceDefinitionMessage.setBroadcasting(true);
                    Log.d(System.getProperty("hcjf.cloud.log.tag"), "Sending interfaces to: %s", serviceEndPoint);
                    try {
                        Object responseObject = this.invokeNetworkComponent(serviceEndPoint, serviceDefinitionMessage);
                        if (responseObject == null) break block14;
                        ServiceDefinitionResponseMessage definitionResponse = (ServiceDefinitionResponseMessage)responseObject;
                        this.fork(() -> {
                            if (definitionResponse.getMessages() != null) {
                                for (Message innerMessage : definitionResponse.getMessages()) {
                                    try {
                                        this.processMessage(null, innerMessage);
                                    }
                                    catch (Exception ex) {
                                        Log.w(System.getProperty("hcjf.cloud.log.tag"), "Unable to process one message of the service publication collection: %s", innerMessage.getClass().toString());
                                    }
                                }
                            }
                        });
                        try {
                            this.endPoints.get(definitionResponse.getServiceId()).setName(definitionResponse.getServiceName());
                            this.endPoints.get(definitionResponse.getServiceId()).setDistributedEventListener(definitionResponse.getEventListener());
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception ex) {
                        Log.w(System.getProperty("hcjf.cloud.log.tag"), "Unable to publish the service: %s", ex, serviceEndPoint);
                        try {
                            Thread.sleep(SystemProperties.getLong("hcjf.cloud.orchestrator.this.service.end.point.publication.timeout"));
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
                Object object = this.publishMeMonitor;
                synchronized (object) {
                    try {
                        this.publishMeMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception ex) {
                Log.w(System.getProperty("hcjf.cloud.log.tag"), "Fail to trying publish the service", ex, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void publishMe() {
        Object object = this.publishMeMonitor;
        synchronized (object) {
            this.publishMeMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConsumer(NetworkComponent networkComponent) {
        if (networkComponent instanceof Node) {
            Map<UUID, Node> map = this.nodes;
            synchronized (map) {
                Node node = (Node)networkComponent;
                String lanId = node.getLanId();
                String wanId = node.getWanId();
                this.nodesByLanId.remove(lanId);
                this.nodesByWanId.remove(wanId);
                this.nodes.remove(node.getId());
                for (Node sortedNode : this.sortedNodes) {
                    try {
                        if (!sortedNode.getLanId().equals(node.getLanId()) && !sortedNode.getId().equals(node.getId())) continue;
                        this.sortedNodes.remove(sortedNode);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private List<Node> getSortedNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        boolean insert = false;
        for (Node node : this.sortedNodes) {
            if (node.equals(this.thisNode)) {
                insert = true;
                continue;
            }
            if (insert) {
                nodes.add(0, node);
                continue;
            }
            nodes.add(node);
        }
        return nodes;
    }

    private Collection<Message> createServicePublicationCollection() {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (DistributedTree.Entry entry : this.sharedStore.filter(LocalLeaf.class)) {
            LocalLeaf localLeaf = (LocalLeaf)entry.getValue();
            Object[] path = entry.getPath();
            if (!(localLeaf.getInstance() instanceof DistributedLayer)) continue;
            PublishLayerMessage publishLayerMessage = new PublishLayerMessage(UUID.randomUUID());
            publishLayerMessage.setPath(path);
            publishLayerMessage.setRegex(((DistributedLayer)localLeaf.getInstance()).getRegex());
            publishLayerMessage.setServiceEndPointId(this.thisServiceEndPoint.getId());
            messages.add(publishLayerMessage);
        }
        return messages;
    }

    public void incomingMessage(CloudSession session, Message message) {
        String from = "unknown";
        if (message.getOriginData() != null) {
            from = JsonUtils.toJsonTree(message.getOriginData()).toString();
        }
        Log.d(System.getProperty("hcjf.cloud.log.tag"), "Incoming '%s' message from '%s': %s", message.getClass(), from, message.getId());
        Message responseMessage = null;
        if (message instanceof ServiceDefinitionMessage) {
            try {
                ServiceDefinitionResponseMessage serviceDefinitionResponseMessage = new ServiceDefinitionResponseMessage();
                serviceDefinitionResponseMessage.setId(UUID.randomUUID());
                serviceDefinitionResponseMessage.setMessages(this.createServicePublicationCollection());
                serviceDefinitionResponseMessage.setServiceId(this.thisServiceEndPoint.getId());
                serviceDefinitionResponseMessage.setServiceName(this.thisServiceEndPoint.getName());
                serviceDefinitionResponseMessage.setEventListener(this.thisServiceEndPoint.isDistributedEventListener());
                serviceDefinitionResponseMessage.setBroadcasting(true);
                ResponseMessage definitionResponse = new ResponseMessage(message);
                definitionResponse.setValue(serviceDefinitionResponseMessage);
                responseMessage = definitionResponse;
            }
            catch (Exception ex) {
                Log.w(System.getProperty("hcjf.cloud.log.tag"), "Unable to create publication response message", ex, new Object[0]);
            }
            try {
                ServiceDefinitionMessage serviceDefinitionMessage = (ServiceDefinitionMessage)message;
                this.fork(() -> {
                    if (serviceDefinitionMessage.getMessages() != null) {
                        for (Message innerMessage : serviceDefinitionMessage.getMessages()) {
                            try {
                                this.processMessage(session, innerMessage);
                            }
                            catch (Exception ex) {
                                Log.w(System.getProperty("hcjf.cloud.log.tag"), "Unable to process one message of the service publication collection: %s", innerMessage.getClass().toString());
                            }
                        }
                    }
                });
                try {
                    this.endPoints.get(((ServiceDefinitionMessage)message).getServiceId()).setName(((ServiceDefinitionMessage)message).getServiceName());
                    this.endPoints.get(((ServiceDefinitionMessage)message).getServiceId()).setDistributedEventListener(((ServiceDefinitionMessage)message).getEventListener());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (SystemProperties.getBoolean("hcjf.cloud.orchestrator.service.publication.broadcasting.enabled").booleanValue()) {
                    this.fork(() -> {
                        if (serviceDefinitionMessage.getBroadcasting() != null && serviceDefinitionMessage.getBroadcasting().booleanValue()) {
                            serviceDefinitionMessage.setBroadcasting(false);
                            for (Node node : this.nodes.values()) {
                                try {
                                    this.invokeNetworkComponent(node, serviceDefinitionMessage, SystemProperties.getLong("hcjf.cloud.orchestrator.service.publication.broadcasting.timeout"));
                                }
                                catch (Exception ex) {
                                    Log.w(System.getProperty("hcjf.cloud.log.tag"), "Unable to notify node: %s", node.toString());
                                }
                            }
                        }
                    });
                }
            }
            catch (Exception ex) {
                Log.w(System.getProperty("hcjf.cloud.log.tag"), "Exception processing publication message: %s", ex, message.getId().toString());
            }
        } else if (message instanceof MessageCollection) {
            MessageCollection collection = (MessageCollection)message;
            for (Message innerMessage : collection.getMessages()) {
                this.processMessage(session, innerMessage);
            }
        } else {
            responseMessage = this.processMessage(session, message);
        }
        if (!(message instanceof ResponseMessage)) {
            if (responseMessage == null) {
                responseMessage = new ResponseMessage(message);
            }
            Log.d(System.getProperty("hcjf.cloud.log.tag"), "Sending response message: %s", message.getId());
            this.sendResponse(session, responseMessage);
        }
    }

    private Message processMessage(CloudSession session, Message message) {
        Message responseMessage = null;
        if (message instanceof NodeIdentificationMessage) {
            NodeIdentificationMessage nodeIdentificationMessage = (NodeIdentificationMessage)message;
            Node node = this.nodesByLanId.get(nodeIdentificationMessage.getNode().getLanId());
            if (node == null) {
                node = this.nodesByWanId.get(nodeIdentificationMessage.getNode().getWanId());
            }
            if (node == null && Objects.equals(nodeIdentificationMessage.getNode().getClusterName(), this.thisNode.getClusterName())) {
                this.registerConsumer(nodeIdentificationMessage.getNode());
                node = this.nodesByLanId.get(nodeIdentificationMessage.getNode().getLanId());
                if (node == null) {
                    node = this.nodesByWanId.get(nodeIdentificationMessage.getNode().getWanId());
                }
            }
            if (node != null) {
                this.updateNode(node, nodeIdentificationMessage);
                if (session.getConsumer() instanceof CloudClient) {
                    Log.d(System.getProperty("hcjf.cloud.log.tag"), "Incoming credentials response from %s:%d", node.getLanAddress(), node.getLanPort());
                    if (!this.connected(node)) {
                        ((CloudClient)session.getConsumer()).disconnect();
                    } else {
                        Log.d(System.getProperty("hcjf.cloud.log.tag"), "Node connected as client %s", node);
                        Log.d(System.getProperty("hcjf.cloud.log.tag"), "Ack sent to %s:%d", node.getLanAddress(), node.getLanPort());
                        responseMessage = new AckMessage(message);
                    }
                } else if (session.getConsumer() instanceof CloudServer) {
                    if (this.connecting(node)) {
                        Log.d(System.getProperty("hcjf.cloud.log.tag"), "Incoming credentials from %s:%d", node.getLanAddress(), node.getLanPort());
                        Log.d(System.getProperty("hcjf.cloud.log.tag"), "Response credentials to %s:%d", node.getLanAddress(), node.getLanPort());
                        NodeIdentificationMessage returnNodeIdentificationMessage = new NodeIdentificationMessage(this.thisNode);
                        this.waitingAck.put(returnNodeIdentificationMessage.getId(), node);
                        responseMessage = returnNodeIdentificationMessage;
                    } else {
                        try {
                            ((CloudServer)session.getConsumer()).send(session, new BusyNodeMessage(this.thisNode));
                        }
                        catch (IOException returnNodeIdentificationMessage) {}
                    }
                }
            } else {
                this.server.destroySession(session);
            }
        } else if (message instanceof BusyNodeMessage) {
            BusyNodeMessage busyNodeMessage = (BusyNodeMessage)message;
            Node node = this.nodesByLanId.get(busyNodeMessage.getNode().getLanId());
            if (node == null) {
                node = this.nodesByWanId.get(busyNodeMessage.getNode().getWanId());
            }
            if (session.getConsumer() instanceof CloudClient) {
                this.disconnected(node);
                ((CloudClient)session.getConsumer()).disconnect();
            }
        } else if (message instanceof HidePathMessage) {
            this.removePath(((HidePathMessage)message).getPath());
        } else if (message instanceof PublishPathMessage) {
            this.addPath(((PublishPathMessage)message).getPath());
        } else if (message instanceof PublishObjectMessage) {
            PublishObjectMessage publishObjectMessage = (PublishObjectMessage)message;
            for (PublishObjectMessage.Path path : publishObjectMessage.getPaths()) {
                if (path.getValue() != null) {
                    this.addLocalObject(path.getValue(), path.getNodes(), List.of(), publishObjectMessage.getTimestamp(), path.getPath());
                    continue;
                }
                this.addRemoteObject(null, path.getNodes(), path.getNodes(), publishObjectMessage.getTimestamp(), path.getPath());
            }
        } else if (message instanceof InvokeMessage) {
            InvokeMessage invokeMessage = (InvokeMessage)message;
            responseMessage = new ResponseMessage(invokeMessage);
            Object object = this.sharedStore.getInstance(invokeMessage.getPath());
            responseMessage.setValue(object);
        } else if (message instanceof LockMessage) {
            LockMessage lockMessage = (LockMessage)message;
            responseMessage = new ResponseMessage(lockMessage);
            responseMessage.setValue(this.distributedLock(lockMessage.getTimestamp(), lockMessage.getNanos(), lockMessage.getPath()));
        } else if (message instanceof UnlockMessage) {
            UnlockMessage unlockMessage = (UnlockMessage)message;
            this.distributedUnlock(unlockMessage.getPath());
        } else if (message instanceof SignalMessage) {
            SignalMessage signalMessage = (SignalMessage)message;
            this.distributedSignal(signalMessage.getLockName(), signalMessage.getConditionName());
        } else if (message instanceof SignalAllMessage) {
            SignalAllMessage signalAllMessage = (SignalAllMessage)message;
            this.distributedSignalAll(signalAllMessage.getLockName(), signalAllMessage.getConditionName());
        } else if (message instanceof EventMessage) {
            EventMessage eventMessage = (EventMessage)message;
            this.distributedDispatchEvent(eventMessage.getEvent(), eventMessage.getSessionBean(), eventMessage.getSessionId());
            responseMessage = new ResponseMessage(eventMessage);
            responseMessage.setValue(true);
        } else if (message instanceof PublishLayerMessage) {
            PublishLayerMessage publishLayerMessage = (PublishLayerMessage)message;
            responseMessage = new ResponseMessage(publishLayerMessage);
            try {
                boolean localImpl = false;
                Object[] path = publishLayerMessage.getPath();
                Class<?> layerInterfaceClass = Class.forName((String)path[path.length - 2]);
                String implName = (String)path[path.length - 1];
                try {
                    Layers.get(layerInterfaceClass, implName);
                    localImpl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!localImpl) {
                    DistributedLayer distributedLayer = this.getDistributedLayer(false, publishLayerMessage.getPath());
                    distributedLayer.setRegex(publishLayerMessage.getRegex());
                    distributedLayer.addServiceEndPoint(publishLayerMessage.getServiceEndPointId());
                    Log.d(System.getProperty("hcjf.cloud.log.tag"), "Remote %s layer founded %s in %s", layerInterfaceClass.getName(), implName, this.endPoints.get(publishLayerMessage.getServiceEndPointId()).getGatewayAddress());
                }
                responseMessage.setValue(true);
                try {
                    Layers.get(layerInterfaceClass, implName);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception ex) {
                responseMessage.setThrowable(ex);
            }
        } else if (message instanceof PublishPluginMessage) {
            PublishPluginMessage publishPluginMessage = (PublishPluginMessage)message;
            Layers.publishPlugin(ByteBuffer.wrap(publishPluginMessage.getJarFile()));
        } else if (message instanceof LayerInvokeMessage) {
            LayerInvokeMessage layerInvokeMessage = (LayerInvokeMessage)message;
            Object result = null;
            Throwable throwable = null;
            try {
                result = this.distributedLayerInvoke(layerInvokeMessage.getSessionId(), layerInvokeMessage.getSessionBean(), layerInvokeMessage.getParameterTypes(), layerInvokeMessage.getParameters(), layerInvokeMessage.getMethodName(), layerInvokeMessage.getPath());
            }
            catch (Throwable t) {
                throwable = t;
            }
            responseMessage = new ResponseMessage(message);
            responseMessage.setValue(result);
            responseMessage.setThrowable(throwable);
        } else if (message instanceof TestNodeMessage) {
            responseMessage = new ResponseMessage(message);
        } else if (message instanceof ResponseMessage) {
            ResponseListener responseListener = this.responseListeners.get(message.getId());
            if (responseListener != null) {
                responseListener.setMessage((ResponseMessage)message);
                if (message instanceof ServiceDefinitionResponseMessage) {
                    for (Message innerMessage : ((ServiceDefinitionResponseMessage)message).getMessages()) {
                        this.processMessage(session, innerMessage);
                    }
                }
            } else {
                Log.d(System.getProperty("hcjf.cloud.log.tag"), "Response listener not found: %s", message.getId());
            }
        } else if (message instanceof AckMessage) {
            Node node;
            Log.d(System.getProperty("hcjf.cloud.log.tag"), "Incoming ack from %s:%d", session.getRemoteHost(), session.getRemotePort());
            if (session.getConsumer() instanceof CloudServer && (node = this.waitingAck.remove(message.getId())) != null && this.connected(node)) {
                Log.d(System.getProperty("hcjf.cloud.log.tag"), "Node connected as server %s", node);
            }
        }
        return responseMessage;
    }

    private void nodeBroadcasting(Message message) {
        ArrayList<Node> nodeList = new ArrayList<Node>(this.nodesByLanId.values());
        for (Node node : nodeList) {
            try {
                this.fork(() -> this.invokeNetworkComponent(node, message));
            }
            catch (Exception exception) {}
        }
    }

    private void sendResponse(CloudSession session, Message message) {
        try {
            NetServiceConsumer consumer = session.getConsumer();
            if (consumer instanceof CloudClient) {
                ((CloudClient)consumer).send(message);
            } else {
                ((CloudServer)consumer).send(session, message);
            }
        }
        catch (IOException e) {
            this.server.destroySession(session);
        }
    }

    private Object invokeNetworkComponent(NetworkComponent networkComponent, Message message) {
        return this.invokeNetworkComponent(networkComponent, message, SystemProperties.getLong("hcjf.cloud.orchestrator.invokeNode.timeout"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeNetworkComponent(NetworkComponent networkComponent, Message message, Long timeout) {
        Object result;
        block14: {
            if (message.getId() == null) {
                message.setId(UUID.randomUUID());
            }
            message = this.populateOriginData(message);
            if (networkComponent != null) {
                CloudClient client;
                try {
                    String host = networkComponent instanceof ServiceEndPoint ? ((ServiceEndPoint)networkComponent).getGatewayAddress() : ((Node)networkComponent).getLanAddress();
                    Integer port = networkComponent instanceof ServiceEndPoint ? ((ServiceEndPoint)networkComponent).getGatewayPort() : ((Node)networkComponent).getLanPort();
                    client = new CloudClient(host, port);
                    NetService.getInstance().registerConsumer(client);
                }
                catch (Exception ex) {
                    throw new HCJFRuntimeException("Unable to connect with service: " + networkComponent.getName(), (Throwable)ex, new Object[0]);
                }
                try {
                    if (client.waitForConnect()) {
                        ResponseListener responseListener = new ResponseListener(timeout);
                        this.registerListener(message, responseListener);
                        try {
                            Log.d(System.getProperty("hcjf.cloud.log.tag"), "Sending to %s invoke service message: '%s' %s", networkComponent.getName(), message.getClass().getName(), message.getId().toString());
                            client.send(message);
                        }
                        catch (Exception ex) {
                            throw new HCJFRuntimeException("Unable to send message to %s", (Throwable)ex, networkComponent.getName());
                        }
                        result = responseListener.getResponse(message);
                        break block14;
                    }
                    throw new HCJFRuntimeException("Connection timeout with service: %s", networkComponent.getName());
                }
                finally {
                    try {
                        client.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
            throw new HCJFRuntimeException("Service end point not found (" + networkComponent.getId() + ")", new Object[0]);
        }
        return result;
    }

    private Message populateOriginData(Message message) {
        if (message instanceof MessageCollection) {
            for (Message innerMessage : ((MessageCollection)message).getMessages()) {
                this.populateOriginData(innerMessage);
            }
        }
        message.setOriginData(this.getOriginData());
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListener(Message message, ResponseListener listener) {
        Map<UUID, ResponseListener> map = this.responseListeners;
        synchronized (map) {
            while (this.responseListeners.containsKey(message.getId())) {
                Log.d(System.getProperty("hcjf.cloud.log.tag"), "Message id crash!! %s", message.getId());
                message.setId(UUID.randomUUID());
            }
            this.responseListeners.put(message.getId(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DistributedLock getDistributedLock(Object ... path) {
        DistributedLock distributedLock;
        DistributedTree distributedTree = this.sharedStore;
        synchronized (distributedTree) {
            distributedLock = (DistributedLock)this.sharedStore.getInstance(path);
            if (distributedLock == null) {
                distributedLock = new DistributedLock();
                distributedLock.setStatus(DistributedLock.Status.UNLOCKED);
                this.addLocalObject(distributedLock, List.of(this.thisNode.getId()), List.of(), System.currentTimeMillis(), path);
            }
        }
        return distributedLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object ... path) {
        DistributedLock distributedLock;
        DistributedLock distributedLock2 = distributedLock = this.getDistributedLock(path);
        synchronized (distributedLock2) {
            while (!distributedLock.getStatus().equals((Object)DistributedLock.Status.UNLOCKED)) {
                try {
                    distributedLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            distributedLock.setStatus(DistributedLock.Status.LOCKING);
        }
        LockMessage lockMessage = new LockMessage(UUID.randomUUID());
        lockMessage.setPath(path);
        lockMessage.setTimestamp(distributedLock.getTimestamp());
        while (!distributedLock.getStatus().equals((Object)DistributedLock.Status.LOCKED)) {
            lockMessage.setNanos(distributedLock.getNanos());
            boolean locked = true;
            ArrayList<Node> nodeList = new ArrayList<Node>(this.nodesByLanId.values());
            for (Node node : nodeList) {
                try {
                    if (locked &= ((Boolean)this.invokeNetworkComponent(node, lockMessage)).booleanValue()) continue;
                    break;
                }
                catch (Exception ex) {
                    Log.w(System.getProperty("hcjf.cloud.log.tag"), "Unable to send lock message to session: ", node.getId());
                }
            }
            if (locked) {
                distributedLock.setStatus(DistributedLock.Status.LOCKED);
                continue;
            }
            distributedLock.setStatus(DistributedLock.Status.WAITING);
            try {
                DistributedLock distributedLock3 = distributedLock;
                synchronized (distributedLock3) {
                    distributedLock.wait(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean distributedLock(Long timestamp, Long nanos, Object ... path) {
        boolean result;
        DistributedLock distributedLock;
        DistributedLock distributedLock2 = distributedLock = this.getDistributedLock(path);
        synchronized (distributedLock2) {
            result = distributedLock.getStatus().equals((Object)DistributedLock.Status.UNLOCKED) || distributedLock.getTimestamp() > timestamp && distributedLock.getNanos() > nanos;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Object ... path) {
        DistributedLock distributedLock;
        DistributedLock distributedLock2 = distributedLock = this.getDistributedLock(path);
        synchronized (distributedLock2) {
            distributedLock.setStatus(DistributedLock.Status.UNLOCKED);
            distributedLock.notifyAll();
        }
        UnlockMessage unlockMessage = new UnlockMessage(UUID.randomUUID());
        unlockMessage.setPath(path);
        this.nodeBroadcasting(unlockMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void distributedUnlock(Object ... path) {
        DistributedLock distributedLock;
        DistributedLock distributedLock2 = distributedLock = this.getDistributedLock(path);
        synchronized (distributedLock2) {
            distributedLock.notifyAll();
        }
    }

    public void signal(String lockName, String conditionName) {
        SignalMessage signalMessage = new SignalMessage(UUID.randomUUID());
        signalMessage.setLockName(lockName);
        signalMessage.setConditionName(conditionName);
        this.nodeBroadcasting(signalMessage);
    }

    private void distributedSignal(String lockName, String conditionName) {
        LockImpl lock = (LockImpl)Cloud.getLock(lockName);
        if (lock != null) {
            ((LockImpl.ConditionImpl)lock.newCondition(conditionName)).distributedSignal();
        }
    }

    public void signalAll(String lockName, String conditionName) {
        SignalAllMessage signalAllMessage = new SignalAllMessage(UUID.randomUUID());
        signalAllMessage.setLockName(lockName);
        signalAllMessage.setConditionName(conditionName);
        this.nodeBroadcasting(signalAllMessage);
    }

    private void distributedSignalAll(String lockName, String conditionName) {
        LockImpl lock = (LockImpl)Cloud.getLock(lockName);
        if (lock != null) {
            ((LockImpl.ConditionImpl)lock.newCondition(conditionName)).distributedSignalAll();
        }
    }

    public void dispatchEvent(DistributedEvent event) {
        for (ServiceEndPoint serviceEndPoint : this.endPoints.values()) {
            if (this.thisServiceEndPoint.getId().equals(serviceEndPoint.getId()) || !serviceEndPoint.isDistributedEventListener().booleanValue()) continue;
            CloudOrchestrator.run(() -> {
                Integer attempts = SystemProperties.getInteger("hcjf.cloud.orchestrator.events.attempts");
                Long sleepTime = SystemProperties.getLong("hcjf.cloud.orchestrator.events.sleep.period.between.attempts");
                Boolean success = false;
                for (int i = 1; i <= attempts; ++i) {
                    try {
                        EventMessage eventMessage = new EventMessage(UUID.randomUUID());
                        eventMessage.setSessionId(((ServiceSession)ServiceSession.getCurrentIdentity()).getId());
                        eventMessage.setSessionBean(((ServiceSession)ServiceSession.getCurrentIdentity()).getBody());
                        eventMessage.setEvent(event);
                        Log.i(System.getProperty("hcjf.cloud.orchestrator.events.log.tag"), "Sending event to %s, attempt %d", serviceEndPoint.toString(), i);
                        this.invokeNetworkComponent(serviceEndPoint, eventMessage);
                        success = true;
                        break;
                    }
                    catch (Exception ex) {
                        Log.w(System.getProperty("hcjf.cloud.orchestrator.events.log.tag"), "Couldn't dispatch event %s, attempt %d", ex, serviceEndPoint.toString(), i);
                        try {
                            Thread.sleep(sleepTime);
                            continue;
                        }
                        catch (Exception ex2) {
                            break;
                        }
                    }
                }
                if (!success.booleanValue()) {
                    try {
                        StoreStrategyLayerInterface storeStrategyLayerInterface = Layers.get(StoreStrategyLayerInterface.class, SystemProperties.get("hcjf.cloud.orchestrator.events.store.strategy"));
                        storeStrategyLayerInterface.storeEvent(event);
                        Log.i(System.getProperty("hcjf.cloud.orchestrator.events.log.tag"), "Event stored", new Object[0]);
                    }
                    catch (Exception ex) {
                        Log.w(System.getProperty("hcjf.cloud.orchestrator.events.log.tag"), "Event discarded", new Object[0]);
                    }
                }
            }, ServiceSession.getCurrentIdentity());
        }
    }

    private void distributedDispatchEvent(DistributedEvent event, Map<String, Object> sessionBean, UUID sessionId) {
        Object newIdentity = sessionBean != null && !sessionBean.isEmpty() ? ServiceSession.findSession(sessionBean) : ServiceSession.findSession(sessionId);
        RemoteEvent remoteEvent = new RemoteEvent(event);
        ServiceSession.runAs(() -> Events.sendEvent(remoteEvent), newIdentity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DistributedLayer getDistributedLayer(boolean local, Object ... path) {
        DistributedLayer distributedLayer;
        DistributedTree distributedTree = this.sharedStore;
        synchronized (distributedTree) {
            distributedLayer = (DistributedLayer)this.sharedStore.getInstance(path);
            if (distributedLayer == null) {
                try {
                    distributedLayer = new DistributedLayer(Class.forName((String)path[path.length - 2]), (String)path[path.length - 1]);
                    if (local) {
                        this.addLocalObject(distributedLayer, List.of(this.thisNode.getId()), List.of(this.thisServiceEndPoint.getId()), System.currentTimeMillis(), path);
                    } else {
                        this.addRemoteObject(distributedLayer, List.of(), List.of(), System.currentTimeMillis(), path);
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new HCJFRuntimeException("Class not found, trying to create the distributed layer instance", (Throwable)ex, new Object[0]);
                }
            }
        }
        return distributedLayer;
    }

    public boolean isDistributedLayerPublished(Object ... path) {
        return this.sharedStore.getInstance(path) != null;
    }

    public String getRegexFromDistributedLayer(Object ... path) {
        String result = null;
        DistributedLayer distributedLayer = (DistributedLayer)this.sharedStore.getInstance(path);
        if (distributedLayer != null) {
            result = distributedLayer.getRegex();
        }
        return result;
    }

    public void publishDistributedLayer(String regex, Object ... path) {
        DistributedLayer distributedLayer = this.getDistributedLayer(true, path);
        distributedLayer.setRegex(regex);
    }

    public void publishPlugin(byte[] jarFile) {
        PublishPluginMessage publishPluginMessage = new PublishPluginMessage();
        publishPluginMessage.setJarFile(jarFile);
        publishPluginMessage.setId(UUID.randomUUID());
        publishPluginMessage.setSessionId(((ServiceSession)ServiceSession.getCurrentIdentity()).getId());
        this.nodeBroadcasting(publishPluginMessage);
    }

    public <O> O layerInvoke(Object[] parameters, Method method, Object ... path) {
        DistributedLayer distributedLayer = this.getDistributedLayer(false, path);
        LayerInvokeMessage layerInvokeMessage = new LayerInvokeMessage(UUID.randomUUID());
        layerInvokeMessage.setMethodName(method.getName());
        layerInvokeMessage.setParameterTypes(method.getParameterTypes());
        layerInvokeMessage.setSessionId(((ServiceSession)ServiceSession.getCurrentIdentity()).getId());
        layerInvokeMessage.setSessionBean(((ServiceSession)ServiceSession.getCurrentIdentity()).getBody());
        layerInvokeMessage.setParameters(parameters);
        layerInvokeMessage.setPath(path);
        UUID serviceEndPointId = distributedLayer.getServiceToInvoke();
        if (serviceEndPointId == null) {
            throw new HCJFRuntimeException("Route not found to the layer: " + distributedLayer.getLayerInterface().getName() + "@" + distributedLayer.getLayerName(), new Object[0]);
        }
        Object result = this.invokeNetworkComponent(this.endPoints.get(serviceEndPointId), layerInvokeMessage);
        return (O)result;
    }

    private Object distributedLayerInvoke(UUID sessionId, Map<String, Object> sessionBean, Class[] parameterTypes, Object[] parameters, String methodName, Object ... path) {
        Object result;
        DistributedLayer distributedLayer = this.getDistributedLayer(true, path);
        Class layerInterface = distributedLayer.getLayerInterface();
        Map<String, DistributedLayerInvoker> invokers = Introspection.getInvokers(layerInterface, new DistributedLayerInvokerFilter(methodName, parameterTypes));
        if (invokers.size() == 1) {
            Object layer = Layers.get(layerInterface, distributedLayer.getLayerName());
            try {
                Object newIdentity = sessionBean != null && !sessionBean.isEmpty() ? ServiceSession.findSession(sessionBean) : ServiceSession.findSession(sessionId);
                result = ServiceSession.callAs(() -> ((DistributedLayerInvoker)invokers.values().iterator().next()).invoke(layer, parameters), newIdentity);
            }
            catch (Exception ex) {
                throw new HCJFRuntimeException("Remote method invocation fail, %s", (Throwable)ex, methodName);
            }
        } else {
            throw new HCJFRuntimeException("Remote method signature not found, %s(%s)", new Object[]{methodName, parameterTypes});
        }
        return result;
    }

    private boolean connected(Node node) {
        Objects.requireNonNull(node, "Null node");
        return this.changeStatus(node, Node.Status.CONNECTED);
    }

    private boolean connecting(Node node) {
        Objects.requireNonNull(node, "Null node");
        return this.changeStatus(node, Node.Status.CONNECTING);
    }

    private boolean disconnected(Node node) {
        Objects.requireNonNull(node, "Null node");
        return this.changeStatus(node, Node.Status.DISCONNECTED);
    }

    private void updateNode(Node node, NodeIdentificationMessage message) {
        node.setId(message.getNode().getId());
        node.setClusterName(message.getNode().getClusterName());
        node.setDataCenterName(message.getNode().getDataCenterName());
        node.setName(message.getNode().getName());
        node.setVersion(message.getNode().getVersion());
        node.setStartupDate(message.getNode().getStartupDate());
        node.setLanAddress(message.getNode().getLanAddress());
        node.setLanPort(message.getNode().getLanPort());
        node.setWanAddress(message.getNode().getWanAddress());
        node.setWanPort(message.getNode().getWanPort());
    }

    private synchronized boolean changeStatus(Node node, Node.Status status) {
        boolean result = false;
        Node.Status currentStatus = node.getStatus();
        switch (currentStatus) {
            case CONNECTED: {
                if (!status.equals((Object)Node.Status.DISCONNECTED)) break;
                result = true;
                break;
            }
            case DISCONNECTED: {
                if (!status.equals((Object)Node.Status.CONNECTING) && !status.equals((Object)Node.Status.LOST)) break;
                result = true;
                break;
            }
            case CONNECTING: {
                if (!status.equals((Object)Node.Status.DISCONNECTED) && !status.equals((Object)Node.Status.CONNECTED)) break;
                result = true;
                break;
            }
            case LOST: {
                if (!status.equals((Object)Node.Status.DISCONNECTED) && !status.equals((Object)Node.Status.CONNECTING)) break;
                result = true;
            }
        }
        if (result) {
            node.setStatus(status);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishPath(Object ... path) {
        DistributedTree distributedTree = this.sharedStore;
        synchronized (distributedTree) {
            this.addPath(path);
            PublishPathMessage publishPathMessage = new PublishPathMessage();
            publishPathMessage.setPath(path);
            this.nodeBroadcasting(publishPathMessage);
        }
    }

    public void publishObject(Object object, Long timestamp, Object ... path) {
        ArrayList<UUID> nodeIds = new ArrayList<UUID>();
        nodeIds.add(this.thisNode.getId());
        List<Node> nodes = this.getSortedNodes();
        int replicationFactor = SystemProperties.getInteger("hcjf.cloud.orchestrator.replication.factor");
        for (int i = 0; i < replicationFactor - 1 && !nodes.isEmpty(); ++i) {
            nodeIds.add(nodes.get(i).getId());
        }
        this.addLocalObject(object, nodeIds, List.of(), timestamp, path);
        PublishObjectMessage.Path pathObject = new PublishObjectMessage.Path(path, nodeIds);
        this.fork(() -> {
            if (!nodes.isEmpty()) {
                int counter = 0;
                for (Node node : nodes) {
                    PublishObjectMessage publishObjectMessage = new PublishObjectMessage(UUID.randomUUID());
                    publishObjectMessage.getPaths().add(pathObject);
                    publishObjectMessage.setTimestamp(timestamp);
                    if (counter < replicationFactor) {
                        pathObject.setValue(object);
                    } else {
                        pathObject.setValue(null);
                    }
                    this.invokeNetworkComponent(node, publishObjectMessage);
                    ++counter;
                }
            }
        });
    }

    public void hidePath(Object ... path) {
        this.removePath(path);
        HidePathMessage hidePathMessage = new HidePathMessage(UUID.randomUUID());
        hidePathMessage.setPath(path);
        this.nodeBroadcasting(hidePathMessage);
    }

    public <O> O invokeNode(Object ... path) {
        Object result = this.sharedStore.getInstance(path);
        if (result instanceof RemoteLeaf) {
            InvokeMessage getMessage = new InvokeMessage(UUID.randomUUID());
            getMessage.setPath(path);
            Iterator<UUID> ids = ((RemoteLeaf)result).getNodes().iterator();
            Node node = null;
            while (ids.hasNext() && node == null) {
                node = this.nodes.get(ids.next());
            }
            result = node != null ? this.invokeNetworkComponent(node, getMessage) : null;
        }
        return (O)result;
    }

    private void removePath(Object ... path) {
        this.sharedStore.remove(path);
    }

    private boolean addPath(Object ... path) {
        boolean result = false;
        if (this.sharedStore.getInstance(path) == null) {
            this.sharedStore.createPath(path);
            Log.d(System.getProperty("hcjf.cloud.log.tag"), "Local path added: %s", Arrays.toString(path));
            result = true;
        }
        return result;
    }

    private void addLocalObject(Object object, List<UUID> nodes, List<UUID> serviceEndPoints, Long timestamp, Object ... path) {
        this.sharedStore.addLocalObject(object, nodes, serviceEndPoints, timestamp, path);
        Log.d(System.getProperty("hcjf.cloud.log.tag"), "Local leaf added: %s", Arrays.toString(path));
    }

    private void addRemoteObject(Object object, List<UUID> nodes, List<UUID> serviceEndPoints, Long timestamp, Object ... path) {
        this.sharedStore.addRemoteObject(object, nodes, serviceEndPoints, timestamp, path);
        Log.d(System.getProperty("hcjf.cloud.log.tag"), "Remote leaf added: %s", Arrays.toString(path));
    }

    private Collection<JoinableMap> getNodesAsJoinableMap() {
        ArrayList<JoinableMap> result = new ArrayList<JoinableMap>();
        ArrayList<Node> nodeList = new ArrayList<Node>(this.nodesByLanId.values());
        for (Node node : nodeList) {
            result.add(new JoinableMap(Introspection.toMap(node), new String[0]));
        }
        return result;
    }

    private Collection<JoinableMap> getServiceAsJoinableMap() {
        ArrayList<JoinableMap> result = new ArrayList<JoinableMap>();
        for (ServiceEndPoint serviceEndPoint : this.endPoints.values()) {
            result.add(new JoinableMap(Introspection.toMap(serviceEndPoint), new String[0]));
        }
        return result;
    }

    static {
        Layers.publishLayer(SystemCloudNodeReadableImplementation.class);
        Layers.publishLayer(SystemCloudServiceReadableImplementation.class);
    }

    public static final class SystemCloudServiceReadableImplementation
    extends Layer
    implements ReadRowsLayerInterface {
        public SystemCloudServiceReadableImplementation() {
            super(SystemProperties.get("hcjf.cloud.orchestrator.this.service.end.point.readable.layer.implementation.name"));
        }

        @Override
        public Collection<JoinableMap> readRows(Queryable queryable) {
            return queryable.evaluate(CloudOrchestrator.getInstance().getServiceAsJoinableMap());
        }
    }

    public static final class SystemCloudNodeReadableImplementation
    extends Layer
    implements ReadRowsLayerInterface {
        public SystemCloudNodeReadableImplementation() {
            super(SystemProperties.get("hcjf.cloud.orchestrator.this.node.readable.layer.implementation.name"));
        }

        @Override
        public Collection<JoinableMap> readRows(Queryable queryable) {
            return queryable.evaluate(CloudOrchestrator.getInstance().getNodesAsJoinableMap());
        }
    }

    private static enum ReorganizationAction {
        CONNECT,
        DISCONNECT,
        TIME;

    }

    private static final class DistributedLayerInvokerFilter
    implements Introspection.InvokerFilter<DistributedLayerInvoker> {
        private final String name;
        private final Class[] parameterTypes;
        private String hash;

        public DistributedLayerInvokerFilter(String name, Class[] parameterTypes) {
            this.name = name;
            this.parameterTypes = parameterTypes;
            this.hash = name;
            if (parameterTypes != null) {
                for (Class type : parameterTypes) {
                    this.hash = this.hash + type.getName();
                }
            }
        }

        @Override
        public Introspection.InvokerEntry<DistributedLayerInvoker> filter(Method method) {
            Introspection.InvokerEntry<DistributedLayerInvoker> result = null;
            if (method.getName().equalsIgnoreCase(this.name) && Arrays.equals(this.parameterTypes, method.getParameterTypes())) {
                result = new Introspection.InvokerEntry<DistributedLayerInvoker>(method.getName(), new DistributedLayerInvoker(method.getDeclaringClass(), method), new String[0]);
            }
            return result;
        }

        @Override
        public String getName() {
            return this.hash;
        }
    }

    private static final class DistributedLayerInvoker
    extends Introspection.Invoker {
        public DistributedLayerInvoker(Class implementationClass, Method method) {
            super(implementationClass, method);
        }
    }

    private final class ResponseListener {
        private final Long timeout;
        private ResponseMessage responseMessage;

        public ResponseListener(Long timeout) {
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getResponse(Message message) {
            ResponseListener responseListener = this;
            synchronized (responseListener) {
                if (this.responseMessage == null) {
                    Log.d(System.getProperty("hcjf.cloud.log.tag"), "Response listener waiting for id: %s", message.getId().toString());
                    try {
                        this.wait(this.timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.responseMessage != null) {
                if (this.responseMessage.getThrowable() != null) {
                    throw new HCJFRemoteException("Remote exception", this.responseMessage.getThrowable(), new Object[0]);
                }
            } else {
                throw new HCJFRemoteInvocationTimeoutException("Remote invocation timeout, message id: " + message.getId().toString(), new Object[0]);
            }
            Object result = this.responseMessage.getValue();
            CloudOrchestrator.this.responseListeners.remove(message.getId());
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMessage(ResponseMessage message) {
            ResponseListener responseListener = this;
            synchronized (responseListener) {
                Log.d(System.getProperty("hcjf.cloud.log.tag"), "Response listener notified with id: %s", message.getId().toString());
                this.responseMessage = message;
                this.notifyAll();
            }
        }
    }

    private static final class OriginDataFields {
        private static final String NODE = "node";
        private static final String SERVICE = "service";
        private static final String UNKNOWN = "unknown";

        private OriginDataFields() {
        }
    }
}

