/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.examples.salary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.examples.salary.ItemCalculator;
import org.hcjf.layers.Layer;
import org.hcjf.layers.Layers;
import org.hcjf.layers.crud.CreateLayerInterface;
import org.hcjf.layers.crud.ReadLayerInterface;
import org.hcjf.layers.crud.ReadRowsLayerInterface;
import org.hcjf.layers.distributed.DistributedLayerInterface;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.Queryable;
import org.hcjf.utils.Introspection;

public class SalaryResource
extends Layer
implements CreateLayerInterface<Map<String, Object>>,
ReadRowsLayerInterface,
DistributedLayerInterface {
    private Map<UUID, Map<String, Object>> db = new HashMap<UUID, Map<String, Object>>();
    public static final String SALUD = "salud";
    public static final String RETIRO = "retiro";

    @Override
    public String getImplName() {
        return "salary";
    }

    @Override
    public Map<String, Object> create(Map<String, Object> salary) {
        Double rawSalary;
        UUID employeeId = (UUID)Introspection.resolve(salary, "employeeId");
        ReadLayerInterface readLayerInterface = Layers.get(ReadLayerInterface.class, "employee");
        if (readLayerInterface.read(employeeId) == null) {
            throw new HCJFRuntimeException("Employee not found", new Object[0]);
        }
        Double totalSalary = rawSalary = Double.valueOf(((Number)Introspection.resolve(salary, "rawSalary")).doubleValue());
        List items = (List)Introspection.resolve(salary, "items");
        ArrayList newItems = new ArrayList();
        for (String item : items) {
            ItemCalculator calculator = Layers.get(ItemCalculator.class, item);
            calculator.calculate(salary, item);
        }
        UUID id = UUID.randomUUID();
        salary.put("items", newItems);
        salary.put("totalSalary", totalSalary);
        salary.put("date", new Date());
        salary.put("id", id);
        this.db.put(id, salary);
        return salary;
    }

    @Override
    public Collection<JoinableMap> readRows(Queryable queryable) {
        ArrayList result = new ArrayList();
        this.db.values().forEach(M -> result.add(new JoinableMap((Map<String, Object>)M, new String[0])));
        return queryable.evaluate(result);
    }
}

