/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.RequestBodyDecoderLayer;
import org.hcjf.layers.Layer;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;

public class FormUrlEncodedDecoder
extends Layer
implements RequestBodyDecoderLayer {
    public FormUrlEncodedDecoder() {
        super("application/x-www-form-urlencoded");
    }

    @Override
    public Map<String, Object> decode(HttpRequest request) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String[] params = new String(request.getBody()).split("&");
        String charset = null;
        HttpHeader contentType = request.getHeader("Content-Type");
        if (contentType != null) {
            charset = contentType.getParameter(contentType.getGroups().iterator().next(), "charset");
        }
        if (charset == null) {
            charset = SystemProperties.getDefaultCharset();
        }
        for (String param : params) {
            String value;
            String key;
            if (param.indexOf("=") < 0) {
                key = param;
                value = null;
            } else {
                String[] keyValue = param.split("=");
                key = keyValue[0];
                String string = value = keyValue.length == 2 ? keyValue[1] : null;
            }
            if (key.contains("[") && key.contains("]")) {
                ArrayList listParameter;
                int insertIndex = -1;
                if (key.indexOf("[") + 1 != key.indexOf("]")) {
                    insertIndex = Integer.parseInt(key.substring(key.indexOf("[") + 1, key.indexOf("]")));
                }
                key = key.substring(0, key.indexOf("["));
                if (parameters.containsKey(key)) {
                    listParameter = (ArrayList)parameters.get(key);
                } else {
                    listParameter = new ArrayList();
                    parameters.put(key, listParameter);
                }
                if (insertIndex >= 0) {
                    listParameter.add(insertIndex, value);
                    continue;
                }
                listParameter.add(value);
                continue;
            }
            try {
                parameters.put(URLDecoder.decode(key, charset), value == null ? null : URLDecoder.decode(value, charset));
            }
            catch (UnsupportedEncodingException e) {
                Log.w(SystemProperties.get("hcjf.net.http.server.log.tag"), "Unable to decode http parameter, %s:%s", key, value);
                parameters.put(key, value);
            }
        }
        return parameters;
    }
}

