/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query;

import java.util.ArrayList;
import java.util.Collection;
import org.hcjf.layers.Layers;
import org.hcjf.layers.crud.ReadRowsLayerInterface;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.evaluators.BaseEvaluator;
import org.hcjf.layers.query.functions.QueryAggregateFunctionLayerInterface;
import org.hcjf.layers.query.functions.QueryFunctionLayerInterface;
import org.hcjf.layers.query.model.QueryField;
import org.hcjf.layers.query.model.QueryFunction;
import org.hcjf.layers.query.model.QueryParameter;
import org.hcjf.layers.query.model.QueryReturnFunction;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.bson.BsonParcelable;

public interface Queryable
extends BsonParcelable {
    public String getResourceName();

    public <O> Collection<O> evaluate(Collection<O> var1);

    public <O> Collection<O> evaluate(Collection<O> var1, Consumer<O> var2);

    public <O> Collection<O> evaluate(DataSource<O> var1);

    public <O> Collection<O> evaluate(DataSource<O> var1, Consumer<O> var2);

    public static class ReadableDataSource
    implements DataSource<JoinableMap> {
        @Override
        public Collection<JoinableMap> getResourceData(Queryable queryable) {
            return Layers.get(ReadRowsLayerInterface.class, queryable.getResourceName()).readRows(queryable);
        }
    }

    public static class IntrospectionConsumer<O>
    extends DefaultConsumer<O> {
        @Override
        public <R> R get(O instance, QueryParameter queryParameter, DataSource<O> dataSource) {
            String result = null;
            if (queryParameter instanceof QueryField) {
                QueryField queryField = (QueryField)queryParameter;
                result = queryField.getFieldPath().equals(SystemProperties.get("hcjf.query.return.all.reserved.word")) ? SystemProperties.get("hcjf.query.return.all.reserved.word") : queryField.resolve(instance);
            } else if (queryParameter instanceof QueryFunction) {
                result = (String)this.resolveFunction((QueryFunction)queryParameter, instance, dataSource);
            }
            return (R)result;
        }

        @Override
        public <R> R getParameter(Integer place) {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class DefaultConsumer<O>
    implements Consumer<O> {
        @Override
        public <R> R resolveFunction(QueryFunction function, Object instance, DataSource<O> dataSource) {
            Object result;
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            for (int i = 0; i < function.getParameters().size(); ++i) {
                Exception value;
                Object currentParameter = function.getParameters().get(i);
                if (currentParameter == null) continue;
                if (currentParameter instanceof QueryFunction) {
                    if (function instanceof QueryReturnFunction && ((QueryReturnFunction)function).isAggregate()) {
                        parameterValues.add(currentParameter);
                        continue;
                    }
                    QueryFunction innerFunction = (QueryFunction)currentParameter;
                    try {
                        value = this.resolveFunction(innerFunction, instance, dataSource);
                    }
                    catch (Exception ex) {
                        value = ex;
                    }
                    parameterValues.add(value);
                    continue;
                }
                if (currentParameter instanceof QueryParameter) {
                    if (function instanceof QueryReturnFunction && ((QueryReturnFunction)function).isAggregate()) {
                        parameterValues.add(currentParameter);
                        continue;
                    }
                    value = this.get(instance, (QueryParameter)currentParameter, dataSource);
                    parameterValues.add(value);
                    continue;
                }
                if (currentParameter instanceof BaseEvaluator.UnprocessedValue) {
                    parameterValues.add(((BaseEvaluator.UnprocessedValue)currentParameter).process(dataSource, this));
                    continue;
                }
                parameterValues.add(currentParameter);
            }
            if (function instanceof QueryReturnFunction && ((QueryReturnFunction)function).isAggregate()) {
                QueryAggregateFunctionLayerInterface queryAggregateFunctionLayerInterface = Layers.get(QueryAggregateFunctionLayerInterface.class, SystemProperties.get("hcjf.query.function.name.prefix") + function.getFunctionName());
                String alias = ((QueryReturnFunction)function).getAlias() == null ? function.toString() : ((QueryReturnFunction)function).getAlias();
                result = queryAggregateFunctionLayerInterface.evaluate(alias, (Collection)instance, parameterValues.toArray());
            } else {
                QueryFunctionLayerInterface queryFunctionLayerInterface = Layers.get(QueryFunctionLayerInterface.class, SystemProperties.get("hcjf.query.function.name.prefix") + function.getFunctionName());
                result = queryFunctionLayerInterface.evaluate(function.getFunctionName(), parameterValues.toArray());
            }
            return (R)result;
        }
    }

    public static interface DataSource<O> {
        public Collection<O> getResourceData(Queryable var1);
    }

    public static interface Consumer<O> {
        public <R> R get(O var1, QueryParameter var2, DataSource<O> var3);

        public <R> R resolveFunction(QueryFunction var1, Object var2, DataSource<O> var3);

        public <R> R getParameter(Integer var1);
    }
}

