/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.evaluators;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.Queryable;
import org.hcjf.layers.query.evaluators.FieldEvaluator;

public class In
extends FieldEvaluator {
    public In(Object leftValue, Object rightValue) {
        super(leftValue, rightValue);
    }

    @Override
    public boolean evaluate(Object object, Queryable.DataSource dataSource, Queryable.Consumer consumer) {
        boolean result = false;
        try {
            Object leftValue = this.getProcessedLeftValue(object, dataSource, consumer);
            Object rightValue = this.getProcessedRightValue(object, dataSource, consumer);
            Collection<Object> collection = null;
            if (Map.class.isAssignableFrom(rightValue.getClass())) {
                collection = ((Map)rightValue).keySet();
            } else if (Collection.class.isAssignableFrom(rightValue.getClass())) {
                collection = (Collection)rightValue;
            } else if (rightValue.getClass().isArray()) {
                collection = Arrays.asList((Object[])rightValue);
            }
            if (collection == null) {
                result = leftValue instanceof Number ? this.numberEquals((Number)leftValue, rightValue) : leftValue.equals(rightValue);
            } else if (leftValue instanceof Number) {
                Object collectionItem;
                Iterator<Object> iterator = collection.iterator();
                while (iterator.hasNext() && !(result = this.numberEquals((Number)leftValue, collectionItem = iterator.next()))) {
                }
            } else {
                result = collection.contains(leftValue);
            }
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("In evaluator fail", (Throwable)ex, new Object[0]);
        }
        return result;
    }
}

