/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.hcjf.layers.query.functions.BaseQueryFunctionLayer;
import org.hcjf.layers.query.functions.QueryFunctionLayerInterface;
import org.hcjf.properties.SystemProperties;

public class ObjectQueryFunction
extends BaseQueryFunctionLayer
implements QueryFunctionLayerInterface {
    private static final String IS_NOT_NULL = "isNotNull";
    private static final String IS_NULL = "isNull";
    private static final String IS_COLLECTION = "isCollection";
    private static final String IS_MAP = "isMap";
    private static final String IS_DATE = "isDate";
    private static final String IS_STRING = "isString";
    private static final String IS_NUMBER = "isNumber";
    private static final String IF = "if";
    private static final String CASE = "case";
    private static final String EQUALS = "equals";
    private static final String NEW = "new";

    public ObjectQueryFunction() {
        super(SystemProperties.get("hcjf.query.function.object.name"));
        this.addFunctionName(IS_NOT_NULL);
        this.addFunctionName(IS_NULL);
        this.addFunctionName(IS_COLLECTION);
        this.addFunctionName(IS_MAP);
        this.addFunctionName(IS_DATE);
        this.addFunctionName(IS_STRING);
        this.addFunctionName(IS_NUMBER);
        this.addFunctionName(IF);
        this.addFunctionName(CASE);
        this.addFunctionName(EQUALS);
        this.addFunctionName(NEW);
    }

    @Override
    public Object evaluate(String functionName, Object ... parameters) {
        Object result = null;
        block13 : switch (functionName) {
            case "isNotNull": {
                boolean booleanValue = false;
                for (Object parameter : parameters) {
                    boolean bl = booleanValue = parameter != null;
                    if (!booleanValue) break;
                }
                result = booleanValue;
                break;
            }
            case "isNull": {
                boolean booleanValue = false;
                for (Object parameter : parameters) {
                    boolean bl = booleanValue = parameter == null;
                    if (booleanValue) break;
                }
                result = booleanValue;
                break;
            }
            case "if": {
                Boolean condition = (Boolean)this.getParameter(0, parameters);
                if (condition != null && condition.booleanValue()) {
                    result = this.getParameter(1, parameters);
                    break;
                }
                if (parameters.length != 3) break;
                result = this.getParameter(2, parameters);
                break;
            }
            case "case": {
                Object mainValue = this.getParameter(0, parameters);
                for (int i = 1; i < parameters.length; i += 2) {
                    if (i + 1 < parameters.length) {
                        if (!mainValue.equals(parameters[i])) continue;
                        result = parameters[i + 1];
                        break block13;
                    }
                    result = parameters[i];
                }
                break;
            }
            case "isCollection": {
                result = this.getParameter(0, parameters) != null && this.getParameter(0, parameters) instanceof Collection;
                break;
            }
            case "isMap": {
                result = this.getParameter(0, parameters) != null && this.getParameter(0, parameters) instanceof Map;
                break;
            }
            case "isDate": {
                result = this.getParameter(0, parameters) != null && this.getParameter(0, parameters) instanceof Date;
                break;
            }
            case "isString": {
                result = this.getParameter(0, parameters) != null && this.getParameter(0, parameters) instanceof String;
                break;
            }
            case "isNumber": {
                result = this.getParameter(0, parameters) != null && this.getParameter(0, parameters) instanceof Number;
                break;
            }
            case "equals": {
                Object parameter1 = this.getParameter(0, parameters);
                Object parameter2 = this.getParameter(1, parameters);
                if (parameter1 instanceof Number && parameter2 instanceof Number) {
                    BigDecimal bigDecimal1 = BigDecimal.valueOf(((Number)parameter1).doubleValue());
                    BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)parameter2).doubleValue());
                    result = bigDecimal1.equals(bigDecimal2);
                    break;
                }
                result = Objects.equals(parameter1, parameter2);
                break;
            }
            case "new": {
                result = this.getParameter(0, parameters);
            }
        }
        return result;
    }
}

