/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.scripting;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import jdk.jshell.JShell;
import org.hcjf.bson.BsonCollection;
import org.hcjf.bson.BsonDecoder;
import org.hcjf.bson.BsonDocument;
import org.hcjf.bson.BsonEncoder;
import org.hcjf.errors.HCJFServiceTimeoutException;
import org.hcjf.layers.Layer;
import org.hcjf.layers.scripting.CodeEvaluator;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;
import org.hcjf.utils.Strings;

public class JavaCodeEvaluator
extends Layer
implements CodeEvaluator {
    private static final String NAME = "java";
    private static final String CLASS_PATH_PROPERTY = "java.class.path";
    private static final String[] imports = new String[]{"import java.util.*;", "import org.hcjf.utils.*;", "import org.hcjf.bson.*;"};
    private static final String BSON_RESULT_VAR_NAME = "_bsonResult";
    private static final String CREATE_PARAMETERS_LINE = "Map<String,Object> parameters = new HashMap<>(parameters);";
    private static final String CREATE_RESULT_LINE = "Map<String,Object> result = new HashMap<>(parameters);";
    private static final String CREATE_BSON_RESULT_LINE = "String _bsonResult = \"\";";
    private static final String OVERRIDE_PARAMETERS_LINE = "parameters = BsonDecoder.decode(Strings.hexToBytes(\"%s\")).toMap();";
    private static final String OVERRIDE_RESULT_LINE = "result = new HashMap<>(parameters);";
    private static final String OVERRIDE_BSON_RESULT_LINE = "_bsonResult = Strings.bytesToHex(BsonEncoder.encode(new BsonDocument(result)));";
    private static final String OUT_FIELD = "_out";
    private static final String ERR_FIELD = "_error";
    private static final String WAITING_VM_TIME_FIELD = "_waitingVmTime";
    private static final String EVAL_TIME_FIELD = "_evalTime";
    private static final Integer DEFAULT_CACHE_SIZE = 1;
    private static final Long DEFAULT_EVAL_TIMEOUT = 5000L;
    private final Queue<JShellInstance> cache = new LinkedList<JShellInstance>();

    public JavaCodeEvaluator() {
        Integer size = SystemProperties.getInteger("hcjf.code.evaluator.java.cache.size", DEFAULT_CACHE_SIZE);
        for (int i = 0; i < size; ++i) {
            this.cache.offer(new JShellInstance());
        }
    }

    @Override
    public String getImplName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> evaluate(String script, Map<String, Object> parameters) {
        JShellInstance jShellInstance;
        Long waitingVmTime = System.currentTimeMillis();
        Queue<JShellInstance> queue = this.cache;
        synchronized (queue) {
            while (this.cache.isEmpty()) {
                try {
                    this.cache.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            jShellInstance = this.cache.remove();
            waitingVmTime = System.currentTimeMillis() - waitingVmTime;
        }
        Boolean killShell = false;
        Long timeout = SystemProperties.getLong("hcjf.code.evaluator.java.cache.timeout", DEFAULT_EVAL_TIMEOUT);
        try {
            Map result = Service.call(() -> jShellInstance.evaluate(script, parameters), ServiceSession.getCurrentIdentity(), timeout);
            result.put(WAITING_VM_TIME_FIELD, waitingVmTime);
            Map map = result;
            return map;
        }
        catch (HCJFServiceTimeoutException ex) {
            killShell = true;
            throw ex;
        }
        finally {
            Queue<JShellInstance> queue2 = this.cache;
            synchronized (queue2) {
                if (killShell.booleanValue()) {
                    jShellInstance.kill();
                    this.cache.offer(new JShellInstance());
                } else {
                    this.cache.offer(jShellInstance);
                }
                this.cache.notifyAll();
            }
        }
    }

    private static class JShellInstance {
        private JShell jShell;
        private ByteArrayOutputStream outStream;
        private ByteArrayOutputStream errorStream;
        private PrintStream out;
        private PrintStream error;

        public JShellInstance() {
            this.init();
        }

        public void init() {
            this.outStream = new ByteArrayOutputStream();
            this.out = new PrintStream(this.outStream);
            this.errorStream = new ByteArrayOutputStream();
            this.error = new PrintStream(this.errorStream);
            this.jShell = JShell.builder().out(this.out).err(this.error).build();
            this.jShell.addToClasspath(System.getProperty(JavaCodeEvaluator.CLASS_PATH_PROPERTY));
            for (String i : imports) {
                this.jShell.eval(i);
            }
            this.jShell.eval(JavaCodeEvaluator.CREATE_PARAMETERS_LINE);
            this.jShell.eval(JavaCodeEvaluator.CREATE_RESULT_LINE);
            this.jShell.eval(JavaCodeEvaluator.CREATE_BSON_RESULT_LINE);
        }

        public Map<String, Object> evaluate(String script, Map<String, Object> parameters) {
            Long time = System.currentTimeMillis();
            String bson = Strings.bytesToHex(BsonEncoder.encode((BsonCollection)new BsonDocument(parameters)));
            this.jShell.eval(String.format(JavaCodeEvaluator.OVERRIDE_PARAMETERS_LINE, bson));
            this.jShell.eval(JavaCodeEvaluator.OVERRIDE_RESULT_LINE);
            this.jShell.eval(script);
            this.jShell.eval(JavaCodeEvaluator.OVERRIDE_BSON_RESULT_LINE);
            String bsonResult = this.jShell.varValue(this.jShell.variables().filter(V -> V.name().equals(JavaCodeEvaluator.BSON_RESULT_VAR_NAME)).findFirst().get());
            bsonResult = bsonResult.replace("\"", "");
            Map result = BsonDecoder.decode((byte[])Strings.hexToBytes(bsonResult)).toMap();
            result.put(JavaCodeEvaluator.OUT_FIELD, this.outStream.toString());
            result.put(JavaCodeEvaluator.ERR_FIELD, this.errorStream.toString());
            result.put(JavaCodeEvaluator.EVAL_TIME_FIELD, System.currentTimeMillis() - time);
            this.outStream.reset();
            this.errorStream.reset();
            return result;
        }

        public void kill() {
            this.jShell.close();
            System.out.println();
        }
    }
}

