/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.properties;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import org.hcjf.cloud.impl.DefaultCloudServiceImpl;
import org.hcjf.layers.locale.DefaultLocaleLayer;
import org.hcjf.properties.IllegalPropertyValueException;
import org.hcjf.properties.PropertyValueValidator;

public final class SystemProperties
extends Properties {
    public static final String HCJF_DEFAULT_DATE_FORMAT = "hcjf.default.date.format";
    public static final String HCJF_DEFAULT_NUMBER_FORMAT = "hcjf.default.number.format";
    public static final String HCJF_DEFAULT_SCIENTIFIC_NUMBER_FORMAT = "hcjf.default.scientific.number.format";
    public static final String HCJF_DEFAULT_DECIMAL_SEPARATOR = "hcjf.default.decimal.separator";
    public static final String HCJF_DEFAULT_GROUPING_SEPARATOR = "hcjf.default.grouping.separator";
    public static final String HCJF_DEFAULT_PROPERTIES_FILE_PATH = "hcjf.default.properties.file.path";
    public static final String HCJF_DEFAULT_PROPERTIES_FILE_XML = "hcjf.default.properties.file.xml";
    public static final String HCJF_UUID_REGEX = "hcjf.uuid.regex";
    public static final String HCJF_INTEGER_NUMBER_REGEX = "hcjf.integer.number.regex";
    public static final String HCJF_DECIMAL_NUMBER_REGEX = "hcjf.decimal.number.regex";
    public static final String HCJF_SCIENTIFIC_NUMBER_REGEX = "hcjf.scientific.number.regex";
    public static final String HCJF_MATH_REGULAR_EXPRESSION = "hcjf.math.regular.expression";
    public static final String HCJF_MATH_CONNECTOR_REGULAR_EXPRESSION = "hcjf.math.connector.regular.expression";
    public static final String HCJF_MATH_SPLITTER_REGULAR_EXPRESSION = "hcjf.math.splitter.regular.expression";
    public static final String HCJF_DEFAULT_LRU_MAP_SIZE = "hcjf.default.lru.map.size";
    public static final String HCJF_DEFAULT_EXCEPTION_MESSAGE_TAG = "hcjf.default.exception.message.tag";
    public static final String FILE_ENCODING = "file.encoding";
    private static final SystemProperties instance = new SystemProperties();
    private final Map<String, Object> instancesCache = new HashMap<String, Object>();
    private final JsonParser jsonParser = new JsonParser();
    private final Gson gson = new Gson();

    private SystemProperties() {
        super(new Properties());
        this.defaults.put(HCJF_DEFAULT_DATE_FORMAT, "yyyy-MM-dd HH:mm:ss");
        this.defaults.put(HCJF_DEFAULT_NUMBER_FORMAT, "0.000");
        this.defaults.put(HCJF_DEFAULT_SCIENTIFIC_NUMBER_FORMAT, "0.00E00");
        this.defaults.put(HCJF_DEFAULT_DECIMAL_SEPARATOR, ".");
        this.defaults.put(HCJF_DEFAULT_GROUPING_SEPARATOR, ",");
        this.defaults.put(HCJF_DEFAULT_PROPERTIES_FILE_XML, "false");
        this.defaults.put(HCJF_UUID_REGEX, "^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
        this.defaults.put(HCJF_INTEGER_NUMBER_REGEX, "^[-]?[0-9]{1,}$");
        this.defaults.put(HCJF_DECIMAL_NUMBER_REGEX, "^[-]?[0-9,\\.]{0,}[0-9]{1,}$");
        this.defaults.put(HCJF_SCIENTIFIC_NUMBER_REGEX, "^[-]?[0-9,\\.]{0,}[0-9]{1,}E[-]?[0-9]{1,}$");
        this.defaults.put(HCJF_MATH_REGULAR_EXPRESSION, "^([\u00bf\\-+/*\\^%=<>!]?((\\d+(\\.\\d+)?)|([a-z A-Z \\(\\) $])))*");
        this.defaults.put(HCJF_MATH_CONNECTOR_REGULAR_EXPRESSION, ".*[+\\-*/%=<>!].*");
        this.defaults.put(HCJF_MATH_SPLITTER_REGULAR_EXPRESSION, "(?<=(\\+|\\-|\\*|/|%|=|>|<|<>|!=|>=|<=))|(?=(\\+|\\-|\\*|/|%|=|>|<|<>|!=|>=|<=))");
        this.defaults.put(HCJF_DEFAULT_LRU_MAP_SIZE, "1000");
        this.defaults.put(HCJF_DEFAULT_EXCEPTION_MESSAGE_TAG, "IMPL");
        this.defaults.put("hcjf.default.locale", java.util.Locale.getDefault().toLanguageTag());
        this.defaults.put("hcjf.default.locale.layer.implementation.name", DefaultLocaleLayer.class.getName());
        this.defaults.put("hcjf.default.locale.layer.implementation.class.name", DefaultLocaleLayer.class.getName());
        this.defaults.put("hcjf.locale.log.tag", "LOCALE");
        this.defaults.put("hcjf.layers.log.tag", "LAYER");
        this.defaults.put("hcjf.layers.readable.all.layer.implementation.name", "system_layer");
        this.defaults.put("hcjf.layers.readable.layer.implementation.name", "system_readable_layer");
        this.defaults.put("hcjf.layers.distributed.layer.enabled", "false");
        this.defaults.put("hcjf.service.static.thread.name", "StaticServiceThread");
        this.defaults.put("hcjf.service.static.thread.pool.core.size", "2");
        this.defaults.put("hcjf.service.static.thread.pool.max.size", "200");
        this.defaults.put("hcjf.service.static.thread.pool.keep.alive.time", "10");
        this.defaults.put("hcjf.service.thread.pool.core.size", "10");
        this.defaults.put("hcjf.service.thread.pool.max.size", "100");
        this.defaults.put("hcjf.service.thread.pool.keep.alive.time", "10");
        this.defaults.put("hcjf.service.guest.session.name", "Guest");
        this.defaults.put("hcjf.service.system.session.name", "System");
        this.defaults.put("hcjf.service.shutdown.time.out", "1000");
        this.defaults.put("hcjf.service.max.allocated.memory.expressed.in.percentage", "true");
        this.defaults.put("max.allocated.memory.exceeded.throws.exception", "false");
        this.defaults.put("max.allocated.memory.for.thread", "15");
        this.defaults.put("max.execution.time.for.thread", Long.toString(1410065408L));
        this.defaults.put("hcjf.event.log.tag", "EVENTS");
        this.defaults.put("hcjf.event.service.name", "Events");
        this.defaults.put("hcjf.event.service.priority", "0");
        this.defaults.put("hcjf.collector.service.name", "Collectors");
        this.defaults.put("hcjf.collector.service.priority", "0");
        this.defaults.put("hcjf.collector.log.tag", "COLLECTOR_SERVICE");
        this.defaults.put("hcjf.collector.flush.period", Long.toString(300000L));
        this.defaults.put("hcjf.collector.cloud.save.mode", "false");
        this.defaults.put("hcjf.collector.cloud.timer.task.name", "CollectorsFlushCycle");
        this.defaults.put("hcjf.code.evaluator.java.cache.size", "3");
        this.defaults.put("hcjf.code.evaluator.java.cache.timeout", "5000");
        this.defaults.put("hcjf.cryptography.key", "71324dccdb58966a04507b0fe2008632940b87c6dc5cea5f4bdf0d0089524c8e");
        this.defaults.put("hcjf.cryptography.algorithm", "AES");
        this.defaults.put("hcjf.cryptography.operation.mode", "GCM");
        this.defaults.put("hcjf.cryptography.padding.scheme", "PKCS5Padding");
        this.defaults.put("hcjf.cryptography.random.iv.size", "96");
        this.defaults.put("hcjf.cryptography.gcm.tag.bit.length", "128");
        this.defaults.put("hcjf.cryptography.aad", "HolandaCatalinaCrypt");
        this.defaults.put("hcjf.encoding.service.name", "EncodingService");
        this.defaults.put("hcjf.encoding.service.priority", "1");
        this.defaults.put("hcjf.file.system.service.name", "FileSystemWatcherService");
        this.defaults.put("hcjf.file.system.service.priority", "1");
        this.defaults.put("hcjf.file.system.log.tag", "FILE_SYSTEM_WATCHER_SERVICE");
        this.defaults.put("hcjf.log.service.name", "LogService");
        this.defaults.put("hcjf.log.service.priority", "0");
        this.defaults.put("hcjf.log.file.prefix", "hcjf");
        this.defaults.put("hcjf.log.error.file", "false");
        this.defaults.put("hcjf.log.warning.file", "false");
        this.defaults.put("hcjf.log.info.file", "false");
        this.defaults.put("hcjf.log.debug.file", "false");
        this.defaults.put("hcjf.log.level", "1");
        this.defaults.put("hcjf.log.date.format", "yyyy-MM-dd HH:mm:ss,SSS");
        this.defaults.put("hcjf.log.consumers", "[]");
        this.defaults.put("hcjf.log.system.out.enabled", "false");
        this.defaults.put("hcjf.log.java.standard.logger.enabled", "false");
        this.defaults.put("hcjf.log.queue.initial.size", "10000");
        this.defaults.put("hcjf.log.truncate.tag", "false");
        this.defaults.put("hcjf.log.truncate.tag.size", "35");
        this.defaults.put("hcjf.log.consumers.size", "50");
        this.defaults.put("hcjf.net.service.name", "Net service");
        this.defaults.put("hcjf.net.log.tag", "NET_SERVICE");
        this.defaults.put("hcjf.net.input.buffer.size", "20240000");
        this.defaults.put("hcjf.net.output.buffer.size", "20240000");
        this.defaults.put("hcjf.net.connection.timeout.available", "true");
        this.defaults.put("hcjf.net.connection.timeout", "30000");
        this.defaults.put("hcjf.net.disconnect.and.remove", "true");
        this.defaults.put("hcjf.net.write.timeout", "100");
        this.defaults.put("hcjf.net.io.udp.lru.addresses.size", "1000");
        this.defaults.put("hcjf.net.io.udp.lru.sessions.size", "1000");
        this.defaults.put("hcjf.net.io.queue.size", "1000000");
        this.defaults.put("hcjf.net.io.thread.pool.keep.alive.time", "120");
        this.defaults.put("hcjf.net.io.thread.pool.name", "IoThreadPool");
        this.defaults.put("hcjf.net.default.input.buffer.size", "20480000");
        this.defaults.put("hcjf.net.default.output.buffer.size", "20480000");
        this.defaults.put("hcjf.net.io.thread.direct.allocate.memory", "false");
        this.defaults.put("hcjf.net.ssl.max.io.thread.pool.size", "2");
        this.defaults.put("hcjf.net.port.provider.time.windows.size", "15000");
        this.defaults.put("hcjf.net.port.probe.connection.timeout", "1000");
        this.defaults.put("hcjf.net.remote.address.into.net.package", "false");
        this.defaults.put("hcjf.net.remote.address.into.net.session", "false");
        this.defaults.put("hcjf.net.nio.selector.health.checker.running.time", "1000");
        this.defaults.put("hcjf.net.nio.selector.health.checker.sample.time", "2000");
        this.defaults.put("hcjf.net.nio.selector.health.checker.dangerous.threshold", "60");
        this.defaults.put("hcjf.net.nio.selector.health.checker.dangerous.repeats", "5");
        this.defaults.put("hcjf.net.nio.selector.health.checker.dangerous.action", "RECREATE_SELECTOR");
        this.defaults.put("hcjf.net.http.host.access.control.regex.start.char", "^");
        this.defaults.put("hcjf.net.http.client.response.handler.queue.size", "1000");
        this.defaults.put("hcjf.net.broadcast.service.name", "Broadcast service");
        this.defaults.put("hcjf.net.broadcast.log.tag", "BROADCAST");
        this.defaults.put("hcjf.net.broadcast.interface.name", "eth0");
        this.defaults.put("hcjf.net.broadcast.ip.version", "4");
        this.defaults.put("hcjf.net.broadcast.sender.delay", "30000");
        this.defaults.put("hcjf.net.broadcast.signature.algorithm", "SHA-1");
        this.defaults.put("hcjf.net.broadcast.receiver.buffer.size", "1024");
        this.defaults.put("hcjf.net.kubernetes.service.name", "Kubernetes Spy Service");
        this.defaults.put("hcjf.net.kubernetes.log.tag", "KUBERNETES_SPY");
        this.defaults.put("hcjf.net.kubernetes.client.connection.timeout", "10000");
        this.defaults.put("hcjf.net.kubernetes.task.sleep.time", "5000");
        this.defaults.put("hcjf.net.kubernetes.curl.command", "curl");
        this.defaults.put("hcjf.net.kubernetes.curl.command.authentication.header", "-H 'Authorization: Bearer %s'");
        this.defaults.put("hcjf.net.kubernetes.curl.command.cacert.parameter", "--cacert %s");
        this.defaults.put("hcjf.net.kubernetes.cacert.file.path", "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");
        this.defaults.put("hcjf.net.kubernetes.token.file.path", "/var/run/secrets/kubernetes.io/serviceaccount/token");
        this.defaults.put("hcjf.net.kubernetes.namespace.file.path", "/var/run/secrets/kubernetes.io/serviceaccount/namespace");
        this.defaults.put("hcjf.net.kubernetes.master.node.host", "KUBERNETES_PORT_443_TCP_ADDR");
        this.defaults.put("hcjf.net.kubernetes.master.node.port", "KUBERNETES_SERVICE_PORT");
        this.defaults.put("hcjf.net.kubernetes.end.points.list.pods", "https://%s:%s/api/v1/namespaces/%s/pods");
        this.defaults.put("hcjf.net.kubernetes.end.points.list.services", "https://%s:%s/api/v1/namespaces/%s/services");
        this.defaults.put("hcjf.net.kubernetes.end.points.list.end_points", "https://%s:%s/api/v1/namespaces/%s/endpoints");
        this.defaults.put("hcjf.net.kubernetes.authorization.header", "Bearer %s");
        this.defaults.put("hcjf.net.kubernetes.json.date.format", "yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.defaults.put("hcjf.net.ssl.default.key.password", "hcjfkeypassword");
        this.defaults.put("hcjf.net.ssl.default.key.type", "JKS");
        this.defaults.put("hcjf.net.ssl.default.keystore.password", "hcjfkeystorepassword");
        this.defaults.put("hcjf.net.ssl.default.keystore.file.path", "./src/resources/org/hcjf/io/net/https/keystore.jks");
        this.defaults.put("hcjf.net.ssl.default.trusted.certs.file.path", "./src/resources/org/hcjf/io/net/https/cacerts.jks");
        this.defaults.put("hcjf.net.ssl.default.protocol", "TLSv1.2");
        this.defaults.put("hcjf.net.ssl.io.thread.name", "SslIoThread");
        this.defaults.put("hcjf.net.ssl.engine.thread.name", "SslEngineThread");
        this.defaults.put("hcjf.net.messages.log.tag", "MESSAGES");
        this.defaults.put("hcjf.net.messages.server.decoupled.io.action", "true");
        this.defaults.put("hcjf.net.messages.server.io.queue.size", "100000");
        this.defaults.put("hcjf.net.messages.server.io.workers", "5");
        this.defaults.put("hcjf.net.http.server.input.log.enabled", "false");
        this.defaults.put("hcjf.net.http.server.output.log.enabled", "false");
        this.defaults.put("hcjf.net.http.server.log.tag", "HTTP_SERVER");
        this.defaults.put("hcjf.net.http.server.name", "HCJF Web Server");
        this.defaults.put("hcjf.net.http.response.date.header.format.value", "EEE, dd MMM yyyy HH:mm:ss z");
        this.defaults.put("hcjf.net.http.input.log.body.max.length", "128");
        this.defaults.put("hcjf.net.http.output.log.body.max.length", "128");
        this.defaults.put("hcjf.net.http.default.server.port", "80");
        this.defaults.put("hcjf.net.http.default.client.port", "80");
        this.defaults.put("hcjf.net.http.streaming.limit.file.size", "10240");
        this.defaults.put("hcjf.net.http.default.error.format.show.stack", "true");
        this.defaults.put("hcjf.net.http.default.client.connect.timeout", "10000");
        this.defaults.put("hcjf.net.http.default.client.read.timeout", "10000");
        this.defaults.put("hcjf.net.http.default.client.write.timeout", "10000");
        this.defaults.put("hcjf.net.http.default.guest.session.name", "Http guest session");
        this.defaults.put("hcjf.net.http.default.file.checksum.algorithm", "MD5");
        this.defaults.put("hcjf.net.http.enable.automatic.response.content.length", "true");
        this.defaults.put("hcjf.net.http.automatic.content.length.skip.codes", "[304]");
        this.defaults.put("hcjf.net.http.max.package.size", Integer.toString(0x1400000));
        this.defaults.put("hcjf.net.http.server.decoupled.io.action", "true");
        this.defaults.put("hcjf.net.http.server.io.queue.size", "100000");
        this.defaults.put("hcjf.net.http.server.io.workers", "5");
        this.defaults.put("hcjf.net.https.default.server.port", "443");
        this.defaults.put("hcjf.net.https.default.server.port", "443");
        this.defaults.put("hcjf.net.http.http2.settings.header.table.size", "4096");
        this.defaults.put("hcjf.net.http.http2.settings.enable.push", "true");
        this.defaults.put("hcjf.net.http.http2.settings.max.concurrent.streams", "-1");
        this.defaults.put("hcjf.net.http.http2.settings.initial.windows.size", "65535");
        this.defaults.put("hcjf.net.http.http2.settings.max.frame.size", "16384");
        this.defaults.put("hcjf.net.http.http2.settings.max.header.list.size", "-1");
        this.defaults.put("hcjf.net.http.folder.log.tag", "FOLDER_CONTEXT");
        this.defaults.put("hcjf.net.http.folder.forbidden.characters", "[]");
        this.defaults.put("hcjf.net.http.folder.file.extension.regex", "\\.(?=[^\\.]+$)");
        this.defaults.put("hcjf.net.http.folder.default.html.document", "<!DOCTYPE html><html><head><title>%s</title><body>%s</body></html></head>");
        this.defaults.put("hcjf.net.http.folder.default.html.body", "<table>%s</table>");
        this.defaults.put("hcjf.net.http.folder.default.html.row", "<tr><th><a href=\"%s\">%s</a></th></tr>");
        this.defaults.put("hcjf.net.http.folder.zip.container", System.getProperty("user.home"));
        this.defaults.put("hcjf.net.http.folder.zip.temp.prefix", "hcjf_zip_temp");
        this.defaults.put("hcjf.net.http.folder.jar.container", System.getProperty("user.home"));
        this.defaults.put("hcjf.net.http.folder.jar.temp.prefix", "hcjf_jar_temp");
        this.defaults.put("hcjf.net.http.end.point.json.date.formats", " [dd/M/yyyy,dd/MM/yyyy]");
        this.defaults.put("hcjf.rest.default.mime.type", "application/json");
        this.defaults.put("hcjf.rest.default.encoding.impl", "hcjf");
        this.defaults.put("hcjf.rest.query.path", "query");
        this.defaults.put("hcjf.rest.query.parameter.path", "q");
        this.defaults.put("hcjf.net.http.rest.body.field", "_body");
        this.defaults.put("hcjf.net.http.rest.query.field", "_query");
        this.defaults.put("hcjf.net.http.rest.queries.field", "_queries");
        this.defaults.put("hcjf.process.log.tag", "PROCESS_DISCOVERY");
        this.defaults.put("hcjf.process.discovery.service.name", "Process Discovery Service");
        this.defaults.put("hcjf.process.discovery.service.priority", "1");
        this.defaults.put("hcjf.process.delay", "3000");
        this.defaults.put("hcjf.query.single.pattern", "SELECT * FROM %s");
        this.defaults.put("hcjf.query.log.tag", "QUERY");
        this.defaults.put("hcjf.query.default.limit", "1000");
        this.defaults.put("hcjf.query.default.desc.order", "false");
        this.defaults.put("hcjf.query.select.regular.expression", "(?i)^(?<select>select[  ]{1,}[a-zA-Z_0-9'=<>!,.~+-/*%\\$&\u00a1\u00bf@ ]{1,})(?<from>[  ]?from[  ](?<resourceValue>[a-zA-Z_0-9$\u00a1\u00bf.]{1,})(?<dynamicResource> as (?<dynamicResourceAlias>[a-zA-Z_0-9.]{1,}[ ]?)|[ ]?))(?<conditionalBody>[a-zA-Z_0-9'=,.~+-/* ?%\\$&\u00a1\u00bf@<>!\\:\\-()\\[\\]]{1,})?[$;]?");
        this.defaults.put("hcjf.query.conditional.regular.expression", "(?i)((?<=(^((inner |left |right |full )?join )|^where |^limit |^start |^order by |^group by |(( inner | left | right | full )?join )| where | limit | start | order by | group by )))|(?=(^((inner |left |right |full )?join )|^where |^limit |^start |^order by |^group by |(( inner | left | right | full )?join )| where | limit | start | order by | group by ))");
        this.defaults.put("hcjf.query.evaluator.collection.regular.expression", "(?i)((?<=( and | or ))|(?=( and | or )))");
        this.defaults.put("hcjf.query.operation.regular.expression", "(?i)(?<=(=|<>|!=|>|<|>=|<=| in | not in | like ))|(?=(=|<>|!=|>|<|>=|<=| in | not in | like ))");
        this.defaults.put("hcjf.query.join.regular.expression", "(?i)(((?<resourceValue>[a-zA-Z_0-9$\u00a1\u00bf.]{1,})(?<dynamicResource>[ ]as[ ](?<dynamicResourceAlias>[a-zA-Z_0-9.]{1,})|[ ]?)) on (?<conditionalBody>[a-zA-Z_0-9'=,.~+-\\/* ?%\\$&\u00a1\u00bf@<>!\\:\\-()\\[\\]]{1,}))");
        this.defaults.put("hcjf.query.join.resource.value", "resourceValue");
        this.defaults.put("hcjf.query.join.dynamic.resource.index", "dynamicResource");
        this.defaults.put("hcjf.query.join.dynamic.resource.alias.index", "dynamicResourceAlias");
        this.defaults.put("hcjf.query.join.conditional.body.index", "conditionalBody");
        this.defaults.put("hcjf.query.union.regular.expression", "(?i)((?<=( union ))|(?=( union )))");
        this.defaults.put("hcjf.query.as.regular.expression", "(?i)((?<=( as ))|(?=( as )))");
        this.defaults.put("hcjf.query.desc.regular.expression", "(?i)((?<=( desc| asc))|(?=( desc| asc)))");
        this.defaults.put("hcjf.query.select.group.index", "select");
        this.defaults.put("hcjf.query.from.group.index", "from");
        this.defaults.put("hcjf.query.conditional.group.index", "conditionalBody");
        this.defaults.put("hcjf.query.resource.value.index", "resourceValue");
        this.defaults.put("hcjf.query.dynamic.resource.group.index", "dynamicResource");
        this.defaults.put("hcjf.query.dynamic.resource.alias.group.index", "dynamicResourceAlias");
        this.defaults.put("hcjf.query.join.resource.name.index", "0");
        this.defaults.put("hcjf.query.join.evaluators.index", "1");
        this.defaults.put("hcjf.query.date.format", "yyyy-MM-dd HH:mm:ss");
        this.defaults.put("hcjf.query.decimal.separator", ".");
        this.defaults.put("hcjf.query.decimal.format", "0.000");
        this.defaults.put("hcjf.query.scientific.notation", "E");
        this.defaults.put("hcjf.query.scientific.notation.format", "0.0E0");
        this.defaults.put("hcjf.query.evaluators.cache", "__evaluators__cache__");
        this.defaults.put("hcjf.query.evaluator.left.values.cache", "__evaluator__left__values__cache__");
        this.defaults.put("hcjf.query.evaluator.right.values.cache", "__evaluator__right__values__cache__");
        this.defaults.put("hcjf.query.compiler.cache.size", "1000");
        this.defaults.put("hcjf.query.select.reserved.word", "SELECT");
        this.defaults.put("hcjf.query.from.reserved.word", "FROM");
        this.defaults.put("hcjf.query.join.reserved.word", "JOIN");
        this.defaults.put("hcjf.query.union.reserved.word", "UNION");
        this.defaults.put("hcjf.query.full.reserved.word", "FULL");
        this.defaults.put("hcjf.query.inner.join.reserved.word", "INNER");
        this.defaults.put("hcjf.query.left.join.reserved.word", "LEFT");
        this.defaults.put("hcjf.query.right.join.reserved.word", "RIGHT");
        this.defaults.put("hcjf.query.on.reserved.word", "ON");
        this.defaults.put("hcjf.query.where.reserved.word", "WHERE");
        this.defaults.put("hcjf.query.order.by.reserved.word", "ORDER BY");
        this.defaults.put("hcjf.query.desc.reserved.word", "DESC");
        this.defaults.put("hcjf.query.limit.reserved.word", "LIMIT");
        this.defaults.put("hcjf.query.start.reserved.word", "START");
        this.defaults.put("hcjf.query.return.all.reserved.word", "*");
        this.defaults.put("hcjf.query.argument.separator", ",");
        this.defaults.put("hcjf.query.equals.reserved.word", "=");
        this.defaults.put("hcjf.query.distinct.reserved.word", "<>");
        this.defaults.put("hcjf.query.distinct.2.reserved.word", "!=");
        this.defaults.put("hcjf.query.greater.than.reserved.word", ">");
        this.defaults.put("hcjf.query.greater.than.or.equals.reserved.word", ">=");
        this.defaults.put("hcjf.query.smaller.than.reserved.word", "<");
        this.defaults.put("hcjf.query.smaller.than.or.equals.reserved.word", "<=");
        this.defaults.put("hcjf.query.in.reserved.word", "IN");
        this.defaults.put("hcjf.query.not.in.reserved.word", "NOT IN");
        this.defaults.put("hcjf.query.not.reserved.word", "NOT");
        this.defaults.put("hcjf.query.not.2.reserved.word", "!");
        this.defaults.put("hcjf.query.like.reserved.word", "LIKE");
        this.defaults.put("hcjf.query.like.wildcard.reserved.word", "%");
        this.defaults.put("hcjf.query.and.reserved.word", "AND");
        this.defaults.put("hcjf.query.or.reserved.word", "OR");
        this.defaults.put("hcjf.query.statement.end.reserved.word", ";");
        this.defaults.put("hcjf.query.replaceable.value.reserved.word", "?");
        this.defaults.put("hcjf.query.string.delimiter.reserved.word", "'");
        this.defaults.put("hcjf.query.null.reserved.word", "NULL");
        this.defaults.put("hcjf.query.true.reserved.word", "TRUE");
        this.defaults.put("hcjf.query.false.reserved.word", "FALSE");
        this.defaults.put("hcjf.query.as.reserved.word", "AS");
        this.defaults.put("hcjf.query.group.by.reserved.word", "GROUP BY");
        this.defaults.put("hcjf.query.function.name.prefix", "query.");
        this.defaults.put("hcjf.query.function.math.name", "math");
        this.defaults.put("hcjf.query.function.string.name", "string");
        this.defaults.put("hcjf.query.function.date.name", "date");
        this.defaults.put("hcjf.query.function.math.eval.expression.name", "evalExpression");
        this.defaults.put("hcjf.query.function.math.addition", "+");
        this.defaults.put("hcjf.query.function.math.subtraction", "-");
        this.defaults.put("hcjf.query.function.math.multiplication", "*");
        this.defaults.put("hcjf.query.function.math.division", "/");
        this.defaults.put("hcjf.query.function.math.modulus", "%");
        this.defaults.put("hcjf.query.function.maht.equals", "=");
        this.defaults.put("hcjf.query.function.math.distinct", "!=");
        this.defaults.put("hcjf.query.function.math.distinct.2", "<>");
        this.defaults.put("hcjf.query.function.math.grater.than", ">");
        this.defaults.put("hcjf.query.function.math.grater.than.or.equals", ">=");
        this.defaults.put("hcjf.query.function.math.less.than", "<");
        this.defaults.put("hcjf.query.function.math.less.than.or.equals", "<=");
        this.defaults.put("hcjf.query.function.reference.name", "reference");
        this.defaults.put("hcjf.query.function.bson.name", "bson");
        this.defaults.put("hcjf.query.function.collection.name", "collection");
        this.defaults.put("hcjf.query.function.object.name", "object");
        this.defaults.put("hcjf.query.function.big.decimal.divide.scale", "8");
        this.defaults.put("hcjf.cloud.name", "CloudService");
        this.defaults.put("hcjf.cloud.priority", "0");
        this.defaults.put("hcjf.cloud.impl", DefaultCloudServiceImpl.class.getName());
        this.defaults.put("hcjf.cloud.log.tag", "CLOUD");
        this.defaults.put("hcjf.cloud.orchestrator.name", "CloudDefaultImplService");
        this.defaults.put("hcjf.cloud.orchestrator.available", "false");
        this.defaults.put("hcjf.cloud.orchestrator.service.priority", "0");
        this.defaults.put("hcjf.cloud.orchestrator.server.listener.port", "18080");
        this.defaults.put("hcjf.cloud.orchestrator.connection.loop.wait.time", "5000");
        this.defaults.put("hcjf.cloud.orchestrator.node.lost.timeout", "1800000");
        this.defaults.put("hcjf.cloud.orchestrator.ack.timeout", "2000");
        this.defaults.put("hcjf.cloud.orchestrator.reorganization.timeout", "2000");
        this.defaults.put("hcjf.cloud.orchestrator.reorganization.warning.time.limit", "1500");
        this.defaults.put("hcjf.cloud.orchestrator.wagon.timeout", "10000");
        this.defaults.put("hcjf.cloud.orchestrator.invokeNode.timeout", "120000");
        this.defaults.put("hcjf.cloud.orchestrator.test.node.timeout", "2000");
        this.defaults.put("hcjf.cloud.orchestrator.replication.factor", "2");
        this.defaults.put("hcjf.cloud.orchestrator.nodes", "[]");
        this.defaults.put("hcjf.cloud.orchestrator.service.end.points", "[]");
        this.defaults.put("hcjf.cloud.orchestrator.service.publication.broadcasting.enabled", "true");
        this.defaults.put("hcjf.cloud.orchestrator.service.publication.broadcasting.timeout", "2000");
        this.defaults.put("hcjf.cloud.orchestrator.cluster.name", "hcjf");
        this.defaults.put("hcjf.cloud.orchestrator.this.node.readable.layer.implementation.name", "system_cloud_node");
        this.defaults.put("hcjf.cloud.orchestrator.this.node.name", "hcjf-node");
        this.defaults.put("hcjf.cloud.orchestrator.this.node.version", "0");
        this.defaults.put("hcjf.cloud.orchestrator.this.node.lan.address", "127.0.0.1");
        this.defaults.put("hcjf.cloud.orchestrator.this.node.lan.port", "18080");
        this.defaults.put("hcjf.cloud.orchestrator.this.service.end.point.readable.layer.implementation.name", "system_cloud_service");
        this.defaults.put("hcjf.cloud.orchestrator.this.service.end.point.publication.timeout", "3600000");
        this.defaults.put("hcjf.cloud.orchestrator.this.service.end.point.distributed.event.listener", "false");
        this.defaults.put("hcjf.cloud.orchestrator.broadcast.enabled", "false");
        this.defaults.put("hcjf.cloud.orchestrator.broadcast.task.name", "Cloud discovery");
        this.defaults.put("hcjf.cloud.orchestrator.broadcast.ip.version", "4");
        this.defaults.put("hcjf.cloud.orchestrator.broadcast.interface.name", "eth0");
        this.defaults.put("hcjf.cloud.orchestrator.broadcast.port", "16000");
        this.defaults.put("hcjf.cloud.orchestrator.kubernetes.enabled", "false");
        this.defaults.put("hcjf.cloud.orchestrator.kubernetes.pod.labels", "[]");
        this.defaults.put("hcjf.cloud.orchestrator.kubernetes.service.labels", "[]");
        this.defaults.put("hcjf.cloud.orchestrator.kubernetes.service.port.name", "hcjf-k8s-port");
        this.defaults.put("hcjf.cloud.orchestrator.kubernetes.allow.phases", "[Running]");
        this.defaults.put("hcjf.cloud.orchestrator.events.log.tag", "DISTRIBUTED_EVENT");
        this.defaults.put("hcjf.cloud.orchestrator.events.timeout", "3000");
        this.defaults.put("hcjf.cloud.orchestrator.events.attempts", "5");
        this.defaults.put("hcjf.cloud.orchestrator.events.sleep.period.between.attempts", "3000");
        this.defaults.put("hcjf.cloud.orchestrator.events.store.strategy", "default");
        this.defaults.put("hcjf.cloud.timer.task.min.value.of.delay", "10000");
        this.defaults.put("hcjf.cloud.timer.task.map.name", "hcjf.cloud.timer.task.map");
        this.defaults.put("hcjf.cloud.timer.task.map.suffix.name", "hcjf.cloud.timer.task.map.");
        this.defaults.put("hcjf.cloud.timer.task.lock.suffix.name", "hcjf.cloud.timer.task.lock.");
        this.defaults.put("hcjf.cloud.timer.task.condition.suffix.name", "hcjf.cloud.timer.task.condition.");
        this.defaults.put("hcjf.cloud.cache.map.suffix.name", "hcjf.cloud.cache.map.");
        this.defaults.put("hcjf.cloud.cache.lock.suffix.name", "hcjf.cloud.cache.lock.");
        this.defaults.put("hcjf.cloud.cache.condition.suffix.name", "hcjf.cloud.cache.condition.");
        this.defaults.put("hcjf.cloud.cache.size.strategy.map.suffix.name", "hcjf.cloud.cache.size.strategy.map.");
        this.defaults.put("hcjf.cloud.queue.lock.name.template", "hcjf.cloud.queue.lock.name.%s");
        this.defaults.put("hcjf.cloud.queue.condition.name.template", "hcjf.cloud.queue.condition.name.%s");
        this.defaults.put("hcjf.cloud.queue.default.size", "100000");
        Properties system = System.getProperties();
        this.putAll((Map<?, ?>)system);
        System.setProperties(this);
    }

    public static void putDefaultValue(String propertyName, String defaultValue) {
        if (propertyName == null) {
            throw new NullPointerException("Invalid property name null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("Invalid default value null");
        }
        SystemProperties.instance.defaults.put(propertyName, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object setProperty(String key, String value) {
        Object result = super.setProperty(key, value);
        Map<String, Object> map = this.instancesCache;
        synchronized (map) {
            this.instancesCache.remove(key);
        }
        return result;
    }

    public static String get(String propertyName, PropertyValueValidator<String> validator) {
        String result = System.getProperty(propertyName);
        if (result == null) {
            org.hcjf.log.Log.w("PROPERTIES", "Property not found: %s", propertyName);
        }
        if (validator != null && !validator.validate(result)) {
            throw new IllegalPropertyValueException(propertyName + "=" + result);
        }
        return result;
    }

    public static String get(String propertyName) {
        return SystemProperties.get(propertyName, null);
    }

    public static Boolean getBoolean(String propertyName) {
        return SystemProperties.getBoolean(propertyName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean getBoolean(String propertyName, Boolean defaultValue) {
        Boolean result = null;
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            result = (Boolean)SystemProperties.instance.instancesCache.get(propertyName);
            if (result == null) {
                String propertyValue = SystemProperties.get(propertyName);
                try {
                    if (propertyValue != null) {
                        result = Boolean.valueOf(propertyValue);
                        SystemProperties.instance.instancesCache.put(propertyName, result);
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a boolean valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static Integer getInteger(String propertyName) {
        return SystemProperties.getInteger(propertyName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getInteger(String propertyName, Integer defaultValue) {
        Integer result = null;
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            result = (Integer)SystemProperties.instance.instancesCache.get(propertyName);
            if (result == null) {
                String propertyValue = SystemProperties.get(propertyName);
                try {
                    if (propertyValue != null) {
                        result = Integer.decode(propertyValue);
                        SystemProperties.instance.instancesCache.put(propertyName, result);
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a integer valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static Long getLong(String propertyName) {
        return SystemProperties.getLong(propertyName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getLong(String propertyName, Long defaultValue) {
        Long result = null;
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            result = (Long)SystemProperties.instance.instancesCache.get(propertyName);
            if (result == null) {
                String propertyValue = SystemProperties.get(propertyName);
                try {
                    if (propertyValue != null) {
                        result = Long.decode(propertyValue);
                        SystemProperties.instance.instancesCache.put(propertyName, result);
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a long valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static Double getDouble(String propertyName) {
        return SystemProperties.getDouble(propertyName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getDouble(String propertyName, Double defaultValue) {
        Double result = null;
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            result = (Double)SystemProperties.instance.instancesCache.get(propertyName);
            if (result == null) {
                String propertyValue = SystemProperties.get(propertyName);
                try {
                    if (propertyValue != null) {
                        result = Double.valueOf(propertyValue);
                        SystemProperties.instance.instancesCache.put(propertyName, result);
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a double valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID getUUID(String propertyName) {
        UUID result = null;
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            result = (UUID)SystemProperties.instance.instancesCache.get(propertyName);
            if (result == null) {
                String propertyValue = SystemProperties.get(propertyName);
                try {
                    if (propertyValue != null) {
                        result = UUID.fromString(propertyValue);
                        SystemProperties.instance.instancesCache.put(propertyName, result);
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a UUID valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path getPath(String propertyName) {
        Path result = null;
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            result = (Path)SystemProperties.instance.instancesCache.get(propertyName);
            if (result == null) {
                String propertyValue = SystemProperties.get(propertyName);
                try {
                    if (propertyValue != null) {
                        result = Paths.get(propertyValue, new String[0]);
                        SystemProperties.instance.instancesCache.put(propertyName, result);
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a path valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <O> Class<O> getClass(String propertyName) {
        Class<?> result;
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            result = (Class<?>)SystemProperties.instance.instancesCache.get(propertyName);
            if (result == null) {
                String propertyValue = SystemProperties.get(propertyName);
                try {
                    if (propertyValue != null) {
                        result = Class.forName(propertyValue);
                        SystemProperties.instance.instancesCache.put(propertyName, result);
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a class name valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        return result;
    }

    public static String getDefaultCharset() {
        return System.getProperty(FILE_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.util.Locale getLocale(String propertyName) {
        java.util.Locale result;
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            result = (java.util.Locale)SystemProperties.instance.instancesCache.get(propertyName);
            if (result == null) {
                String propertyValue = SystemProperties.get(propertyName);
                try {
                    result = java.util.Locale.forLanguageTag(propertyValue);
                    SystemProperties.instance.instancesCache.put(propertyName, result);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a locale tag valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        return result;
    }

    public static java.util.Locale getLocale() {
        return SystemProperties.getLocale("hcjf.default.locale");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DecimalFormat getDecimalFormat(String propertyName) {
        DecimalFormat result;
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            result = (DecimalFormat)SystemProperties.instance.instancesCache.get(propertyName);
            if (result == null) {
                String propertyValue = SystemProperties.get(propertyName);
                try {
                    DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                    symbols.setDecimalSeparator(SystemProperties.get(HCJF_DEFAULT_DECIMAL_SEPARATOR).charAt(0));
                    symbols.setGroupingSeparator(SystemProperties.get(HCJF_DEFAULT_GROUPING_SEPARATOR).charAt(0));
                    result = new DecimalFormat(propertyValue, symbols);
                    SystemProperties.instance.instancesCache.put(propertyName, result);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a decimal pattern valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleDateFormat getDateFormat(String propertyName) {
        SimpleDateFormat result;
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            result = (SimpleDateFormat)SystemProperties.instance.instancesCache.get(propertyName);
            if (result == null) {
                String propertyValue = SystemProperties.get(propertyName);
                try {
                    result = new SimpleDateFormat(SystemProperties.get(propertyName));
                    SystemProperties.instance.instancesCache.put(propertyName, result);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a date pattern valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        return result;
    }

    public static <O> O getObject(String propertyName, Class<O> objectType) {
        try {
            return (O)SystemProperties.instance.gson.fromJson(SystemProperties.get(propertyName), objectType);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The property value has not a json object valid to create the instance: '" + propertyName + ":" + objectType + "'", ex);
        }
    }

    public static <O> List<O> getObjects(String propertyName, Class<O> objectType) {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            JsonArray array = (JsonArray)SystemProperties.instance.jsonParser.parse(SystemProperties.get(propertyName));
            Iterator iterator = array.iterator();
            while (iterator.hasNext()) {
                result.add(SystemProperties.instance.gson.fromJson((JsonElement)iterator.next(), objectType));
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The property value has not a json object valid to create the instance: '" + propertyName + ":" + objectType + "'", ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getList(String propertyName) {
        String propertyValue = SystemProperties.get(propertyName);
        ArrayList<String> result = new ArrayList<String>();
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            if (SystemProperties.instance.instancesCache.containsKey(propertyName)) {
                result.addAll((List)SystemProperties.instance.instancesCache.get(propertyName));
            } else {
                try {
                    JsonArray array = (JsonArray)SystemProperties.instance.jsonParser.parse(propertyValue);
                    array.forEach(A -> result.add(A.getAsString()));
                    ArrayList<String> cachedResult = new ArrayList<String>();
                    cachedResult.addAll(result);
                    SystemProperties.instance.instancesCache.put(propertyName, cachedResult);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a json array valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getSet(String propertyName) {
        String propertyValue = SystemProperties.get(propertyName);
        TreeSet<String> result = new TreeSet<String>();
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            if (SystemProperties.instance.instancesCache.containsKey(propertyName)) {
                result.addAll((List)SystemProperties.instance.instancesCache.get(propertyName));
            } else {
                try {
                    JsonArray array = (JsonArray)SystemProperties.instance.jsonParser.parse(propertyValue);
                    array.forEach(A -> result.add(A.getAsString()));
                    ArrayList<String> cachedResult = new ArrayList<String>();
                    cachedResult.addAll(result);
                    SystemProperties.instance.instancesCache.put(propertyName, cachedResult);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a json array valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getMap(String propertyName) {
        String propertyValue = SystemProperties.get(propertyName);
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            if (SystemProperties.instance.instancesCache.containsKey(propertyName)) {
                result.putAll((Map)SystemProperties.instance.instancesCache.get(propertyName));
            } else {
                try {
                    JsonObject object = (JsonObject)SystemProperties.instance.jsonParser.parse(propertyValue);
                    object.entrySet().forEach((? super T S) -> result.put((String)S.getKey(), object.get((String)S.getKey()).getAsString()));
                    HashMap<String, String> cachedResult = new HashMap<String, String>();
                    cachedResult.putAll(result);
                    SystemProperties.instance.instancesCache.put(propertyName, cachedResult);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a json object valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        return result;
    }

    public static Pattern getPattern(String propertyName) {
        return SystemProperties.getPattern(propertyName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pattern getPattern(String propertyName, int flags) {
        Pattern result;
        String propertyValue = SystemProperties.get(propertyName);
        Map<String, Object> map = SystemProperties.instance.instancesCache;
        synchronized (map) {
            if (SystemProperties.instance.instancesCache.containsKey(propertyName)) {
                result = (Pattern)SystemProperties.instance.instancesCache.get(propertyName);
            } else {
                try {
                    result = Pattern.compile(propertyValue, flags);
                    SystemProperties.instance.instancesCache.put(propertyName, result);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("The property value has not a regex valid format: '" + propertyName + ":" + propertyValue + "'", ex);
                }
            }
        }
        return result;
    }

    public static class Cloud {
        public static final String SERVICE_NAME = "hcjf.cloud.name";
        public static final String SERVICE_PRIORITY = "hcjf.cloud.priority";
        public static final String IMPL = "hcjf.cloud.impl";
        public static final String LOG_TAG = "hcjf.cloud.log.tag";

        public static class Queue {
            public static final String LOCK_NAME_TEMPLATE = "hcjf.cloud.queue.lock.name.template";
            public static final String CONDITION_NAME_TEMPLATE = "hcjf.cloud.queue.condition.name.template";
            public static final String DEFAULT_SIZE = "hcjf.cloud.queue.default.size";
        }

        public static class Cache {
            public static final String MAP_SUFFIX_NAME = "hcjf.cloud.cache.map.suffix.name";
            public static final String LOCK_SUFFIX_NAME = "hcjf.cloud.cache.lock.suffix.name";
            public static final String CONDITION_SUFFIX_NAME = "hcjf.cloud.cache.condition.suffix.name";
            public static final String SIZE_STRATEGY_MAP_SUFFIX_NAME = "hcjf.cloud.cache.size.strategy.map.suffix.name";
        }

        public static class TimerTask {
            public static final String MIN_VALUE_OF_DELAY = "hcjf.cloud.timer.task.min.value.of.delay";
            public static final String MAP_NAME = "hcjf.cloud.timer.task.map.name";
            public static final String MAP_SUFFIX_NAME = "hcjf.cloud.timer.task.map.suffix.name";
            public static final String LOCK_SUFFIX_NAME = "hcjf.cloud.timer.task.lock.suffix.name";
            public static final String CONDITION_SUFFIX_NAME = "hcjf.cloud.timer.task.condition.suffix.name";
        }

        public static class Orchestrator {
            public static final String SERVICE_NAME = "hcjf.cloud.orchestrator.name";
            public static final String SERVICE_PRIORITY = "hcjf.cloud.orchestrator.service.priority";
            public static final String AVAILABLE = "hcjf.cloud.orchestrator.available";
            public static final String SERVER_LISTENER_PORT = "hcjf.cloud.orchestrator.server.listener.port";
            public static final String CONNECTION_LOOP_WAIT_TIME = "hcjf.cloud.orchestrator.connection.loop.wait.time";
            public static final String NODE_LOST_TIMEOUT = "hcjf.cloud.orchestrator.node.lost.timeout";
            public static final String ACK_TIMEOUT = "hcjf.cloud.orchestrator.ack.timeout";
            public static final String CLUSTER_NAME = "hcjf.cloud.orchestrator.cluster.name";
            public static final String WAGON_TIMEOUT = "hcjf.cloud.orchestrator.wagon.timeout";
            public static final String REORGANIZATION_TIMEOUT = "hcjf.cloud.orchestrator.reorganization.timeout";
            public static final String REORGANIZATION_WARNING_TIME_LIMIT = "hcjf.cloud.orchestrator.reorganization.warning.time.limit";
            public static final String INVOKE_TIMEOUT = "hcjf.cloud.orchestrator.invokeNode.timeout";
            public static final String TEST_NODE_TIMEOUT = "hcjf.cloud.orchestrator.test.node.timeout";
            public static final String REPLICATION_FACTOR = "hcjf.cloud.orchestrator.replication.factor";
            public static final String NODES = "hcjf.cloud.orchestrator.nodes";
            public static final String SERVICE_END_POINTS = "hcjf.cloud.orchestrator.service.end.points";
            public static final String SERVICE_PUBLICATION_REPLICAS_BROADCASTING_ENABLED = "hcjf.cloud.orchestrator.service.publication.broadcasting.enabled";
            public static final String SERVICE_PUBLICATION_REPLICAS_BROADCASTING_TIMEOUT = "hcjf.cloud.orchestrator.service.publication.broadcasting.timeout";

            public static final class Broadcast {
                public static final String ENABLED = "hcjf.cloud.orchestrator.broadcast.enabled";
                public static final String TASK_NAME = "hcjf.cloud.orchestrator.broadcast.task.name";
                public static final String IP_VERSION = "hcjf.cloud.orchestrator.broadcast.ip.version";
                public static final String INTERFACE_NAME = "hcjf.cloud.orchestrator.broadcast.interface.name";
                public static final String PORT = "hcjf.cloud.orchestrator.broadcast.port";
            }

            public static final class ThisServiceEndPoint {
                public static final String READABLE_LAYER_IMPLEMENTATION_NAME = "hcjf.cloud.orchestrator.this.service.end.point.readable.layer.implementation.name";
                public static final String ID = "hcjf.cloud.orchestrator.this.service.end.point.id";
                public static final String NAME = "hcjf.cloud.orchestrator.this.service.end.point.name";
                public static final String GATEWAY_ADDRESS = "hcjf.cloud.orchestrator.this.service.end.point.gateway.address";
                public static final String GATEWAY_PORT = "hcjf.cloud.orchestrator.this.service.end.point.gateway.port";
                public static final String PUBLICATION_TIMEOUT = "hcjf.cloud.orchestrator.this.service.end.point.publication.timeout";
                public static final String DISTRIBUTED_EVENT_LISTENER = "hcjf.cloud.orchestrator.this.service.end.point.distributed.event.listener";
            }

            public static final class ThisNode {
                public static final String READABLE_LAYER_IMPLEMENTATION_NAME = "hcjf.cloud.orchestrator.this.node.readable.layer.implementation.name";
                public static final String ID = "hcjf.cloud.orchestrator.this.node.id";
                public static final String NAME = "hcjf.cloud.orchestrator.this.node.name";
                public static final String VERSION = "hcjf.cloud.orchestrator.this.node.version";
                public static final String CLUSTER_NAME = "hcjf.cloud.orchestrator.this.node.cluster.name";
                public static final String DATA_CENTER_NAME = "hcjf.cloud.orchestrator.this.node.data.center.name";
                public static final String LAN_ADDRESS = "hcjf.cloud.orchestrator.this.node.lan.address";
                public static final String LAN_PORT = "hcjf.cloud.orchestrator.this.node.lan.port";
                public static final String WAN_ADDRESS = "hcjf.cloud.orchestrator.this.node.wan.address";
                public static final String WAN_PORT = "hcjf.cloud.orchestrator.this.node.wan.port";
            }

            public static final class Kubernetes {
                public static final String ENABLED = "hcjf.cloud.orchestrator.kubernetes.enabled";
                public static final String POD_LABELS = "hcjf.cloud.orchestrator.kubernetes.pod.labels";
                public static final String NAMESPACE = "hcjf.cloud.orchestrator.kubernetes.namespace";
                public static final String SERVICE_NAME = "hcjf.cloud.orchestrator.kubernetes.service.name";
                public static final String SERVICE_LABELS = "hcjf.cloud.orchestrator.kubernetes.service.labels";
                public static final String SERVICE_PORT_NAME = "hcjf.cloud.orchestrator.kubernetes.service.port.name";
                public static final String ALLOW_PHASES = "hcjf.cloud.orchestrator.kubernetes.allow.phases";
            }

            public static final class Events {
                public static final String LOG_TAG = "hcjf.cloud.orchestrator.events.log.tag";
                public static final String TIMEOUT = "hcjf.cloud.orchestrator.events.timeout";
                public static final String ATTEMPTS = "hcjf.cloud.orchestrator.events.attempts";
                public static final String SLEEP_PERIOD_BETWEEN_ATTEMPTS = "hcjf.cloud.orchestrator.events.sleep.period.between.attempts";
                public static final String STORE_STRATEGY = "hcjf.cloud.orchestrator.events.store.strategy";
            }
        }
    }

    public static final class Query {
        public static final String SINGLE_PATTERN = "hcjf.query.single.pattern";
        public static final String LOG_TAG = "hcjf.query.log.tag";
        public static final String DEFAULT_LIMIT = "hcjf.query.default.limit";
        public static final String DEFAULT_DESC_ORDER = "hcjf.query.default.desc.order";
        public static final String SELECT_REGULAR_EXPRESSION = "hcjf.query.select.regular.expression";
        public static final String CONDITIONAL_REGULAR_EXPRESSION = "hcjf.query.conditional.regular.expression";
        public static final String EVALUATOR_COLLECTION_REGULAR_EXPRESSION = "hcjf.query.evaluator.collection.regular.expression";
        public static final String OPERATION_REGULAR_EXPRESSION = "hcjf.query.operation.regular.expression";
        public static final String JOIN_REGULAR_EXPRESSION = "hcjf.query.join.regular.expression";
        public static final String JOIN_RESOURCE_VALUE_INDEX = "hcjf.query.join.resource.value";
        public static final String JOIN_DYNAMIC_RESOURCE_INDEX = "hcjf.query.join.dynamic.resource.index";
        public static final String JOIN_DYNAMIC_RESOURCE_ALIAS_INDEX = "hcjf.query.join.dynamic.resource.alias.index";
        public static final String JOIN_CONDITIONAL_BODY_INDEX = "hcjf.query.join.conditional.body.index";
        public static final String UNION_REGULAR_EXPRESSION = "hcjf.query.union.regular.expression";
        public static final String AS_REGULAR_EXPRESSION = "hcjf.query.as.regular.expression";
        public static final String DESC_REGULAR_EXPRESSION = "hcjf.query.desc.regular.expression";
        public static final String SELECT_GROUP_INDEX = "hcjf.query.select.group.index";
        public static final String FROM_GROUP_INDEX = "hcjf.query.from.group.index";
        public static final String CONDITIONAL_GROUP_INDEX = "hcjf.query.conditional.group.index";
        public static final String RESOURCE_VALUE_INDEX = "hcjf.query.resource.value.index";
        public static final String DYNAMIC_RESOURCE_INDEX = "hcjf.query.dynamic.resource.group.index";
        public static final String DYNAMIC_RESOURCE_ALIAS_INDEX = "hcjf.query.dynamic.resource.alias.group.index";
        public static final String JOIN_RESOURCE_NAME_INDEX = "hcjf.query.join.resource.name.index";
        public static final String JOIN_EVALUATORS_INDEX = "hcjf.query.join.evaluators.index";
        public static final String DATE_FORMAT = "hcjf.query.date.format";
        public static final String DECIMAL_SEPARATOR = "hcjf.query.decimal.separator";
        public static final String DECIMAL_FORMAT = "hcjf.query.decimal.format";
        public static final String SCIENTIFIC_NOTATION = "hcjf.query.scientific.notation";
        public static final String SCIENTIFIC_NOTATION_FORMAT = "hcjf.query.scientific.notation.format";
        public static final String EVALUATORS_CACHE_NAME = "hcjf.query.evaluators.cache";
        public static final String EVALUATOR_LEFT_VALUES_CACHE_NAME = "hcjf.query.evaluator.left.values.cache";
        public static final String EVALUATOR_RIGHT_VALUES_CACHE_NAME = "hcjf.query.evaluator.right.values.cache";
        public static final String COMPILER_CACHE_SIZE = "hcjf.query.compiler.cache.size";

        public static class Function {
            public static final String NAME_PREFIX = "hcjf.query.function.name.prefix";
            public static final String MATH_EVAL_EXPRESSION_NAME = "hcjf.query.function.math.eval.expression.name";
            public static final String MATH_FUNCTION_NAME = "hcjf.query.function.math.name";
            public static final String STRING_FUNCTION_NAME = "hcjf.query.function.string.name";
            public static final String DATE_FUNCTION_NAME = "hcjf.query.function.date.name";
            public static final String MATH_ADDITION = "hcjf.query.function.math.addition";
            public static final String MATH_SUBTRACTION = "hcjf.query.function.math.subtraction";
            public static final String MATH_MULTIPLICATION = "hcjf.query.function.math.multiplication";
            public static final String MATH_DIVISION = "hcjf.query.function.math.division";
            public static final String MATH_MODULUS = "hcjf.query.function.math.modulus";
            public static final String MATH_EQUALS = "hcjf.query.function.maht.equals";
            public static final String MATH_DISTINCT = "hcjf.query.function.math.distinct";
            public static final String MATH_DISTINCT_2 = "hcjf.query.function.math.distinct.2";
            public static final String MATH_GREATER_THAN = "hcjf.query.function.math.grater.than";
            public static final String MATH_GREATER_THAN_OR_EQUALS = "hcjf.query.function.math.grater.than.or.equals";
            public static final String MATH_LESS_THAN = "hcjf.query.function.math.less.than";
            public static final String MATH_LESS_THAN_OR_EQUALS = "hcjf.query.function.math.less.than.or.equals";
            public static final String REFERENCE_FUNCTION_NAME = "hcjf.query.function.reference.name";
            public static final String BSON_FUNCTION_NAME = "hcjf.query.function.bson.name";
            public static final String COLLECTION_FUNCTION_NAME = "hcjf.query.function.collection.name";
            public static final String OBJECT_FUNCTION_NAME = "hcjf.query.function.object.name";
            public static final String BIG_DECIMAL_DIVIDE_SCALE = "hcjf.query.function.big.decimal.divide.scale";
        }

        public static final class ReservedWord {
            public static final String SELECT = "hcjf.query.select.reserved.word";
            public static final String FROM = "hcjf.query.from.reserved.word";
            public static final String JOIN = "hcjf.query.join.reserved.word";
            public static final String UNION = "hcjf.query.union.reserved.word";
            public static final String FULL = "hcjf.query.full.reserved.word";
            public static final String INNER = "hcjf.query.inner.join.reserved.word";
            public static final String LEFT = "hcjf.query.left.join.reserved.word";
            public static final String RIGHT = "hcjf.query.right.join.reserved.word";
            public static final String ON = "hcjf.query.on.reserved.word";
            public static final String WHERE = "hcjf.query.where.reserved.word";
            public static final String ORDER_BY = "hcjf.query.order.by.reserved.word";
            public static final String DESC = "hcjf.query.desc.reserved.word";
            public static final String LIMIT = "hcjf.query.limit.reserved.word";
            public static final String START = "hcjf.query.start.reserved.word";
            public static final String RETURN_ALL = "hcjf.query.return.all.reserved.word";
            public static final String ARGUMENT_SEPARATOR = "hcjf.query.argument.separator";
            public static final String EQUALS = "hcjf.query.equals.reserved.word";
            public static final String DISTINCT = "hcjf.query.distinct.reserved.word";
            public static final String DISTINCT_2 = "hcjf.query.distinct.2.reserved.word";
            public static final String GREATER_THAN = "hcjf.query.greater.than.reserved.word";
            public static final String GREATER_THAN_OR_EQUALS = "hcjf.query.greater.than.or.equals.reserved.word";
            public static final String SMALLER_THAN = "hcjf.query.smaller.than.reserved.word";
            public static final String SMALLER_THAN_OR_EQUALS = "hcjf.query.smaller.than.or.equals.reserved.word";
            public static final String IN = "hcjf.query.in.reserved.word";
            public static final String NOT_IN = "hcjf.query.not.in.reserved.word";
            public static final String NOT = "hcjf.query.not.reserved.word";
            public static final String NOT_2 = "hcjf.query.not.2.reserved.word";
            public static final String LIKE = "hcjf.query.like.reserved.word";
            public static final String LIKE_WILDCARD = "hcjf.query.like.wildcard.reserved.word";
            public static final String AND = "hcjf.query.and.reserved.word";
            public static final String OR = "hcjf.query.or.reserved.word";
            public static final String STATEMENT_END = "hcjf.query.statement.end.reserved.word";
            public static final String REPLACEABLE_VALUE = "hcjf.query.replaceable.value.reserved.word";
            public static final String STRING_DELIMITER = "hcjf.query.string.delimiter.reserved.word";
            public static final String NULL = "hcjf.query.null.reserved.word";
            public static final String TRUE = "hcjf.query.true.reserved.word";
            public static final String FALSE = "hcjf.query.false.reserved.word";
            public static final String AS = "hcjf.query.as.reserved.word";
            public static final String GROUP_BY = "hcjf.query.group.by.reserved.word";
        }
    }

    public static final class ProcessDiscovery {
        public static final String LOG_TAG = "hcjf.process.log.tag";
        public static final String SERVICE_NAME = "hcjf.process.discovery.service.name";
        public static final String SERVICE_PRIORITY = "hcjf.process.discovery.service.priority";
        public static final String DELAY = "hcjf.process.delay";
    }

    public static final class Net {
        public static final String SERVICE_NAME = "hcjf.net.service.name";
        public static final String LOG_TAG = "hcjf.net.log.tag";
        public static final String INPUT_BUFFER_SIZE = "hcjf.net.input.buffer.size";
        public static final String OUTPUT_BUFFER_SIZE = "hcjf.net.output.buffer.size";
        public static final String DISCONNECT_AND_REMOVE = "hcjf.net.disconnect.and.remove";
        public static final String CONNECTION_TIMEOUT_AVAILABLE = "hcjf.net.connection.timeout.available";
        public static final String CONNECTION_TIMEOUT = "hcjf.net.connection.timeout";
        public static final String WRITE_TIMEOUT = "hcjf.net.write.timeout";
        public static final String IO_UDP_LRU_SESSIONS_SIZE = "hcjf.net.io.udp.lru.sessions.size";
        public static final String IO_UDP_LRU_ADDRESSES_SIZE = "hcjf.net.io.udp.lru.addresses.size";
        public static final String IO_QUEUE_SIZE = "hcjf.net.io.queue.size";
        public static final String IO_THREAD_POOL_KEEP_ALIVE_TIME = "hcjf.net.io.thread.pool.keep.alive.time";
        public static final String IO_THREAD_POOL_NAME = "hcjf.net.io.thread.pool.name";
        public static final String DEFAULT_INPUT_BUFFER_SIZE = "hcjf.net.default.input.buffer.size";
        public static final String DEFAULT_OUTPUT_BUFFER_SIZE = "hcjf.net.default.output.buffer.size";
        public static final String IO_THREAD_DIRECT_ALLOCATE_MEMORY = "hcjf.net.io.thread.direct.allocate.memory";
        public static final String SSL_MAX_IO_THREAD_POOL_SIZE = "hcjf.net.ssl.max.io.thread.pool.size";
        public static final String PORT_PROVIDER_TIME_WINDOWS_SIZE = "hcjf.net.port.provider.time.windows.size";
        public static final String PORT_PROBE_CONNECTION_TIMEOUT = "hcjf.net.port.probe.connection.timeout";
        public static final String REMOTE_ADDRESS_INTO_NET_PACKAGE = "hcjf.net.remote.address.into.net.package";
        public static final String REMOTE_ADDRESS_INTO_NET_SESSION = "hcjf.net.remote.address.into.net.session";
        public static final String NIO_SELECTOR_HEALTH_CHECKER_RUNNING_TIME = "hcjf.net.nio.selector.health.checker.running.time";
        public static final String NIO_SELECTOR_HEALTH_CHECKER_SAMPLE_TIME = "hcjf.net.nio.selector.health.checker.sample.time";
        public static final String NIO_SELECTOR_HEALTH_CHECKER_DANGEROUS_THRESHOLD = "hcjf.net.nio.selector.health.checker.dangerous.threshold";
        public static final String NIO_SELECTOR_HEALTH_CHECKER_DANGEROUS_REPEATS = "hcjf.net.nio.selector.health.checker.dangerous.repeats";
        public static final String NIO_SELECTOR_HEALTH_CHECKER_DANGEROUS_ACTION = "hcjf.net.nio.selector.health.checker.dangerous.action";

        public static final class Rest {
            public static final String DEFAULT_MIME_TYPE = "hcjf.rest.default.mime.type";
            public static final String DEFAULT_ENCODING_IMPL = "hcjf.rest.default.encoding.impl";
            public static final String QUERY_PATH = "hcjf.rest.query.path";
            public static final String QUERY_PARAMETER = "hcjf.rest.query.parameter.path";
            public static final String BODY_FIELD = "hcjf.net.http.rest.body.field";
            public static final String QUERY_FIELD = "hcjf.net.http.rest.query.field";
            public static final String QUERIES_FIELD = "hcjf.net.http.rest.queries.field";
        }

        public static final class Https {
            public static final String DEFAULT_SERVER_PORT = "hcjf.net.https.default.server.port";
            public static final String DEFAULT_CLIENT_PORT = "hcjf.net.https.default.server.port";
        }

        public static final class Http {
            public static final String INPUT_LOG_ENABLED = "hcjf.net.http.server.input.log.enabled";
            public static final String OUTPUT_LOG_ENABLED = "hcjf.net.http.server.output.log.enabled";
            public static final String LOG_TAG = "hcjf.net.http.server.log.tag";
            public static final String SERVER_NAME = "hcjf.net.http.server.name";
            public static final String RESPONSE_DATE_HEADER_FORMAT_VALUE = "hcjf.net.http.response.date.header.format.value";
            public static final String INPUT_LOG_BODY_MAX_LENGTH = "hcjf.net.http.input.log.body.max.length";
            public static final String OUTPUT_LOG_BODY_MAX_LENGTH = "hcjf.net.http.output.log.body.max.length";
            public static final String DEFAULT_SERVER_PORT = "hcjf.net.http.default.server.port";
            public static final String DEFAULT_CLIENT_PORT = "hcjf.net.http.default.client.port";
            public static final String STREAMING_LIMIT_FILE_SIZE = "hcjf.net.http.streaming.limit.file.size";
            public static final String DEFAULT_ERROR_FORMAT_SHOW_STACK = "hcjf.net.http.default.error.format.show.stack";
            public static final String DEFAULT_CLIENT_CONNECT_TIMEOUT = "hcjf.net.http.default.client.connect.timeout";
            public static final String DEFAULT_CLIENT_READ_TIMEOUT = "hcjf.net.http.default.client.read.timeout";
            public static final String DEFAULT_CLIENT_WRITE_TIMEOUT = "hcjf.net.http.default.client.write.timeout";
            public static final String DEFAULT_GUEST_SESSION_NAME = "hcjf.net.http.default.guest.session.name";
            public static final String DEFAULT_FILE_CHECKSUM_ALGORITHM = "hcjf.net.http.default.file.checksum.algorithm";
            public static final String ENABLE_AUTOMATIC_RESPONSE_CONTENT_LENGTH = "hcjf.net.http.enable.automatic.response.content.length";
            public static final String AUTOMATIC_CONTENT_LENGTH_SKIP_CODES = "hcjf.net.http.automatic.content.length.skip.codes";
            public static final String MAX_PACKAGE_SIZE = "hcjf.net.http.max.package.size";
            public static final String SERVER_DECOUPLED_IO_ACTION = "hcjf.net.http.server.decoupled.io.action";
            public static final String SERVER_IO_QUEUE_SIZE = "hcjf.net.http.server.io.queue.size";
            public static final String SERVER_IO_WORKERS = "hcjf.net.http.server.io.workers";
            public static final String HOST_ACCESS_CONTROL_REGEX_START_CHAR = "hcjf.net.http.host.access.control.regex.start.char";
            public static final String CLIENT_RESPONSE_HANDLER_QUEUE_SIZE = "hcjf.net.http.client.response.handler.queue.size";

            public static final class EndPoint {

                public static final class Json {
                    public static final String DATE_FORMATS = "hcjf.net.http.end.point.json.date.formats";
                }
            }

            public static final class Folder {
                public static final String LOG_TAG = "hcjf.net.http.folder.log.tag";
                public static final String FORBIDDEN_CHARACTERS = "hcjf.net.http.folder.forbidden.characters";
                public static final String FILE_EXTENSION_REGEX = "hcjf.net.http.folder.file.extension.regex";
                public static final String DEFAULT_HTML_DOCUMENT = "hcjf.net.http.folder.default.html.document";
                public static final String DEFAULT_HTML_BODY = "hcjf.net.http.folder.default.html.body";
                public static final String DEFAULT_HTML_ROW = "hcjf.net.http.folder.default.html.row";
                public static final String ZIP_CONTAINER = "hcjf.net.http.folder.zip.container";
                public static final String ZIP_TEMP_PREFIX = "hcjf.net.http.folder.zip.temp.prefix";
                public static final String JAR_CONTAINER = "hcjf.net.http.folder.jar.container";
                public static final String JAR_TEMP_PREFIX = "hcjf.net.http.folder.jar.temp.prefix";
            }

            public static final class Http2Settings {
                public static final String HEADER_TABLE_SIZE = "hcjf.net.http.http2.settings.header.table.size";
                public static final String ENABLE_PUSH = "hcjf.net.http.http2.settings.enable.push";
                public static final String MAX_CONCURRENT_STREAMS = "hcjf.net.http.http2.settings.max.concurrent.streams";
                public static final String INITIAL_WINDOWS_SIZE = "hcjf.net.http.http2.settings.initial.windows.size";
                public static final String MAX_FRAME_SIZE = "hcjf.net.http.http2.settings.max.frame.size";
                public static final String MAX_HEADER_LIST_SIZE = "hcjf.net.http.http2.settings.max.header.list.size";
            }
        }

        public static final class Messages {
            public static final String LOG_TAG = "hcjf.net.messages.log.tag";
            public static final String SERVER_DECOUPLED_IO_ACTION = "hcjf.net.messages.server.decoupled.io.action";
            public static final String SERVER_IO_QUEUE_SIZE = "hcjf.net.messages.server.io.queue.size";
            public static final String SERVER_IO_WORKERS = "hcjf.net.messages.server.io.workers";
        }

        public static final class Ssl {
            public static final String DEFAULT_PROTOCOL = "hcjf.net.ssl.default.protocol";
            public static final String IO_THREAD_NAME = "hcjf.net.ssl.io.thread.name";
            public static final String ENGINE_THREAD_NAME = "hcjf.net.ssl.engine.thread.name";
            public static final String DEFAULT_KEYSTORE_PASSWORD = "hcjf.net.ssl.default.keystore.password";
            public static final String DEFAULT_KEY_PASSWORD = "hcjf.net.ssl.default.key.password";
            public static final String DEFAULT_KEYSTORE_FILE_PATH = "hcjf.net.ssl.default.keystore.file.path";
            public static final String DEFAULT_TRUSTED_CERTS_FILE_PATH = "hcjf.net.ssl.default.trusted.certs.file.path";
            public static final String DEFAULT_KEY_TYPE = "hcjf.net.ssl.default.key.type";
        }

        public static final class KubernetesSpy {
            public static final String SERVICE_NAME = "hcjf.net.kubernetes.service.name";
            public static final String LOG_TAG = "hcjf.net.kubernetes.log.tag";
            public static final String CLIENT_CONNECTION_TIMEOUT = "hcjf.net.kubernetes.client.connection.timeout";
            public static final String TASK_SLEEP_TIME = "hcjf.net.kubernetes.task.sleep.time";
            public static final String CURL_COMMAND = "hcjf.net.kubernetes.curl.command";
            public static final String CURL_COMMAND_AUTHENTICATION_HEADER = "hcjf.net.kubernetes.curl.command.authentication.header";
            public static final String CURL_COMMAND_CACERT_PARAMETER = "hcjf.net.kubernetes.curl.command.cacert.parameter";
            public static final String CACERT_FILE_PATH = "hcjf.net.kubernetes.cacert.file.path";
            public static final String TOKEN_FILE_PATH = "hcjf.net.kubernetes.token.file.path";
            public static final String NAMESPACE_FILE_PATH = "hcjf.net.kubernetes.namespace.file.path";
            public static final String MASTER_NODE_HOST = "hcjf.net.kubernetes.master.node.host";
            public static final String MASTER_NODE_PORT = "hcjf.net.kubernetes.master.node.port";
            public static final String AUTHORIZATION_HEADER = "hcjf.net.kubernetes.authorization.header";
            public static final String JSON_DATE_FORMAT = "hcjf.net.kubernetes.json.date.format";

            public static final class EndPoints {
                public static final String LIST_PODS = "hcjf.net.kubernetes.end.points.list.pods";
                public static final String LIST_SERVICES = "hcjf.net.kubernetes.end.points.list.services";
                public static final String LIST_END_POINTS = "hcjf.net.kubernetes.end.points.list.end_points";
            }
        }

        public static final class Broadcast {
            public static final String SERVICE_NAME = "hcjf.net.broadcast.service.name";
            public static final String LOG_TAG = "hcjf.net.broadcast.log.tag";
            public static final String INTERFACE_NAME = "hcjf.net.broadcast.interface.name";
            public static final String IP_VERSION = "hcjf.net.broadcast.ip.version";
            public static final String SENDER_DELAY = "hcjf.net.broadcast.sender.delay";
            public static final String SIGNATURE_ALGORITHM = "hcjf.net.broadcast.signature.algorithm";
            public static final String RECEIVER_BUFFER_SIZE = "hcjf.net.broadcast.receiver.buffer.size";
        }
    }

    public static final class FileSystem {
        public static final String SERVICE_NAME = "hcjf.file.system.service.name";
        public static final String SERVICE_PRIORITY = "hcjf.file.system.service.priority";
        public static final String LOG_TAG = "hcjf.file.system.log.tag";
    }

    public static final class Encoding {
        public static final String SERVICE_NAME = "hcjf.encoding.service.name";
        public static final String SERVICE_PRIORITY = "hcjf.encoding.service.priority";
    }

    public static final class Log {
        public static final String SERVICE_NAME = "hcjf.log.service.name";
        public static final String SERVICE_PRIORITY = "hcjf.log.service.priority";
        public static final String FILE_PREFIX = "hcjf.log.file.prefix";
        public static final String ERROR_FILE = "hcjf.log.error.file";
        public static final String WARNING_FILE = "hcjf.log.warning.file";
        public static final String INFO_FILE = "hcjf.log.info.file";
        public static final String DEBUG_FILE = "hcjf.log.debug.file";
        public static final String LEVEL = "hcjf.log.level";
        public static final String DATE_FORMAT = "hcjf.log.date.format";
        public static final String CONSUMERS = "hcjf.log.consumers";
        public static final String SYSTEM_OUT_ENABLED = "hcjf.log.system.out.enabled";
        public static final String JAVA_STANDARD_LOGGER_ENABLED = "hcjf.log.java.standard.logger.enabled";
        public static final String QUEUE_INITIAL_SIZE = "hcjf.log.queue.initial.size";
        public static final String TRUNCATE_TAG = "hcjf.log.truncate.tag";
        public static final String TRUNCATE_TAG_SIZE = "hcjf.log.truncate.tag.size";
        public static final String LOG_CONSUMERS_SIZE = "hcjf.log.consumers.size";
    }

    public static final class Cryptography {
        public static final String KEY = "hcjf.cryptography.key";
        public static final String ALGORITHM = "hcjf.cryptography.algorithm";
        public static final String OPERATION_MODE = "hcjf.cryptography.operation.mode";
        public static final String PADDING_SCHEME = "hcjf.cryptography.padding.scheme";
        public static final String AAD = "hcjf.cryptography.aad";

        public static final class GCM {
            public static final String TAG_BIT_LENGTH = "hcjf.cryptography.gcm.tag.bit.length";
        }

        public static final class Random {
            public static final String IV_SIZE = "hcjf.cryptography.random.iv.size";
        }
    }

    public static final class CodeEvaluator {
        public static final String JAVA_CACHE_SIZE = "hcjf.code.evaluator.java.cache.size";
        public static final String JAVA_CACHE_TIMEOUT = "hcjf.code.evaluator.java.cache.timeout";
    }

    public static final class Collector {
        public static final String SERVICE_NAME = "hcjf.collector.service.name";
        public static final String SERVICE_PRIORITY = "hcjf.collector.service.priority";
        public static final String LOG_TAG = "hcjf.collector.log.tag";
        public static final String FLUSH_PERIOD = "hcjf.collector.flush.period";
        public static final String CLOUD_SAVE_MODE = "hcjf.collector.cloud.save.mode";
        public static final String CLOUD_TIMER_TASK_NAME = "hcjf.collector.cloud.timer.task.name";
    }

    public static final class Event {
        public static final String LOG_TAG = "hcjf.event.log.tag";
        public static final String SERVICE_NAME = "hcjf.event.service.name";
        public static final String SERVICE_PRIORITY = "hcjf.event.service.priority";
    }

    public static final class Service {
        public static final String STATIC_THREAD_NAME = "hcjf.service.static.thread.name";
        public static final String STATIC_THREAD_POOL_CORE_SIZE = "hcjf.service.static.thread.pool.core.size";
        public static final String STATIC_THREAD_POOL_MAX_SIZE = "hcjf.service.static.thread.pool.max.size";
        public static final String STATIC_THREAD_POOL_KEEP_ALIVE_TIME = "hcjf.service.static.thread.pool.keep.alive.time";
        public static final String THREAD_POOL_CORE_SIZE = "hcjf.service.thread.pool.core.size";
        public static final String THREAD_POOL_MAX_SIZE = "hcjf.service.thread.pool.max.size";
        public static final String THREAD_POOL_KEEP_ALIVE_TIME = "hcjf.service.thread.pool.keep.alive.time";
        public static final String GUEST_SESSION_NAME = "hcjf.service.guest.session.name";
        public static final String SYSTEM_SESSION_NAME = "hcjf.service.system.session.name";
        public static final String SHUTDOWN_TIME_OUT = "hcjf.service.shutdown.time.out";
        public static final String MAX_ALLOCATED_MEMORY_EXPRESSED_IN_PERCENTAGE = "hcjf.service.max.allocated.memory.expressed.in.percentage";
        public static final String MAX_ALLOCATED_MEMORY_FOR_THREAD = "max.allocated.memory.for.thread";
        public static final String MAX_EXECUTION_TIME_FOR_THREAD = "max.execution.time.for.thread";
        public static final String MAX_ALLOCATED_MEMORY_EXCEEDED_THROWS_EXCEPTION = "max.allocated.memory.exceeded.throws.exception";
    }

    public static final class Layer {
        public static final String LOG_TAG = "hcjf.layers.log.tag";
        public static final String READABLE_ALL_LAYER_IMPLEMENTATION_NAME = "hcjf.layers.readable.all.layer.implementation.name";
        public static final String READABLE_LAYER_IMPLEMENTATION_NAME = "hcjf.layers.readable.layer.implementation.name";
        public static final String PLUGIN_THREADING_GRANT = "hcjf.layers.plugin.threading.grant";
        public static final String PLUGIN_FILE_ACCESS_GRANT = "hcjf.layers.plugin.file.access.grant";
        public static final String DISTRIBUTED_LAYER_ENABLED = "hcjf.layers.distributed.layer.enabled";
    }

    public static final class Locale {
        public static final String LOG_TAG = "hcjf.locale.log.tag";
        public static final String DEFAULT_LOCALE = "hcjf.default.locale";
        public static final String DEFAULT_LOCALE_LAYER_IMPLEMENTATION_CLASS_NAME = "hcjf.default.locale.layer.implementation.class.name";
        public static final String DEFAULT_LOCALE_LAYER_IMPLEMENTATION_NAME = "hcjf.default.locale.layer.implementation.name";
    }
}

