/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.names.Naming;
import org.hcjf.service.security.LazyPermission;
import org.hcjf.service.security.Permission;
import org.hcjf.service.security.SecurityPermissions;

public final class Introspection {
    private static final Pattern GETTER_METHODS_PATTERN = Pattern.compile("^(get|is)([1,A-Z]|[1,0-9])(.*)");
    private static final Pattern SETTER_METHODS_PATTERN = Pattern.compile("^(set)([1,A-Z]|[1,0-9])(.*)");
    private static final String PATH_SEPARATOR = "\\.";
    private static final String SETTER_PREFIX = "set";
    private static final String GROUP_AS_LIST_CHARACTER = "**";
    private static final String GROUP_AS_SET_CHARACTER = "*";
    private static final String CONCAT_GROUP_CHARACTER = "|";
    private static final int SETTER_GETTER_FIRST_CHAR_FIELD_NAME_GROUP = 2;
    private static final int SETTER_GETTER_FIELD_NAME_GROUP = 3;
    private static final Map<String, Map<String, ? extends Invoker>> invokerCache = new HashMap<String, Map<String, ? extends Invoker>>();
    private static final Map<Class, Map<String, Accessors>> accessorsCache = new HashMap<Class, Map<String, Accessors>>();

    public static <O> O silentResolve(Object instance, String path) {
        O result = null;
        try {
            String[] pathElements = path.split(PATH_SEPARATOR);
            result = Introspection.resolve(instance, pathElements);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static <O> O resolve(Object instance, String path) {
        String[] pathElements = path.split(PATH_SEPARATOR);
        return Introspection.resolve(instance, pathElements);
    }

    public static <O> O resolve(Object instance, String ... path) {
        Object result = instance;
        Integer currentElement = 0;
        for (String element : path) {
            if (result == null) break;
            if (element.startsWith(GROUP_AS_SET_CHARACTER)) {
                result = Introspection.resolvePathAndJoin(result, currentElement, !element.startsWith(GROUP_AS_LIST_CHARACTER), element.endsWith(CONCAT_GROUP_CHARACTER), path);
                break;
            }
            if (result instanceof Map) {
                result = ((Map)result).get(element);
            } else {
                Integer index;
                if (result instanceof List) {
                    try {
                        index = Integer.parseInt(element);
                        result = ((List)result).get(index);
                    }
                    catch (Exception e) {
                        throw new HCJFRuntimeException("Unable to access to list value [" + element + "]", new Object[0]);
                    }
                }
                if (result instanceof Collection) {
                    try {
                        index = Integer.parseInt(element);
                        result = result.stream().skip(index - 1).findFirst().get();
                    }
                    catch (Exception e) {
                        throw new HCJFRuntimeException("Unable to access to collection value [" + element + "]", new Object[0]);
                    }
                }
                if (result.getClass().isArray()) {
                    try {
                        index = Integer.parseInt(element);
                        result = Array.get(result, index);
                    }
                    catch (Exception e) {
                        throw new HCJFRuntimeException("Unable to access to array value [" + element + "]", new Object[0]);
                    }
                }
                try {
                    result = Introspection.get(result, element);
                }
                catch (Exception e) {
                    throw new HCJFRuntimeException("Unable to access to field '" + element + "'", new Object[0]);
                }
            }
            Integer n = currentElement;
            currentElement = currentElement + 1;
        }
        return (O)result;
    }

    private static <O> Collection<O> resolvePathAndJoin(Object instance, Integer currenElement, boolean onlyDistinct, boolean concat, String ... path) {
        SequencedCollection<Object> result;
        List<Object> collectionInstance = instance.getClass().isArray() ? Arrays.asList(instance) : (instance instanceof Collection ? (List<Object>)instance : List.of(instance));
        if (currenElement < path.length - 1) {
            result = onlyDistinct ? new TreeSet() : new ArrayList<Object>();
            Integer newLength = path.length - currenElement - 1;
            String[] newPath = new String[newLength.intValue()];
            System.arraycopy(path, currenElement + 1, newPath, 0, newLength);
            for (Object e : collectionInstance) {
                O introspectionResult = Introspection.resolve(e, newPath);
                if (introspectionResult == null) continue;
                if (concat && introspectionResult instanceof Collection) {
                    result.addAll((Collection)introspectionResult);
                    continue;
                }
                result.add(introspectionResult);
            }
        } else {
            result = collectionInstance;
        }
        return result;
    }

    public static <O> O createAndPut(Object value, String path) {
        return Introspection.put(null, value, path);
    }

    public static <O> O createAndPut(Object value, String ... path) {
        return Introspection.put(null, value, path);
    }

    public static <O> O put(O instance, Object value, String path) {
        String[] pathElements = path.split(PATH_SEPARATOR);
        return Introspection.put(instance, value, pathElements);
    }

    public static <O> O put(O instance, Object value, String ... path) {
        if (instance == null) {
            instance = new HashMap();
        }
        O currentInstance = instance;
        if (path != null && path.length > 0) {
            for (int i = 0; i < path.length; ++i) {
                if (i + 1 == path.length) {
                    Introspection.set(currentInstance, path[i], value);
                    continue;
                }
                Object nextInstance = Introspection.resolve(currentInstance, path[i]);
                if (nextInstance == null) {
                    nextInstance = new HashMap();
                    Introspection.set(currentInstance, path[i], nextInstance);
                }
                currentInstance = nextInstance;
            }
        } else {
            throw new HCJFRuntimeException("The path to put a value can't be empty", new Object[0]);
        }
        return instance;
    }

    public static void set(Object instance, String path, Object value) {
        Object bean = instance;
        int separatorIndex = path.lastIndexOf(".");
        if (separatorIndex != -1) {
            String beanPath = path.substring(0, separatorIndex);
            bean = Introspection.resolve(instance, beanPath);
            path = path.substring(separatorIndex + 1);
        }
        if (bean instanceof Map) {
            ((Map)bean).put(path, value);
        } else {
            Integer index;
            if (bean instanceof List) {
                try {
                    index = Integer.parseInt(path);
                    ((List)bean).set(index, value);
                }
                catch (Exception e) {
                    throw new HCJFRuntimeException("Unable to access to list value [" + path + "]", new Object[0]);
                }
            }
            if (bean.getClass().isArray()) {
                try {
                    index = Integer.parseInt(path);
                    Array.set(bean, index, value);
                }
                catch (Exception e) {
                    throw new HCJFRuntimeException("Unable to access to array value [" + path + "]", new Object[0]);
                }
            }
            try {
                String setterName = SETTER_PREFIX + Character.toUpperCase(path.charAt(0)) + path.substring(1);
                Method setter = null;
                for (Method method : bean.getClass().getMethods()) {
                    if (!method.getName().equals(setterName) || method.getParameterCount() != 1 || !method.getParameters()[0].getType().isAssignableFrom(value.getClass())) continue;
                    setter = method;
                    break;
                }
                Introspection.setValue(bean, new Setter(bean.getClass(), path, setter), value);
            }
            catch (Exception e) {
                throw new HCJFRuntimeException("Unable to access to field '" + path + "'", new Object[0]);
            }
        }
    }

    public static <O> O get(Object instance, String getterName) {
        return Introspection.getGetters(instance.getClass()).get(getterName).get(instance);
    }

    public static List get(Object instance, String ... getters) {
        ArrayList result = new ArrayList();
        for (String getter : getters) {
            result.add(Introspection.get(instance, getter));
        }
        return result;
    }

    private static void setValue(Object instance, Setter setter, Object value) throws InstantiationException, IllegalAccessException {
        if (value instanceof Number) {
            if (Byte.class.isAssignableFrom(setter.getParameterType())) {
                setter.set(instance, ((Number)value).byteValue());
            } else if (Short.class.isAssignableFrom(setter.getParameterType())) {
                setter.set(instance, ((Number)value).shortValue());
            } else if (Integer.class.isAssignableFrom(setter.getParameterType())) {
                setter.set(instance, ((Number)value).intValue());
            } else if (Long.class.isAssignableFrom(setter.getParameterType())) {
                setter.set(instance, ((Number)value).longValue());
            } else if (Float.class.isAssignableFrom(setter.getParameterType())) {
                setter.set(instance, Float.valueOf(((Number)value).floatValue()));
            } else if (Double.class.isAssignableFrom(setter.getParameterType())) {
                setter.set(instance, ((Number)value).doubleValue());
            }
        } else if (Map.class.isAssignableFrom(value.getClass()) && !Map.class.isAssignableFrom(setter.getParameterType())) {
            setter.set(instance, Introspection.toInstance((Map)value, setter.getParameterType()));
        } else {
            setter.set(instance, value);
        }
    }

    public static Map<String, Object> toMap(Object instance) {
        return Introspection.toMap(instance, O -> O);
    }

    public static Map<String, String> toStringsMap(Object instance) {
        return Introspection.toMap(instance, O -> O.toString());
    }

    public static <O> Map<String, O> toMap(Object instance, Consumer consumer) {
        Map<String, Object> result = new HashMap();
        if (instance instanceof Map) {
            result = (Map)instance;
        } else {
            Map<String, Getter> getters = Introspection.getGetters(instance.getClass());
            for (String name : getters.keySet()) {
                try {
                    Object value = getters.get(name).get(instance);
                    if (value == null) continue;
                    result.put(name, consumer.consume(value));
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public static <O> O toInstance(Map<String, Object> map, Class<O> clazz) throws IllegalAccessException, InstantiationException {
        O result = null;
        try {
            result = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new HCJFRuntimeException("Unable to create instance", (Throwable)e, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HCJFRuntimeException("Default constructor not found", (Throwable)e, new Object[0]);
        }
        Map<String, Setter> setters = Introspection.getSetters(clazz);
        for (String name : setters.keySet()) {
            if (!map.containsKey(name)) continue;
            try {
                Setter currentSetter = setters.get(name);
                Object currentValue = map.get(name);
                Introspection.setValue(result, currentSetter, currentValue);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends Invoker> Map<String, I> getInvokers(Class clazz, InvokerFilter<I> filter) {
        Map<Object, Object> result = new HashMap();
        String invokerKey = Introspection.getInvokerKey(clazz, filter);
        if (!clazz.equals(Object.class)) {
            Map<String, Map<String, ? extends Invoker>> map = invokerCache;
            synchronized (map) {
                if (!invokerCache.containsKey(invokerKey)) {
                    invokerCache.put(invokerKey, result);
                    if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Objects.class)) {
                        result.putAll(Introspection.getInvokers(clazz.getSuperclass(), filter));
                    }
                    for (Method method : clazz.getDeclaredMethods()) {
                        InvokerEntry<I> entry = filter.filter(method);
                        if (entry == null) continue;
                        result.put(entry.getKey(), entry.getInvoker());
                        for (String alias : entry.getAliases()) {
                            result.put(alias, entry.getInvoker());
                        }
                    }
                } else {
                    result = invokerCache.get(invokerKey);
                }
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private static String getInvokerKey(Class clazz, InvokerFilter filter) {
        return clazz.getName() + filter.getName();
    }

    public static synchronized Map<String, Accessors> getAccessors(Class clazz) {
        Map<String, Accessors> result = accessorsCache.get(clazz);
        if (result == null) {
            result = new HashMap<String, Accessors>();
            Map<String, Setter> setterMap = Introspection.getSetters(clazz);
            Map<String, Getter> getterMap = Introspection.getGetters(clazz);
            HashSet<String> keySet = new HashSet<String>();
            keySet.addAll(setterMap.keySet());
            keySet.addAll(getterMap.keySet());
            for (String key : keySet) {
                result.put(key, new Accessors(key, getterMap.get(key), setterMap.get(key)));
            }
            accessorsCache.put(clazz, result);
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, Getter> getGetters(Class clazz, String namingImpl) {
        Map<String, Getter> getters = Introspection.getGetters(clazz);
        HashMap<String, Getter> result = new HashMap<String, Getter>();
        for (String name : getters.keySet()) {
            result.put(Naming.normalize(namingImpl, name), getters.get(name));
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, Getter> getGetters(Class clazz) {
        Map result = Introspection.getInvokers(clazz, method -> {
            Matcher matcher;
            InvokerEntry<Getter> result1 = null;
            if (Modifier.isPublic(method.getModifiers()) && (matcher = GETTER_METHODS_PATTERN.matcher(method.getName())).matches() && !method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 0) {
                String fieldName = matcher.group(2).toLowerCase() + matcher.group(3);
                result1 = new InvokerEntry<Getter>(fieldName, new Getter(method.getDeclaringClass(), fieldName, method), new String[0]);
            }
            return result1;
        });
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, Setter> getSetters(Class clazz, String namingImpl) {
        Map<String, Setter> setters = Introspection.getSetters(clazz);
        HashMap<String, Setter> result = new HashMap<String, Setter>();
        for (String name : setters.keySet()) {
            result.put(Naming.normalize(namingImpl, name), setters.get(name));
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, Setter> getSetters(Class clazz) {
        Map result = Introspection.getInvokers(clazz, method -> {
            Matcher matcher;
            InvokerEntry<Setter> result1 = null;
            if (Modifier.isPublic(method.getModifiers()) && (matcher = SETTER_METHODS_PATTERN.matcher(method.getName())).matches() && method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 1) {
                String fieldName = matcher.group(2).toLowerCase() + matcher.group(3);
                result1 = new InvokerEntry<Setter>(fieldName, new Setter(method.getDeclaringClass(), fieldName, method), new String[0]);
            }
            return result1;
        });
        return Collections.unmodifiableMap(result);
    }

    public static interface Consumer {
        public Object consume(Object var1);
    }

    public static class InvokerEntry<I extends Invoker> {
        private final String key;
        private final I invoker;
        private final String[] aliases;

        public InvokerEntry(String key, I invoker, String ... aliases) {
            this.key = key;
            this.invoker = invoker;
            this.aliases = aliases;
        }

        public String getKey() {
            return this.key;
        }

        public I getInvoker() {
            return this.invoker;
        }

        public String[] getAliases() {
            return this.aliases;
        }
    }

    public static interface InvokerFilter<I extends Invoker> {
        public InvokerEntry<I> filter(Method var1);

        default public String getName() {
            return this.getClass().getName();
        }
    }

    public static class Setter
    extends Accessor {
        private final Class parameterType;
        private ParameterizedType parameterParameterizedType;
        private final Class parameterKeyType;
        private final Class parameterCollectionType;

        public Setter(Class implementationClass, String resourceName, Method method) {
            super(implementationClass, resourceName, method);
            this.parameterType = method.getParameterTypes()[0];
            this.parameterParameterizedType = null;
            if (method.getGenericParameterTypes()[0] instanceof ParameterizedType) {
                this.parameterParameterizedType = (ParameterizedType)method.getGenericParameterTypes()[0];
                if (Collection.class.isAssignableFrom(this.parameterType)) {
                    this.parameterKeyType = null;
                    this.parameterCollectionType = this.parameterParameterizedType.getActualTypeArguments()[0] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[0] : (this.parameterParameterizedType.getActualTypeArguments()[0] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[0]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[0]).getRawType());
                } else if (Map.class.isAssignableFrom(this.parameterType)) {
                    this.parameterKeyType = this.parameterParameterizedType.getActualTypeArguments()[0] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[0] : (this.parameterParameterizedType.getActualTypeArguments()[0] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[0]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[0]).getRawType());
                    this.parameterCollectionType = this.parameterParameterizedType.getActualTypeArguments()[1] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[1] : (this.parameterParameterizedType.getActualTypeArguments()[1] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[1]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[1]).getRawType());
                } else {
                    this.parameterKeyType = null;
                    this.parameterCollectionType = null;
                }
            } else {
                this.parameterKeyType = null;
                this.parameterCollectionType = null;
            }
        }

        public void set(Object instance, Object value) {
            this.invoke(instance, value);
        }

        public final Class getParameterType() {
            return this.parameterType;
        }

        public final ParameterizedType getParameterParameterizedType() {
            return this.parameterParameterizedType;
        }

        public final Class getParameterKeyType() {
            return this.parameterKeyType;
        }

        public final Class getParameterCollectionType() {
            return this.parameterCollectionType;
        }
    }

    public static class Getter
    extends Accessor {
        private final Class returnType;
        private ParameterizedType parameterParameterizedType;
        private final Class returnKeyType;
        private final Class returnCollectionType;

        public Getter(Class implementationClass, String resourceName, Method method) {
            super(implementationClass, resourceName, method);
            this.returnType = method.getReturnType();
            this.parameterParameterizedType = null;
            if (method.getGenericReturnType() instanceof ParameterizedType) {
                this.parameterParameterizedType = (ParameterizedType)method.getGenericReturnType();
                if (Collection.class.isAssignableFrom(this.returnType)) {
                    this.returnKeyType = null;
                    this.returnCollectionType = this.parameterParameterizedType.getActualTypeArguments()[0] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[0] : (this.parameterParameterizedType.getActualTypeArguments()[0] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[0]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[0]).getRawType());
                } else if (Map.class.isAssignableFrom(this.returnType)) {
                    this.returnKeyType = this.parameterParameterizedType.getActualTypeArguments()[0] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[0] : (this.parameterParameterizedType.getActualTypeArguments()[0] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[0]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[0]).getRawType());
                    this.returnCollectionType = this.parameterParameterizedType.getActualTypeArguments()[1] instanceof Class ? (Class)this.parameterParameterizedType.getActualTypeArguments()[1] : (this.parameterParameterizedType.getActualTypeArguments()[1] instanceof TypeVariable ? (Class)((TypeVariable)this.parameterParameterizedType.getActualTypeArguments()[1]).getBounds()[0] : (Class)((ParameterizedType)this.parameterParameterizedType.getActualTypeArguments()[1]).getRawType());
                } else {
                    this.returnKeyType = null;
                    this.returnCollectionType = null;
                }
            } else {
                this.returnKeyType = null;
                this.returnCollectionType = null;
            }
        }

        public <O> O get(Object instance) {
            return (O)this.invoke(instance, new Object[0]);
        }

        public final Class getReturnType() {
            return this.returnType;
        }

        public final ParameterizedType getParameterParameterizedType() {
            return this.parameterParameterizedType;
        }

        public final Class getReturnKeyType() {
            return this.returnKeyType;
        }

        public final Class getReturnCollectionType() {
            return this.returnCollectionType;
        }
    }

    public static abstract class Accessor
    extends Invoker {
        private final String resourceName;

        protected Accessor(Class implementationClass, String resourceName, Method method) {
            super(implementationClass, method);
            this.resourceName = resourceName;
        }

        public final String getResourceName() {
            return this.resourceName;
        }
    }

    public static final class Accessors {
        private final String resourceName;
        private final Getter getter;
        private final Setter setter;

        public Accessors(String resourceName, Getter getter, Setter setter) {
            this.resourceName = resourceName;
            this.getter = getter;
            this.setter = setter;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public Getter getGetter() {
            return this.getter;
        }

        public Setter getSetter() {
            return this.setter;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            boolean result = false;
            if (this.getter != null) {
                result |= this.getter.isAnnotationPresent(annotationClass);
            }
            if (this.setter != null) {
                result |= this.setter.isAnnotationPresent(annotationClass);
            }
            return result;
        }

        public final <A extends Annotation> A getAnnotation(Class<? extends A> annotationClass) {
            A result = null;
            if (this.getter != null) {
                result = this.getter.getAnnotation(annotationClass);
            }
            if (result == null && this.setter != null) {
                result = this.setter.getAnnotation(annotationClass);
            }
            return result;
        }

        public final <A extends Annotation> List<A> getAnnotations(Class<? extends A> annotationClass) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (this.getter != null) {
                result.addAll(this.getter.getAnnotations(annotationClass));
            }
            if (this.setter != null) {
                result.addAll(this.setter.getAnnotations(annotationClass));
            }
            return result;
        }

        public final Map<Class<? extends Annotation>, List<Annotation>> getAnnotationsMap() {
            HashMap<Class<? extends Annotation>, List<Annotation>> result = new HashMap<Class<? extends Annotation>, List<Annotation>>();
            if (this.getter != null) {
                result.putAll(this.getter.getAnnotationsMap());
            }
            if (this.setter != null) {
                result.putAll(this.setter.getAnnotationsMap());
            }
            return result;
        }
    }

    public static abstract class Invoker {
        private final Class implementationClass;
        private final Method method;
        private final Map<Class<? extends Annotation>, List<Annotation>> annotationsMap;
        private boolean containsPermission;

        public Invoker(Class implementationClass, Method method) {
            this.implementationClass = implementationClass;
            this.method = method;
            this.annotationsMap = new HashMap<Class<? extends Annotation>, List<Annotation>>();
            for (Annotation annotation : method.getAnnotations()) {
                Class<?> annotationClass = null;
                for (Class<?> interfaceClass : annotation.getClass().getInterfaces()) {
                    if (!Annotation.class.isAssignableFrom(interfaceClass)) continue;
                    annotationClass = interfaceClass;
                }
                List<Annotation> annotationList = this.annotationsMap.get(annotationClass);
                if (annotationList == null) {
                    annotationList = new ArrayList<Annotation>();
                    this.annotationsMap.put(annotationClass, annotationList);
                }
                annotationList.add(annotation);
                if (annotationClass.equals(Permission.class)) {
                    SecurityPermissions.publishPermission(implementationClass, ((Permission)annotation).value(), ((Permission)annotation).description(), List.of(((Permission)annotation).tags()));
                    this.containsPermission = true;
                    continue;
                }
                if (!annotationClass.equals(LazyPermission.class)) continue;
                SecurityPermissions.publishPermission(implementationClass, ((LazyPermission)annotation).value(), ((Permission)annotation).description(), List.of(((LazyPermission)annotation).tags()));
            }
        }

        public final Class getImplementationClass() {
            return this.implementationClass;
        }

        public final Method getMethod() {
            return this.method;
        }

        public final boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.annotationsMap.containsKey(annotationClass);
        }

        public final <A extends Annotation> A getAnnotation(Class<? extends A> annotationClass) {
            Annotation result = null;
            if (this.annotationsMap.containsKey(annotationClass)) {
                result = this.annotationsMap.get(annotationClass).get(0);
            }
            return (A)result;
        }

        public final <A extends Annotation> List<A> getAnnotations(Class<? extends A> annotationClass) {
            List<Object> result = new ArrayList();
            if (this.annotationsMap.containsKey(annotationClass)) {
                result = Collections.unmodifiableList(this.annotationsMap.get(annotationClass));
            }
            return result;
        }

        public final Map<Class<? extends Annotation>, List<Annotation>> getAnnotationsMap() {
            return Collections.unmodifiableMap(this.annotationsMap);
        }

        public Object invoke(Object instance, Object ... params) {
            if (this.containsPermission) {
                for (Permission permission : this.getAnnotations(Permission.class)) {
                    SecurityPermissions.checkPermission(instance.getClass(), permission.value());
                }
            }
            try {
                Object result = instance instanceof InvocationHandler ? ((InvocationHandler)instance).invoke(instance, this.method, params) : this.getMethod().invoke(instance, params);
                return result;
            }
            catch (Throwable throwable) {
                throw new HCJFRuntimeException("Layer invoker", throwable, new Object[0]);
            }
        }
    }
}

