/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.events;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.hcjf.cloud.Cloud;
import org.hcjf.errors.Errors;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.events.DistributedEvent;
import org.hcjf.events.Event;
import org.hcjf.events.EventListener;
import org.hcjf.events.RemoteEvent;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;

public final class Events
extends Service<EventListener> {
    private static final Events instance = new Events();
    public final List<EventListener> listeners = new ArrayList<EventListener>();

    private Events() {
        super(SystemProperties.get("hcjf.event.service.name"), SystemProperties.getInteger("hcjf.event.service.priority"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConsumer(EventListener consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(Errors.getMessage("org.hcjf.events@1", new Object[0]));
        }
        List<EventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConsumer(EventListener consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(Errors.getMessage("org.hcjf.events@1", new Object[0]));
        }
        List<EventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EventListener> getListeners(Event event) {
        ArrayList<EventListener> result = new ArrayList<EventListener>();
        List<EventListener> list = this.listeners;
        synchronized (list) {
            for (EventListener listener : this.listeners) {
                if (!listener.getEventType().isAssignableFrom(event.getClass())) continue;
                result.add(listener);
            }
        }
        return result;
    }

    private void dispatchEvent(Event event) {
        if (event != null) {
            if (event instanceof DistributedEvent) {
                this.dispatchDistributedEvent((DistributedEvent)event);
            } else if (event instanceof RemoteEvent) {
                this.dispatchLocalEvent(((RemoteEvent)event).getEvent());
            } else {
                this.dispatchLocalEvent(event);
            }
        }
    }

    private void dispatchLocalEvent(Event event) {
        for (EventListener listener : this.getListeners(event)) {
            try {
                Events.run(() -> listener.onEventReceived(event), ServiceSession.getCurrentIdentity());
            }
            catch (Exception ex) {
                Log.e(SystemProperties.get("hcjf.event.log.tag"), "Unable to dispatch event", ex, new Object[0]);
            }
        }
    }

    private void synchronousDispatchEvent(Event event) {
        if (event != null) {
            if (event instanceof DistributedEvent) {
                throw new HCJFRuntimeException("Unable to use synchronous dispatch for distributed events", new Object[0]);
            }
            if (event instanceof RemoteEvent) {
                this.synchronousDispatchLocalEvent(((RemoteEvent)event).getEvent());
            } else {
                this.synchronousDispatchLocalEvent(event);
            }
        }
    }

    private void synchronousDispatchLocalEvent(Event event) {
        for (EventListener listener : this.getListeners(event)) {
            try {
                listener.onEventReceived(event);
            }
            catch (Exception ex) {
                Log.e(SystemProperties.get("hcjf.event.log.tag"), "Unable to dispatch event", ex, new Object[0]);
            }
        }
    }

    private void dispatchDistributedEvent(DistributedEvent distributedEvent) {
        Cloud.dispatchEvent(distributedEvent);
    }

    public static void sendEvent(Event event) {
        instance.dispatchEvent(event);
    }

    public static void processEvent(Event event) {
        instance.synchronousDispatchEvent(event);
    }

    public static void addEventListener(EventListener eventListener) {
        instance.registerConsumer(eventListener);
    }

    public static void removeEventListener(EventListener eventListener) {
        instance.unregisterConsumer(eventListener);
    }

    public static <E extends Event> E waitForEvent(Class<E> eventClass) throws InterruptedException {
        return Events.waitForEvent(eventClass, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Event> E waitForEvent(final Class<E> eventClass, long timeout) throws InterruptedException {
        final AtomicReference result = new AtomicReference();
        Events.addEventListener(new EventListener<E>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEventReceived(E event) {
                result.set(event);
                AtomicReference atomicReference = result;
                synchronized (atomicReference) {
                    result.notifyAll();
                }
            }

            @Override
            public Class<E> getEventType() {
                return eventClass;
            }
        });
        AtomicReference atomicReference = result;
        synchronized (atomicReference) {
            result.wait(timeout);
        }
        return (E)((Event)result.get());
    }

    public static <O, E extends Event> O waitForEvent(Class<E> eventClass, EventCollector<E> eventCollector) throws InterruptedException {
        return Events.waitForEvent(eventClass, eventCollector, Long.MAX_VALUE);
    }

    public static <O, E extends Event> O waitForEvent(Class<E> eventClass, EventCollector<E> eventCollector, long timeout) throws InterruptedException {
        return eventCollector.collect(Events.waitForEvent(eventClass, timeout));
    }

    public static interface EventCollector<E extends Event> {
        public <O> O collect(E var1);
    }
}

