/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.fs;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import org.hcjf.service.ServiceConsumer;

public abstract class FileSystemWatcherConsumer
implements ServiceConsumer {
    private final Path path;
    private final String fileName;
    private final Path basePath;
    private final WatchEvent.Kind[] eventKinds;

    public FileSystemWatcherConsumer(Path path, WatchEvent.Kind ... eventKinds) {
        this.path = path;
        if (!Files.isDirectory(path, new LinkOption[0])) {
            this.basePath = path.getParent();
            this.fileName = path.getFileName().toString();
        } else {
            this.basePath = path;
            this.fileName = null;
        }
        this.eventKinds = eventKinds;
    }

    public Path getPath() {
        return this.path;
    }

    public final Path getBasePath() {
        return this.basePath;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final WatchEvent.Kind[] getEventKinds() {
        return this.eventKinds;
    }

    protected void create(WatchEvent<Path> event) {
    }

    protected void update(WatchEvent<Path> event) {
    }

    protected void delete(WatchEvent<Path> event) {
    }

    protected void overflow(WatchEvent<Path> event) {
    }
}

