/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net;

import java.util.Date;
import java.util.UUID;
import org.hcjf.io.net.NetSession;

public abstract class NetPackage {
    private final UUID id = UUID.randomUUID();

    public final UUID getId() {
        return this.id;
    }

    public abstract NetSession getSession();

    public abstract void setSession(NetSession var1);

    public abstract byte[] getPayload();

    public abstract String getRemoteAddress();

    public abstract String getRemoteHost();

    public abstract int getRemotePort();

    public abstract int getLocalPort();

    public abstract Date getDate();

    public abstract ActionEvent getActionEvent();

    public abstract PackageStatus getPackageStatus();

    public abstract void setPackageStatus(PackageStatus var1);

    public static final NetPackage wrap(NetPackage netPackage, byte[] newPayLoad) {
        return new NetPackageWrapper(netPackage, newPayLoad);
    }

    public static enum PackageStatus {
        WAITING,
        UNKNOWN_SESSION,
        CONNECTION_CLOSE,
        REJECTED_SESSION_LOCK,
        IO_ERROR,
        OK;

    }

    public static enum ActionEvent {
        CONNECT,
        DISCONNECT,
        READ,
        WRITE;

    }

    public static final class NetPackageWrapper
    extends NetPackage {
        private final NetPackage netPackage;
        private final byte[] payLoad;

        private NetPackageWrapper(NetPackage netPackage, byte[] payLoad) {
            this.netPackage = netPackage;
            this.payLoad = payLoad != null ? payLoad : new byte[0];
        }

        public NetPackage getNetPackage() {
            return this.netPackage;
        }

        @Override
        public NetSession getSession() {
            return this.netPackage.getSession();
        }

        @Override
        public void setSession(NetSession session) {
            this.netPackage.setSession(session);
        }

        @Override
        public byte[] getPayload() {
            return this.payLoad;
        }

        @Override
        public String getRemoteAddress() {
            return this.netPackage.getRemoteAddress();
        }

        @Override
        public String getRemoteHost() {
            return this.netPackage.getRemoteHost();
        }

        @Override
        public int getRemotePort() {
            return this.netPackage.getRemotePort();
        }

        @Override
        public int getLocalPort() {
            return this.netPackage.getLocalPort();
        }

        @Override
        public Date getDate() {
            return this.netPackage.getDate();
        }

        @Override
        public ActionEvent getActionEvent() {
            return this.netPackage.getActionEvent();
        }

        @Override
        public PackageStatus getPackageStatus() {
            return this.netPackage.getPackageStatus();
        }

        @Override
        public void setPackageStatus(PackageStatus packageStatus) {
            this.netPackage.setPackageStatus(packageStatus);
        }
    }
}

