/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.broadcast;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hcjf.bson.BsonCollection;
import org.hcjf.bson.BsonDecoder;
import org.hcjf.bson.BsonDocument;
import org.hcjf.bson.BsonEncoder;
import org.hcjf.io.net.broadcast.BroadcastConsumer;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.Service;
import org.hcjf.utils.Introspection;

public class BroadcastService
extends Service<BroadcastConsumer> {
    private static final String IMPLEMENTATION_FIELD_NAME = "implementation";
    private static final String IP_PROTOCOL_VERSION_4 = "4";
    private static final String IP_PROTOCOL_VERSION_6 = "6";
    private static final BroadcastService instance = new BroadcastService(SystemProperties.get("hcjf.net.broadcast.service.name"));
    private static final UUID instanceId = UUID.randomUUID();
    private Map<String, BroadcastInterface> interfaces;
    private BroadcastSender sender;
    private Map<String, BroadcastReceiver> receivers;
    private Map<String, BroadcastConsumer> consumers;
    private boolean shuttingDown;
    private MessageDigest messageDigest;

    private BroadcastService(String serviceName) {
        super(serviceName, 2);
    }

    public static BroadcastService getInstance() {
        return instance;
    }

    @Override
    protected void init() {
        this.interfaces = new HashMap<String, BroadcastInterface>();
        this.consumers = new HashMap<String, BroadcastConsumer>();
        this.sender = new BroadcastSender();
        this.receivers = new HashMap<String, BroadcastReceiver>();
        try {
            this.messageDigest = MessageDigest.getInstance(SystemProperties.get("hcjf.net.broadcast.signature.algorithm"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Broadcast signature algorithm not found", e);
        }
        this.fork(this.sender);
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutdown(Service.ShutdownStage stage) {
        this.shuttingDown = true;
        BroadcastSender broadcastSender = this.sender;
        synchronized (broadcastSender) {
            this.sender.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConsumer(BroadcastConsumer consumer) {
        this.consumers.put(consumer.getTaskName(), consumer);
        BroadcastSender broadcastSender = this.sender;
        synchronized (broadcastSender) {
            this.sender.notify();
        }
    }

    @Override
    public void unregisterConsumer(BroadcastConsumer consumer) {
        this.consumers.remove(consumer);
    }

    private synchronized BroadcastInterface getBroadcastInterface(BroadcastConsumer consumer) throws SocketException {
        Integer port = consumer.getPort();
        String interfaceId = BroadcastInterface.createInterfaceId(consumer.getNetInterfaceName(), port);
        BroadcastInterface result = this.interfaces.get(interfaceId);
        if (result == null) {
            Enumeration<NetworkInterface> interfacesEnumeration = NetworkInterface.getNetworkInterfaces();
            boolean done = false;
            while (interfacesEnumeration.hasMoreElements()) {
                NetworkInterface networkInterface = interfacesEnumeration.nextElement();
                if (networkInterface.getName().equals(consumer.getNetInterfaceName())) {
                    for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                        switch (consumer.getIpVersion()) {
                            case "4": {
                                done = interfaceAddress.getAddress() instanceof Inet4Address;
                                break;
                            }
                            case "6": {
                                done = interfaceAddress.getAddress() instanceof Inet6Address;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid ip version: " + consumer.getIpVersion());
                            }
                        }
                        if (!done) continue;
                        result = new BroadcastInterface(consumer.getNetInterfaceName(), port, interfaceAddress.getAddress(), interfaceAddress.getBroadcast());
                        this.interfaces.put(result.getId(), result);
                        BroadcastReceiver broadcastReceiver = new BroadcastReceiver(result);
                        this.receivers.put(result.getId(), broadcastReceiver);
                        this.fork(broadcastReceiver);
                        break;
                    }
                }
                if (!done) continue;
                break;
            }
        }
        return result;
    }

    private String sign(String name, String privateKey, String time) {
        String signature = name + privateKey + time;
        return new String(this.messageDigest.digest(signature.getBytes()));
    }

    private byte[] encode(BroadcastMessage message) {
        BsonDocument document = new BsonDocument();
        Map<String, Introspection.Getter> getters = Introspection.getGetters(message.getClass());
        getters.forEach((K, V) -> {
            try {
                document.put(K, V.get(message));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return BsonEncoder.encode((BsonCollection)document);
    }

    private BroadcastMessage decode(byte[] body) {
        BroadcastMessage message;
        try {
            BsonDocument document = BsonDecoder.decode((byte[])body);
            message = (BroadcastMessage)Class.forName(document.get(IMPLEMENTATION_FIELD_NAME).getAsString()).getConstructor(new Class[0]).newInstance(new Object[0]);
            Map<String, Introspection.Setter> setters = Introspection.getSetters(message.getClass());
            setters.forEach((K, V) -> {
                try {
                    V.set(message, document.get(K).getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return message;
    }

    public static class ShutdownMessage
    extends BroadcastMessage {
    }

    public static class PongMessage
    extends BroadcastMessage {
    }

    public static class PingMessage
    extends BroadcastMessage {
    }

    private static abstract class BroadcastMessage {
        private String taskName;
        private String host;
        private Integer port;
        private Long timestamp;
        private String signature;
        private UUID instanceId;
        private Map<String, Object> customParameters;

        private BroadcastMessage() {
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public String getSignature() {
            return this.signature;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public UUID getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(UUID instanceId) {
            this.instanceId = instanceId;
        }

        public Map<String, Object> getCustomParameters() {
            return this.customParameters;
        }

        public void setCustomParameters(Map<String, Object> customParameters) {
            this.customParameters = customParameters;
        }

        public String getImplementation() {
            return this.getClass().getName();
        }
    }

    private static class BroadcastInterface
    implements Closeable {
        private final String id;
        private final String name;
        private final Integer port;
        private final InetAddress localAddress;
        private final InetAddress broadcastAddress;
        private final DatagramSocket broadcastSocket;

        public BroadcastInterface(String name, Integer port, InetAddress localAddress, InetAddress broadcastAddress) throws SocketException {
            this.id = BroadcastInterface.createInterfaceId(name, port);
            this.name = name;
            this.port = port;
            this.localAddress = localAddress;
            this.broadcastAddress = broadcastAddress;
            this.broadcastSocket = new DatagramSocket(port);
        }

        @Override
        public void close() throws IOException {
            this.broadcastSocket.close();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPort() {
            return this.port;
        }

        public InetAddress getLocalAddress() {
            return this.localAddress;
        }

        public InetAddress getBroadcastAddress() {
            return this.broadcastAddress;
        }

        public DatagramSocket getBroadcastSocket() {
            return this.broadcastSocket;
        }

        public static String createInterfaceId(String name, Integer port) {
            return name + port.toString();
        }
    }

    private class BroadcastReceiver
    implements Runnable {
        private final BroadcastInterface broadcastInterface;

        public BroadcastReceiver(BroadcastInterface broadcastInterface) {
            this.broadcastInterface = broadcastInterface;
        }

        @Override
        public void run() {
            while (!instance.isShuttingDown()) {
                try {
                    byte[] buffer = new byte[SystemProperties.getInteger("hcjf.net.broadcast.receiver.buffer.size").intValue()];
                    DatagramPacket inputPacket = new DatagramPacket(buffer, buffer.length);
                    try {
                        this.broadcastInterface.getBroadcastSocket().receive(inputPacket);
                    }
                    catch (IOException ex) {
                        continue;
                    }
                    BroadcastMessage broadcastMessage = instance.decode(inputPacket.getData());
                    BroadcastConsumer consumer = BroadcastService.this.consumers.get(broadcastMessage.getTaskName());
                    if (broadcastMessage instanceof PingMessage) {
                        if (broadcastMessage.getInstanceId().equals(instanceId)) continue;
                        consumer.onPing((PingMessage)broadcastMessage);
                        Instant instant = Instant.now();
                        LocalTime localTime = LocalTime.now();
                        String hour = Integer.toString(localTime.get(ChronoField.HOUR_OF_DAY));
                        String minute = Integer.toString(localTime.get(ChronoField.MINUTE_OF_HOUR));
                        PongMessage pongMessage = new PongMessage();
                        pongMessage.setTaskName(consumer.getTaskName());
                        pongMessage.setHost(this.broadcastInterface.getLocalAddress().getHostName());
                        pongMessage.setPort(this.broadcastInterface.getPort());
                        pongMessage.setInstanceId(instanceId);
                        pongMessage.setTimestamp(instant.toEpochMilli());
                        pongMessage.setSignature(instance.sign(consumer.getTaskName(), consumer.getPrivateKey(), hour + minute));
                        pongMessage.setCustomParameters((Map)consumer.getPingParameters());
                        byte[] body = instance.encode(pongMessage);
                        DatagramPacket packet = new DatagramPacket(body, body.length, InetAddress.getByName(broadcastMessage.getHost()), this.broadcastInterface.getPort());
                        this.broadcastInterface.getBroadcastSocket().send(packet);
                        continue;
                    }
                    if (broadcastMessage instanceof PongMessage) {
                        consumer.onPong((PongMessage)broadcastMessage);
                        continue;
                    }
                    if (!(broadcastMessage instanceof ShutdownMessage) || broadcastMessage.getHost().equals(this.broadcastInterface.getLocalAddress().getHostName())) continue;
                    consumer.onShutdown((ShutdownMessage)broadcastMessage);
                }
                catch (Exception ex) {
                    Log.w(SystemProperties.get("hcjf.net.broadcast.log.tag"), "Broadcast receiver error", this.broadcastInterface.getName(), ex);
                }
            }
        }
    }

    private class BroadcastSender
    implements Runnable {
        private BroadcastSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BroadcastInterface broadcastInterface;
            String minute;
            String hour;
            LocalTime localTime;
            Instant instant;
            while (!instance.isShuttingDown()) {
                for (BroadcastConsumer consumer : BroadcastService.this.consumers.values()) {
                    try {
                        instant = Instant.now();
                        localTime = LocalTime.now();
                        hour = Integer.toString(localTime.get(ChronoField.HOUR_OF_DAY));
                        minute = Integer.toString(localTime.get(ChronoField.MINUTE_OF_HOUR));
                        broadcastInterface = BroadcastService.this.getBroadcastInterface(consumer);
                        PingMessage pingMessage = new PingMessage();
                        pingMessage.setTaskName(consumer.getTaskName());
                        pingMessage.setHost(broadcastInterface.getLocalAddress().getHostName());
                        pingMessage.setPort(broadcastInterface.getPort());
                        pingMessage.setInstanceId(instanceId);
                        pingMessage.setTimestamp(instant.toEpochMilli());
                        pingMessage.setSignature(instance.sign(consumer.getTaskName(), consumer.getPrivateKey(), hour + minute));
                        pingMessage.setCustomParameters((Map)consumer.getPingParameters());
                        byte[] body = instance.encode(pingMessage);
                        for (int i = broadcastInterface.getPort().intValue(); i < broadcastInterface.getPort() + 10; ++i) {
                            DatagramPacket packet = new DatagramPacket(body, body.length, broadcastInterface.getBroadcastAddress(), i);
                            broadcastInterface.getBroadcastSocket().send(packet);
                        }
                    }
                    catch (Exception ex) {
                        Log.w(SystemProperties.get("hcjf.net.broadcast.log.tag"), ex.getMessage(), new Object[0]);
                    }
                }
                BroadcastSender broadcastSender = this;
                synchronized (broadcastSender) {
                    try {
                        this.wait(SystemProperties.getLong("hcjf.net.broadcast.sender.delay"));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            for (BroadcastConsumer consumer : BroadcastService.this.consumers.values()) {
                try {
                    instant = Instant.now();
                    localTime = LocalTime.now();
                    hour = Integer.toString(localTime.get(ChronoField.HOUR_OF_DAY));
                    minute = Integer.toString(localTime.get(ChronoField.MINUTE_OF_HOUR));
                    broadcastInterface = BroadcastService.this.getBroadcastInterface(consumer);
                    ShutdownMessage shutdownMessage = new ShutdownMessage();
                    shutdownMessage.setTaskName(consumer.getTaskName());
                    shutdownMessage.setHost(broadcastInterface.getLocalAddress().getHostName());
                    shutdownMessage.setPort(broadcastInterface.getPort());
                    shutdownMessage.setInstanceId(instanceId);
                    shutdownMessage.setTimestamp(instant.toEpochMilli());
                    shutdownMessage.setSignature(instance.sign(consumer.getTaskName(), consumer.getPrivateKey(), hour + minute));
                    shutdownMessage.setCustomParameters((Map)consumer.getPingParameters());
                    byte[] body = instance.encode(shutdownMessage);
                    DatagramPacket packet = new DatagramPacket(body, body.length, broadcastInterface.getBroadcastAddress(), broadcastInterface.getPort());
                    broadcastInterface.getBroadcastSocket().send(packet);
                    broadcastInterface.close();
                }
                catch (Exception ex) {
                    Log.w(SystemProperties.get("hcjf.net.broadcast.log.tag"), "", ex, new Object[0]);
                }
            }
        }
    }
}

