/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http.proxy;

import java.net.URL;
import org.hcjf.io.net.http.HttpClient;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.HttpResponse;
import org.hcjf.io.net.http.proxy.HttpProxyRule;
import org.hcjf.io.net.http.proxy.ProxyTask;

public class RedirectionRule
extends HttpProxyRule {
    private final String contextRegex;
    private final URL url;

    public RedirectionRule(String contextRegex, URL url) {
        this.contextRegex = contextRegex;
        this.url = url;
    }

    @Override
    public boolean evaluate(HttpRequest request) {
        return request.getContext().matches(this.contextRegex);
    }

    @Override
    public ProxyTask getTask() {
        return new RedirectionTask();
    }

    private class RedirectionTask
    extends ProxyTask {
        private HttpResponse response;

        private RedirectionTask() {
        }

        @Override
        public HttpResponse execute(HttpRequest request) {
            HttpClient client = new HttpClient(RedirectionRule.this.url);
            client.setHttpMethod(request.getMethod());
            request.getHeaders().stream().filter(header -> !header.getHeaderName().equals("Host")).forEach(client::addHttpHeader);
            return client.request();
        }
    }
}

