/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.evaluators;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.Queryable;
import org.hcjf.layers.query.evaluators.Evaluator;
import org.hcjf.layers.query.model.QueryField;
import org.hcjf.layers.query.model.QueryParameter;

public abstract class BaseEvaluator
implements Evaluator {
    private List<QueryField> evaluatorFields;
    private boolean trueForced;

    public boolean isTrueForced() {
        return this.trueForced;
    }

    public void setTrueForced(boolean trueForced) {
        this.trueForced = trueForced;
    }

    public final List<QueryField> getEvaluatorFields() {
        return this.evaluatorFields;
    }

    public final void setEvaluatorFields(List<QueryField> evaluatorFields) {
        this.evaluatorFields = evaluatorFields;
    }

    protected final Object getProcessedValue(Object currentResultSetElement, Object rawValue, Queryable.DataSource dataSource, Queryable.Consumer consumer) {
        Object result = rawValue;
        if (result != null) {
            if (result instanceof UnprocessedValue) {
                result = ((UnprocessedValue)result).process(dataSource, consumer);
            } else if (result instanceof QueryParameter) {
                result = ((QueryParameter)result).isUnderlying() ? Boolean.valueOf(true) : consumer.get(currentResultSetElement, (QueryParameter)result, dataSource);
            } else if (result instanceof Collection) {
                ArrayList<Object> collectionResult = new ArrayList<Object>();
                for (Object internalValue : (Collection)result) {
                    collectionResult.add(this.getProcessedValue(currentResultSetElement, internalValue, dataSource, consumer));
                }
                result = collectionResult;
            } else if (result.getClass().isArray()) {
                ArrayList<Object> collectionResult = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(result); ++i) {
                    collectionResult.add(this.getProcessedValue(currentResultSetElement, Array.get(result, i), dataSource, consumer));
                }
                result = collectionResult;
            }
        }
        return result;
    }

    public static class QueryValue
    implements UnprocessedValue {
        private final Query query;
        private Collection subQueryResult;

        public QueryValue(Query query) {
            this.query = query;
        }

        public Query getQuery() {
            return this.query;
        }

        @Override
        public Object process(Queryable.DataSource dataSource, Queryable.Consumer consumer) {
            ArrayList<Object> collection;
            if (this.subQueryResult == null) {
                this.subQueryResult = this.query.evaluate(dataSource, consumer);
            }
            if (this.query.getReturnParameters().size() == 1) {
                ArrayList<Object> listResult = new ArrayList<Object>();
                for (Object element : this.subQueryResult) {
                    listResult.add(((JoinableMap)element).values().stream().findFirst().orElse(null));
                }
                collection = listResult;
            } else {
                collection = this.subQueryResult;
            }
            Object result = collection.size() == 0 ? null : (collection.size() == 1 ? collection.iterator().next() : collection);
            return result;
        }
    }

    public static class ReplaceableValue
    implements UnprocessedValue {
        private final Integer place;

        public ReplaceableValue(Integer place) {
            this.place = place;
        }

        @Override
        public Object process(Queryable.DataSource dataSource, Queryable.Consumer consumer) {
            return consumer.getParameter(this.place);
        }

        public final Integer getPlace() {
            return this.place;
        }
    }

    public static interface UnprocessedValue {
        public Object process(Queryable.DataSource var1, Queryable.Consumer var2);
    }
}

