/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.evaluators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hcjf.layers.query.evaluators.And;
import org.hcjf.layers.query.evaluators.BooleanEvaluator;
import org.hcjf.layers.query.evaluators.Distinct;
import org.hcjf.layers.query.evaluators.Equals;
import org.hcjf.layers.query.evaluators.Evaluator;
import org.hcjf.layers.query.evaluators.FieldEvaluator;
import org.hcjf.layers.query.evaluators.GreaterThan;
import org.hcjf.layers.query.evaluators.GreaterThanOrEqual;
import org.hcjf.layers.query.evaluators.In;
import org.hcjf.layers.query.evaluators.Like;
import org.hcjf.layers.query.evaluators.NotIn;
import org.hcjf.layers.query.evaluators.Or;
import org.hcjf.layers.query.evaluators.SmallerThan;
import org.hcjf.layers.query.evaluators.SmallerThanOrEqual;
import org.hcjf.layers.query.evaluators.TrueEvaluator;
import org.hcjf.layers.query.model.QueryField;
import org.hcjf.layers.query.model.QueryFunction;
import org.hcjf.layers.query.model.QueryParameter;
import org.hcjf.layers.query.model.QueryResource;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;

public abstract class EvaluatorCollection {
    protected final Set<Evaluator> evaluators = new LinkedHashSet<Evaluator>();
    private final EvaluatorCollection parent;

    public EvaluatorCollection() {
        this(null);
    }

    public EvaluatorCollection(EvaluatorCollection parent) {
        this.parent = parent;
    }

    public final Set<Evaluator> getEvaluators() {
        return Collections.unmodifiableSet(this.evaluators);
    }

    public boolean hasEvaluators() {
        boolean result = false;
        for (Evaluator evaluator : this.getEvaluators()) {
            if (evaluator instanceof EvaluatorCollection) {
                result = ((EvaluatorCollection)((Object)evaluator)).hasEvaluators();
                if (!result) continue;
                break;
            }
            if (evaluator instanceof TrueEvaluator) continue;
            result = true;
            break;
        }
        return result;
    }

    public final EvaluatorCollection up() {
        EvaluatorCollection result = this.parent;
        if (result == null) {
            result = this;
        }
        return result;
    }

    public void removeEvaluator(Evaluator evaluator) {
        this.evaluators.remove(evaluator);
    }

    public final EvaluatorCollection addEvaluator(Evaluator evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException("Null evaluator");
        }
        if (!this.evaluators.contains(evaluator)) {
            if (this.onAddEvaluator(evaluator)) {
                this.evaluators.add(this.checkEvaluator(evaluator));
            }
        } else {
            Log.w(SystemProperties.get("hcjf.query.log.tag"), "Duplicate evaluator: $s", evaluator);
        }
        return this;
    }

    protected boolean onAddEvaluator(Evaluator evaluator) {
        return true;
    }

    private QueryParameter checkQueryParameter(QueryParameter queryParameter) {
        if (queryParameter instanceof QueryField) {
            QueryField queryField = (QueryField)queryParameter;
            QueryResource queryResource = queryField.getResource();
        } else if (queryParameter instanceof QueryFunction) {
            QueryFunction function = (QueryFunction)queryParameter;
            for (Object functionParameter : function.getParameters()) {
                if (!(functionParameter instanceof QueryParameter)) continue;
                this.checkQueryParameter((QueryParameter)functionParameter);
            }
        }
        return queryParameter;
    }

    protected Evaluator checkEvaluator(Evaluator evaluator) {
        if (evaluator instanceof FieldEvaluator) {
            FieldEvaluator fieldEvaluator = (FieldEvaluator)evaluator;
            if (fieldEvaluator.getLeftValue() instanceof QueryParameter) {
                this.checkQueryParameter((QueryParameter)fieldEvaluator.getLeftValue());
            }
            if (fieldEvaluator.getRightValue() instanceof QueryParameter) {
                this.checkQueryParameter((QueryParameter)fieldEvaluator.getRightValue());
            }
        }
        return evaluator;
    }

    public Collection<Evaluator> getFieldEvaluators(String fieldName, Class<? extends FieldEvaluator> ... evaluatorType) {
        ArrayList<Evaluator> results = new ArrayList<Evaluator>();
        block0: for (Evaluator evaluator : this.getEvaluators()) {
            FieldEvaluator fieldEvaluator;
            if (evaluator instanceof EvaluatorCollection) {
                results.addAll(((EvaluatorCollection)((Object)evaluator)).getFieldEvaluators(fieldName, evaluatorType));
                continue;
            }
            if (!(evaluator instanceof FieldEvaluator) || !(fieldEvaluator = (FieldEvaluator)evaluator).containsReference(fieldName)) continue;
            if (evaluatorType.length == 0) {
                results.add(fieldEvaluator);
                continue;
            }
            for (int i = 0; i < evaluatorType.length; ++i) {
                if (!fieldEvaluator.getClass().isAssignableFrom(evaluatorType[i])) continue;
                results.add(fieldEvaluator);
                continue block0;
            }
        }
        return results;
    }

    public final EvaluatorCollection addBoolean(Object value) {
        return this.addEvaluator(new BooleanEvaluator(value));
    }

    public final EvaluatorCollection distinct(Object leftValue, Object rightValue) {
        return this.addEvaluator(new Distinct(leftValue, rightValue));
    }

    public final EvaluatorCollection equals(Object leftValue, Object rightValue) {
        return this.addEvaluator(new Equals(leftValue, rightValue));
    }

    public final EvaluatorCollection greaterThan(Object leftValue, Object rightValue) {
        return this.addEvaluator(new GreaterThan(leftValue, rightValue));
    }

    public final EvaluatorCollection greaterThanOrEquals(Object leftValue, Object rightValue) {
        return this.addEvaluator(new GreaterThanOrEqual(leftValue, rightValue));
    }

    public final EvaluatorCollection in(Object leftValue, Object rightValue) {
        return this.addEvaluator(new In(leftValue, rightValue));
    }

    public final EvaluatorCollection notIn(Object leftValue, Object rightValue) {
        return this.addEvaluator(new NotIn(leftValue, rightValue));
    }

    public final EvaluatorCollection smallerThan(Object leftValue, Object rightValue) {
        return this.addEvaluator(new SmallerThan(leftValue, rightValue));
    }

    public final EvaluatorCollection smallerThanOrEqual(Object leftValue, Object rightValue) {
        return this.addEvaluator(new SmallerThanOrEqual(leftValue, rightValue));
    }

    public final EvaluatorCollection like(Object leftValue, Object rightValue) {
        return this.addEvaluator(new Like(leftValue, rightValue));
    }

    public final EvaluatorCollection or() {
        Or or = new Or(this);
        this.addEvaluator(or);
        return or;
    }

    public final EvaluatorCollection and() {
        And and = new And(this);
        this.addEvaluator(and);
        return and;
    }
}

