/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.util.ArrayList;
import java.util.List;

public class Bytes {
    public static List<Integer> allIndexOf(byte[] value, byte[] key, int startIndex, int resultSize) {
        if (startIndex < 0) {
            throw new IllegalArgumentException("The start index can not be smaller than 1");
        }
        if (startIndex > value.length) {
            throw new IllegalArgumentException("The start index can not be bigger than the value");
        }
        if (key.length > value.length) {
            throw new IllegalArgumentException("The array can not contain something larger than itself");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        boolean accumulate = false;
        int keyIndex = 0;
        int startKey = 0;
        for (int i = 0; i < value.length; ++i) {
            if (!accumulate) {
                if (value[i] != key[keyIndex]) continue;
                accumulate = true;
                startKey = i;
                ++keyIndex;
                continue;
            }
            if (value[i] == key[keyIndex]) {
                if (++keyIndex != key.length) continue;
                result.add(startKey);
                if (result.size() == resultSize) break;
                startKey = 0;
                accumulate = false;
                keyIndex = 0;
                continue;
            }
            startKey = 0;
            accumulate = false;
            keyIndex = 0;
        }
        return result;
    }

    public static List<Integer> allIndexOf(byte[] value, byte[] key) {
        return Bytes.allIndexOf(value, key, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(byte[] value, byte[] key) {
        List<Integer> indexes = Bytes.allIndexOf(value, key, 0, 1);
        int result = -1;
        if (indexes.size() > 0) {
            result = indexes.get(0);
        }
        return result;
    }

    public static int indexOf(byte[] value, byte[] key, int startIndex) {
        List<Integer> indexes = Bytes.allIndexOf(value, key, startIndex, 1);
        int result = -1;
        if (indexes.size() > 0) {
            result = indexes.get(0);
        }
        return result;
    }

    public static List<byte[]> split(byte[] value, byte[] splitKey) {
        byte[] body;
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        List<Integer> indexes = Bytes.allIndexOf(value, splitKey, 0, Integer.MAX_VALUE);
        Integer startIndex = 0;
        for (Integer index : indexes) {
            body = new byte[index - startIndex];
            if (body.length > 0) {
                System.arraycopy(value, startIndex, body, 0, body.length);
            }
            result.add(body);
            startIndex = index + splitKey.length;
        }
        body = new byte[value.length - startIndex];
        System.arraycopy(value, startIndex, body, 0, body.length);
        result.add(body);
        return result;
    }
}

