/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import java.util.HashMap;
import java.util.Map;
import org.hcjf.layers.Layers;
import org.hcjf.layers.locale.LocaleLayerInterface;

public abstract class Messages {
    private final Map<String, String> defaultMessages = new HashMap<String, String>();

    protected Messages() {
        Layers.publishLayer(this.getLocaleLayerImplementation());
    }

    protected abstract Class getLocaleLayerImplementation();

    protected String getInternalMessage(String messageCode, String localeLayerName, Object ... params) {
        String result = null;
        if (localeLayerName != null) {
            try {
                result = Layers.get(LocaleLayerInterface.class, localeLayerName).translate(messageCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null && (result = this.defaultMessages.get(messageCode)) == null) {
            result = messageCode;
        }
        return String.format(result, params);
    }

    protected void addInternalDefault(String errorCode, String defaultMessage) {
        this.defaultMessages.put(errorCode, defaultMessage);
    }
}

