/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.impl.network;

import java.util.Date;
import org.hcjf.cloud.impl.network.NetworkComponent;

public class Node
extends NetworkComponent
implements Comparable<Node> {
    private String version;
    private String clusterName;
    private String dataCenterName;
    private Date startupDate;
    private String lanAddress;
    private Integer lanPort;
    private String wanAddress;
    private Integer wanPort;
    private Status status = Status.DISCONNECTED;
    private Long lastStatusUpdate = System.currentTimeMillis();
    private Integer connectionAttempts = 0;
    private boolean localNode;

    public synchronized String getLanId() {
        String result = null;
        if (this.lanAddress != null && !this.lanAddress.isEmpty()) {
            result = Node.createNodeHash(this.lanAddress, this.lanPort);
        }
        return result;
    }

    public synchronized String getWanId() {
        String result = null;
        if (this.wanAddress != null && !this.wanAddress.isEmpty()) {
            result = Node.createNodeHash(this.wanAddress, this.wanPort);
        }
        return result;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getDataCenterName() {
        return this.dataCenterName;
    }

    public void setDataCenterName(String dataCenterName) {
        this.dataCenterName = dataCenterName;
    }

    public Date getStartupDate() {
        return this.startupDate;
    }

    public void setStartupDate(Date startupDate) {
        this.startupDate = startupDate;
    }

    public String getLanAddress() {
        return this.lanAddress;
    }

    public void setLanAddress(String lanAddress) {
        this.lanAddress = lanAddress;
    }

    public Integer getLanPort() {
        return this.lanPort;
    }

    public void setLanPort(Integer lanPort) {
        this.lanPort = lanPort;
    }

    public String getWanAddress() {
        return this.wanAddress;
    }

    public void setWanAddress(String wanAddress) {
        this.wanAddress = wanAddress;
    }

    public Integer getWanPort() {
        return this.wanPort;
    }

    public void setWanPort(Integer wanPort) {
        this.wanPort = wanPort;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.lastStatusUpdate = System.currentTimeMillis();
    }

    public Long getLastStatusUpdate() {
        return this.lastStatusUpdate;
    }

    public Integer getConnectionAttempts() {
        return this.connectionAttempts;
    }

    public void setConnectionAttempts(Integer connectionAttempts) {
        this.connectionAttempts = connectionAttempts;
    }

    public boolean isLocalNode() {
        return this.localNode;
    }

    public void setLocalNode(boolean localNode) {
        this.localNode = localNode;
    }

    public static String createNodeHash(String remoteHost, Integer port) {
        return remoteHost + ":" + port;
    }

    @Override
    public int compareTo(Node node) {
        return this.getLanId().compareTo(node.getLanId());
    }

    public static enum Status {
        LOST,
        DISCONNECTED,
        CONNECTED,
        CONNECTING;

    }
}

