/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.messages;

import java.io.IOException;
import org.hcjf.bson.BsonCollection;
import org.hcjf.bson.BsonDecoder;
import org.hcjf.bson.BsonDocument;
import org.hcjf.bson.BsonEncoder;
import org.hcjf.io.net.NetClient;
import org.hcjf.io.net.NetPackage;
import org.hcjf.io.net.NetService;
import org.hcjf.io.net.NetSession;
import org.hcjf.io.net.messages.EncryptedMessage;
import org.hcjf.io.net.messages.Message;
import org.hcjf.io.net.messages.MessageBuffer;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Cryptography;
import org.hcjf.utils.bson.BsonParcelable;

public abstract class MessagesNode<S extends NetSession>
extends NetClient<S, MessageBuffer> {
    private MessageBuffer messageBuffer;
    private Boolean connected = null;
    private final Cryptography cryptography;

    public MessagesNode(String host, Integer port) {
        this(host, port, (Cryptography)null);
    }

    public MessagesNode(String host, Integer port, Cryptography cryptography) {
        super(host, port, NetService.TransportLayerProtocol.TCP);
        this.cryptography = cryptography;
    }

    public boolean isEncrypted() {
        return this.cryptography != null;
    }

    @Override
    protected final byte[] encode(MessageBuffer payLoad) {
        return payLoad.getBytes();
    }

    @Override
    protected final synchronized MessageBuffer decode(NetPackage netPackage) {
        if (this.messageBuffer == null) {
            this.messageBuffer = new MessageBuffer();
        }
        this.messageBuffer.append(netPackage.getPayload());
        return this.messageBuffer;
    }

    public final void send(Message message) throws IOException {
        MessageBuffer buffer = new MessageBuffer();
        buffer.append(this.isEncrypted() ? this.encrypt(message) : message);
        this.write(this.getSession(), buffer, false);
    }

    public final synchronized boolean waitForConnect() {
        if (this.connected == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.connected;
    }

    @Override
    protected final synchronized void onConnect(S session, MessageBuffer payLoad, NetPackage netPackage) {
        this.connected = true;
        this.notifyAll();
    }

    @Override
    protected final synchronized void onConnectFail() {
        this.connected = false;
        this.notifyAll();
    }

    public final boolean isConnected() {
        return this.connected;
    }

    @Override
    protected void onDisconnect(S session, NetPackage netPackage) {
        this.connected = false;
    }

    @Override
    protected final synchronized void onRead(S session, MessageBuffer payLoad, NetPackage netPackage) {
        if (payLoad.isComplete()) {
            for (Message message : payLoad.getMessages()) {
                try {
                    this.onRead(session, this.isEncrypted() ? this.decrypt((EncryptedMessage)message) : message);
                }
                catch (ClassCastException ex) {
                    Log.w(SystemProperties.get("hcjf.net.messages.log.tag"), "Incoming not encrypted message and the server has a cryptography policy", new Object[0]);
                }
            }
            this.messageBuffer = payLoad.getLeftover();
        }
    }

    protected EncryptedMessage encrypt(Message message) {
        EncryptedMessage encryptedMessage = new EncryptedMessage();
        encryptedMessage.setId(message.getId());
        encryptedMessage.setSessionId(message.getSessionId());
        encryptedMessage.setTimestamp(message.getTimestamp());
        encryptedMessage.setEncrypedData(this.cryptography.encrypt(BsonEncoder.encode((BsonCollection)message.toBson())));
        return encryptedMessage;
    }

    protected Message decrypt(EncryptedMessage encryptedMessage) {
        BsonDocument document = BsonDecoder.decode((byte[])this.cryptography.decrypt(encryptedMessage.getEncrypedData()));
        return (Message)BsonParcelable.Builder.create(document);
    }

    protected abstract void onRead(S var1, Message var2);
}

