/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.functions.BaseQueryFunctionLayer;
import org.hcjf.layers.query.functions.QueryFunctionLayerInterface;
import org.hcjf.properties.SystemProperties;

public class DateQueryFunctionLayer
extends BaseQueryFunctionLayer
implements QueryFunctionLayerInterface {
    private static final String NOW = "now";
    private static final String GET_YEAR = "getYear";
    private static final String GET_MONTH = "getMonth";
    private static final String GET_MONTH_NUMBER = "getMonthNumber";
    private static final String GET_DAY_OF_MONTH = "getDayOfMonth";
    private static final String GET_DAY_OF_WEEK = "getDayOfWeek";
    private static final String GET_DAY_OF_YEAR = "getDayOfYear";
    private static final String GET_HOUR = "getHour";
    private static final String GET_MINUTE = "getMinute";
    private static final String GET_SECOND = "getSecond";
    private static final String GET_MILLISECOND_UNIX_EPOCH = "getMillisecondUnixEpoch";
    private static final String GET_NANO = "getNano";
    private static final String PLUS_YEARS = "plusYears";
    private static final String PLUS_MONTHS = "plusMonths";
    private static final String PLUS_DAYS = "plusDays";
    private static final String PLUS_HOURS = "plusHours";
    private static final String PLUS_MINUTES = "plusMinutes";
    private static final String PLUS_SECONDS = "plusSeconds";
    private static final String MINUS_YEARS = "minusYears";
    private static final String MINUS_MONTHS = "minusMonths";
    private static final String MINUS_DAYS = "minusDays";
    private static final String MINUS_HOURS = "minusHours";
    private static final String MINUS_MINUTES = "minusMinutes";
    private static final String MINUS_SECONDS = "minusSeconds";
    private static final String PERIOD_IN_NANOS = "periodInNanos";
    private static final String PERIOD_IN_MILLISECONDS = "periodInMilliseconds";
    private static final String PERIOD_IN_SECONDS = "periodInSeconds";
    private static final String PERIOD_IN_MINUTES = "periodInMinutes";
    private static final String PERIOD_IN_HOURS = "periodInHours";
    private static final String PERIOD_IN_DAYS = "periodInDays";
    private static final String DATE_FORMAT = "dateFormat";
    private static final String PARSE_DATE = "parseDate";
    private static final String TO_DATE = "toDate";
    private final Map<String, DateTimeFormatter> dateTimeFormatterCache = new HashMap<String, DateTimeFormatter>();

    public DateQueryFunctionLayer() {
        super(SystemProperties.get("hcjf.query.function.date.name"));
        this.addFunctionName(NOW);
        this.addFunctionName(GET_YEAR);
        this.addFunctionName(GET_MONTH);
        this.addFunctionName(GET_MONTH_NUMBER);
        this.addFunctionName(GET_DAY_OF_MONTH);
        this.addFunctionName(GET_DAY_OF_WEEK);
        this.addFunctionName(GET_DAY_OF_YEAR);
        this.addFunctionName(GET_HOUR);
        this.addFunctionName(GET_MINUTE);
        this.addFunctionName(GET_SECOND);
        this.addFunctionName(GET_MILLISECOND_UNIX_EPOCH);
        this.addFunctionName(GET_NANO);
        this.addFunctionName(PLUS_YEARS);
        this.addFunctionName(PLUS_MONTHS);
        this.addFunctionName(PLUS_DAYS);
        this.addFunctionName(PLUS_HOURS);
        this.addFunctionName(PLUS_MINUTES);
        this.addFunctionName(PLUS_SECONDS);
        this.addFunctionName(MINUS_YEARS);
        this.addFunctionName(MINUS_MONTHS);
        this.addFunctionName(MINUS_DAYS);
        this.addFunctionName(MINUS_HOURS);
        this.addFunctionName(MINUS_MINUTES);
        this.addFunctionName(MINUS_SECONDS);
        this.addFunctionName(PERIOD_IN_NANOS);
        this.addFunctionName(PERIOD_IN_MILLISECONDS);
        this.addFunctionName(PERIOD_IN_SECONDS);
        this.addFunctionName(PERIOD_IN_MINUTES);
        this.addFunctionName(PERIOD_IN_HOURS);
        this.addFunctionName(PERIOD_IN_DAYS);
        this.addFunctionName(DATE_FORMAT);
        this.addFunctionName(PARSE_DATE);
        this.addFunctionName(TO_DATE);
    }

    @Override
    public Object evaluate(String functionName, Object ... parameters) {
        Object result;
        switch (functionName) {
            case "now": {
                if (parameters.length == 0) {
                    result = Date.from(ZonedDateTime.now().toInstant());
                    break;
                }
                if (parameters.length == 1) {
                    ZoneId zoneId = ZoneId.of((String)parameters[0]);
                    result = Date.from(ZonedDateTime.now(zoneId).toInstant());
                    break;
                }
                throw new HCJFRuntimeException("Illegal parameters length, now() or now((String)zoneId)", new Object[0]);
            }
            case "getYear": {
                result = this.getZonedDateTimeFromDate(parameters).getYear();
                break;
            }
            case "getMonth": {
                result = this.getZonedDateTimeFromDate(parameters).getMonth();
                break;
            }
            case "getMonthNumber": {
                result = this.getZonedDateTimeFromDate(parameters).getMonthValue();
                break;
            }
            case "getDayOfMonth": {
                result = this.getZonedDateTimeFromDate(parameters).getDayOfMonth();
                break;
            }
            case "getDayOfWeek": {
                result = this.getZonedDateTimeFromDate(parameters).getDayOfWeek();
                break;
            }
            case "getDayOfYear": {
                result = this.getZonedDateTimeFromDate(parameters).getDayOfYear();
                break;
            }
            case "getHour": {
                result = this.getZonedDateTimeFromDate(parameters).getHour();
                break;
            }
            case "getMinute": {
                result = this.getZonedDateTimeFromDate(parameters).getMinute();
                break;
            }
            case "getSecond": {
                result = this.getZonedDateTimeFromDate(parameters).getSecond();
                break;
            }
            case "getNano": {
                result = this.getZonedDateTimeFromDate(parameters).getNano();
                break;
            }
            case "getMillisecondUnixEpoch": {
                result = Date.from(this.getZonedDateTimeFromDate(parameters).toInstant()).getTime();
                break;
            }
            case "plusYears": {
                result = this.getZonedDateTimeFromDate(1, parameters).plusYears((Long)parameters[parameters.length - 1]);
                break;
            }
            case "plusMonths": {
                result = this.getZonedDateTimeFromDate(1, parameters).plusMonths((Long)parameters[parameters.length - 1]);
                break;
            }
            case "plusDays": {
                result = this.getZonedDateTimeFromDate(1, parameters).plusDays((Long)parameters[parameters.length - 1]);
                break;
            }
            case "plusHours": {
                result = this.getZonedDateTimeFromDate(1, parameters).plusHours((Long)parameters[parameters.length - 1]);
                break;
            }
            case "plusMinutes": {
                result = this.getZonedDateTimeFromDate(1, parameters).plusMinutes((Long)parameters[parameters.length - 1]);
                break;
            }
            case "plusSeconds": {
                result = this.getZonedDateTimeFromDate(1, parameters).plusSeconds((Long)parameters[parameters.length - 1]);
                break;
            }
            case "minusYears": {
                result = this.getZonedDateTimeFromDate(1, parameters).minusYears((Long)parameters[parameters.length - 1]);
                break;
            }
            case "minusMonths": {
                result = this.getZonedDateTimeFromDate(1, parameters).minusMonths((Long)parameters[parameters.length - 1]);
                break;
            }
            case "minusDays": {
                result = this.getZonedDateTimeFromDate(1, parameters).minusDays((Long)parameters[parameters.length - 1]);
                break;
            }
            case "minusHours": {
                result = this.getZonedDateTimeFromDate(1, parameters).minusHours((Long)parameters[parameters.length - 1]);
                break;
            }
            case "minusMinutes": {
                result = this.getZonedDateTimeFromDate(1, parameters).minusMinutes((Long)parameters[parameters.length - 1]);
                break;
            }
            case "minusSeconds": {
                result = this.getZonedDateTimeFromDate(1, parameters).minusSeconds((Long)parameters[parameters.length - 1]);
                break;
            }
            case "periodInNanos": {
                result = this.getDuration(parameters).toNanos();
                break;
            }
            case "periodInMilliseconds": {
                result = this.getDuration(parameters).toMillis();
                break;
            }
            case "periodInSeconds": {
                result = this.getDuration(parameters).toMillis() / 1000L;
                break;
            }
            case "periodInMinutes": {
                result = this.getDuration(parameters).toMinutes();
                break;
            }
            case "periodInHours": {
                result = this.getDuration(parameters).toHours();
                break;
            }
            case "periodInDays": {
                result = this.getDuration(parameters).toDays();
                break;
            }
            case "toDate": {
                Object param = this.getParameter(0, parameters);
                if (param instanceof Number) {
                    result = new Date(((Number)param).longValue());
                    break;
                }
                if (param instanceof ZonedDateTime) {
                    result = Date.from(((ZonedDateTime)param).toInstant());
                    break;
                }
                throw new HCJFRuntimeException("Illegal argument for 'toDate' function", new Object[0]);
            }
            case "parseDate": {
                if (parameters.length >= 2) {
                    try {
                        result = new SimpleDateFormat((String)parameters[0]).parse((String)parameters[1]);
                        break;
                    }
                    catch (Exception ex) {
                        throw new HCJFRuntimeException("Date parse fail", (Throwable)ex, new Object[0]);
                    }
                }
                throw new HCJFRuntimeException("Illegal parameters length, parseDate((String)pattern, (String)vale)", new Object[0]);
            }
            case "dateFormat": {
                if (parameters.length >= 2) {
                    String pattern = (String)parameters[parameters.length - 1];
                    ZonedDateTime zonedDateTime = this.getZonedDateTimeFromDate(1, parameters);
                    result = this.getDateFormatter(pattern).format(zonedDateTime);
                    break;
                }
                throw new HCJFRuntimeException("Illegal parameters length", new Object[0]);
            }
            default: {
                throw new HCJFRuntimeException("Date function not found: %s", functionName);
            }
        }
        return result;
    }

    private synchronized DateTimeFormatter getDateFormatter(String pattern) {
        DateTimeFormatter formatter = this.dateTimeFormatterCache.get(pattern);
        if (formatter == null) {
            formatter = DateTimeFormatter.ofPattern(pattern);
            this.dateTimeFormatterCache.put(pattern, formatter);
        }
        return formatter;
    }

    private ZonedDateTime getZonedDateTimeFromDate(int skipping, Object ... parameters) {
        Object[] subSet = new Object[parameters.length - skipping];
        System.arraycopy(parameters, 0, subSet, 0, subSet.length);
        return this.getZonedDateTimeFromDate(subSet);
    }

    private ZonedDateTime getZonedDateTimeFromDate(Object ... parameters) {
        ZonedDateTime result;
        if (parameters.length == 1) {
            result = ZonedDateTime.ofInstant(((Date)this.getParameter(0, parameters)).toInstant(), ZoneId.systemDefault());
        } else if (parameters.length == 2) {
            ZoneId zoneId = ZoneId.of((String)this.getParameter(1, parameters));
            result = ZonedDateTime.ofInstant(((Date)this.getParameter(0, parameters)).toInstant(), zoneId);
        } else {
            throw new HCJFRuntimeException("Illegal parameters length", new Object[0]);
        }
        return result;
    }

    private Duration getDuration(Object ... parameters) {
        Duration result;
        if (parameters.length == 1) {
            result = Duration.between(((Date)this.getParameter(0, parameters)).toInstant(), Instant.now());
        } else if (parameters.length == 2) {
            result = Duration.between(((Date)this.getParameter(0, parameters)).toInstant(), ((Date)this.getParameter(1, parameters)).toInstant());
        } else {
            throw new HCJFRuntimeException("Illegal parameters length", new Object[0]);
        }
        return result;
    }
}

