/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.impl.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DistributedLayer {
    private final Class layerInterface;
    private final String layerName;
    private final List<UUID> serviceEndPoints;
    private final Map<UUID, ResponseAverage> invocationCounter;
    private String regex;

    public DistributedLayer(Class layerInterface, String layerName) {
        this.layerInterface = layerInterface;
        this.layerName = layerName;
        this.serviceEndPoints = new ArrayList<UUID>();
        this.invocationCounter = new HashMap<UUID, ResponseAverage>();
    }

    public Class getLayerInterface() {
        return this.layerInterface;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public synchronized UUID getServiceToInvoke() {
        UUID result = null;
        if (this.serviceEndPoints.size() > 0) {
            result = this.serviceEndPoints.get(0);
            this.serviceEndPoints.add(result);
        }
        return result;
    }

    public synchronized void addServiceEndPoint(UUID serviceEndPointId) {
        this.serviceEndPoints.add(serviceEndPointId);
        this.invocationCounter.put(serviceEndPointId, new ResponseAverage());
    }

    public synchronized void removeServiceEndPoint(UUID serviceEndPointId) {
        this.serviceEndPoints.remove(serviceEndPointId);
        this.invocationCounter.remove(serviceEndPointId);
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    private class ResponseAverage {
        private long accumulator = 0L;
        private int size = 1;

        public void add(long value) {
            if (this.size == 100) {
                this.accumulator /= (long)this.size;
                this.size = 1;
            }
            this.accumulator += value;
            ++this.size;
        }

        public long get() {
            return this.accumulator / (long)this.size;
        }
    }
}

