/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net;

import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.HashSet;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.TtlSet;

public final class InetPortProvider {
    private static final Integer MAX_PORT_NUMBER = 65535;
    private static final TtlSet<Integer> reservedTcpPorts = new TtlSet(new HashSet(), SystemProperties.getLong("hcjf.net.port.provider.time.windows.size"));
    private static final TtlSet<Integer> reservedUdpPorts = new TtlSet(new HashSet(), SystemProperties.getLong("hcjf.net.port.provider.time.windows.size"));

    public static synchronized Integer getTcpPort(Integer basePort) {
        Integer result = basePort;
        while (reservedTcpPorts.contains(basePort) || !InetPortProvider.probeTcpPort(result)) {
            Integer n = result;
            result = result + 1;
            if (result <= MAX_PORT_NUMBER) continue;
            throw new IllegalStateException("There aren't any port available from base port " + basePort);
        }
        reservedTcpPorts.add(result);
        return result;
    }

    private static boolean probeTcpPort(Integer port) {
        boolean result = true;
        try {
            ServerSocket serverSocket = new ServerSocket(port);
            serverSocket.close();
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static synchronized Integer getUdpPort(Integer basePort) {
        Integer result = basePort;
        while (reservedUdpPorts.contains(basePort) || !InetPortProvider.probeUdpPort(result)) {
            Integer n = result;
            result = result + 1;
            if (result <= MAX_PORT_NUMBER) continue;
            throw new IllegalStateException("There aren't any port available from base port " + basePort);
        }
        reservedTcpPorts.add(result);
        return result;
    }

    private static boolean probeUdpPort(Integer port) {
        boolean result = true;
        try {
            DatagramSocket datagramSocket = new DatagramSocket(port);
            datagramSocket.close();
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }
}

