/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.hcjf.encoding.MimeType;
import org.hcjf.errors.Errors;
import org.hcjf.io.net.http.Context;
import org.hcjf.io.net.http.HttpHeader;
import org.hcjf.io.net.http.HttpRequest;
import org.hcjf.io.net.http.HttpResponse;
import org.hcjf.io.net.http.HttpResponseCode;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;

public class FolderContext
extends Context {
    private final Path baseFolder;
    private final String name;
    private String defaultFile;
    private final String[] names;
    private final MessageDigest messageDigest;

    public FolderContext(String name, Path baseFolder, String defaultFile) {
        super("^/" + name + ".*");
        if (baseFolder == null) {
            throw new NullPointerException(Errors.getMessage("org.hcjf.io.net.http@1", new Object[0]));
        }
        if (!baseFolder.toFile().exists()) {
            throw new IllegalArgumentException(Errors.getMessage("org.hcjf.io.net.http@2", new Object[0]));
        }
        if (this.verifyJatFormat(baseFolder)) {
            try {
                baseFolder = this.unzipJar(baseFolder);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to unzip jar file", e);
            }
        }
        if (this.verifyZipFormat(baseFolder)) {
            try {
                baseFolder = this.unzip(baseFolder);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to unzip file", e);
            }
        }
        if (defaultFile != null) {
            File file = baseFolder.resolve(defaultFile).toFile();
            if (file.exists()) {
                if (file.isDirectory()) {
                    baseFolder = baseFolder.resolve(defaultFile);
                } else {
                    this.defaultFile = defaultFile;
                }
            } else {
                Log.w(SystemProperties.get("hcjf.net.http.folder.log.tag"), "Default file doesn't exist %s", defaultFile);
            }
        }
        this.name = name;
        this.baseFolder = baseFolder;
        this.names = name.split("/");
        try {
            this.messageDigest = MessageDigest.getInstance(SystemProperties.get("hcjf.net.http.default.file.checksum.algorithm"));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(Errors.getMessage("org.hcjf.io.net.http@9", new Object[0]), ex);
        }
    }

    public FolderContext(String name, Path baseFolder) {
        this(name, baseFolder, null);
    }

    private boolean verifyZipFormat(Path path) {
        boolean result = false;
        try {
            new ZipFile(path.toFile()).getName();
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private boolean verifyJatFormat(Path path) {
        boolean result = false;
        try {
            new JarFile(path.toFile()).getName();
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private Path unzip(Path zipFilePath) throws IOException {
        int errors;
        ZipFile zipFile = new ZipFile(zipFilePath.toFile());
        Path tempFolder = Files.createTempDirectory(SystemProperties.getPath("hcjf.net.http.folder.zip.container"), SystemProperties.get("hcjf.net.http.folder.zip.temp.prefix"), new FileAttribute[0]);
        tempFolder.toFile().deleteOnExit();
        TreeSet<String> processedNames = new TreeSet<String>();
        do {
            errors = 0;
            Enumeration<? extends ZipEntry> entryEnumeration = zipFile.entries();
            while (entryEnumeration.hasMoreElements()) {
                ZipEntry zipEntry;
                block17: {
                    zipEntry = entryEnumeration.nextElement();
                    if (processedNames.contains(zipEntry.getName())) continue;
                    try {
                        if (zipEntry.isDirectory()) {
                            Files.createDirectory(tempFolder.resolve(zipEntry.getName()), new FileAttribute[0]);
                            break block17;
                        }
                        Path file = Files.createFile(tempFolder.resolve(zipEntry.getName()), new FileAttribute[0]);
                        try (InputStream inputStream = zipFile.getInputStream(zipEntry);
                             FileOutputStream fileOutputStream = new FileOutputStream(file.toFile());){
                            byte[] buffer = new byte[2048];
                            int readSize = inputStream.read(buffer);
                            while (readSize >= 0) {
                                fileOutputStream.write(buffer, 0, readSize);
                                fileOutputStream.flush();
                                readSize = inputStream.read(buffer);
                            }
                        }
                    }
                    catch (IOException ex) {
                        ++errors;
                    }
                }
                processedNames.add(zipEntry.getName());
            }
        } while (errors > 0);
        return tempFolder;
    }

    private Path unzipJar(Path jarFilePath) throws IOException {
        int errors;
        JarFile jarFile = new JarFile(jarFilePath.toFile());
        Path tempFolder = Files.createTempDirectory(SystemProperties.getPath("hcjf.net.http.folder.jar.container"), SystemProperties.get("hcjf.net.http.folder.jar.temp.prefix"), new FileAttribute[0]);
        tempFolder.toFile().deleteOnExit();
        TreeSet<String> processedNames = new TreeSet<String>();
        do {
            errors = 0;
            Enumeration<JarEntry> entryEnumeration = jarFile.entries();
            while (entryEnumeration.hasMoreElements()) {
                ZipEntry zipEntry;
                block17: {
                    zipEntry = entryEnumeration.nextElement();
                    if (processedNames.contains(zipEntry.getName())) continue;
                    try {
                        if (zipEntry.isDirectory()) {
                            Files.createDirectory(tempFolder.resolve(zipEntry.getName()), new FileAttribute[0]);
                            break block17;
                        }
                        Path file = Files.createFile(tempFolder.resolve(zipEntry.getName()), new FileAttribute[0]);
                        try (InputStream inputStream = jarFile.getInputStream(zipEntry);
                             FileOutputStream fileOutputStream = new FileOutputStream(file.toFile());){
                            byte[] buffer = new byte[2048];
                            int readSize = inputStream.read(buffer);
                            while (readSize >= 0) {
                                fileOutputStream.write(buffer, 0, readSize);
                                fileOutputStream.flush();
                                readSize = inputStream.read(buffer);
                            }
                        }
                    }
                    catch (IOException ex) {
                        ++errors;
                    }
                }
                processedNames.add(zipEntry.getName());
            }
        } while (errors > 0);
        return tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final HttpResponse onContext(HttpRequest request) {
        List<String> elements = request.getPathParts();
        for (String forbidden : SystemProperties.getList("hcjf.net.http.folder.forbidden.characters")) {
            for (String element : elements) {
                if (!element.contains(forbidden)) continue;
                throw new IllegalArgumentException(Errors.getMessage("org.hcjf.io.net.http@3", forbidden, request.getContext()));
            }
        }
        Path path = this.baseFolder.toAbsolutePath();
        boolean emptyElement = true;
        for (String element : elements) {
            if (element.isEmpty() || Arrays.binarySearch(this.names, element) >= 0) continue;
            path = path.resolve(element);
            emptyElement = false;
        }
        if (emptyElement && this.defaultFile != null) {
            path = path.resolve(this.defaultFile);
        }
        HttpResponse response = new HttpResponse();
        File file = path.toFile();
        boolean retry = true;
        while (retry) {
            retry = false;
            if (file.exists()) {
                String[] nameExtension;
                String checksum;
                byte[] body;
                Object document;
                if (file.isDirectory()) {
                    StringBuilder list = new StringBuilder();
                    for (File subFile : file.listFiles()) {
                        list.append(String.format(SystemProperties.get("hcjf.net.http.folder.default.html.row"), path.relativize(this.baseFolder).resolve(request.getContext()).resolve(subFile.getName()).toString(), subFile.getName()));
                    }
                    String htmlBody = String.format(SystemProperties.get("hcjf.net.http.folder.default.html.body"), list.toString());
                    document = String.format(SystemProperties.get("hcjf.net.http.folder.default.html.document"), file.getName(), htmlBody);
                    byte[] body2 = ((String)document).getBytes();
                    response.addHeader(new HttpHeader("Content-Length", Integer.toString(body2.length)));
                    response.addHeader(new HttpHeader("Content-Type", "html"));
                    response.setResponseCode(HttpResponseCode.OK);
                    response.setBody(body2);
                    continue;
                }
                try {
                    body = Files.readAllBytes(file.toPath());
                    document = this;
                    synchronized (document) {
                        checksum = new String(Base64.getEncoder().encode(this.messageDigest.digest(body)));
                        this.messageDigest.reset();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(Errors.getMessage("org.hcjf.io.net.http@4", Paths.get(request.getContext(), file.getName())), ex);
                }
                Integer responseCode = HttpResponseCode.OK;
                HttpHeader ifNonMatch = request.getHeader("If-None-Match");
                if (ifNonMatch != null && checksum.equals(ifNonMatch.getHeaderValue())) {
                    responseCode = HttpResponseCode.NOT_MODIFIED;
                }
                String extension = (nameExtension = file.getName().split(SystemProperties.get("hcjf.net.http.folder.file.extension.regex"))).length == 2 ? nameExtension[1] : "bin";
                response.setResponseCode(responseCode);
                MimeType mimeType = MimeType.fromSuffix(extension);
                response.addHeader(new HttpHeader("Content-Type", mimeType == null ? "bin" : mimeType.toString()));
                response.addHeader(new HttpHeader("ETag", checksum));
                response.addHeader(new HttpHeader("Last-Modified", SystemProperties.getDateFormat("hcjf.net.http.response.date.header.format.value").format(new Date(file.lastModified()))));
                if (!responseCode.equals(HttpResponseCode.OK)) continue;
                HttpHeader acceptEncodingHeader = request.getHeader("Accept-Encoding");
                if (acceptEncodingHeader != null) {
                    boolean notAcceptable = true;
                    for (String group : acceptEncodingHeader.getGroups()) {
                        if (group.equalsIgnoreCase("gzip") || group.equalsIgnoreCase("deflate")) {
                            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                                try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(out);){
                                    gzipOutputStream.write(body);
                                    gzipOutputStream.flush();
                                    gzipOutputStream.finish();
                                    body = out.toByteArray();
                                    response.addHeader(new HttpHeader("Content-Encoding", "gzip"));
                                    notAcceptable = false;
                                }
                                break;
                            }
                            catch (Exception ex) {
                                Log.w(SystemProperties.get("hcjf.net.http.folder.log.tag"), "Zip file process fail", ex, new Object[0]);
                                continue;
                            }
                        }
                        if (!group.equalsIgnoreCase("identity")) continue;
                        response.addHeader(new HttpHeader("Content-Encoding", "identity"));
                        notAcceptable = false;
                        break;
                    }
                    if (notAcceptable) {
                        response.setResponseCode(HttpResponseCode.NOT_ACCEPTABLE);
                    }
                }
                if (!responseCode.equals(HttpResponseCode.OK)) continue;
                response.addHeader(new HttpHeader("Content-Length", Integer.toString(body.length)));
                response.setBody(body);
                continue;
            }
            retry = this.onNonExistentFile(request, file);
        }
        return response;
    }

    public boolean onNonExistentFile(HttpRequest request, File file) {
        throw new IllegalArgumentException(Errors.getMessage("org.hcjf.io.net.http@5", request.getContext()));
    }
}

