/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http;

import java.util.HashMap;
import java.util.Map;

public interface HttpResponseCode {
    public static final Integer CONTINUE = 100;
    public static final Integer SWITCHING_PROTOCOLS = 101;
    public static final Integer OK = 200;
    public static final Integer CREATED = 201;
    public static final Integer ACCEPTED = 202;
    public static final Integer NON_AUTHORITATIVE_INFOTMATION = 203;
    public static final Integer NO_CONTENT = 204;
    public static final Integer RESET_CONTENT = 205;
    public static final Integer PARTIAL_CONTENT = 206;
    public static final Integer MULTIPLE_CHOICES = 300;
    public static final Integer MOVED_PERMANENTLY = 301;
    public static final Integer FOUND = 302;
    public static final Integer SEE_OTHER = 303;
    public static final Integer NOT_MODIFIED = 304;
    public static final Integer USE_PROXY = 305;
    public static final Integer TEMPORARY_REDIRECT = 307;
    public static final Integer BAD_REQUEST = 400;
    public static final Integer UNAUTHORIZED = 401;
    public static final Integer PAYMENT_REQUIRED = 402;
    public static final Integer FORBIDDEN = 403;
    public static final Integer NOT_FOUND = 404;
    public static final Integer METHOD_NOT_ALLOWED = 405;
    public static final Integer NOT_ACCEPTABLE = 406;
    public static final Integer REQUEST_TIMEOUT = 408;
    public static final Integer CONFLICT = 409;
    public static final Integer GONE = 410;
    public static final Integer LENGTH_REQUIRED = 411;
    public static final Integer PRECONDITION_FAILED = 412;
    public static final Integer REQUEST_ENTITY_TOO_LARGE = 413;
    public static final Integer REQUEST_URI_TOO_LARGE = 414;
    public static final Integer UNSUPPORTED_MEDIA_TYPE = 415;
    public static final Integer REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final Integer EXPECTATION_FAILED = 417;
    public static final Integer INTERNAL_SERVER_ERROR = 500;
    public static final Integer NOT_IMPLEMENTED = 501;
    public static final Integer BAD_GATEWAY = 502;
    public static final Integer SERVICE_UNAVAILABLE = 503;
    public static final Integer GATEWAY_TIMEOUT = 504;
    public static final Integer HTTP_VERSION_NOT_SUPPORTED = 505;

    public static final class DefaultPhrase {
        private static final Map<Integer, String> phrases = new HashMap<Integer, String>();

        public static String getDefaultPhrase(Integer httpResponseCode) {
            return phrases.get(httpResponseCode);
        }

        static {
            phrases.put(CONTINUE, "Continue");
            phrases.put(SWITCHING_PROTOCOLS, "Switching protocols");
            phrases.put(OK, "Ok");
            phrases.put(CREATED, "Created");
            phrases.put(ACCEPTED, "Accepted");
            phrases.put(NON_AUTHORITATIVE_INFOTMATION, "Non authoritative information");
            phrases.put(NO_CONTENT, "No content");
            phrases.put(RESET_CONTENT, "Reset content");
            phrases.put(PARTIAL_CONTENT, "Partial content");
            phrases.put(MULTIPLE_CHOICES, "Multiple choices");
            phrases.put(MOVED_PERMANENTLY, "Moved permanently");
            phrases.put(FOUND, "Found");
            phrases.put(SEE_OTHER, "See other");
            phrases.put(NOT_MODIFIED, "Not modified");
            phrases.put(USE_PROXY, "Use proxy");
            phrases.put(TEMPORARY_REDIRECT, "Temporary redirect");
            phrases.put(BAD_REQUEST, "Bad request");
            phrases.put(UNAUTHORIZED, "Unauthorized");
            phrases.put(PAYMENT_REQUIRED, "Payment required");
            phrases.put(FORBIDDEN, "Forbidden");
            phrases.put(NOT_FOUND, "Not found");
            phrases.put(METHOD_NOT_ALLOWED, "Method not allowed");
            phrases.put(NOT_ACCEPTABLE, "Not acceptable");
            phrases.put(REQUEST_TIMEOUT, "Request timeout");
            phrases.put(CONFLICT, "Conflict");
            phrases.put(GONE, "Gone");
            phrases.put(LENGTH_REQUIRED, "Length required");
            phrases.put(PRECONDITION_FAILED, "Precondition failed");
            phrases.put(REQUEST_ENTITY_TOO_LARGE, "Request entity too large");
            phrases.put(REQUEST_URI_TOO_LARGE, "Request uri too large");
            phrases.put(UNSUPPORTED_MEDIA_TYPE, "Unsupported media type.");
            phrases.put(REQUESTED_RANGE_NOT_SATISFIABLE, "Requested range not satisfiable");
            phrases.put(EXPECTATION_FAILED, "Expectation failed");
            phrases.put(INTERNAL_SERVER_ERROR, "Internal server error");
            phrases.put(NOT_IMPLEMENTED, "Not implemented");
            phrases.put(BAD_GATEWAY, "Bad gateway");
            phrases.put(SERVICE_UNAVAILABLE, "Service unavailable");
            phrases.put(GATEWAY_TIMEOUT, "Gateway timeout");
            phrases.put(HTTP_VERSION_NOT_SUPPORTED, "Http version not supported");
        }
    }
}

