/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.io.net.http.http2.frames;

import java.nio.ByteBuffer;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.io.net.http.http2.frames.ContinuationFrame;
import org.hcjf.io.net.http.http2.frames.DataFrame;
import org.hcjf.io.net.http.http2.frames.GoAwayFrame;
import org.hcjf.io.net.http.http2.frames.HeadersFrame;
import org.hcjf.io.net.http.http2.frames.PingFrame;
import org.hcjf.io.net.http.http2.frames.PriorityFrame;
import org.hcjf.io.net.http.http2.frames.PushPromiseFrame;
import org.hcjf.io.net.http.http2.frames.RstStreamFrame;
import org.hcjf.io.net.http.http2.frames.SettingsFrame;
import org.hcjf.io.net.http.http2.frames.WindowsUpdateFrame;

public abstract class Http2Frame {
    private final Integer length;
    private final Type type;
    private Byte flags;
    private Integer id;
    private ByteBuffer payload;
    private Boolean complete;

    protected Http2Frame(Integer length, Type type) {
        this.length = length;
        this.type = type;
        this.complete = false;
        this.payload = ByteBuffer.allocate(length);
    }

    public final Type getType() {
        return this.type;
    }

    public final Byte getFlags() {
        return this.flags;
    }

    public final void setFlags(Byte flags) {
        this.flags = flags;
    }

    public final Integer getId() {
        return this.id;
    }

    public final void setId(Integer id) {
        this.id = id;
    }

    public final ByteBuffer getPayload() {
        return this.payload;
    }

    public final void setPayload(ByteBuffer payload) {
        this.payload = payload;
    }

    public final Boolean getComplete() {
        return this.complete;
    }

    protected final void setComplete(Boolean complete) {
        this.complete = complete;
    }

    public final void addData(ByteBuffer data) {
        if (!this.getComplete().booleanValue()) {
            this.payload.put(data);
            if (this.payload.position() == this.payload.limit()) {
                this.setComplete(true);
                this.payload.rewind();
                this.processPayload();
            }
        }
    }

    protected abstract void processPayload();

    public static enum Settings {
        SETTINGS_HEADER_TABLE_SIZE(1),
        SETTINGS_ENABLE_PUSH(2),
        SETTINGS_MAX_CONCURRENT_STREAMS(3),
        SETTINGS_INITIAL_WINDOW_SIZE(4),
        SETTINGS_MAX_FRAME_SIZE(5),
        SETTINGS_MAX_HEADER_LIST_SIZE(6);

        private final byte id;

        private Settings(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }
    }

    public static enum Error {
        NO_ERROR(0),
        PROTOCOL_ERROR(1),
        INTERNAL_ERROR(2),
        FLOW_CONTROL_ERROR(3),
        SETTINGS_TIMEOUT(4),
        STREAM_CLOSED(5),
        FRAME_SIZE_ERROR(6),
        REFUSED_STREAM(7),
        CANCEL(8),
        COMPRESSION_ERROR(9),
        CONNECT_ERROR(10),
        ENHANCE_YOUR_CALM(11),
        INADEQUATE_SECURITY(12),
        HTTP_1_1_REQUIRED(13);

        private final byte id;

        private Error(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }
    }

    protected static enum Type {
        DATA(DataFrame.class, 0),
        HEADERS(HeadersFrame.class, 1),
        PRIORITY(PriorityFrame.class, 2),
        RST_STREAM(RstStreamFrame.class, 3),
        SETTINGS(SettingsFrame.class, 4),
        PUSH_PROMISE(PushPromiseFrame.class, 5),
        PING(PingFrame.class, 6),
        GO_AWAY(GoAwayFrame.class, 7),
        WINDOW_UPDATE(WindowsUpdateFrame.class, 8),
        CONTINUATION(ContinuationFrame.class, 9);

        private final Class<? extends Http2Frame> frameClass;
        private final byte id;

        private Type(Class<? extends Http2Frame> frameClass, byte id) {
            this.frameClass = frameClass;
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public static Class<? extends Http2Frame> getClassById(byte id) {
            Class<? extends Http2Frame> result = null;
            for (Type type : Type.values()) {
                if (type.id != id) continue;
                result = type.frameClass;
            }
            return result;
        }
    }

    public static final class Builder {
        public static <F extends Http2Frame> F build(Integer length, Byte type) {
            Class<? extends Http2Frame> frameClass = Type.getClassById(type);
            if (frameClass == null) {
                throw new HCJFRuntimeException("Frame type not found: %d", type);
            }
            try {
                return (F)frameClass.getConstructor(Integer.class, Byte.class).newInstance(length, type);
            }
            catch (Exception e) {
                throw new HCJFRuntimeException("Unable to create frame instance", new Object[0]);
            }
        }
    }
}

