/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.query.functions;

import java.util.HashSet;
import java.util.Set;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.query.functions.BaseFunctionLayer;
import org.hcjf.layers.query.functions.QueryFunctionLayerInterface;
import org.hcjf.properties.SystemProperties;

public abstract class BaseQueryFunctionLayer
extends BaseFunctionLayer
implements QueryFunctionLayerInterface {
    private final Set<String> aliases = new HashSet<String>();

    public BaseQueryFunctionLayer(String implName) {
        super(SystemProperties.get("hcjf.query.function.name.prefix") + implName);
    }

    protected final void addFunctionName(String alias) {
        this.aliases.add(SystemProperties.get("hcjf.query.function.name.prefix") + alias);
    }

    @Override
    public final Set<String> getAliases() {
        return this.aliases;
    }

    protected void checkNumberAndType(String functionName, Object[] parameters, Integer expectedLength, Class ... types) {
        if (parameters.length == expectedLength) {
            for (int i = 0; i < parameters.length || i < types.length; ++i) {
                if (types[i].isAssignableFrom(parameters[i].getClass())) continue;
                throw new HCJFRuntimeException("The query function '%s' expect something assignable to '%s' class and incoming an instance of '%s' in %d\u00b0 place", new Object[0]);
            }
        } else {
            throw new HCJFRuntimeException("The query function '%s' expect %d number of arguments and incoming %d arguments", new Object[]{functionName, expectedLength, parameters.length});
        }
    }
}

