/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.impl.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.hcjf.cloud.impl.objects.DistributedLeaf;
import org.hcjf.cloud.impl.objects.DistributedObject;
import org.hcjf.cloud.impl.objects.LocalLeaf;
import org.hcjf.cloud.impl.objects.RemoteLeaf;

public class DistributedTree
implements DistributedObject {
    private final Object key;
    private final Map<Object, DistributedObject> branches;
    private final Long lastUpdate;

    public DistributedTree(Object key) {
        this.key = key;
        this.branches = new HashMap<Object, DistributedObject>();
        this.lastUpdate = System.currentTimeMillis();
    }

    public final List<Entry> filter(Class<? extends DistributedObject> ... predicate) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        ArrayList<Object> path = new ArrayList<Object>();
        return this.filter(path, result, predicate);
    }

    public final List<Entry> filter(List<Object> path, List<Entry> result, Class<? extends DistributedObject> ... predicate) {
        for (Object key : this.branches.keySet()) {
            DistributedObject value = this.branches.get(key);
            path.add(key);
            if (value instanceof DistributedTree) {
                ((DistributedTree)value).filter(path, result, predicate);
            } else if (this.evaluatePredicate(value.getClass(), predicate)) {
                result.add(new Entry(path.toArray(), value));
            }
            path.remove(path.size() - 1);
        }
        return result;
    }

    private boolean evaluatePredicate(Class currentClass, Class<? extends DistributedObject> ... predicate) {
        boolean result = false;
        for (Class<? extends DistributedObject> predicateClass : predicate) {
            if (!(result |= predicateClass.isAssignableFrom(currentClass))) break;
        }
        return result;
    }

    @Override
    public final Object getKey() {
        return this.key;
    }

    @Override
    public final Long getLastUpdate() {
        return this.lastUpdate;
    }

    public final int size() {
        return this.branches.size();
    }

    public final boolean isEmpty() {
        return this.branches.isEmpty();
    }

    public final boolean containsKey(Object key) {
        return this.branches.containsKey(key);
    }

    public final Set keySet() {
        return this.branches.keySet();
    }

    public final synchronized LocalLeaf addLocalObject(Object object, List<UUID> nodes, List<UUID> serviceEndPoints, Long timestamp, Object ... path) {
        LocalLeaf result;
        Objects.requireNonNull(object, "Null distributed object");
        this.createPath(0, path.length - 1, path);
        Object instance = this.getInstance(0, path.length - 1, path);
        if (instance instanceof DistributedTree) {
            Object key = path[path.length - 1];
            result = new LocalLeaf(key);
            result.setLastUpdate(this.lastUpdate);
            result.setInstance(object);
            result.getNodes().addAll(nodes);
            result.getServiceEndPoints().addAll(serviceEndPoints);
            DistributedLeaf leaf = (DistributedLeaf)this.branches.get(key);
            if (leaf != null) {
                if (leaf.getLastUpdate() < timestamp) {
                    if (leaf instanceof LocalLeaf) {
                        result = (LocalLeaf)leaf;
                        result.setLastUpdate(timestamp);
                        result.getNodes().addAll(nodes);
                        result.getServiceEndPoints().addAll(serviceEndPoints);
                        result.setInstance(object);
                    } else {
                        ((DistributedTree)instance).branches.put(key, result);
                    }
                } else if (leaf instanceof LocalLeaf) {
                    result = (LocalLeaf)this.branches.get(key);
                    result.getNodes().addAll(nodes);
                    result.getServiceEndPoints().addAll(serviceEndPoints);
                }
            } else {
                ((DistributedTree)instance).branches.put(key, result);
            }
        } else {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public final synchronized RemoteLeaf addRemoteObject(Object object, List<UUID> nodes, List<UUID> serviceEndPoints, Long timestamp, Object ... path) {
        RemoteLeaf result;
        this.createPath(0, path.length - 1, path);
        Object instance = this.getInstance(0, path.length - 1, path);
        if (instance instanceof DistributedTree) {
            Object key = path[path.length - 1];
            result = new RemoteLeaf(key);
            result.setLastUpdate(this.lastUpdate);
            result.setInstance(object);
            result.getNodes().addAll(nodes);
            result.getServiceEndPoints().addAll(serviceEndPoints);
            DistributedLeaf leaf = (DistributedLeaf)this.branches.get(key);
            if (leaf != null) {
                if (leaf.getLastUpdate() < timestamp) {
                    if (leaf instanceof RemoteLeaf) {
                        result = (RemoteLeaf)leaf;
                        result.setLastUpdate(timestamp);
                        result.getNodes().addAll(nodes);
                        result.getServiceEndPoints().addAll(serviceEndPoints);
                        result.setInstance(object);
                    } else {
                        ((DistributedTree)instance).branches.put(key, result);
                    }
                } else if (leaf instanceof RemoteLeaf) {
                    result = (RemoteLeaf)this.branches.get(key);
                    result.getNodes().addAll(nodes);
                    result.getServiceEndPoints().addAll(serviceEndPoints);
                }
            } else {
                ((DistributedTree)instance).branches.put(key, result);
            }
        } else {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public final synchronized DistributedObject remove(Object ... path) {
        return this.remove(0, path);
    }

    private DistributedObject remove(int index, Object ... path) {
        DistributedObject result = null;
        if (index + 1 == path.length) {
            result = this.branches.remove(path[index]);
        } else {
            DistributedObject distributedObject = this.branches.get(path[index]);
            if (distributedObject != null && distributedObject instanceof DistributedTree) {
                result = ((DistributedTree)distributedObject).remove(index + 1, path);
            }
        }
        return result;
    }

    public final synchronized void clear(Object ... path) {
        this.clear(0, path);
    }

    private void clear(int index, Object ... path) {
        DistributedObject distributedObject;
        if ((distributedObject = this.branches.get(index++)) instanceof DistributedTree) {
            if (index == path.length) {
                ((DistributedTree)distributedObject).branches.clear();
            } else {
                ((DistributedTree)distributedObject).clear(index, path);
            }
        }
    }

    @Override
    public Object getInstance() {
        return this;
    }

    public Object getInstance(Object ... path) {
        return this.getInstance(0, path.length, path);
    }

    private Object getInstance(int index, int length, Object ... path) {
        DistributedObject distributedObject;
        Object result = null;
        if ((distributedObject = this.branches.get(path[index++])) != null) {
            if (index == length) {
                result = distributedObject.getInstance();
            } else if (distributedObject instanceof DistributedTree) {
                result = ((DistributedTree)distributedObject).getInstance(index, length, path);
            }
        }
        return result;
    }

    public synchronized boolean createPath(Object ... path) {
        return this.createPath(0, path.length, path);
    }

    private boolean createPath(int index, int length, Object ... path) {
        Object key;
        boolean result = false;
        if (!this.branches.containsKey(key = path[index++])) {
            this.branches.put(key, new DistributedTree(key));
            result = true;
        }
        if (index < length) {
            result &= ((DistributedTree)this.branches.get(key)).createPath(index, length, path);
        }
        return result;
    }

    public static class Entry {
        private final Object[] path;
        private final DistributedObject value;

        public Entry(Object[] path, DistributedObject value) {
            this.path = path;
            this.value = value;
        }

        public Object[] getPath() {
            return this.path;
        }

        public DistributedObject getValue() {
            return this.value;
        }
    }
}

