/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.cloud.timer;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.hcjf.cloud.Cloud;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.ServiceSession;
import org.hcjf.service.ServiceThread;

public abstract class CloudTimerTask
implements Runnable {
    private final String name;
    private final Lock lock;
    private final Condition condition;
    private final Map<String, Long> timerTaskMap;
    private final String mapName;
    private final String lockName;
    private final String conditionName;

    public CloudTimerTask(String name) {
        this.name = name;
        this.mapName = SystemProperties.get("hcjf.cloud.timer.task.map.suffix.name") + name;
        this.lockName = SystemProperties.get("hcjf.cloud.timer.task.lock.suffix.name") + name;
        this.conditionName = SystemProperties.get("hcjf.cloud.timer.task.condition.suffix.name") + name;
        this.lock = Cloud.getLock(this.lockName);
        this.condition = Cloud.getCondition(this.conditionName, this.lock);
        this.timerTaskMap = Cloud.getMap(SystemProperties.get("hcjf.cloud.timer.task.map.name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (!Thread.currentThread().isInterrupted()) {
            this.lock.lock();
            try {
                Long lastExecution;
                Long delay = this.getDelay();
                if (delay < SystemProperties.getLong("hcjf.cloud.timer.task.min.value.of.delay")) {
                    delay = SystemProperties.getLong("hcjf.cloud.timer.task.min.value.of.delay");
                }
                if ((lastExecution = this.timerTaskMap.get(this.mapName)) == null) {
                    lastExecution = System.currentTimeMillis();
                    this.timerTaskMap.put(this.mapName, lastExecution);
                }
                delay = delay - (System.currentTimeMillis() - lastExecution);
                this.condition.await(delay, TimeUnit.MILLISECONDS);
                Long currentExecution = this.timerTaskMap.get(this.mapName);
                if (!currentExecution.equals(lastExecution)) continue;
                ServiceSession previousSession = ((ServiceThread)Thread.currentThread()).getSession();
                try {
                    Log.d(System.getProperty("hcjf.cloud.log.tag"), "Starting timer task execution %s", this.name);
                    ((ServiceThread)Thread.currentThread()).setSession(ServiceSession.getSystemSession());
                    this.onRun();
                    ((ServiceThread)Thread.currentThread()).setSession(previousSession);
                }
                catch (Throwable ex) {
                    try {
                        Log.d(System.getProperty("hcjf.cloud.log.tag"), "Starting timer task error execution %s", this.name);
                        this.onError(ex);
                        ((ServiceThread)Thread.currentThread()).setSession(previousSession);
                    }
                    catch (Throwable throwable) {
                        ((ServiceThread)Thread.currentThread()).setSession(previousSession);
                        Log.d(System.getProperty("hcjf.cloud.log.tag"), "Ending timer task execution %s", this.name);
                        throw throwable;
                    }
                    Log.d(System.getProperty("hcjf.cloud.log.tag"), "Ending timer task execution %s", this.name);
                }
                Log.d(System.getProperty("hcjf.cloud.log.tag"), "Ending timer task execution %s", this.name);
                this.timerTaskMap.put(this.mapName, System.currentTimeMillis());
            }
            catch (InterruptedException ex) {
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected abstract Long getDelay();

    protected abstract void onRun();

    protected void onError(Throwable throwable) {
    }
}

