/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.hcjf.cloud.Cloud;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.layers.DefaultLayer;
import org.hcjf.layers.Layer;
import org.hcjf.layers.LayerInterface;
import org.hcjf.layers.crud.IdentifiableLayerInterface;
import org.hcjf.layers.crud.ReadRowsLayerInterface;
import org.hcjf.layers.distributed.DistributedLayer;
import org.hcjf.layers.distributed.DistributedLayerInterface;
import org.hcjf.layers.plugins.Plugin;
import org.hcjf.layers.plugins.PluginClassLoader;
import org.hcjf.layers.plugins.PluginLayer;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.Queryable;
import org.hcjf.layers.resources.Resource;
import org.hcjf.layers.resources.Resourceable;
import org.hcjf.layers.scripting.JavaCodeEvaluator;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.service.security.LazyPermission;
import org.hcjf.service.security.Permission;
import org.hcjf.service.security.SecurityPermissions;
import org.hcjf.utils.NamedUuid;
import org.hcjf.utils.Version;

public final class Layers {
    private static final String PLUGIN_GROUP_NAME = "Plugin-Group-Name";
    private static final String PLUGIN_NAME = "Plugin-Name";
    private static final String PLUGIN_VERSION = "Plugin-Version";
    private static final String LAYERS = "Layers";
    private static final String CLASS_SEPARATOR = ";";
    private static final Layers instance = new Layers();
    private final Map<Class<? extends Layer>, Object> initialInstances = new HashMap<Class<? extends Layer>, Object>();
    private final Map<Class<? extends LayerInterface>, Map<String, String>> implAlias = new HashMap<Class<? extends LayerInterface>, Map<String, String>>();
    private final Map<Class<? extends LayerInterface>, Map<String, Class<? extends Layer>>> layerImplementations = new HashMap<Class<? extends LayerInterface>, Map<String, Class<? extends Layer>>>();
    private final Map<Class<? extends LayerInterface>, Map<String, String>> layerImplementationsByRegex = new HashMap<Class<? extends LayerInterface>, Map<String, String>>();
    private final Map<Class<? extends LayerInterface>, String> defaultLayers;
    private final Map<Class<? extends LayerInterface>, Map<String, String>> pluginLayerImplementations = new HashMap<Class<? extends LayerInterface>, Map<String, String>>();
    private final Map<Class<? extends LayerInterface>, Map<String, LayerInterface>> distributedLayers = new HashMap<Class<? extends LayerInterface>, Map<String, LayerInterface>>();
    private final Map<Class<? extends LayerInterface>, Map<String, String>> distributedLayersByRegex = new HashMap<Class<? extends LayerInterface>, Map<String, String>>();
    private final Map<Class<? extends Layer>, LayerInterface> instanceCache;
    private final Map<String, LayerInterface> pluginWrapperCache;
    private final Map<String, Layer> pluginCache;
    private final Set<Resource> resources;
    private final List<Plugin> plugins;

    private Layers() {
        this.defaultLayers = new HashMap<Class<? extends LayerInterface>, String>();
        this.instanceCache = new HashMap<Class<? extends Layer>, LayerInterface>();
        this.pluginWrapperCache = new HashMap<String, LayerInterface>();
        this.pluginCache = new HashMap<String, Layer>();
        this.resources = new HashSet<Resource>();
        this.plugins = new ArrayList<Plugin>();
    }

    private static synchronized <L extends LayerInterface> L getImplementationInstance(Class<? extends Layer> clazz) {
        LayerInterface result = null;
        result = Layers.instance.instanceCache.get(clazz);
        if (result == null) {
            try {
                result = (LayerInterface)Layers.instance.initialInstances.get(clazz);
                if (result == null) {
                    result = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if ((result = (LayerInterface)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), Layers.getLayerInterfaceClass(clazz).toArray(new Class[0]), (InvocationHandler)result)).isStateful()) {
                    Layers.instance.instanceCache.put(clazz, result);
                }
            }
            catch (Exception ex) {
                throw new HCJFRuntimeException("Unable to create layer instance", (Throwable)ex, new Object[0]);
            }
        }
        return (L)result;
    }

    private static synchronized <L extends LayerInterface> L getPluginImplementationInstance(Class<? extends L> layerClass, final String layerName) {
        LayerInterface result = null;
        result = Layers.instance.pluginWrapperCache.get(layerName);
        if (result == null) {
            result = (LayerInterface)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{layerClass}, (InvocationHandler)new PluginLayer(){

                @Override
                protected Object getTarget() {
                    return Layers.instance.pluginCache.get(layerName);
                }
            });
            Layers.instance.pluginWrapperCache.put(layerName, result);
        }
        return (L)result;
    }

    private static synchronized <L extends LayerInterface> L getDistributedImplementationInstance(Class<? extends L> layerClass, String layerName) {
        LayerInterface result;
        if (!Layers.instance.distributedLayers.containsKey(layerClass)) {
            Layers.instance.distributedLayers.put(layerClass, new HashMap());
        }
        if ((result = Layers.instance.distributedLayers.get(layerClass).get(layerName)) == null) {
            result = (LayerInterface)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{layerClass}, (InvocationHandler)new DistributedLayer(layerName, layerClass));
            Layers.instance.distributedLayers.get(layerClass).put(layerName, result);
            String regex = Cloud.getRegexFromDistributedLayer(layerClass, layerName);
            if (regex != null) {
                if (!Layers.instance.distributedLayersByRegex.containsKey(layerClass)) {
                    Layers.instance.distributedLayersByRegex.put(layerClass, new HashMap());
                }
                Layers.instance.distributedLayersByRegex.get(layerClass).put(regex, layerName);
            }
        }
        return (L)result;
    }

    public static <L extends LayerInterface> L get(Class<? extends L> layerClass, String implName) {
        String className;
        LayerInterface result = null;
        if (Layers.instance.layerImplementations.containsKey(layerClass)) {
            Class<? extends Layer> clazz = Layers.instance.layerImplementations.get(layerClass).get(implName);
            if (clazz == null && Layers.instance.implAlias.get(layerClass).containsKey(implName)) {
                clazz = Layers.instance.layerImplementations.get(layerClass).get(Layers.instance.implAlias.get(layerClass).get(implName));
            }
            if (clazz == null && Layers.instance.defaultLayers.containsKey(layerClass)) {
                clazz = Layers.instance.layerImplementations.get(layerClass).get(Layers.instance.defaultLayers.get(layerClass));
            }
            if (clazz != null) {
                result = (LayerInterface)Layers.getImplementationInstance(clazz);
            }
        }
        if (result == null && Layers.instance.pluginLayerImplementations.containsKey(layerClass) && (className = Layers.instance.pluginLayerImplementations.get(layerClass).get(implName)) != null && (result = (LayerInterface)Layers.getPluginImplementationInstance(layerClass, className)) instanceof IdentifiableLayerInterface) {
            NamedUuid.registerName(result.getImplName());
        }
        if (result == null && SystemProperties.getBoolean("hcjf.layers.distributed.layer.enabled").booleanValue() && Cloud.isLayerPublished(layerClass, implName)) {
            result = (LayerInterface)Layers.getDistributedImplementationInstance(layerClass, implName);
        }
        if (result == null) {
            if (Layers.instance.layerImplementationsByRegex.containsKey(layerClass)) {
                for (String regex : Layers.instance.layerImplementationsByRegex.get(layerClass).keySet()) {
                    if (!implName.matches(regex)) continue;
                    result = Layers.getImplementationInstance(Layers.instance.layerImplementations.get(layerClass).get(Layers.instance.layerImplementationsByRegex.get(layerClass).get(regex)));
                    break;
                }
            }
            if (result == null && Layers.instance.distributedLayersByRegex.containsKey(layerClass)) {
                for (String regex : Layers.instance.distributedLayersByRegex.get(layerClass).keySet()) {
                    if (!implName.matches(regex)) continue;
                    result = Layers.getDistributedImplementationInstance(layerClass, Layers.instance.distributedLayersByRegex.get(layerClass).get(regex));
                    break;
                }
            }
            if (result == null) {
                throw new HCJFRuntimeException("Layer implementation not found: %s@%s", layerClass, implName);
            }
        }
        return (L)result;
    }

    public static <L extends LayerInterface> Set<L> getAll(Class<? extends L> layerClass, LayerMatcher<L> matcher) {
        return Layers.match(layerClass, matcher, false);
    }

    public static <L extends LayerInterface> L get(Class<? extends L> layerClass, LayerMatcher<L> matcher) {
        Set<L> result = Layers.match(layerClass, matcher, true);
        if (result.isEmpty()) {
            throw new HCJFRuntimeException("Layer implementation not found", new Object[0]);
        }
        return (L)((LayerInterface)result.iterator().next());
    }

    private static <L extends LayerInterface> Set<L> match(Class<? extends L> layerClass, LayerMatcher<L> matcher, boolean onlyFirst) {
        Object layerFounded;
        Map<String, Object> layersByName;
        HashSet<L> result = new HashSet<L>();
        if (Layers.instance.layerImplementations.containsKey(layerClass)) {
            layersByName = Layers.instance.layerImplementations.get(layerClass);
            for (String implName : layersByName.keySet()) {
                layerFounded = Layers.getImplementationInstance((Class)layersByName.get(implName));
                if (!matcher.match(layerFounded)) continue;
                result.add(layerFounded);
                if (!onlyFirst) continue;
                break;
            }
        }
        if ((result.isEmpty() || !onlyFirst) && Layers.instance.pluginLayerImplementations.containsKey(layerClass)) {
            layersByName = Layers.instance.pluginLayerImplementations.get(layerClass);
            for (String implName : layersByName.keySet()) {
                layerFounded = Layers.getPluginImplementationInstance(layerClass, (String)layersByName.get(implName));
                if (!matcher.match(layerFounded)) continue;
                result.add(layerFounded);
                if (!onlyFirst) continue;
                break;
            }
        }
        if ((result.isEmpty() || !onlyFirst) && Layers.instance.distributedLayers.containsKey(layerClass)) {
            layersByName = Layers.instance.distributedLayers.get(layerClass);
            for (String implName : layersByName.keySet()) {
                layerFounded = (LayerInterface)layersByName.get(implName);
                if (!matcher.match(layerFounded)) continue;
                result.add(layerFounded);
                if (!onlyFirst) continue;
                break;
            }
        }
        return result;
    }

    public static synchronized <L extends Layer> String publishLayer(L layerInstance) {
        Class<?> layerClass = layerInstance.getClass();
        if (layerClass.isAnonymousClass() && !layerInstance.isStateful()) {
            throw new HCJFRuntimeException("Unable to publish anonymous and stateless class, to publish anonymous class its must by stateful", new Object[0]);
        }
        String implName = layerInstance.getImplName();
        if (implName == null) {
            throw new HCJFRuntimeException("Unable to publish %s because the implementation is not name declared", layerClass);
        }
        for (Class<? extends LayerInterface> layerInterfaceClass : Layers.getLayerInterfaceClass(layerClass)) {
            if (!Layers.instance.layerImplementations.containsKey(layerInterfaceClass)) {
                Layers.instance.layerImplementations.put(layerInterfaceClass, new HashMap());
                Layers.instance.implAlias.put(layerInterfaceClass, new HashMap());
            }
            if (Layers.instance.layerImplementations.get(layerInterfaceClass).containsKey(implName)) {
                Layers.checkOverwriteAlias(layerInterfaceClass, layerInstance, implName);
            }
            if (layerInstance.getAliases() != null) {
                for (String alias : layerInstance.getAliases()) {
                    Layers.checkOverwriteAlias(layerInterfaceClass, layerInstance, alias);
                }
            }
            if (layerInstance.isStateful()) {
                Layers.instance.initialInstances.put(layerClass, layerInstance);
            }
            Layers.instance.layerImplementations.get(layerInterfaceClass).put(implName, layerClass);
            if (layerInstance.getRegex() != null) {
                if (!Layers.instance.layerImplementationsByRegex.containsKey(layerInterfaceClass)) {
                    Layers.instance.layerImplementationsByRegex.put(layerInterfaceClass, new HashMap());
                }
                Layers.instance.layerImplementationsByRegex.get(layerInterfaceClass).put(layerInstance.getRegex(), implName);
            }
            if (layerInstance.getAliases() != null) {
                for (String alias : layerInstance.getAliases()) {
                    Layers.instance.implAlias.get(layerInterfaceClass).put(alias, implName);
                }
            }
            if (layerInstance instanceof Resourceable) {
                ((Resourceable)((Object)layerInstance)).createResource(layerInterfaceClass).forEach(R -> Layers.instance.resources.add((Resource)R));
            }
            if (!SystemProperties.getBoolean("hcjf.layers.distributed.layer.enabled").booleanValue() || !(layerInstance instanceof DistributedLayerInterface)) continue;
            Cloud.publishDistributedLayer(layerInterfaceClass, implName, layerInstance.getRegex());
        }
        if (layerClass.isAnnotationPresent(DefaultLayer.class)) {
            List<Class<?>> classInterfaces = Arrays.asList(layerClass.getInterfaces());
            for (GenericDeclaration genericDeclaration : layerClass.getAnnotation(DefaultLayer.class).value()) {
                if (classInterfaces.contains(genericDeclaration)) {
                    Layers.instance.defaultLayers.put((Class<? extends LayerInterface>)genericDeclaration, implName);
                    continue;
                }
                Log.d(SystemProperties.get("hcjf.layers.log.tag"), "The class '%s' could not be a default layer for interface '%s' because the class don't implements this interface", layerClass, genericDeclaration);
            }
        }
        if (layerInstance instanceof IdentifiableLayerInterface) {
            NamedUuid.registerName(layerInstance.getImplName());
        }
        Class<?> classToIntrospect = layerInstance.getClass();
        while (!classToIntrospect.equals(Layer.class) && !classToIntrospect.equals(Object.class)) {
            for (GenericDeclaration genericDeclaration : classToIntrospect.getDeclaredMethods()) {
                for (Permission permission : (Permission[])genericDeclaration.getDeclaredAnnotationsByType(Permission.class)) {
                    SecurityPermissions.publishPermission(layerInstance.getClass(), permission.value(), permission.title(), permission.description(), List.of(permission.tags()));
                }
                for (Annotation annotation : (LazyPermission[])genericDeclaration.getDeclaredAnnotationsByType(LazyPermission.class)) {
                    SecurityPermissions.publishPermission(layerInstance.getClass(), annotation.value(), annotation.title(), annotation.description(), List.of(annotation.tags()));
                }
            }
            classToIntrospect = classToIntrospect.getSuperclass();
        }
        return implName;
    }

    public static synchronized String publishLayer(Class<? extends Layer> layerClass) {
        Layer layerInstance;
        if (layerClass == null) {
            throw new HCJFRuntimeException("Unable to publish a null class", new Object[0]);
        }
        try {
            layerInstance = layerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new HCJFRuntimeException("Unable to publish %s because fail to create a new instance", (Throwable)ex, layerClass);
        }
        return Layers.publishLayer(layerInstance);
    }

    private static void checkOverwriteAlias(Class<? extends LayerInterface> layerInterfaceClass, Layer layerInstance, String alias) {
        Layer initialImplementation = (Layer)Layers.instance.initialInstances.get(Layers.instance.layerImplementations.get(layerInterfaceClass).get(layerInstance.getImplName()));
        if (initialImplementation != null) {
            if (initialImplementation.isOverwritable()) {
                Log.d(SystemProperties.get("hcjf.layers.log.tag"), "The alias %s for the instance %s will be overwritten for instance of %s", alias, initialImplementation.getClass().getName(), layerInstance.getClass().getName());
            } else {
                throw new HCJFRuntimeException("This implementation %s is not over-writable", initialImplementation.getClass().toString());
            }
        }
    }

    public static synchronized Plugin publishPlugin(ByteBuffer jarBuffer) {
        String pluginGroupName = "";
        String pluginName = "";
        Version pluginVersion = null;
        Plugin result = null;
        try {
            File tempFile = File.createTempFile("." + UUID.randomUUID().toString(), "tmp");
            FileOutputStream fos = new FileOutputStream(tempFile);
            fos.write(jarBuffer.array());
            fos.flush();
            fos.close();
            JarFile jarFile = new JarFile(tempFile);
            Manifest manifest = jarFile.getManifest();
            Attributes pluginAttributes = manifest.getMainAttributes();
            pluginGroupName = pluginAttributes.getValue(PLUGIN_GROUP_NAME);
            if (pluginGroupName == null) {
                throw new HCJFRuntimeException("Plugin group name is not specified into the manifest file (Plugin-Group-Name)", new Object[0]);
            }
            pluginName = pluginAttributes.getValue(PLUGIN_NAME);
            if (pluginName == null) {
                throw new HCJFRuntimeException("Plugin name is not specified into the manifest file (Plugin-Name)", new Object[0]);
            }
            pluginVersion = Version.build(pluginAttributes.getValue(PLUGIN_VERSION));
            result = new Plugin(pluginGroupName, pluginName, pluginVersion);
            boolean deployPlugin = false;
            if (Layers.instance.plugins.contains(result)) {
                int currentIndex = Layers.instance.plugins.indexOf(result);
                if (!Layers.instance.plugins.get(currentIndex).getVersion().equals(result.getVersion())) {
                    Plugin currentPlugin = Layers.instance.plugins.remove(currentIndex);
                    if (currentPlugin.getVersion().compareTo(result.getVersion()) > 0) {
                        Log.d(SystemProperties.get("hcjf.layers.log.tag"), "Downgrade plugin version %s.%s:%s -> %s", pluginGroupName, pluginName, currentPlugin.getVersion().toString(), pluginVersion.toString());
                    } else {
                        Log.d(SystemProperties.get("hcjf.layers.log.tag"), "Upgrade plugin version %s.%s:%s -> %s", pluginGroupName, pluginName, currentPlugin.getVersion().toString(), pluginVersion.toString());
                    }
                    deployPlugin = true;
                }
            } else {
                deployPlugin = true;
            }
            if (deployPlugin) {
                Layers.instance.plugins.add(result);
                String[] layers = pluginAttributes.getValue(LAYERS).split(CLASS_SEPARATOR);
                Log.d(SystemProperties.get("hcjf.layers.log.tag"), "Deploying plugin %s.%s:%s", pluginGroupName, pluginName, pluginVersion.toString());
                PluginClassLoader pluginClassLoader = new PluginClassLoader(result, new URL[]{tempFile.toURI().toURL()}, instance.getClass().getClassLoader());
                ArrayList<Layer> toDeployLayers = new ArrayList<Layer>();
                for (String layerClassName : layers) {
                    Log.d(SystemProperties.get("hcjf.layers.log.tag"), "Loading layer %s", layerClassName);
                    Class<?> layerClass = Class.forName(layerClassName, true, pluginClassLoader);
                    result.addLayer(layerClass);
                    Layer layer = (Layer)layerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    toDeployLayers.add(layer);
                    Log.d(SystemProperties.get("hcjf.layers.log.tag"), "Layer %s loaded", layer.getImplName());
                }
                for (Layer layerInstance : toDeployLayers) {
                    Layers.instance.pluginCache.remove(layerInstance.getClass().getName());
                    Layers.instance.pluginCache.put(layerInstance.getClass().getName(), layerInstance);
                    for (Class<? extends LayerInterface> layerInterfaceClass : Layers.getLayerInterfaceClass(layerInstance.getClass())) {
                        if (!Layers.instance.pluginLayerImplementations.containsKey(layerInterfaceClass)) {
                            Layers.instance.pluginLayerImplementations.put(layerInterfaceClass, new HashMap());
                        }
                        if (Layers.instance.pluginLayerImplementations.get(layerInterfaceClass).containsKey(layerInstance.getImplName())) continue;
                        Layers.instance.pluginLayerImplementations.get(layerInterfaceClass).put(layerInstance.getImplName(), layerInstance.getClass().getName());
                    }
                }
            } else {
                Log.d(SystemProperties.get("hcjf.layers.log.tag"), "Exists a plugin deployment in the same group with the same name and version: %s.%s:%s", pluginGroupName, pluginName, pluginVersion.toString());
            }
        }
        catch (Exception ex) {
            Log.d(SystemProperties.get("hcjf.layers.log.tag"), "Plugin deployment fail %s.%s", ex, pluginGroupName, pluginName);
        }
        return result;
    }

    public static Set<Class<? extends LayerInterface>> getLayerInterfaceClass(Class<? extends Layer> layerClass) {
        HashSet<Class<? extends LayerInterface>> result = new HashSet<Class<? extends LayerInterface>>();
        Class<? extends Layer> introspectedClass = layerClass;
        while (!introspectedClass.equals(Object.class)) {
            for (Class<?> layerInterface : introspectedClass.getInterfaces()) {
                if (!LayerInterface.class.isAssignableFrom(layerInterface) || layerInterface.equals(LayerInterface.class)) continue;
                result.add(layerInterface);
            }
            introspectedClass = introspectedClass.getSuperclass();
        }
        if (result.isEmpty()) {
            throw new HCJFRuntimeException("Unable to publish %s because must implement a son of LayerClass", layerClass);
        }
        return result;
    }

    public static Set<Resource> getResources() {
        return Layers.getResources(R -> true);
    }

    public static Set<Resource> getResources(ResourcePredicate predicate) {
        return Layers.instance.resources.stream().filter(predicate).collect(Collectors.toSet());
    }

    private static Collection<JoinableMap> getLayers() {
        JoinableMap map;
        ArrayList<JoinableMap> result = new ArrayList<JoinableMap>();
        for (Class<? extends LayerInterface> clazz : Layers.instance.layerImplementations.keySet()) {
            Map<String, Class<? extends Layer>> implementationMap = Layers.instance.layerImplementations.get(clazz);
            for (String string : implementationMap.keySet()) {
                map = new JoinableMap(new HashMap<String, Object>(), new String[0]);
                map.put("layerInterfaceName", (Object)clazz.getName());
                map.put("layerImplementationName", (Object)implementationMap.get(string).getName());
                map.put("layerName", (Object)string);
                map.put("remote", (Object)false);
                map.put("plugin", (Object)false);
                result.add(map);
            }
        }
        for (Class<? extends LayerInterface> clazz : Layers.instance.pluginLayerImplementations.keySet()) {
            Map<String, String> pluginImplementation = Layers.instance.pluginLayerImplementations.get(clazz);
            for (String name : pluginImplementation.keySet()) {
                map = new JoinableMap(new HashMap<String, Object>(), new String[0]);
                map.put("layerInterfaceName", (Object)clazz.getName());
                map.put("layerImplementationName", (Object)Layers.instance.pluginWrapperCache.get(pluginImplementation.get(name)).getClass().getName());
                map.put("layerName", (Object)name);
                map.put("remote", (Object)false);
                map.put("plugin", (Object)true);
                result.add(map);
            }
        }
        for (Class<? extends LayerInterface> clazz : Layers.instance.distributedLayers.keySet()) {
            Map<String, LayerInterface> map2 = Layers.instance.distributedLayers.get(clazz);
            for (String name : map2.keySet()) {
                map = new JoinableMap(new HashMap<String, Object>(), new String[0]);
                map.put("layerInterfaceName", (Object)clazz.getName());
                map.put("layerImplementationName", (Object)map2.get(name).getClass().getName());
                map.put("layerName", (Object)name);
                map.put("remote", (Object)true);
                map.put("plugin", (Object)false);
                result.add(map);
            }
        }
        return result;
    }

    private static Collection<JoinableMap> getReadableLayers() {
        ArrayList<JoinableMap> result = new ArrayList<JoinableMap>();
        for (ReadRowsLayerInterface layer : Layers.getAll(ReadRowsLayerInterface.class, L -> true)) {
            result.add(new JoinableMap(Map.of("name", layer.getImplName()), new String[0]));
        }
        return result;
    }

    static {
        Layers.publishLayer(SystemLayerReadableImplementation.class);
        Layers.publishLayer(SystemResourceReadableImplementation.class);
        Layers.publishLayer(JavaCodeEvaluator.class);
    }

    public static class SystemResourceReadableImplementation
    extends Layer
    implements ReadRowsLayerInterface {
        public SystemResourceReadableImplementation() {
            super(SystemProperties.get("hcjf.layers.readable.layer.implementation.name"));
        }

        @Override
        public Collection<JoinableMap> readRows(Queryable queryable) {
            return queryable.evaluate(Layers.getReadableLayers());
        }
    }

    public static class SystemLayerReadableImplementation
    extends Layer
    implements ReadRowsLayerInterface {
        public SystemLayerReadableImplementation() {
            super(SystemProperties.get("hcjf.layers.readable.all.layer.implementation.name"));
        }

        @Override
        public Collection<JoinableMap> readRows(Queryable queryable) {
            return queryable.evaluate(Layers.getLayers());
        }
    }

    public static interface ResourcePredicate
    extends Predicate<Resource> {
    }

    public static interface LayerMatcher<L extends LayerInterface> {
        public boolean match(L var1);
    }
}

