/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.service.security;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import org.hcjf.service.Service;
import org.hcjf.service.ServiceSession;
import org.hcjf.service.ServiceThread;
import org.hcjf.service.security.SecurityPermissions;

public class ServiceSecurityManager
extends SecurityManager {
    private static final String GRANT_NOT_FOUND_TEMPLATE = "Grant not found %s into service session %s";
    private static final String SECURITY_EXCEPTION_MESSAGE = "Security exception";

    @Override
    public void checkPermission(Permission perm) {
        if (perm instanceof SecurityPermissions.SecurityPermission) {
            Object serviceSession;
            try {
                serviceSession = ServiceSession.getCurrentIdentity();
            }
            catch (Exception ex) {
                throw new SecurityException(SECURITY_EXCEPTION_MESSAGE, ex);
            }
            if (!((ServiceSession)serviceSession).isSystemSession() && !((ServiceSession)serviceSession).containsGrant(perm.getName())) {
                throw new SecurityException(String.format(GRANT_NOT_FOUND_TEMPLATE, perm.getName(), ((ServiceSession)serviceSession).getId()));
            }
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
    }

    @Override
    public void checkCreateClassLoader() {
    }

    @Override
    public void checkAccess(Thread thread) {
        ServiceSession.LayerStackElement element;
        Object session;
        if (Thread.currentThread() instanceof ServiceThread && (session = ServiceSession.getCurrentIdentity()) != null && (element = ((ServiceSession)session).getCurrentLayer()) != null && element.isPlugin() && !(thread instanceof Service.StaticServiceThread)) {
            throw new SecurityException("Unable to manipulate a thread into a plugin layer");
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
    }

    @Override
    public void checkExit(int status) {
    }

    @Override
    public void checkExec(String cmd) {
    }

    @Override
    public void checkLink(String lib) {
    }

    @Override
    public void checkRead(FileDescriptor fd) {
    }

    @Override
    public void checkRead(String file) {
    }

    @Override
    public void checkRead(String file, Object context) {
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
    }

    @Override
    public void checkWrite(String file) {
    }

    @Override
    public void checkDelete(String file) {
    }

    @Override
    public void checkConnect(String host, int port) {
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
    }

    @Override
    public void checkListen(int port) {
    }

    @Override
    public void checkAccept(String host, int port) {
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
    }

    @Override
    public void checkPropertiesAccess() {
    }

    @Override
    public void checkPropertyAccess(String key) {
    }

    @Override
    public void checkPrintJobAccess() {
    }

    @Override
    public void checkPackageAccess(String pkg) {
    }

    @Override
    public void checkPackageDefinition(String pkg) {
    }

    @Override
    public void checkSecurityAccess(String target) {
    }
}

