/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.utils;

import com.esri.core.geometry.ogc.OGCGeometry;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.hcjf.errors.HCJFRuntimeException;
import org.hcjf.utils.Introspection;
import org.hcjf.utils.JsonUtils;

public class GeoUtils {
    public static final OGCGeometry createGeometry(Object object) {
        OGCGeometry geometry;
        if (object instanceof byte[]) {
            geometry = OGCGeometry.fromBinary((ByteBuffer)ByteBuffer.wrap((byte[])object));
        } else if (object instanceof String) {
            geometry = ((String)object).startsWith("{") || ((String)object).startsWith("[") ? GeoUtils.fromGeoJson((Map)JsonUtils.createObject((String)object)) : OGCGeometry.fromText((String)((String)object));
        } else if (object instanceof Map) {
            geometry = GeoUtils.fromGeoJson((Map)object);
        } else {
            throw new HCJFRuntimeException("Illegal argument exception, unsupported geom data type: %s", object.getClass());
        }
        return geometry;
    }

    private static OGCGeometry fromGeoJson(Map<String, Object> geoJson) {
        OGCGeometry result = null;
        if (geoJson.containsKey("coordinates")) {
            result = OGCGeometry.fromGeoJson((String)JsonUtils.toJsonTree(geoJson).toString());
        } else {
            Collection features = (Collection)Introspection.resolve(geoJson, "features");
            for (Map feature : features) {
                Number buffer = (Number)Introspection.resolve((Object)feature, "properties._radius");
                if (buffer == null) {
                    buffer = (Number)Introspection.resolve((Object)feature, "properties._buffer");
                }
                OGCGeometry geometry = OGCGeometry.fromGeoJson((String)JsonUtils.toJsonTree(Introspection.resolve((Object)feature, "geometry")).toString());
                if (buffer != null) {
                    geometry = geometry.buffer(buffer.doubleValue());
                }
                if (result == null) {
                    result = geometry;
                    continue;
                }
                result.union(geometry);
            }
        }
        return result;
    }

    private static final class Paths {
        private static final String COORDINATES = "coordinates";
        private static final String FEATURES = "features";
        private static final String PROPERTIES_RADIUS = "properties._radius";
        private static final String PROPERTIES_BUFFER = "properties._buffer";
        private static final String GEOMETRY = "geometry";

        private Paths() {
        }
    }
}

